local channels = {"yell", "raidWarning", "raid", "party", "channel"}

function ZFreezeFail(destName, missType)
	local tbl = ZHunterMod_Saved["ZFreezeFail"]
	if tbl.playSound then
		PlaySoundFile("Sound\\Creature\\Basilisk\\mBasiliskAttackC.wav")
	end
	missType = missType and missType:lower() or ""
	local message = tbl.format or "Не удалось замарозить: $player. ($type)"
	local newmessage
	newmessage = message:gsub("$player", destName)
	newmessage = newmessage:gsub("$type", missType)
	local channelNum = tbl.channelNum
	for i, v in ipairs(channels) do
		if tbl[v] or (tbl[v] == nil and IsActiveBattlefieldArena()) then
			ZHunter[v](newmessage, channelNum)
		end
	end
	if tbl.print or (tbl.print == nil and IsActiveBattlefieldArena()) then
		newmessage = message:gsub("$player", destName)
		newmessage = newmessage:gsub("$type", "|cFFFF0000"..missType.."|r")
		ZHunter.print(newmessage)
	end
end

ZHunterModOptions.args.freezefail = {
	type = "group",
	name = "Неудачное замораживание",
	desc = "Опции настроек сообщений о несработанной Замораживающей ловушке.",
	order = 7,
	args = {
		description = {
			type = "description",
			name = "Отмеченое серым, используется только для оповещения когда вы находитесь на арене.",
			order = 1
		},
		format = {
			type = "input",
			name = "Сообщение",
			desc = "Изменение формата оповещающего сообщения. Используйте '$player' и '$type' для вывода цели ловушки и типа неудачи (сопротивление/иммунитет).",
			order = 2,
			get = function(info) return ZHunterMod_Saved.ZFreezeFail.format end,
			set = function(info, v) ZHunterMod_Saved.ZFreezeFail.format = v end
		},
		playSound = {
			type = "toggle",
			name = "Приграть звук",
			desc = "Вкл/Выкл проигрование звука при неудачной ловушке.",
			order = 3,
			get = function(info) return ZHunterMod_Saved.ZFreezeFail.playSound end,
			set = function(info, v) ZHunterMod_Saved.ZFreezeFail.playSound = v end
		}
	}
}

ZHunterModOptions_SetBroadcastOptions("ZFreezeFail", ZHunterModOptions.args.freezefail.args)