local directions = {TOP="Вверх", BOTTOM="Вниз", LEFT="Влево", RIGHT="Вправо"}
local triggers = {OnRightClick="При Правом-Клике", OnMouseOver="При наводе мыши", AlwaysOn="Всегда показывать"}

function ZActionBar_AddButtonOptions(bar, id)
	local buttonName = bar.name..id
	local saved = getglobal(bar.savedName)[bar.name]
	local options = bar.options.args[bar.name].args
	options.hotkeys.args["hotkey"..id] = {
		type = "keybinding",
		name = "Кнопка "..id,
		desc = "Установка назначения для "..id..".",
		order = id,
		get = function(info)
			local key = GetBindingKey("CLICK " .. buttonName .. ":LeftButton")
			return key
		end,
		set = function(info, v)
			SetBinding(v, "CLICK " .. buttonName .. ":LeftButton")
			SaveBindings(GetCurrentBindingSet());
		end
	}
	options.spells.args["button"..id] = {
		type = "select", style = "dropdown", values = bar.spellList,
		name = "Кнопка "..id, desc = "Назначте заклинание на кнопку "..id..".",
		order = id,
		get = function(info) return saved.spells[id] end,
		set = function(info, v)
			saved.spells[id] = v
			ZActionBar_UpdateBar(bar)
		end
	}
	options.custom.args.count.max = id
	options.custom.args.perRow.max = id
end

local defaults = {
	enabled = true,
	size = 30,
	roundButton = true,
	backgroundColor = {r=0.5, g=0.4, b=0.2},
	count = 99,
	perRow = 99,
	expand = "RIGHT",
	stack = "BOTTOM",
	trigger = "OnMouseOver",
	tooltip = true
}
defaults.x, defaults.y = UIParent:GetCenter()

local function validate(src, dest)
	for i, v in pairs(src) do
		local varType = type(v)
		if varType == "table" then
			if type(dest[i]) ~= "table" then
				dest[i] = {}
			end
			validate(v, dest[i])
		else
			local otherType = type(dest[i])
			if varType ~= otherType then
				if varType ~= "boolean" or otherType ~= "nil" then
					dest[i] = v
				end
			end
		end
	end
end

local function setDefaults(savedName, name)
	local saved = getglobal(savedName)
	if type(saved) ~= "table" then
		saved = {}
		setglobal(savedName, saved)
	end
	if not saved[name] then
		saved[name] = {}
	end
	saved = saved[name]
	validate(defaults, saved)
end

function ZActionBar_SetupOptions(bar)
	setDefaults(bar.savedName, bar.name)
	local saved = getglobal(bar.savedName)[bar.name]
	for i in pairs(defaults) do
		bar[i] = saved[i]
	end
	if bar.setupSpecial then
		bar.special = saved.special
	end
	bar.options.args[bar.name] = {
		type = "group",
		name = bar.name,
		desc = "Панели команд.",
		args = {
			custom = {
				type = "group",
				name = "Отображение",
				desc = "Настройка отображения кнопок.",
				order = 1,
				args = {
					size = {
						type = "range", min = 20, max = 50, step = 1,
						name = "Размер кнопок", desc = "Изменение размера кнопок заклинаний.",
						order = 1,
						get = function(info) return saved.size end,
						set = function(info, v)
							saved.size = v
							ZActionBar_SetSize(bar, v)
						end
					},
					count = {
						type = "range", min = 0, max = 0, step = 1,
						name = "Число кнопок", desc = "Назначение числа кнопок которые будут отображаться на панеле.",
						order = 2,
						get = function(info) return saved.count end,
						set = function(info, v)
							saved.count = v
							ZActionBar_SetCount(bar, v)
						end
					},
					roundButton = {
						type = "toggle",
						name = "Округленные кнопки", desc = "Делает края кнопок округленными.",
						order = 3,
						get = function(info) return saved.roundButton end,
						set = function(info, v)
							saved.roundButton = v
							ZActionBar_SetRoundButton(bar, v)
						end
					},
					backgroundColor = {
						type = "color", hasAlpha = false,
						name = "Цвет края", desc = "Установка цвета края кнопок.",
						order = 4,
						get = function(info) return saved.backgroundColor.r, saved.backgroundColor.g, saved.backgroundColor.b end,
						set = function(info, r, g, b)
							saved.backgroundColor.r = r
							saved.backgroundColor.g = g
							saved.backgroundColor.b = b
							ZActionBar_SetBackgroundColor(bar, saved.backgroundColor)
						end
					},
					expand = {
						type = "select", style = "dropdown", values = directions,
						name = "Направление раскрывания", desc = "Установка направления раскрытия кнопок.",
						order = 5,
						get = function(info) return saved.expand end,
						set = function(info, v)
							saved.expand = v
							ZActionBar_SetExpand(bar, v)
						end
					},
					stack = {
						type = "select", style = "dropdown", values = directions,
						name = "Направление набора", desc = "Установка направления рядов друг от друга.",
						order = 6,
						get = function(info) return saved.stack end,
						set = function(info, v)
							saved.stack = v
							ZActionBar_SetStack(bar, v)
						end
					},
					perRow = {
						type = "range", min = 1, max = 1, step = 1,
						name = "Кнопок в ряду", desc = "Назначение числа рядов в которых будет отображаться кнопки на панеле.",
						order = 7,
						get = function(info) return saved.perRow end,
						set = function(info, v)
							saved.perRow = v
							ZActionBar_SetPerRow(bar, v)
						end
					},
					trigger = {
						type = "select", style = "dropdown", values = triggers,
						name = "Поведение панели", desc = "Установка поведения отображения панели.",
						order = 8,
						get = function(info) return saved.trigger end,
						set = function(info, v)
							saved.trigger = v
							ZActionBar_SetTrigger(bar, v)
						end
					},
					tooltip = {
						type = "toggle",
						name = "Подсказка", desc = "Установка отображения подсказок при наведении мыши над кнопками.",
						order = 9,
						get = function(info) return saved.tooltip end,
						set = function(info, v)
							saved.tooltip = v
							ZActionBar_SetTooltip(bar, v)
						end
					}
				}
			},
			hotkeys = {
				type = "group",
				name = "Горячие клавиши",
				desc = "Установите горячие клавиши для кнопок.",
				order = 2,
				args = {}
			},
			spells = {
				type = "group",
				name = "Заклинания",
				desc = "Установка порядка отображения заклинаний.",
				order = 3,
				args = {}
			},
			enabled = {
				type = "toggle",
				name = "Включить панели",
				desc = "Переключение отображения панелей команд.",
				get = function(info) return saved.enabled end,
				set = function(info, v)
					saved.enabled = v
					ZActionBar_ToggleBar(bar, v)
				end
			}
		}
	}
	if bar.setupSpecial then
		bar.options.args[bar.name].args.custom.args.special = {
			type = "toggle",
			name = "Особый", desc = "Вкл/выкл использование на первой кнопки особую возможность.",
			order = 10,
			get = function(info) return saved.special end,
			set = function(info, v)
				saved.special = v
				ZActionBar_SetSpecial(bar, v)
			end
		}
	end
end