if select(2, UnitClass('player')) ~= "SHAMAN" then
	return
end

local LBF = LibStub("LibButtonFacade",true)
local LSM = LibStub("LibSharedMedia-3.0",true)
local AceGUI = LibStub("AceGUI-3.0",true)
local LDB = LibStub("LibDataBroker-1.1", true)
local L = LibStub("AceLocale-3.0"):GetLocale("Yata")
local resetkeys = {"shift", "ctrl", "alt", "none"}
function Yata:PopulateOptions()
	local options = {
	    name = "Yata",
	    handler = Yata,
	    type = 'group',
	    args = {
			lock = {
				name = L["Lock frames"],
				desc = L["Lock frames"],
				type = "toggle",
				get = function() return self.CurrentDb.Locked end,
				set = function(info, value)
					if(value) then
						Yata.Bar:Lock()
					else
						Yata.Bar:Unlock()
					end				
				end,
				disabled = function() return InCombatLockdown() end,
				},
			reset = {
					name = L["Reset"],
					desc = L["Reset all settings to defaults. Will reload UI."],
					type = "execute",
					func = function() self:Reset() end,
					disabled = function() return InCombatLockdown() end
				},
			totembuttons = {
				name = L["Totem buttons"],
				desc = L["Totem buttons configuration"],
				type = "group",
				args = {
					autobuttonswap = {
						name = L["Auto button-swap"],
						desc = L["Enable automatic button swapping"],
						type = "toggle",
						get = function() return self.CurrentDb.AutoButtonSwap end,
						set = function(info, value) Yata.Bar:SetAutoButtonSwap(value) end,
						disabled = function() return InCombatLockdown() end,
					},
					autoswaptocall = {
						name = L["Auto swap to call"],
						desc = L["If enabled, casting a call spell will bring the totems in that spell to the front"],
						type = "toggle",
						get = function() return self.CurrentDb.AutoSwapToCall end,
						set = function(info, value) Yata.Bar:SetAutoSwapToCall(value) end,
						disabled = function() return InCombatLockdown() end,
					},
					buttongap = {
						name = L["Button gap"],
						desc = L["Changes the gap between button"],
						type = "range",
						get = function() return self.CurrentDb.ButtonGap end,
						set = function(info, value) Yata.Bar:ConfigureBarDisplay(value, self.CurrentDb.BarOrientation, self.CurrentDb.VisibleButtons) end,
						min = -4,
						max = 8,
						step = 1,
						disabled = function() return InCombatLockdown() end,
					},					
					visiblebuttons = {
						name = L["Visible buttons"],
						desc = L["Changes the always-visible buttons"],
						type = "range",
						get = function() return self.CurrentDb.VisibleButtons end,
						set = function(info, value) Yata.Bar:ConfigureBarDisplay(self.CurrentDb.ButtonGap, self.CurrentDb.BarOrientation, value) end,
						min = 1,
						max = 10,
						step = 1,
						disabled = function() return InCombatLockdown() end,	
					},
					buttonsetcallkey = {
						name = L["Button assign to call key"],
						desc = L["Sets the key that will allow you to click to assign or remove a spell from a call"],
						type = "select",
						values = resetkeys,
						get = function() for k,v in ipairs(resetkeys) do if v == self.CurrentDb.ButtonSetCallKey then return k end end end,
						set = function(info, value) Yata.Bar:SetButtonSetCallKey(resetkeys[value]) end,
						disabled = function() return InCombatLockdown() end,
					},	
					buttonswapkey = {
						name = L["Button swap key"],
						desc = L["Changes the button swap key"],
						type = "select",
						values = resetkeys,
						get = function() for k,v in ipairs(resetkeys) do if v == self.CurrentDb.ButtonSwapKey then return k end end end,
						set = function(info, value) Yata.Bar:SetButtonSwapKey(resetkeys[value]) end,
						disabled = function() return InCombatLockdown() end,
					},
					buttonnoswapkey = {
						name = L["Button no-swap key"],
						desc = L["Changes the button no-swap key"],
						type = "select",
						values = resetkeys,
						get = function() for k,v in ipairs(resetkeys) do if v == self.CurrentDb.ButtonNoSwapKey then return k end end end,
						set = function(info, value) Yata.Bar:SetButtonNoSwapKey(resetkeys[value]) end,
						disabled = function() return InCombatLockdown() end,				
					},
					manualswaptocallkey = {
						name = L["Manual swap to call key"],
						desc = L["Changes the right click key that brings a call's totems to the front"],
						type = "select",
						values = resetkeys,
						get = function() for k,v in ipairs(resetkeys) do if v == self.CurrentDb.ManualSwapToCallKey then return k end end end,
						set = function(info, value) Yata.Bar:SetManualSwapToCallKey(resetkeys[value]) end,
						disabled = function() return InCombatLockdown() end,				
					},
					shorttooltip = {
						name = L["Short tooltip"],
						desc = L["Enable short tooltip"],
						type = "toggle",
						get = function() return self.CurrentDb.ShortTooltip end,
						set = function(info, value) self.CurrentDb.ShortTooltip = value end,
						disabled = function() return InCombatLockdown() end,
					},
				},
			},
			totembar = {
				name = L["Totem bar"],
				desc = L["Totem bar configuration"],
				type = "group",
				args = {
					barorientation = {
						name = L["Bar orientation"],
						desc = L["Changes the bar orientation"],
						type = "select",
						values = {L["Horizontal, Top-Popup"], L["Horizontal, Bottom-Popup"], L["Vertical, Right-Popup"], L["Vertical, Left-Popup"] },
						get = function() return self.CurrentDb.BarOrientation end,
						set = function(info, value) Yata.Bar:ConfigureBarDisplay(self.CurrentDb.ButtonGap, value, self.CurrentDb.VisibleButtons) end,
						disabled = function() return InCombatLockdown() end,
					},
					barscale = 	{
						name = L["Bar scale"],
						desc = L["Changes the bar scaling"],
						type = "range",
						get = function() return self.CurrentDb.BarScale end,
						set = function(info, value)
							self.CurrentDb.BarScale = value 
							self.Bar:SetScale(self.CurrentDb.BarScale)
						end,
						min = 0.5,
						max = 2.5,
						step = 0.01,
						bigStep = 0.05,
						disabled = function() return InCombatLockdown() end,
					},
					popoutscale = 	{
						name = L["Pop-out scale"],
						desc = L["Changes the scale of the pop-out buttons"],
						type = "range",
						get = function() return self.CurrentDb.PopOutScale end,
						set = function(info, value)
							self.CurrentDb.PopOutScale = value 
							Yata.Bar:SetPopOutScale(value)
						end,
						min = 0.5,
						max = 1.5,
						step = 0.05,
						bigStep = 0.05,
						disabled = function() return InCombatLockdown() end,
					},
					totemlayout = {
						name = L["Layout editor"],
						desc = L["Changes the layout of the totem buttons"],
						type = "execute",
						func = function() local editor = AceGUI:Create("Yata_TotemButtonLayoutEditor") end,
						disabled = function() return InCombatLockdown() end,
					},
				},				
			},
			totemtimers = {
				name = L["Totem timers"],
				desc = L["Totem timers"],
				type = "group",
				args = {
					enabletimers = {
						name = L["Enable timers"],
						desc = L["Enable timers"],
						type = "toggle",
						get = function() return self.CurrentDb.TimerEnabled end,
						set = function(info, value) self.CurrentDb.TimerEnabled = value end,
						disabled = function() return InCombatLockdown() end,
					},
					timerscale = 	{
						name = L["Timer scale"],
						desc = L["Changes the timer scaling"],
						type = "range",
						get = function() return self.CurrentDb.TimerScale end,
						set = function(info, value)
							self.CurrentDb.TimerScale = value 
							self:SetTimerScale(self.CurrentDb.TimerScale)
						end,
						min = 0.5,
						max = 2.5,
						step = 0.01,
						bigStep = 0.05,
						disabled = function() return InCombatLockdown() end,
					},					
					timertype = {
						name = L["Timer type"],
						desc = L["Changes the timer type"],
						type = "select",
						values = {L["Timer bars"], L["Button timer"]},
						get = function() return self.CurrentDb.TimerType end,
						set = function(info, value) self.CurrentDb.TimerType = value end,
						disabled = function() return InCombatLockdown() end,
					},					
				},
			},
			totemmacro = {
				name = L["Totem macro"],
				desc = L["Totem macro"],
				type = "group",
				args = {
					resetkey = {
						name = L["Macro reset key"],
						desc = L["Changes the macro reset key"],
						type = "select",
						values = resetkeys,
						get = function() for k,v in ipairs(resetkeys) do if v == self.CurrentDb.MacroResetKey then return k end end end,
						set = function(info, value) local oldKey = self.CurrentDb.MacroResetKey self.CurrentDb.MacroResetKey = resetkeys[value] Yata.Bar:EditMacro(oldKey, self.CurrentDb.MacroResetKey) end,
						disabled = function() return InCombatLockdown() end,
					},
				},
			},
		},
	}
	if LBF then
		buttonskin = {
			name = L["Button Skin"],
			desc = L["Sets the Button Skin"],
			type = "select",
			values = function() return LBF:ListSkins() end,
			get = function() return self.CurrentDb.ButtonSkin  end,
			set = function(info, value) Yata.Bar:SkinButtons(value) end,
			disabled = function() return InCombatLockdown() end,
		}
		options.args.totembuttons.args["buttonskin"] = buttonskin
	end
	if LSM then
		timerbarskin = {
			name = L["Timer bar texture"],
			desc = L["Changes the timer bar texture"],
			type = "select",
			values = function() return LSM:List("statusbar") end,
			get = function() for k,v in ipairs(LSM:List("statusbar")) do if v == self.CurrentDb.TimerBarSkin then return k end end end,
			set = function(info, value) self.CurrentDb.TimerBarSkin = LSM:List("statusbar")[value] self:LoadTimerConfig() end,
			disabled = function() return InCombatLockdown() end,
		}
		options.args.totemtimers.args["timerbarskin"] = timerbarskin
	end
	return options
end 

-- Adapted from Nevcairiel's Bartender4
if LDB then
	LibStub("LibDataBroker-1.1"):NewDataObject("Yata", {
		type = "launcher",
		text = "Yata",
		label = "Yata",
		OnClick = function(_, msg)
			if msg == "LeftButton" then
				if Yata.CurrentDb.Locked then
					Yata.Bar:Unlock()
				else
					Yata.Bar:Lock()
				end
			elseif msg == "RightButton" then
				if LibStub("AceConfigDialog-3.0").OpenFrames["Yata"] then
					LibStub("AceConfigDialog-3.0"):Close("Yata")
				else
					LibStub("AceConfigDialog-3.0"):Open("Yata")
				end
			end
		end,
		icon = "Interface\\Icons\\Spell_Nature_EarthBindTotem",
		OnTooltipShow = function(tooltip)
			if not tooltip or not tooltip.AddLine then return end
			tooltip:AddLine("Yata")
			tooltip:AddLine(L["Click to toggle bar lock"])
			tooltip:AddLine(L["Right-click to open the options menu"])
		end,
	})
end

	StaticPopupDialogs["Yata_AddSet"] = {
		text = L["Enter name for new set"],
		button1 = ACCEPT,
		button2 = CANCEL,
		timeout = 0,
		hasEditBox = 1,
		whileDead = 1,
		hideOnEscape = 1,
		OnAccept = function(self,data) this:GetParent().data:AddSet(getglobal(this:GetParent():GetName().."EditBox"):GetText()) end,
		OnCancel = function() end,
	}
	
	StaticPopupDialogs["Yata_DelSet"] = {
		text = L["Enter set name to delete"],
		button1 = ACCEPT,
		button2 = CANCEL,
		timeout = 0,
		hasEditBox = 1,
		whileDead = 1,
		hideOnEscape = 1,
		OnAccept = function(self,data) this:GetParent().data:DelSet(getglobal(this:GetParent():GetName().."EditBox"):GetText()) end,
		OnCancel = function() end,
	}