﻿if select(2, UnitClass('player')) ~= "SHAMAN" then
	return
end

Yata = LibStub("AceAddon-3.0"):NewAddon("Yata", "AceConsole-3.0", "AceEvent-3.0", "LibBars-1.0")
local L = LibStub("AceLocale-3.0"):GetLocale("Yata")
local LibKeyBound = LibStub("LibKeyBound-1.0")
local AceConfigDialog = LibStub("AceConfigDialog-3.0")

TOTEM_SET_PRIMARY_DEFAULT = "Default"
TOTEM_SET_SECONDARY_DEFAULT = "Secondary Default"
SPELL_GROUP_CALL = "CallSpell"
SPELL_GROUP_IMBUE = "Imbue"

SpellGroups = {"Earth", "Air", "Water", "Fire", SPELL_GROUP_CALL, SPELL_GROUP_IMBUE}
ElementsMap = {["Fire"] = 1, ["Earth"] = 2, ["Water"] = 3, ["Air"] = 4}

local defaults = {
	profile = {
		BarScale = 1.0,
		PopOutScale = 0.85,
		BarOrientation = 1,		
		ButtonGap = 0,
		VisibleButtons = 1,
		AutoButtonSwap = true,
		Locked = true,
		ShowTooltip = true,
		ShortTooltip = true,
		TimerEnabled = true,
		TimerType = 1,
		TimerScale = 1.0,
		ButtonSkin = "Onyx",
		TimerBarSkin = "Blizzard",
		MacroResetKey = "none",
		ButtonSetCallKey = "alt",
		ButtonSwapKey = "ctrl",
		ButtonNoSwapKey = "shift",
		ManualSwapToCallKey = "alt",
		AutoSwapToCall = false,
		CurrentTotemSet = TOTEM_SET_PRIMARY_DEFAULT,
		InitialSpec = nil,
		alternativespec = {
			BarScale = 1.0,
			PopOutScale = 0.85,
			BarOrientation = 1,		
			ButtonGap = 0,
			VisibleButtons = 1,
			AutoButtonSwap = true,
			Locked = true,
			ShowTooltip = true,
			ShortTooltip = true,
			TimerEnabled = true,
			TimerType = 1,
			TimerScale = 1.0,
			ButtonSkin = "Onyx",
			TimerBarSkin = "Blizzard",
			MacroResetKey = "none",
			ButtonSetCallKey = "alt",
			ButtonSwapKey = "ctrl",
			ButtonNoSwapKey = "shift",
			ManualSwapToCallKey = "alt",
			AutoSwapToCall = false,
			CurrentTotemSet = TOTEM_SET_PRIMARY_DEFAULT,
			FirstUse = true
		}
	},
};

function Yata:OnInitialize()
    -- Called when the addon is loaded
	self.db = LibStub("AceDB-3.0"):New("YataDB", defaults)
	
	LibStub("AceConfig-3.0"):RegisterOptionsTable("Yata", self:PopulateOptions(), {"yatacmd"})
	
	self:RegisterChatCommand("yata", function() AceConfigDialog:Open("Yata") end)	
	self.optionsFrame = AceConfigDialog:AddToBlizOptions("Yata", nil, nil)
	
	LibKeyBound.RegisterCallback(self, "LIBKEYBOUND_ENABLED")
	LibKeyBound.RegisterCallback(self, "LIBKEYBOUND_DISABLED")
	LibKeyBound.RegisterCallback(self, "LIBKEYBOUND_MODE_COLOR_CHANGED")
end

function Yata:OnEnable()
	
	if self.Bar then
		self.Bar:Destroy()
	end

	local firstUse = self:SetActiveTalentProfile()
	
	self.Bar = TotemBar:Create() 

	self:RegisterEvent("LEARNED_SPELL_IN_TAB", "Reload")
	self:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED", "Reload") -- just to be sure
	
	RegisterStateDriver(MultiCastActionBarFrame, "visibility", "hide");

	if firstUse == true then
		print ("First time in this spec: copying yata profile and reloading")
		self:Reload()
	end
end

function Yata:OnDisable()
	if self.Bar then
		self.Bar:Destroy()
	end
end

function Yata:Reload()
	self:UnregisterAllEvents()

	self:OnDisable()
	
	self:OnEnable()
end

function Yata:Reset()
	self.db:ResetProfile()
	ReloadUI()
end

function Yata:SetActiveTalentProfile()
	local specIndex = GetActiveTalentGroup(false, false)
	local firstUse = false
	
	if self.db.profile.InitialSpec == nil then
		self.db.profile.InitialSpec = specIndex
	end

	if specIndex == self.db.profile.InitialSpec then
		self.CurrentDb = self.db.profile
	else
		self.CurrentDb = self.db.profile.alternativespec
		if self.db.profile.alternativespec.FirstUse == true then
			self.db.profile.alternativespec = Yata:deepcopy(self.db.profile)
			
			self.db.profile.alternativespec.alternativespec = nil
			
			self.db.profile.alternativespec.FirstUse = false
			
			firstUse = true
		end
	end
	
	return firstUse	
end

function Yata:deepcopy(object)
    local lookup_table = {}
    local function _copy(object)
        if type(object) ~= "table" then
            return object
        elseif lookup_table[object] then
            return lookup_table[object]
        end
        local new_table = {}
        lookup_table[object] = new_table
        for index, value in pairs(object) do
            new_table[_copy(index)] = _copy(value)
        end
        return setmetatable(new_table, getmetatable(object))
    end
    return _copy(object)
end