if not ShockAndAwe then return end

local L = LibStub("AceLocale-3.0"):GetLocale("ShockAndAwe")
local media = LibStub:GetLibrary("LibSharedMedia-3.0");
local C = ShockAndAwe.constants -- Defined in ShockAndAwe LUA no locale needed.
local _, _, _, clientVersion = GetBuildInfo()

ShockAndAwe.emptyOptions = { "none", "none", "none", "none", "none", "none", "none", "none", "none", "none", "none", "none", "none", "none", "none", "none" }
ShockAndAwe.singleOptions = { "mw5_lb", "fs", "ss_0", "ls_0", "fe_boss", "mt_0", "sw_boss", "sr_boss", "es", "ss", "ll", "fn", "mt", "shield", "none", "none" }
ShockAndAwe.aoeOptions = { "mw5_cl", "mw5_lb", "fn", "mt_0", "fs", "ss_0", "ls_0", "fe_boss", "sr_boss", "es", "ss", "ll", "fn", "mt", "shield", "none" }

ShockAndAwe.fonteffects = {
	["none"] = L["None"],
	["OUTLINE"] = L["OUTLINE"],
	["THICKOUTLINE"] = L["THICKOUTLINE"],
	["MONOCHROME"] = L["MONOCHROME"],
}

-------------------
-- Config details
-------------------

ShockAndAwe.defaults = {
	char = {
		disabled = false,
		specchangewarning = true,
		message = "Welcome Home!",
		movingframes = true,
		showicons = true,
		relativeTo = "UIParent",
		relativePoint = "CENTER",
		point = "CENTER",
		texture = "Blizzard",
		barfont = "Friz Quadrata TT",
		barfontsize = 12,
		barfonteffect = "none",
		msgfont = "Friz Quadrata TT",
		msgfontsize = 24,
		msgfonteffect = "none",
		border = "None",
		barborder = "Blizzard Tooltip",
		mw4sound = "Sound\\Spells\\ShootWandLaunchLightning.wav",
		mw4soundname = "SAA Maelstrom 1",
		mw5sound = "Sound\\Spells\\DynamiteExplode.wav",
		mw5soundname = "SAA Maelstrom 2",
		shieldsound = "Sound\\Doodad\\BellowIn.wav",
		shieldsoundname = "SAA Shield 1",
		weaponsound = "Sound\\Doodad\\BellowIn.wav",
		weaponsoundname = "SAA Shield 1",
		xOffset = 0,
		yOffset = -100,
		fWidth = 300,
		fHeight = 175,
		resetOn = true,
		scale = 1,
		ShockPercent = .6,
		ShearPercent = .6,
		shockshow = true,
		shearshow = false,
		windshearshow = true,
		threatThreshold = 90,
		ssshow = true,
		firetotemshow = true,
		wfshow = true,
		fsdotshow = true,
		gcdshow = false,
		gcdfullwidth = false,
		llshow = true,
		fnshow = true,
		fsshow = true,
		disablebars = false,
		maelstromTalents = 0,
		lavaLashTalented = false,
		feralSpiritTalented = false,
		mw4soundplay = true,
		mw5soundplay = true,
		mw5repeat = 3,
		mwflash = true,
		shieldshow = true,
		msshow = true,
		msstacks = 0,
		arena = false,
		barstext = true,
		SSlen = 10,
		LLlen = 6,
		ShockLen = 6,
		ShearLen = 6,
		lastshock = "",
		debug = false,
		msg = { r = 1, g = .5, b = 0, },
		msgtime = 2,
		newsitem = 0,
		castweaponrebuff = false,
		MSBToutputarea = "Notification",
		colours = {
			watershield = { r=.6, g=.6,	b=1, a=.3 },
			lightningshield = { r=0, g=0, b=1, a=.5 },
			earthshield = { r=0, g=1, b=0, a=.5 },
			noshield = { r=1, g=0, b=0, a=1 },
			
			flameshock = { r=1, g=.6, b=.2, a=.9 },
			flameshockDot = { r=1, g=.6, b=.2, a=.6 },
			earthshock = { r=0, g=1, b=.3, a=.9 },
			frostshock = { r=.6, g=.6, b=1, a=.9 },
			windshear = { r=.6, g=.6, b=.6, a=.9 },
			
			maelstrom = { r=1, g=.5, b=1, a=.3 },
			msalpha = .3,
			msalphaFull = .9,

			magma = { r=.9, g=.4, b=0, a=.9 },
			lavalash = { r=1, g=.1, b=.1, a=.9 },
			feralspirit = { r=0, g=.6, b=.95, a=.9 },
			feralspiritCD = { r=0, g=.6, b=.95, a=.9 },
			stormstrike = { r=1, g=1, b=.2, a=.9 },
			firenova = { r=1, g=.9, b=.4, a=.9 },
			windfury = { r=1, g=0, b=0, a=.5 },
		},
		uptime = {
			show = true,
			fWidth = 120,
			fHeight = 120,
			barWidth = 100,
			barHeight = 20,
			relativeTo = "UIParent",
			relativePoint = "CENTER",
			point = "CENTER",
			xOffset = -200,
			yOffset = -275,
			alpha = 0.4,
			scale = 1,
			flurry = { r = .2, g = .1, b = 1, a = 0.5, },
			ed = { r = 1, g = 1, b = .8, a = 0.5, },
			ur = { r = 1, g = .5, b = 0, a = 0.5, },
		},
		stats = {
			show = true,
			fWidth = 120,
			fHeight = 200,
			barWidth = 100,
			barHeight = 20,
			relativeTo = "self.UptimeFrame",
			relativePoint = "TOPLEFT",
			point = "TOPLEFT",
			xOffset = 125,
			yOffset = 0,
			alpha = 0.4,
			scale = 1,	
			wfcalc = true,
			wfcol = { r = 1, g = .5, b = 0, a = 0.8, },
			wftime = 2,
			best = {
				ap = 0,
				spellpower = 0,
				meleehit = 0,
				spellhit = 0,
				expertise = 0,
				meleecrit = 0,
				spellcrit = 0,
				wfmh = 0,
				wfoh = 0,
				stormstrike = 0,
			},
		},
		priority = {
			show = true,
			titleshow = true,
			relativeTo = "UIParent",
			relativePoint = "CENTER",
			point = "CENTER",
			fWidth = 50,
			fHeight = 50,
			xOffset = -215,
			yOffset = -60,
			alpha = 0.4,
			scale = 1,	
			next = 1,
			cooldown = 0.5,
			fsticksleft = 2,
			totemtimeleft = 20,
			srmana = 10,
			wsmana = 0,
			shieldorbs = 1,
			magmaticks = 2,
			magmatime = 0,
			hwhealth = 25,
			chingroup = true,
			worldbossonly = true,
			hideImmune = true,
			combopoints = true,
			showpurge = true,
			showinterrupt = true,
			showcooldown = true,
			prOption = ShockAndAwe.singleOptions,
			groupnumber = 1, 
			prOptions = { 	
					ShockAndAwe.singleOptions, 
					ShockAndAwe.aoeOptions, 
					ShockAndAwe.emptyOptions, 
					ShockAndAwe.emptyOptions, 
					ShockAndAwe.emptyOptions }
		},
		binding = {
			show = true,
			relativeTo = "UIParent",
			relativePoint = "CENTER",
			point = "CENTER",
			fWidth = 200,
			fHeight = 50,
			xOffset = -200,
			yOffset = -100,
			alpha = 0.4,
			scale = 1,	
			mhspell = C["Windfury Weapon"],
			ohspell = C["Flametongue Weapon"],
			macroset = false,
		},
		warning = {
			show = true,
			duration = 3,
			shield = false,
			weapon = true,
			range = false,
			grounding = true,
			interrupt = true,
			purge = true,
			timeleft = 300, 
			colour = { r = 1, g = .5, b = 0, a = 0.5, },
			relativeTo = "UIParent",
			relativePoint = "TOP",
			point = "CENTER",
			fWidth = 400,
			fHeight = 75,
			xOffset = 0,
			yOffset = -250,
		},
	}
}

function ShockAndAwe:VerifyOptions()
	self.db.char.priority.option =  nil -- remove old format of options
	self.db.char.priority.options = nil
	if not self.db.char.priority.prOption then -- fix for corruption in v5.50
		self.db.char.priority.prOption = ShockAndAwe.emptyOptions
		self:Print(L["ShockAndAwe Warning : No options set"])
	end
	for index = 1, 16 do
		if not self.db.char.priority.prOption[index] then
			self.db.char.priority.prOption[index] = "none"
		end
	end
	for group = 1, 5 do
		for index = 1, 16 do
			if not self.db.char.priority.prOptions[group][index] then
				self.db.char.priority.prOptions[group][index] = "none"
			end
		end
	end
end

function ShockAndAwe:GetOptions()
	local options = { 
		name = "ShockAndAwe",
		handler = ShockAndAwe,
		type='group',
		childGroups ='tree',
		args = {
			frames = {
				name = L["Frame Options"],
				type = 'group',
				order = 1,
				args = {
					width = {
						type = 'range',
						name = L["Bar Width"],
						desc = L["help_width"],
						min = 100,
						max = 500,
						step = 10,
						get = "GetWidth",
						set = "SetWidth",
						order = 32,
					},
					scale = {
						type = 'range',
						name = L["Bar Scale"],
						desc = L["help_scale"],
						min = 0.10,
						max = 2.00,
						step = 0.05,
						get = "GetScale",
						set = "SetScale",
						order = 33,
					},
					resetbars = {
						type = 'execute',
						name = L["Reset Bars"],
						desc = L["help_reset"],
						func = "ResetBars",
						order = 34,
					},
					resetuptime = {
						type = 'execute',
						name = L["Reset Uptime"],
						desc = L["help_reset_uptime"],
						func = "ResetUptime",
						order = 35,
					},
					resetpriority = {
						type = 'execute',
						name = L["Reset Priority"],
						desc = L["help_reset_priority"],
						func = "ResetPriority",
						order = 36,
					},
				},
			},
			bars = {
				name = L["Timer Bars"],
				type = 'group',
				order = 2,
				args = {
					disable = {
						type = 'toggle',
						name = L["Disable out of combat"],
						desc = L["help_disablebars"],
						get = "disableQuery",
						set = "Activatedisable",
						order = 1,
						},
					icons = {
						type = 'toggle',
						name = L["Show bar icons"],
						desc = L["help_baricons"],
						get = "bariconsQuery",
						set = "ActivateBarIcons",
						order = 2,
						},
					break1 = {
						type = 'header',
						name = L["Bars Section"],
						dialogHidden = true,
						order = 10,
					},
					feralspiritbar = {
						type = 'toggle',
						name = L["Feral Spirit Bar"],
						desc = L["help_feralspirit"],
						get = "feralspiritQuery",
						set = "ActivateFeralSpirit",
						order = 11,
						},
					shieldbar = {
						type = 'toggle',
						name = L["Shield Bar"],
						desc = L["help_shield"],
						get = "shieldQuery",
						set = "ActivateShield",
						order = 11,
						},
					maelstrom = {
						type = 'toggle',
						name = L["Maelstrom Bar"],
						desc = L["help_maelstrom"],
						get = "maelstromQuery",
						set = "ActivateMaelstrom",
						order = 12,
						},
					SS = {
						type = 'toggle',
						name = L["Stormstrike Bar"],
						desc = L["help_ss"],
						get = "SSQuery",
						set = "ActivateSS",
						order = 13,
					},
					magma = {
						type = 'toggle',
						name = L["Fire Totem Bar"],
						desc = L["help_magma"],
						get = "FireTotemQuery",
						set = "ActivateFireTotem",
						order = 13,
					},
					WF = {
						type = 'toggle',
						name = L["Windfury Bar"],
						desc = L["help_wf"],
						get = "WFQuery",
						set = "ActivateWF",
						order = 14,
					},
					shock = {
						type = 'toggle',
						name = L["Shock Bar"],
						desc = L["help_shock"],
						get = "shockQuery",
						set = "ActivateShock",
						order = 15,
					},
					fsdot = {
						type = 'toggle',
						name = L["FS Dot Bar"],
						desc = L["help_fsdot"],
						get = "fsdotbarQuery",
						set = "ActivateFSDotBar",
						order = 16,
					},
					shear = {
						type = 'toggle',
						name = L["Shear Bar"],
						desc = L["help_shear"],
						get = "shearQuery",
						set = "ActivateShear",
						order = 17,
					},
					gcd = {
						type = 'toggle',
						name = L["GCD"],
						desc = L["help_gcd"],
						get = "gcdQuery",
						set = "ActivateGCD",
						order = 18,
					},
					gcdfullwidth = {
						type = 'toggle',
						name = L["GCD full width"],
						desc = L["help_gcd_fullwidth"],
						get = "gcdFullwidthQuery",
						set = "ActivateGCDfullwidth",
						order = 19,
					},
					lavalash = {
						type = 'toggle',
						name = C["Lava Lash"],
						desc = L["help_lavalash"],
						get = "lavalashQuery",
						set = "ActivateLavaLash",
						order = 20,
					},
					firenova = {
						type = 'toggle',
						name = C["Fire Nova"],
						desc = L["help_firenova"],
						get = "firenovaQuery",
						set = "ActivateFireNova",
						order = 21,
					},
					break4 = {
						type = 'header',
						name = L["Misc Options"],
						dialogHidden = true,
						order = 40,
					},
					arena = {
						type = 'toggle',
						name = L["4 piece arena bonus"],
						desc = L["help_arena"],
						get = "arenaQuery",
						set = "ActivateArena",
						order = 42,
					},
					text = {
						type = 'toggle',
						name = L["Text Display"],
						desc = L["help_textonbars"],
						get = "textOnBarsQuery",
						set = "ActivateTextOnBars",
						order = 43,
					},
					mw4sound = {
						type = 'toggle',
						name = L["Maelstrom Sound 4"],
						desc = L["help_mw4soundplay"],
						get = "mw4soundplayQuery",
						set = "ActivateMW4sound",
						order = 44,
					},
					mw5sound = {
						type = 'toggle',
						name = L["Maelstrom Sound 5"],
						desc = L["help_mw5soundplay"],
						get = "mw5soundplayQuery",
						set = "ActivateMW5sound",
						order = 45,
					},
					mwflash = {
						type = 'toggle',
						name = L["Maelstrom Flash"],
						desc = L["help_mw5flash"],
						get = "mw5flashQuery",
						set = "ActivateMW5flash",
						order = 46,
					},
				},
			},
			barcolours = {
				name = L["Bar Colours"],
				type = 'group',
				order = 3, 
				args = {
					break1 = {
						type = 'header',
						name = L["Shields"],
						dialogHidden = true,
						order = 1,
					},
					watershield = {
						type = 'color',
						name = L["Water Shield Colour"],
						desc = L["colWaterShield"],
						get = "getWaterShieldColour",
						set = "setWaterShieldColour",
						hasAlpha = true,
						order = 2,
					},
					lightningshield = {
						type = 'color',
						name = L["Lightning Shield Colour"],
						desc = L["colLightningShield"],
						get = "getLightningShieldColour",
						set = "setLightningShieldColour",
						hasAlpha = true,
						order = 3,
					},
					earthshield = {
						type = 'color',
						name = L["Earth Shield Colour"],
						desc = L["colEarthShield"],
						get = "getEarthShieldColour",
						set = "setEarthShieldColour",
						hasAlpha = true,
						order = 4,
					},
					noshield = {
						type = 'color',
						name = L["Shield Down Colour"],
						desc = L["colNoShield"],
						get = "getNoShieldColour",
						set = "setNoShieldColour",
						hasAlpha = false,
						order = 5,
					},
					break2 = {
						type = 'header',
						name = L["Shocks"],
						dialogHidden = true,
						order = 6,
					},
					flameshock = {
						type = 'color',
						name = L["Flame Shock Colour"],
						desc = L["colFlameShock"],
						get = "getFlameShockColour",
						set = "setFlameShockColour",
						hasAlpha = true,
						order = 7,
					},
					flameshockdot = {
						type = 'color',
						name = L["FS Dot Colour"],
						desc = L["colFlameShockDot"],
						get = "getFlameShockDotColour",
						set = "setFlameShockDotColour",
						hasAlpha = true,
						order = 8,
					},
					earthshock = {
						type = 'color',
						name = L["Earth Shock Colour"],
						desc = L["colEarthShock"],
						get = "getEarthShockColour",
						set = "setEarthShockColour",
						hasAlpha = true,
						order = 9,
					},
					frostshock = {
						type = 'color',
						name = L["Frost Shock Colour"],
						desc = L["colFrostShock"],
						get = "getFrostShockColour",
						set = "setFrostShockColour",
						hasAlpha = true,
						order = 10,
					},
					windshear = {
						type = 'color',
						name = L["Wind Shear Colour"],
						desc = L["colWindShear"],
						get = "getWindShearColour",
						set = "setWindShearColour",
						hasAlpha = true,
						order = 11,
					},
					break3 = {
						type = 'header',
						name = L["Maelstrom Bar"],
						dialogHidden = true,
						order = 12,
					},
					maelstrom = {
						type = 'color',
						name = L["Maelstrom Bar Colour"],
						desc = L["colMaelstrom"],
						get = "getMaelstromColour",
						set = "setMaelstromColour",
						hasAlpha = false,
						order = 13,
					},
					msalpha = {
						type = 'range',
						name = L["Maelstrom Alpha"],
						desc = L["colMaelstromAlpha"],
						min = 0,
						max = 1,
						isPercent = true,
						get = "GetMSalpha",
						set = "SetMSalpha",
						order = 14,
					},
					msalphaFull = {
						type = 'range',
						name = L["Maelstrom Full Alpha"],
						desc = L["colMaelstromFullAlpha"],
						min = 0,
						max = 1,
						isPercent = true,
						get = "GetMSalphaFull",
						set = "SetMSalphaFull",
						order = 15,
					},
					break4 = {
						type = 'header',
						name = L["Other Bars"],
						dialogHidden = true,
						order = 20,
					},
					stormstrike = {
						type = 'color',
						name = L["Stormstrike Bar Colour"],
						desc = L["colStormstrike"],
						get = "getStormstrikeColour",
						set = "setStormstrikeColour",
						hasAlpha = true,
						order = 21,
					},
					windfury = {
						type = 'color',
						name = L["Windfury Bar Colour"],
						desc = L["colWindfury"],
						get = "getWindfuryColour",
						set = "setWindfuryColour",
						hasAlpha = true,
						order = 22,
					},
					lavalash = {
						type = 'color',
						name = L["Lava Lash Bar Colour"],
						desc = L["colLavaLash"],
						get = "getLavaLashColour",
						set = "setLavaLashColour",
						hasAlpha = true,
						order = 23,
					},
					firenova = {
						type = 'color',
						name = L["Fire Nova Bar Colour"],
						desc = L["colFireNova"],
						get = "getFireNovaColour",
						set = "setFireNovaColour",
						hasAlpha = true,
						order = 24,
					},
					magma = {
						type = 'color',
						name = L["Fire Bar Colour"],
						desc = L["colMagma"],
						get = "getMagmaColour",
						set = "setMagmaColour",
						hasAlpha = true,
						order = 25,
					},
					feralspirit = {
						type = 'color',
						name = L["Feral Spirit Bar Colour"],
						desc = L["colFeralSpirit"],
						get = "getFeralSpiritColour",
						set = "setFeralSpiritColour",
						hasAlpha = true,
						order = 26,
					},
					feralspiritCD = {
						type = 'color',
						name = L["Feral Spirit CD Bar Colour"],
						desc = L["colFeralSpiritCD"],
						get = "getFeralSpiritCDColour",
						set = "setFeralSpiritCDColour",
						hasAlpha = true,
						order = 27,
					},
				},
			},
			priority = {
				name = L["Priority Frame"],
				type = 'group',
				order = 4, 
				args = {
					priority = {
						type = 'toggle',
						name = L["Priority Frame"],
						desc = L["help_priority"],
						get = "priorityQuery",
						set = "ActivatePriority",
						order = 21,
					},
					title = {
						type = 'toggle',
						name = L["Display frame title"],
						get = "priorityTitleQuery",
						set = "ActivatePriorityTitle",
						order = 22,
					},
					combopoints = {
						type = 'toggle',
						name = L["Combo Points"],
						desc = L["help_combopoints"],
						get = "combopointsQuery",
						set = "ActivateComboPoints",
						order = 23,
					},
					priorityscale = {
						type = 'range',
						name = L["Priority Bar Scale"],
						desc = L["help_priority_scale"],
						min = 0.50,
						max = 2.00,
						step = 0.01,
						get = "GetPriorityScale",
						set = "SetPriorityScale",
						order = 24,
					},
					windshear = {
						type = 'toggle',
						name = C["Wind Shear"],
						desc = L["help_windshear"],
						get = "windshearQuery",
						set = "ActivateWindShear",
						order = 25,
					},
					worldbossonly = {
						type = 'toggle',
						name = L["World Boss Only"],
						desc = L["help_worldbossonly"],
						get = "worldbossQuery",
						set = "ActivateWorldBoss",
						order = 25,
					},
					hideImmuneSpells = {
						type = 'toggle',
						name = L["Hide Immune Spells"],
						desc = L["help_hideimmunespells"],
						get = "hideImmuneQuery",
						set = "ActivateHideImmune",
						order = 26,
					},
					showinterrupt = {
						type = 'toggle',
						name = L["Show Interrupt"],
						desc = L["help_showinterrupt"],
						get = "showinterruptQuery",
						set = "ActivateShowInterrupt",
						order = 27,
					},
					showpurge = {
						type = 'toggle',
						name = L["Show Purge"],
						desc = L["help_showpurge"],
						get = "showpurgeQuery",
						set = "ActivateShowPurge",
						order = 28,
					},
					showcooldown = {
						type = 'toggle',
						name = L["Show Cooldown"],
						desc = L["help_showcooldown"],
						get = "showcooldownQuery",
						set = "ActivateShowCooldown",
						order = 29,
					},
					threat = {
						type = 'range',
						name = L["Threat Threshold"],
						desc = L["help_threat"],
						min = 75,
						max = 110,
						step = 1,
						get = "GetThreatThreshold",
						set = "SetThreatThreshold",
						order = 50,
					},
					cooldown = {
						type = 'range',
						name = L["Cooldown Threshold"],
						desc = L["help_cooldown"],
						min = 0,
						max = 1.5,
						step = 0.05,
						get = "GetCooldownThreshold",
						set = "SetCooldownThreshold",
						order = 51,
					},
					fsticksleft = {
						type = 'range',
						name = L["Flame Shock Ticks Left"],
						desc = L["help_fsticksleft"],
						min = 0,
						max = 6,
						step = 1,
						get = "GetFSTicksLeft",
						set = "SetFSTicksLeft",
						order = 52,
					},
--~ 					totemtimeleft = {
--~ 						type = 'range',
--~ 						name = L["Totem Time Left"],
--~ 						desc = L["help_totemtimeleft"],
--~ 						min = 0,
--~ 						max = 300,
--~ 						step = 5,
--~ 						get = "GetTotemTimeLeft",
--~ 						set = "SetTotemTimeLeft",
--~ 						order = 35,
--~ 					},
					hwhealth = {
						type = 'range',
						name = L["Healing Wave Health%"],
						desc = L["help_hwhealth"],
						min = 1,
						max = 100,
						step = 1,
						get = "GetHWHealth",
						set = "SetHWHealth",
						order = 53,
					},
					chingroup = {
						type = 'toggle',
						name = L["Chain Heal in group"],
						desc = L["help_chingroup"],
						get = "GetCHInGroup",
						set = "SetCHInGroup",
						order = 54,
					},
					srmana = {
						type = 'range',
						name = L["Shamanistic Rage Level%"],
						desc = L["help_srmana"],
						min = 0,
						max = 50,
						step = 1,
						get = "GetSRMana",
						set = "SetSRMana",
						order = 55,
					},
					wsmana = {
						type = 'range',
						name = L["Water Shield Level%"],
						desc = L["help_wsmana"],
						min = 0,
						max = 100,
						step = 1,
						get = "GetWSMana",
						set = "SetWSMana",
						order = 56,
					},
					shieldorbs = {
						type = 'range',
						name = L["Shield orbs left"],
						desc = L["help_shieldorbs"],
						min = 0,
						max = 9,
						step = 1,
						get = "GetShieldOrbs",
						set = "SetShieldOrbs",
						order = 57,
					},
					magmaticks = {
						type = 'range',
						name = L["Magma ticks left"],
						desc = L["help_magmaticks"],
						min = 0,
						max = 9,
						step = 1,
						get = "GetMagmaTicks",
						set = "SetMagmaTicks",
						order = 58,
					},
				},
			},
			warning = {
				name = L["Warning Options"],
				type = 'group',
				order = 6, 
				args = {
					show = {
						type = 'toggle',
						name = L["Use Warning Frame"],
						desc = L["help_warningframe"],
						get = "WarningFrameQuery",
						set = "ActivateWarningFrame",
						order = 1,
					},
					shield = {
						type = 'toggle',
						name = L["Shield Warning"],
						desc = L["help_shieldwarning"],
						get = "shieldWarnQuery",
						set = "ActivateShieldWarn",
						order = 2,
					},
					weapons = {
						type = 'toggle',
						name = L["Weapon Inbue Warning"],
						desc = L["help_weaponwarning"],
						get = "weaponWarnQuery",
						set = "ActivateWeaponWarn",
						order = 3,
					},
					range = {
						type = 'toggle',
						name = L["Out of range"],
						desc = L["help_outofrange"],
						get = "rangeWarnQuery",
						set = "ActivateRangeWarn",
						order = 4,
					},
					grounding = {
						type = 'toggle',
						name = L["Grounding Warning"],
						desc = L["help_groundingwarning"],
						get = "groundingWarnQuery",
						set = "ActivateGroundingWarn",
						order = 5,
					},
					interrupt = {
						type = 'toggle',
						name = L["Interrupt Warning"],
						desc = L["help_interruptwarning"],
						get = "interruptWarnQuery",
						set = "ActivateInterruptWarn",
						order = 6,
					},
					purge = {
						type = 'toggle',
						name = L["Purge Warning"],
						desc = L["help_purgewarning"],
						get = "purgeWarnQuery",
						set = "ActivatePurgeWarn",
						order = 7,
					},
					mainhand = {
						type = 'select',
						name = L["Main Hand Imbue"],
						get = "GetMainHandImbue",
						set = "SetMainHandImbue",
						values = ShockAndAwe.bindings.imbues,
						order = 8,
					},
					offhand = {
						type = 'select',
						name = L["Off Hand Imbue"],
						get = "GetOffHandImbue",
						set = "SetOffHandImbue",
						values = ShockAndAwe.bindings.imbues,
						order = 9,
					},
					colour = {
						type = 'color',
						name = L["Warning Msg Colour"],
						desc = L["colWarningMessage"],
						get = "getWarningColour",
						set = "setWarningColour",
						hasAlpha = true,
						order = 10,
					},
					duration = {
						type = 'range',
						name = L["Warning Message Duration"],
						min = 1,
						max = 10,
						step = .2,
						get = "GetWarningDuration",
						set = "SetWarningDuration",
						order = 11,
					},
--~					msbt = {
--~						type = 'select',
--~						name = L["MSBT output area"],
--~						get = "GetMSBTareas",
--~						set = "SetMSBTareas",
--~						values = ShockAndAwe.MSBT.areas,
--~						order = 12,
--~					},
--~ 					rebuff = {
--~ 						type = 'range',
--~ 						name = L["Weapon Rebuff time"],
--~ 						desc = L["help_weaponrebuff"],
--~ 						min = 0,
--~ 						max = 900,
--~ 						step = 10,
--~ 						get = "GetRebuffTime",
--~ 						set = "SetRebuffTime",
--~ 						order = 6,
--~ 					},
				},
			},
			media = {
				name = L["Media Options"],
				type = 'group',
				order = 7, 
				args = {
					texture = {
						type = 'select',
						name = L["Bar Texture"],
						get = "GetBarTexture",
						set = "SetBarTexture",
						values = self.textures,
						order = 1,
					},
					border = {
						type = 'select',
						name = L["Border Texture"],
						get = "GetBorderTexture",
						set = "SetBorderTexture",
						values = self.borders,
						order = 2,
					},
					barborder = {
						type = 'select',
						name = L["Bar Border Texture"],
						get = "GetBarBorderTexture",
						set = "SetBarBorderTexture",
						values = self.borders,
						order = 3,
					},
					barfont = {
						type = 'select',
						name = L["Bar Font"],
						get = "GetBarFont",
						set = "SetBarFont",
						values = self.fonts,
						order = 4,
					},
					barfonteffect = {
						name = L["Bar Font Effect"],
						type = "select",
						get = "GetBarFontEffect",
						set = "SetBarFontEffect",
						values = self.fonteffects,
						order = 5,
					},
					barfontsize = {
						type = 'range',
						name = L["Bar Font Size"],
						min = 6,
						max = 32,
						step = 1,
						get = "GetBarFontSize",
						set = "SetBarFontSize",
						order = 6,
					},
					msgfont = {
						type = 'select',
						name = L["Message Font"],
						get = "GetMsgFont",
						set = "SetMsgFont",
						values = self.fonts,
						order = 7,
					},
					msgfonteffect = {
						name = L["Message Font Effect"],
						type = "select",
						get = "GetMsgFontEffect",
						set = "SetMsgFontEffect",
						values = self.fonteffects,
						order = 8,
					},
					msgfontsize = {
						type = 'range',
						name = L["Message Font Size"],
						min = 6,
						max = 32,
						step = 1,
						get = "GetMsgFontSize",
						set = "SetMsgFontSize",
						order = 9,
					},
					mw4sound = {
						type = 'select',
						name = L["Maelstrom Sound 4"],
						get = "GetMW4sound",
						set = "SetMW4sound",
						values = self.sounds,
						order = 10,
					},
					mw5sound = {
						type = 'select',
						name = L["Maelstrom Sound 5"],
						get = "GetMW5sound",
						set = "SetMW5sound",
						values = self.sounds,
						order = 11,
					},
					mw5repeat = {
						type = 'range',
						name = L["Sound Repeat Interval"],
						desc = L["help_mw5repeat"],
						min = 1,
						max = 10,
						step = 0.1,
						get = "GetMW5repeat",
						set = "SetMW5repeat",
						order = 12,
					},
					shieldsound = {
						type = 'select',
						name = L["Shield Sound"],
						get = "GetShieldSound",
						set = "SetShieldSound",
						values = self.sounds,
						order = 13,
					},
					weaponsound = {
						type = 'select',
						name = L["Weapon Sound"],
						get = "GetWeaponSound",
						set = "SetWeaponSound",
						values = self.sounds,
						order = 14,
					},
				},
			},
			uptime = {
				name = L["Uptime Frame"],
				type = 'group',
				order = 8,
				args = {
					break1 = {
						type = 'header',
						name = L["Bar Colours"],
						dialogHidden = true,
						order = 1,
					},
					flurry = {
						type = 'color',
						name = L["Flurry Colour"],
						desc = L["colFlurry"],
						get = "getFlurryColour",
						set = "setFlurryColour",
						hasAlpha = true,
						order = 2,
					},					
					ed = {
						type = 'color',
						name = L["Elemental Devastation Colour"],
						desc = L["colED"],
						get = "getEDColour",
						set = "setEDColour",
						hasAlpha = true,
						order = 2,
					},					
					ur = {
						type = 'color',
						name = L["Unleashed Rage Colour"],
						desc = L["colUR"],
						get = "getURColour",
						set = "setURColour",
						hasAlpha = true,
						order = 2,
					},					
					break2 = {
						type = 'header',
						name = L["Misc Options"],
						dialogHidden = true,
						order = 10,
					},
					show = {
						type = 'toggle',
						name = L["Show Frame"],
						desc = L["help_showuptime"],
						get = "showUptimeQuery",
						set = "ActivateShowUptime",
						order = 11,
					},
					resetsession = {
						type = 'execute',
						name = L["Reset Session info"],
						desc = L["help_reset"],
						func = "InitialiseUptime",
						order = 13,
					},			
				},			
			},
			stats = {
				name = L["Stats Frame"],
				type = 'group',
				order = 9,
				args = {
					showWFtotals = {
						type = 'toggle',
						name = L["Show Windfury Totals"],
						desc = L["help_showwftotals"],
						get = "GetShowWFTotals",
						set = "SetShowWFTotals",
						order = 1,
					},
					wfcol = {
						type = 'color',
						name = L["Windfury Totals Colour"],
						desc = L["colWFTotals"],
						get = "getWFTotalsColour",
						set = "setWFTotalsColour",
						hasAlpha = true,
						order = 7,
					},
				},
			},				
			specchangewarning = {
				type = 'toggle',
				name = L["Warn on Spec Change"],
				desc = L["help_specchangewarning"],
				get = "specchangewarningQuery",
				set = "Activatespecchangewarning",
				order = 19,
			},			
			debug = {
				type = 'toggle',
				name = L["Debug mode"],
				desc = L["help_debug"],
				get = "debugQuery",
				set = "ActivateDebug",
				order = 20,
			},
			moveframes = {
				type = 'toggle',
				name = L["Move Frames"],
				desc = L["help_display"],
				get = "MovingFramesQuery",
				set = "ShowHideBars",
				order = 21,
			},
			testbar = {
				type = 'execute',
				name = L["Display Test Bar"],
				desc = L["help_testbar"],
				func = "WFProcBar",
				order = 22,
			},
			export = {
				type = 'execute',
				name = L["Export to Sim"],
				desc = L["help_export"],
				func = "ExportToSim",
				order = 23,
			},
			config = {
				type = 'execute',
				name = L["Configure Options"],
				desc = L["help_config"],
				func = "OpenConfig",
				order = 24,
			},
			news = {
				type = 'execute',
				name = L["Display News"],
				desc = L["help_news"],
				func = function() self:News(true); end,
				order = 25,
			},
			enable = {
				type = 'execute',
				name = L["Enable/Disable"],
				desc = L["help_disable"],
				func = "EnableDisable",
				order = 26,
			},
			disable = {
				type = 'execute',
				name = L["Enable/Disable"],
				desc = L["help_disable"],
				func = "EnableDisable",
				guiHidden = true,
				order = 27,
			},
			resetimmunity = {
				type = 'execute',
				name = L["Reset Immunity"],
				desc = L["help_resetImmunity"],
				func = "ResetImmunity",
				order = 28,
			},
			version = {
				type = 'execute',
				name = L["Version"],
				desc = L["help_version"],
				func = "DisplayVersion",
				order = 29,
			},
			help = {
				type = 'description',
				name = L["help"],
				guiHidden = true,
				order = 30,
			},
			priorities = { 
				name = L["Set Priorities"],
				type='group',
				childGroups ='tree',
				order = 5,
				args = {			
					prioritygroup = {
						type = 'select',
						name = L["Priority Group"],
						get = "GetPriorityGroup",
						set = "SetPriorityGroup",
						values = { L["Priority Group One"],  L["Priority Group Two"], L["Priority Group Three"], L["Priority Group Four"], L["Priority Group Five"] },
						order = 1,
					},
					priority1 = {
						type = 'select',
						name = L["First Priority"],
						get = ShockAndAwe:GetPriority(1),
						set = ShockAndAwe:SetPriority(1),
						values = self.priorityTable.name,
						order = 31,
					},
					priority2 = {
						type = 'select',
						name = L["Second Priority"],
						get = ShockAndAwe:GetPriority(2),
						set = ShockAndAwe:SetPriority(2),
						values = self.priorityTable.name,
						order = 32,
					},
					priority3 = {
						type = 'select',
						name = L["Third Priority"],
						get = ShockAndAwe:GetPriority(3),
						set = ShockAndAwe:SetPriority(3),
						values = self.priorityTable.name,
						order = 33,
					},
					priority4 = {
						type = 'select',
						name = L["Fourth Priority"],
						get = ShockAndAwe:GetPriority(4),
						set = ShockAndAwe:SetPriority(4),
						values = self.priorityTable.name,
						order = 34,
					},
					priority5 = {
						type = 'select',
						name = L["Fifth Priority"],
						get = ShockAndAwe:GetPriority(5),
						set = ShockAndAwe:SetPriority(5),
						values = self.priorityTable.name,
						order = 35,
					},
					priority6 = {
						type = 'select',
						name = L["Sixth Priority"],
						get = ShockAndAwe:GetPriority(6),
						set = ShockAndAwe:SetPriority(6),
						values = self.priorityTable.name,
						order = 36,
					},
					priority7 = {
						type = 'select',
						name = L["Seventh Priority"],
						get = ShockAndAwe:GetPriority(7),
						set = ShockAndAwe:SetPriority(7),
						values = self.priorityTable.name,
						order = 37,
					},
					priority8 = {
						type = 'select',
						name = L["Eighth Priority"],
						get = ShockAndAwe:GetPriority(8),
						set = ShockAndAwe:SetPriority(8),
						values = self.priorityTable.name,
						order = 38,
					},
					priority9 = {
						type = 'select',
						name = L["Ninth Priority"],
						get = ShockAndAwe:GetPriority(9),
						set = ShockAndAwe:SetPriority(9),
						values = self.priorityTable.name,
						order = 39,
					},
					priority10 = {
						type = 'select',
						name = L["Tenth Priority"],
						get = ShockAndAwe:GetPriority(10),
						set = ShockAndAwe:SetPriority(10),
						values = self.priorityTable.name,
						order = 40,
					},
					priority11 = {
						type = 'select',
						name = L["Eleventh Priority"],
						get = ShockAndAwe:GetPriority(11),
						set = ShockAndAwe:SetPriority(11),
						values = self.priorityTable.name,
						order = 41,
					},
					priority12 = {
						type = 'select',
						name = L["Twelfth Priority"],
						get = ShockAndAwe:GetPriority(12),
						set = ShockAndAwe:SetPriority(12),
						values = self.priorityTable.name,
						order = 42,
					},
					priority13 = {
						type = 'select',
						name = L["Thirteenth Priority"],
						get = ShockAndAwe:GetPriority(13),
						set = ShockAndAwe:SetPriority(13),
						values = self.priorityTable.name,
						order = 43,
					},
					priority14 = {
						type = 'select',
						name = L["Fourteenth Priority"],
						get = ShockAndAwe:GetPriority(14),
						set = ShockAndAwe:SetPriority(14),
						values = self.priorityTable.name,
						order = 44,
					},
					priority15 = {
						type = 'select',
						name = L["Fifteenth Priority"],
						get = ShockAndAwe:GetPriority(15),
						set = ShockAndAwe:SetPriority(15),
						values = self.priorityTable.name,
						order = 45,
					},
					priority16 = {
						type = 'select',
						name = L["Sixteenth Priority"],
						get = ShockAndAwe:GetPriority(16),
						set = ShockAndAwe:SetPriority(16),
						values = self.priorityTable.name,
						order = 46,
					},
				}
			}
		}
	}
	return options
end

function ShockAndAwe:ActivateSS()
	self.db.char.ssshow = not self.db.char.ssshow
	self:CreateBaseFrame()
	if (self.db.char.ssshow) then
		self:Print(L["config_SS_on"])
	else
		self:Print(L["config_SS_off"])
	end
end

function ShockAndAwe:ActivateFireTotem()
	self.db.char.firetotemshow = not self.db.char.firetotemshow
	self:CreateBaseFrame()
	if (self.db.char.firetotemshow) then
		self:Print(L["config_magma_on"])
	else
		self:Print(L["config_magma_off"])
	end
end

function ShockAndAwe:ActivateWF()
	self.db.char.wfshow = not self.db.char.wfshow
	self:CreateBaseFrame()
	if (self.db.char.wfshow) then
		self:Print(L["config_WF_on"])
	else
		self:Print(L["config_WF_off"])
	end
end

function ShockAndAwe:ActivateShock()
	self.db.char.shockshow = not self.db.char.shockshow
	self:CreateBaseFrame()
	if (self.db.char.shockshow) then
		self:Print(L["config_Shock_on"])
	else
		self:Print(L["config_Shock_off"])
	end
end

function ShockAndAwe:ActivateFSDotBar()
	self.db.char.fsdotshow = not self.db.char.fsdotshow
	self:CreateBaseFrame()
	if (self.db.char.fsdotshow) then
		self:Print(L["config_FSDotShow_on"])
	else
		self:Print(L["config_FSDotShow_off"])
	end
end

function ShockAndAwe:ActivateShear()
	self.db.char.shearshow = not self.db.char.shearshow
	self:CreateBaseFrame()
	if (self.db.char.shearshow) then
		self:Print(L["config_Shear_on"])
	else
		self:Print(L["config_Shear_off"])
	end
end

function ShockAndAwe:ActivateFeralSpirit()
	self.db.char.fsshow = not self.db.char.fsshow
	self:CreateBaseFrame()
	if (self.db.char.fsshow) then
		self:Print(L["config_feralspirit_on"])
	else
		self.frames["FeralSpirit"]:Hide()
		self:Print(L["config_feralspirit_off"])
	end
end

function ShockAndAwe:ActivateShield()
	self.db.char.shieldshow = not self.db.char.shieldshow
	self:CreateBaseFrame()
	if (self.db.char.shieldshow) then
		self:Print(L["config_Sheild_on"])
	else
		self.frames["Shield"]:Hide()
		self:Print(L["config_Sheild_off"])
	end
end

function ShockAndAwe:ActivateArena()
	self.db.char.arena = not self.db.char.arena
	self:SetTalentEffects()
	self:CreateBaseFrame()
	if (self.db.char.arena) then
		self:Print(L["config_Arena_on"])
	else
		self:Print(L["config_Arena_off"])
	end
end

function ShockAndAwe:ActivateShowUptime()
	self.db.char.uptime.show = not self.db.char.uptime.show
	if (self.db.char.uptime.show) then
		self.UptimeFrame:Show()
		self:Print(L["config_Uptime_on"])
	else
		self.UptimeFrame:Hide()
		self:Print(L["config_Uptime_off"])
	end
end

function ShockAndAwe:ActivateMaelstrom()
	self.db.char.msshow = not self.db.char.msshow
	self:CreateBaseFrame()
	if (self.db.char.msshow) then
		self:MaelstromBar()
		self.db.char.msstacks = ShockAndAwe:GetMaelstromInfo()
		self:Print(L["config_MW_on"])
	else
		self.frames["Maelstrom"]:Hide()
		self:Print(L["config_MW_off"])
	end
end

function ShockAndAwe:ActivateLavaLash()
	self.db.char.llshow = not self.db.char.llshow
	self:CreateBaseFrame()
	if (self.db.char.llshow) then
		self:Print(L["config_LL_on"])
	else
		self.frames["LavaLash"]:Hide()
		self:Print(L["config_LL_off"])
	end
end

function ShockAndAwe:ActivateFireNova()
	self.db.char.fnshow = not self.db.char.fnshow
	self:CreateBaseFrame()
	if (self.db.char.fnshow) then
		self:Print(L["config_FN_on"])
	else
		self.frames["FireNova"]:Hide()
		self:Print(L["config_FN_off"])
	end
end

function ShockAndAwe:ActivateGCD()
	self.db.char.gcdshow = not self.db.char.gcdshow
	self:CreateBaseFrame()
	if (self.db.char.gcdshow) then
		self.frames["GCD"]:Show()
		self:Print(L["config_GCD_on"])
	else
		self.frames["GCD"]:Hide()
		self:Print(L["config_GCD_off"])
	end
end

function ShockAndAwe:ActivateGCDfullwidth()
	self.db.char.gcdfullwidth = not self.db.char.gcdfullwidth
	self:SetTalentEffects()
	self:CreateBaseFrame()
	if (self.db.char.gcdfullwidth) then
		self:Print(L["config_GCD_fullwidth_on"])
	else
		self:Print(L["config_GCD_fullwidth_off"])
	end
end

function ShockAndAwe:Activatedisable()
	self.db.char.disablebars = not self.db.char.disablebars
	if (self.db.char.disablebars) then
		if not InCombatLockdown() then
			self.BaseFrame:Hide()
		end
		self:Print(L["config_disable_on"])
	else
		self.BaseFrame:Show()
		self:Print(L["config_disable_off"])
	end
end

function ShockAndAwe:ActivateBarIcons()
	self.db.char.showicons = not self.db.char.showicons
	if (self.db.char.showicons) then
		self:Print(L["config_baricons_on"])
	else
		self:Print(L["config_baricons_off"])
	end
end

function ShockAndAwe:ActivateDebug()
	self.db.char.debug = not self.db.char.debug
	if (self.db.char.debug) then
		self:Print(L["config_debug_on"])
	else
		self:Print(L["config_debug_off"])
	end
end

function ShockAndAwe:Activatespecchangewarning()
	self.db.char.specchangewarning = not self.db.char.specchangewarning
	if (self.db.char.specchangewarning) then
		self:Print(L["config_specchangewarning_on"])
	else
		self:Print(L["config_specchangewarning_off"])
	end
end

function ShockAndAwe:ActivateWindShear()
	self.db.char.windshearshow = not self.db.char.windshearshow
	if (self.db.char.windshearshow) then
		self:Print(L["config_WSicon_on"])
	else
		self:Print(L["config_WSicon_off"])
	end
end

function ShockAndAwe:ActivateComboPoints()
	self.db.char.priority.combopoints = not self.db.char.priority.combopoints
	if (self.db.char.priority.combopoints) then
		for index = 1, 5 do
			self.PriorityFrame.combo[index].frame:Show()
		end
		self:Print(L["config_combopoints_on"])
	else
		for index = 1, 5 do
			self.PriorityFrame.combo[index].frame:Hide()
		end
		self:Print(L["config_combopoints_off"])
	end
end

function ShockAndAwe:ActivateWorldBoss()
	self.db.char.priority.worldbossonly = not self.db.char.priority.worldbossonly
	if (self.db.char.priority.worldbossonly) then
		self:Print(L["config_worldboss_on"])
	else
		self:Print(L["config_worldboss_off"])
	end
end

function ShockAndAwe:ActivateHideImmune()
	self.db.char.priority.hideImmune = not self.db.char.priority.hideImmune
	if (self.db.char.priority.hideImmune) then
		self:Print(L["config_hideimmune_on"])
	else
		self:Print(L["config_hideimmune_off"])
	end
end

function ShockAndAwe:ActivateShowInterrupt()
	self.db.char.priority.showinterrupt = not self.db.char.priority.showinterrupt
	if (self.db.char.priority.showinterrupt) then
		self.PriorityFrame.interrupt.frame:Show()
		self:Print(L["config_showinterrupt_on"])
	else
		self.PriorityFrame.interrupt.frame:Hide()
		self:Print(L["config_showinterrupt_off"])
	end
end

function ShockAndAwe:ActivateShowPurge()
	self.db.char.priority.showpurge = not self.db.char.priority.showpurge
	if (self.db.char.priority.showpurge) then
		self.PriorityFrame.purge.frame:Show()
		self:Print(L["config_showpurge_on"])
	else
		self.PriorityFrame.purge.frame:Hide()
		self:Print(L["config_showpurge_off"])
	end
end

function ShockAndAwe:ActivateShowCooldown()
	self.db.char.priority.showcooldown = not self.db.char.priority.showcooldown
	if (self.db.char.priority.showcooldown) then
		self:Print(L["config_showcooldown_on"])
	else
		self:Print(L["config_showcooldown_off"])
	end
end

function ShockAndAwe:ActivateTextOnBars()
	self.db.char.barstext = not self.db.char.barstext
	self:UpdateShieldBar()
	if (self.db.char.barstext) then
		self:Print(L["config_Barstext_on"])
	else
		self:Print(L["config_Barstext_off"])
	end
end

function ShockAndAwe:ActivateMW5sound()
	self.db.char.mw5soundplay = not self.db.char.mw5soundplay
	if (self.db.char.mw5soundplay) then
		self:Print(L["config_mw5soundplay_on"])
	else
		self:Print(L["config_mw5soundplay_off"])
	end
end

function ShockAndAwe:ActivateMW4sound()
	self.db.char.mw4soundplay = not self.db.char.mw4soundplay
	if (self.db.char.mw4soundplay) then
		self:Print(L["config_mw4soundplay_on"])
	else
		self:Print(L["config_mw4soundplay_off"])
	end
end

function ShockAndAwe:ActivateMW5flash()
	self.db.char.mw5flash = not self.db.char.mw5flash
	if (self.db.char.mw5flash) then
		self:Print(L["config_mw5flash_on"])
	else
		UIFrameFlashRemoveFrame(ShockAndAwe.frames["Maelstrom"])
		ShockAndAwe:SetMaelstromAlpha(self.db.char.colours.msalpha)
		self:Print(L["config_mw5flash_off"])
	end
end

function ShockAndAwe:ShowHideBars()
	self.db.char.movingframes = not self.db.char.movingframes
	if self.db.char.movingframes then
		self.PriorityFrame:EnableMouse(1)
		self.PriorityFrame:SetBackdropColor(0, 0, 0, 1)
		self.PriorityFrame:Show()
		self.UptimeFrame:EnableMouse(1)
		self.UptimeFrame:SetBackdropColor(0, 0, 0, 1)
		self.UptimeFrame:Show()
		self.msgFrame:EnableMouse(1)
		self.msgFrame:SetBackdropColor(0, 0, 0, 1)
		self.msgFrame:Show()
		self.BaseFrame:EnableMouse(1)
		self.BaseFrame:SetBackdropColor(0, 0, 0, 1);
		self.frames["Maelstrom"]:Show()
		self.frames["Stormstrike"]:Show()
		self.frames["Shock"]:Show()
		self.frames["Windfury"]:Show()
		self.frames["Shield"]:Show()
		self.frames["LavaLash"]:Show()
		self.frames["FeralSpirit"]:Show()
		self.frames["GCD"]:Show()
		self.frames["fireTotem"]:Show()
		self.frames["FireNova"]:Show()
	else
		self.PriorityFrame:EnableMouse(0);
		self.PriorityFrame:SetBackdropColor(1, 1, 1, 0);
		self.BaseFrame:EnableMouse(0);
		self.BaseFrame:SetBackdropColor(1, 1, 1, 0);
		self.UptimeFrame:EnableMouse(0)
		self.UptimeFrame:SetBackdropColor(0, 0, 0, 0.3);
		self.msgFrame:EnableMouse(0)
		self.msgFrame:SetBackdropColor(1, 1, 1, 0);
		-- self.BaseFrame:Hide()
		self.frames["Maelstrom"]:Hide()
		self.frames["Stormstrike"]:Hide()
		self.frames["Shock"]:Hide()
		self.frames["Windfury"]:Hide()
		self.frames["LavaLash"]:Hide()
		self.frames["GCD"]:Hide()
		self.frames["fireTotem"]:Hide()
		self.frames["FireNova"]:Hide()
		self:UpdateShieldBar()
		if self.db.char.priority.show and InCombatLockdown() then
			self.PriorityFrame:Show()
		else
			self.PriorityFrame:Hide()
		end
		if self.db.char.fsshow and InCombatLockdown() then
			self.frames["FeralSpirit"]:Show()
		else
			self.frames["FeralSpirit"]:Hide()
		end
		if self.db.char.uptime.show then
			self.UptimeFrame:Show()
		else
			self.UptimeFrame:Hide()
		end
	end
	self:SetPriorityUpdateScript()
end

function ShockAndAwe:FinishedMoving(var, frame)
	local point, relativeTo, relativePoint, xOffset, yOffset = frame:GetPoint();
	var.point = point
	var.relativeTo = relativeTo
	var.relativePoint = relativePoint
	var.xOffset = xOffset
	var.yOffset = yOffset
end

function ShockAndAwe:SetShowWFTotals(info, newValue)
	self.db.char.stats.wfcalc = newValue
	if (self.db.char.stats.wfcalc) then
		self:Print(L["config_wfcalc_on"])
	else
		self:Print(L["config_wfcalc_off"])
	end
end

function ShockAndAwe:MovingFramesQuery()
	return self.db.char.movingframes
end

function ShockAndAwe:SSQuery()
	return self.db.char.ssshow
end

function ShockAndAwe:FireTotemQuery()
	return self.db.char.firetotemshow
end

function ShockAndAwe:WFQuery()
	return self.db.char.wfshow
end

function ShockAndAwe:shockQuery()
	return self.db.char.shockshow
end

function ShockAndAwe:fsdotbarQuery()
	return self.db.char.fsdotshow
end

function ShockAndAwe:shearQuery()
	return self.db.char.shearshow
end

function ShockAndAwe:gcdQuery()
	return self.db.char.gcdshow
end

function ShockAndAwe:gcdFullwidthQuery()
	return self.db.char.gcdfullwidth
end

function ShockAndAwe:windshearQuery()
	return self.db.char.windshearshow
end

function ShockAndAwe:combopointsQuery()
	return self.db.char.priority.combopoints
end

function ShockAndAwe:worldbossQuery()
	return self.db.char.priority.worldbossonly
end

function ShockAndAwe:hideImmuneQuery()
	return self.db.char.priority.hideImmune
end

function ShockAndAwe:showinterruptQuery()
	return self.db.char.priority.showinterrupt
end

function ShockAndAwe:showpurgeQuery()
	return self.db.char.priority.showpurge
end

function ShockAndAwe:showcooldownQuery()
	return self.db.char.priority.showcooldown
end

function ShockAndAwe:feralspiritQuery()
	return self.db.char.fsshow
end

function ShockAndAwe:shieldQuery()
	return self.db.char.shieldshow
end

function ShockAndAwe:disableQuery()
	return self.db.char.disablebars
end

function ShockAndAwe:bariconsQuery()
	return self.db.char.showicons
end

function ShockAndAwe:arenaQuery()
	return self.db.char.arena
end

function ShockAndAwe:showUptimeQuery()
	return self.db.char.uptime.show
end

function ShockAndAwe:maelstromQuery()
	return self.db.char.msshow
end

function ShockAndAwe:lavalashQuery()
	return self.db.char.llshow
end

function ShockAndAwe:firenovaQuery()
	return self.db.char.fnshow
end

function ShockAndAwe:textOnBarsQuery()
    return self.db.char.barstext
end

function ShockAndAwe:mw5soundplayQuery()
    return self.db.char.mw5soundplay
end

function ShockAndAwe:mw4soundplayQuery()
    return self.db.char.mw4soundplay
end

function ShockAndAwe:mw5flashQuery()
    return self.db.char.mw5flash
end

function ShockAndAwe:debugQuery()
	return self.db.char.debug
end

function ShockAndAwe:specchangewarningQuery()
	return self.db.char.specchangewarning
end

function ShockAndAwe:GetBarTexture()
    return self.db.char.texture
end

function ShockAndAwe:GetBorderTexture()
    return self.db.char.border
end

function ShockAndAwe:GetBarBorderTexture()
    return self.db.char.barborder
end

function ShockAndAwe:GetBarFont()
    return self.db.char.barfont
end

function ShockAndAwe:GetBarFontSize()
    return self.db.char.barfontsize
end

function ShockAndAwe:GetBarFontEffect()
    return self.db.char.barfonteffect
end

function ShockAndAwe:GetMsgFont()
    return self.db.char.msgfont
end

function ShockAndAwe:GetMsgFontSize()
    return self.db.char.msgfontsize
end

function ShockAndAwe:GetMsgFontEffect()
    return self.db.char.msgfonteffect
end

function ShockAndAwe:GetWidth()
    return self.db.char.fWidth
end

function ShockAndAwe:GetScale()
    return self.db.char.scale
end

function ShockAndAwe:GetPriorityScale()
    return self.db.char.priority.scale
end

function ShockAndAwe:GetMSalpha()
    return self.db.char.colours.msalpha
end

function ShockAndAwe:GetMSalphaFull()
    return self.db.char.colours.msalphaFull
end

function ShockAndAwe:GetShieldSound()
    return self.db.char.shieldsoundname
end

function ShockAndAwe:GetWeaponSound()
    return self.db.char.weaponsoundname
end

function ShockAndAwe:GetMW5sound()
    return self.db.char.mw5soundname
end

function ShockAndAwe:GetMW5repeat()
    return self.db.char.mw5repeat
end

function ShockAndAwe:GetMW4sound()
    return self.db.char.mw4soundname
end

function ShockAndAwe:GetThreatThreshold()
    return self.db.char.threatThreshold
end

function ShockAndAwe:GetCooldownThreshold()
    return self.db.char.priority.cooldown
end

function ShockAndAwe:GetFSTicksLeft()
    return self.db.char.priority.fsticksleft
end

function ShockAndAwe:GetTotemTimeLeft()
    return self.db.char.priority.totemtimeleft
end

function ShockAndAwe:GetSRMana()
    return self.db.char.priority.srmana
end

function ShockAndAwe:GetWSMana()
    return self.db.char.priority.wsmana
end

function ShockAndAwe:GetShieldOrbs()
    return self.db.char.priority.shieldorbs
end

function ShockAndAwe:GetMagmaTicks()
    return self.db.char.priority.magmaticks
end

function ShockAndAwe:GetHWHealth()
    return self.db.char.priority.hwhealth
end

function ShockAndAwe:GetCHInGroup()
	return self.db.char.priority.chingroup 
end

function ShockAndAwe:GetRebuffTime()
    return self.db.char.warning.timeleft
end

function ShockAndAwe:GetShowWFTotals()
	return self.db.char.stats.wfcalc
end

function ShockAndAwe:SetCHInGroup()
	self.db.char.priority.chingroup = not self.db.char.priority.chingroup
	if (self.db.char.priority.chingroup) then
		self:Print(L["config_chingroup_on"])
	else
		self:Print(L["config_chingroup_off"])
	end
end

function ShockAndAwe:SetBarFont(info, newValue)
	self.db.char.barfont = newValue
	self:RedrawFrames()
end

function ShockAndAwe:SetBarFontSize(info, newValue)
	self.db.char.barfontsize = newValue
	self:RedrawFrames()
end

function ShockAndAwe:SetBarFontEffect(info, newValue)
	self.db.char.barfonteffect = newValue
	self:RedrawFrames()
end

function ShockAndAwe:SetMsgFont(info, newValue)
	self.db.char.msgfont = newValue
	self:CreateMsgFrame()
end

function ShockAndAwe:SetMsgFontSize(info, newValue)
	self.db.char.msgfontsize = newValue
	self:CreateMsgFrame()
end

function ShockAndAwe:SetMsgFontEffect(info, newValue)
	self.db.char.msgfonteffect = newValue
	self:CreateMsgFrame()
end

function ShockAndAwe:SetBarTexture(info, newValue)
	self.db.char.texture = newValue
	local barTexture = media:Fetch('statusbar', newValue)
	self.frames["FeralSpirit"].statusbar:SetStatusBarTexture(barTexture)
	self.frames["Shield"].statusbar:SetStatusBarTexture(barTexture)
	self.frames["Maelstrom"].statusbar:SetStatusBarTexture(barTexture)
	self.frames["LavaLash"].statusbar:SetStatusBarTexture(barTexture)
	self.frames["Stormstrike"].statusbar:SetStatusBarTexture(barTexture)
	self.frames["Shock"].statusbar:SetStatusBarTexture(barTexture)
	self.frames["Windfury"].statusbar:SetStatusBarTexture(barTexture)
	self.frames["GCD"].statusbar:SetStatusBarTexture(barTexture)
end

function ShockAndAwe:SetBorderTexture(info, newValue)
	self.db.char.border = newValue
	local newTexture = media:Fetch("border", self.db.char.border)
	if newTexture then
		self.frameBackdrop.edgeFile = newTexture
		self:RedrawFrames()
	else
		if self.db.char.debug then
			self:Print("border texture not found. Trying to set "..self.db.char.border)
		end
	end
end

function ShockAndAwe:SetBarBorderTexture(info, newValue)
	self.db.char.barborder = newValue
	local newTexture = media:Fetch("border", self.db.char.barborder)
	if newTexture then
		self.barBackdrop.edgeFile = newTexture
		self.frames["FeralSpirit"]:SetBackdrop(self.barBackdrop)
		self.frames["Shield"]:SetBackdrop(self.barBackdrop)
		self.frames["Maelstrom"]:SetBackdrop(self.barBackdrop)
		self.frames["LavaLash"]:SetBackdrop(self.barBackdrop)
		self.frames["Stormstrike"]:SetBackdrop(self.barBackdrop)
		self.frames["Shock"]:SetBackdrop(self.barBackdrop)
		self.frames["Windfury"]:SetBackdrop(self.barBackdrop)
		self.frames["GCD"]:SetBackdrop(self.barBackdrop)
		self:RedrawFrames()
	else
		if self.db.char.debug then
			self:Print("bar border texture not found. Trying to set "..self.db.char.barborder)
		end
	end
end

function ShockAndAwe:SetShieldSound(info, newValue)
	local newSound = media:Fetch("sound", newValue)
	self.db.char.shieldsoundname = newValue
	if newSound then
		self.db.char.shieldsound = newSound
		PlaySoundFile(newSound)
	else
		if self.db.char.debug then
			self:Print("Sound not found. Trying to set "..newSound)
		end
	end
end

function ShockAndAwe:SetWeaponSound(info, newValue)
	local newSound = media:Fetch("sound", newValue)
	self.db.char.weaponsoundname = newValue
	if newSound then
		self.db.char.weaponsound = newSound
		PlaySoundFile(newSound)
	else
		if self.db.char.debug then
			self:Print("Sound not found. Trying to set "..newSound)
		end
	end
end

function ShockAndAwe:SetMW5sound(info, newValue)
	local newSound = media:Fetch("sound", newValue)
	self.db.char.mw5soundname = newValue
	if newSound then
		self.db.char.mw5sound = newSound
		PlaySoundFile(newSound)
	else
		if self.db.char.debug then
			self:Print("Sound not found. Trying to set "..newSound)
		end
	end
end

function ShockAndAwe:SetMW5repeat(info, newValue)
	self.db.char.mw5repeat = newValue
end

function ShockAndAwe:SetMW4sound(info, newValue)
	local newSound = media:Fetch("sound", newValue)
	self.db.char.mw4soundname = newValue
	if newSound then
		self.db.char.mw4sound = newSound
		PlaySoundFile(newSound)
	else
		if self.db.char.debug then
			self:Print("Sound not found. Trying to set "..newSound)
		end
	end
end

function ShockAndAwe:SetThreatThreshold(info, newValue)
	self.db.char.threatThreshold = newValue
	self:Print(L["config_Threat"]..newValue)
end

function ShockAndAwe:SetCooldownThreshold(info, newValue)
	self.db.char.priority.cooldown = newValue
	self:Print(L["config_Cooldown"]..newValue)
end

function ShockAndAwe:SetFSTicksLeft(info, newValue)
	self.db.char.priority.fsticksleft = newValue
	self:Print(L["config_FSTicksLeft"]..newValue..L["config_ticksleft"])
end

function ShockAndAwe:SetTotemTimeLeft(info, newValue)
	self.db.char.priority.totemtimeleft = newValue
	self:Print(L["config_TotemTimeLeft"]..newValue)
end

function ShockAndAwe:SetSRMana(info, newValue)
	self.db.char.priority.srmana = newValue
	self:Print(L["config_srmana"]..newValue)
end

function ShockAndAwe:SetShieldOrbs(info, newValue)
	self.db.char.priority.shieldorbs = newValue
	self:Print(L["config_shieldorbs"]..newValue)
end

function ShockAndAwe:SetMagmaTicks(info, newValue)
	self.db.char.priority.magmaticks = newValue
	self:Print(string.format(L["config_magmaticks"],newValue))
end

function ShockAndAwe:SetWSMana(info, newValue)
	self.db.char.priority.wsmana = newValue
	self:Print(L["config_wsmana"]..newValue)
end

function ShockAndAwe:SetHWHealth(info, newValue)
	self.db.char.priority.hwhealth = newValue
	self:Print(L["config_hwhealth"]..newValue)
end

function ShockAndAwe:SetRebuffTime(info, newValue)
	self.db.char.warning.timeleft = newValue
end

function ShockAndAwe:SetWidth(info,newValue)
	if InCombatLockdown() then
		self:Print(L["Cannot change bar width in combat"])
		return
	end
	local wasMoving = self.db.char.movingframes
	self.db.char.fWidth = newValue
	self:RedrawFrames()
	if wasMoving then
		self:ShowHideBars()
	end
	self:DebugPrint(L["Frame width set to : "]..self.db.char.fWidth)	
end

function ShockAndAwe:SetScale(info,newValue)
	if InCombatLockdown() then
		self:Print(L["Cannot change scale in combat"])
		return
	end
	local wasMoving = self.db.char.movingframes
	self.db.char.scale = newValue
	self.BaseFrame:SetScale(self.db.char.scale)
	self:RedrawFrames()
	if wasMoving then
		self:ShowHideBars()
	end
	self:DebugPrint(L["Scale set to : "]..self.db.char.scale)
end

function ShockAndAwe:SetPriorityScale(info,newValue)
	if InCombatLockdown() then
		self:Print(L["Cannot change scale in combat"])
	end
	self.db.char.priority.scale = newValue
	self.PriorityFrame:SetScale(self.db.char.priority.scale)
	self:DebugPrint(L["Priority Scale set to : "]..self.db.char.priority.scale)
end

function ShockAndAwe:SetMSalpha(info,newValue)
	if self.db.char.msshow then
		self.db.char.colours.msalpha = newValue
		self:SetMaelstromAlpha(self.db.char.colours.msalpha)
		self:Print(L["config_MSAlpha_ooc"]..self.db.char.colours.msalpha)
	end
end

function ShockAndAwe:SetMSalphaFull(info,newValue)
	if self.db.char.msshow then
		self.db.char.colours.msalphaFull = newValue
		self:SetMaelstromAlpha(self.db.char.colours.msalphaFull)
		self:Print(L["config_MSAlpha_combat"]..self.db.char.colours.msalphaFull)
	end
end

function ShockAndAwe:SetMaelstromAlpha(alphaValue)
	self.frames["Maelstrom"]:SetBackdropColor(0, 0, 0, alphaValue * .2)
	self.frames["Maelstrom"]:SetBackdropBorderColor( 1, 1, 1, alphaValue)
	local colours = self.db.char.colours.maelstrom
	self.frames["Maelstrom"].statusbar:SetStatusBarColor( colours.r, colours.g, colours.b, alphaValue)
end

-----------------------------------------
-- Colour choices getter/setters
-----------------------------------------

function ShockAndAwe:getWaterShieldColour(info)
	local colours = self.db.char.colours.watershield
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setWaterShieldColour(info,r,g,b,a)
	self.db.char.colours.watershield.r = r
	self.db.char.colours.watershield.g = g
	self.db.char.colours.watershield.b = b
	self.db.char.colours.watershield.a = a
	self:UpdateShieldBar()
end

function ShockAndAwe:getLightningShieldColour(info)
	local colours = self.db.char.colours.lightningshield
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setLightningShieldColour(info,r,g,b,a)
	self.db.char.colours.lightningshield.r = r
	self.db.char.colours.lightningshield.g = g
	self.db.char.colours.lightningshield.b = b
	self.db.char.colours.lightningshield.a = a
	self:UpdateShieldBar()
end

function ShockAndAwe:getEarthShieldColour(info)
	local colours = self.db.char.colours.earthshield
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setEarthShieldColour(info,r,g,b,a)
	self.db.char.colours.earthshield.r = r
	self.db.char.colours.earthshield.g = g
	self.db.char.colours.earthshield.b = b
	self.db.char.colours.earthshield.a = a
	self:UpdateShieldBar()
end

function ShockAndAwe:getNoShieldColour(info)
	local colours = self.db.char.colours.noshield
	return colours.r, colours.g, colours.b, 0.2 -- use out of combat alpha
end

function ShockAndAwe:setNoShieldColour(info,r,g,b,a)
	self.db.char.colours.noshield.r = r
	self.db.char.colours.noshield.g = g
	self.db.char.colours.noshield.b = b
	self.db.char.colours.noshield.a = a
	self:UpdateShieldBar()
end

function ShockAndAwe:getEarthShockColour(info)
	local colours = self.db.char.colours.earthshock
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setEarthShockColour(info,r,g,b,a)
	self.db.char.colours.earthshock.r = r
	self.db.char.colours.earthshock.g = g
	self.db.char.colours.earthshock.b = b
	self.db.char.colours.earthshock.a = a
	self:ShockBar(self.db.char.colours.earthshock)
end

function ShockAndAwe:getFlameShockColour(info)
	local colours = self.db.char.colours.flameshock
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setFlameShockColour(info,r,g,b,a)
	self.db.char.colours.flameshock.r = r
	self.db.char.colours.flameshock.g = g
	self.db.char.colours.flameshock.b = b
	self.db.char.colours.flameshock.a = a
	self:ShockBar(self.db.char.colours.flameshock)
end

function ShockAndAwe:getFlameShockDotColour(info)
	local colours = self.db.char.colours.flameshockDot
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setFlameShockDotColour(info,r,g,b,a)
	self.db.char.colours.flameshockDot.r = r
	self.db.char.colours.flameshockDot.g = g
	self.db.char.colours.flameshockDot.b = b
	self.db.char.colours.flameshockDot.a = a
	FSDotTime = GetTime() + 18
	self:FlameShockDotBar(true) 
end

function ShockAndAwe:getFrostShockColour(info)
	local colours = self.db.char.colours.frostshock
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setFrostShockColour(info,r,g,b,a)
	self.db.char.colours.frostshock.r = r
	self.db.char.colours.frostshock.g = g
	self.db.char.colours.frostshock.b = b
	self.db.char.colours.frostshock.a = a
	self:ShockBar(self.db.char.colours.frostshock)
end

function ShockAndAwe:getWindShearColour(info)
	local colours = self.db.char.colours.windshear
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setWindShearColour(info,r,g,b,a)
	self.db.char.colours.windshear.r = r
	self.db.char.colours.windshear.g = g
	self.db.char.colours.windshear.b = b
	self.db.char.colours.windshear.a = a
	self:ShearBar()
end

function ShockAndAwe:getMaelstromColour(info)
	local colours = self.db.char.colours.maelstrom
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setMaelstromColour(info,r,g,b,a)
	self.db.char.colours.maelstrom.r = r
	self.db.char.colours.maelstrom.g = g
	self.db.char.colours.maelstrom.b = b
	self.db.char.colours.maelstrom.a = a
	self:MaelstromBar()
end

function ShockAndAwe:getStormstrikeColour(info)
	local colours = self.db.char.colours.stormstrike
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setStormstrikeColour(info,r,g,b,a)
	self.db.char.colours.stormstrike.r = r
	self.db.char.colours.stormstrike.g = g
	self.db.char.colours.stormstrike.b = b
	self.db.char.colours.stormstrike.a = a
	self:StormstrikeBar()
end

function ShockAndAwe:getWindfuryColour(info)
	local colours = self.db.char.colours.windfury
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setWindfuryColour(info,r,g,b,a)
	self.db.char.colours.windfury.r = r
	self.db.char.colours.windfury.g = g
	self.db.char.colours.windfury.b = b
	self.db.char.colours.windfury.a = a
	self:WFProcBar()
end

function ShockAndAwe:getLavaLashColour(info)
	local colours = self.db.char.colours.lavalash
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setLavaLashColour(info,r,g,b,a)
	self.db.char.colours.lavalash.r = r
	self.db.char.colours.lavalash.g = g
	self.db.char.colours.lavalash.b = b
	self.db.char.colours.lavalash.a = a
	self:LavaLashBar()
end

function ShockAndAwe:getFireNovaColour(info)
	local colours = self.db.char.colours.firenova
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setFireNovaColour(info,r,g,b,a)
	self.db.char.colours.firenova.r = r
	self.db.char.colours.firenova.g = g
	self.db.char.colours.firenova.b = b
	self.db.char.colours.firenova.a = a
	self:FireNovaBar()
end

function ShockAndAwe:getMagmaColour(info)
	local colours = self.db.char.colours.magma
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setMagmaColour(info,r,g,b,a)
	self.db.char.colours.magma.r = r
	self.db.char.colours.magma.g = g
	self.db.char.colours.magma.b = b
	self.db.char.colours.magma.a = a
	self:MagmaBar()
end

function ShockAndAwe:getFeralSpiritCDColour(info)
	local colours = self.db.char.colours.feralspiritCD
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setFeralSpiritCDColour(info,r,g,b,a)
	self.db.char.colours.feralspiritCD.r = r
	self.db.char.colours.feralspiritCD.g = g
	self.db.char.colours.feralspiritCD.b = b
	self.db.char.colours.feralspiritCD.a = a
	local colours = self.db.char.colours.feralspiritCD
	self.frames["FeralSpiritCD"].statusbar:SetStatusBarColor(colours.r, colours.g, colours.b, colours.a)
end

function ShockAndAwe:getFeralSpiritColour(info)
	local colours = self.db.char.colours.feralspirit
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setFeralSpiritColour(info,r,g,b,a)
	self.db.char.colours.feralspirit.r = r
	self.db.char.colours.feralspirit.g = g
	self.db.char.colours.feralspirit.b = b
	self.db.char.colours.feralspirit.a = a
	local colours = self.db.char.colours.feralspirit
	self.frames["FeralSpirit"].statusbar:SetStatusBarColor(colours.r, colours.g, colours.b, colours.a)
end

function ShockAndAwe:getLavaBurstColour(info)
	local colours = self.db.char.colours.lavaburst
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setLavaBurstColour(info,r,g,b,a)
	self.db.char.colours.lavaburst.r = r
	self.db.char.colours.lavaburst.g = g
	self.db.char.colours.lavaburst.b = b
	self.db.char.colours.lavaburst.a = a
	self:LavaBurstBar()
end

function ShockAndAwe:getFlurryColour(info)
	local colours = self.db.char.uptime.flurry
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setFlurryColour(info,r,g,b,a)
	self.db.char.uptime.flurry.r = r
	self.db.char.uptime.flurry.g = g
	self.db.char.uptime.flurry.b = b
	self.db.char.uptime.flurry.a = a
	local buffColours = self.db.char.uptime.flurry
	self.uptime.session.buffs[Flurry].barFrame.statusbar:SetStatusBarColor(buffColours.r, buffColours.g, buffColours.b, buffColours.a)
	self.uptime.lastfight.buffs[Flurry].barFrame.statusbar:SetStatusBarColor(buffColours.r, buffColours.g, buffColours.b, buffColours.a)
end

function ShockAndAwe:getEDColour(info)
	local colours = self.db.char.uptime.ed
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setEDColour(info,r,g,b,a)
	self.db.char.uptime.ed.r = r
	self.db.char.uptime.ed.g = g
	self.db.char.uptime.ed.b = b
	self.db.char.uptime.ed.a = a
	local buffColours = self.db.char.uptime.ed
	self.uptime.session.buffs[ElementalDevastation].barFrame.statusbar:SetStatusBarColor(buffColours.r, buffColours.g, buffColours.b, buffColours.a)
	self.uptime.lastfight.buffs[ElementalDevastation].barFrame.statusbar:SetStatusBarColor(buffColours.r, buffColours.g, buffColours.b, buffColours.a)
end

function ShockAndAwe:getURColour(info)
	local colours = self.db.char.uptime.ur
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setURColour(info,r,g,b,a)
	self.db.char.uptime.ur.r = r
	self.db.char.uptime.ur.g = g
	self.db.char.uptime.ur.b = b
	self.db.char.uptime.ur.a = a
	local buffColours = self.db.char.uptime.ur
	self.uptime.session.buffs[UnleashedRage].barFrame.statusbar:SetStatusBarColor(buffColours.r, buffColours.g, buffColours.b, buffColours.a)
	self.uptime.lastfight.buffs[UnleashedRage].barFrame.statusbar:SetStatusBarColor(buffColours.r, buffColours.g, buffColours.b, buffColours.a)
end

function ShockAndAwe:getWFTotalsColour(info)
	local colours = self.db.char.stats.wfcol
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setWFTotalsColour(info,r,g,b,a)
	self.db.char.stats.wfcol.r = r
	self.db.char.stats.wfcol.g = g
	self.db.char.stats.wfcol.b = b
	self.db.char.stats.wfcol.a = a
end

-----------------------------------------
-- Priority Choices
-----------------------------------------

function ShockAndAwe:GetPriorityGroup(info)
	return self.db.char.priority.groupnumber
end

function ShockAndAwe:SetPriorityGroup(info, groupnumber)
	self.db.char.priority.groupnumber = groupnumber
	self:SelectPrioritySet(groupnumber)
end

function ShockAndAwe:GetPriority(index)
	return 	
		function(info) 
			return self.db.char.priority.prOption[index]  
		end
end

function ShockAndAwe:SetPriority(index)
	return 		
		function(info, priorityValue)
			self:DebugPrint("setting priority "..index.." to "..priorityValue)
			self.db.char.priority.prOption[index] = priorityValue
			self.db.char.priority.prOptions[self.db.char.priority.groupnumber] = self.db.char.priority.prOption
		end
end

function ShockAndAwe:priorityQuery()
	return self.db.char.priority.show
end

function ShockAndAwe:ActivatePriority()
	self.db.char.priority.show = not self.db.char.priority.show
	if (self.db.char.priority.show) then
		self:Print(L["config_priority_on"])
	else
		self.PriorityFrame:Hide()
		self:Print(L["config_priority_off"])
	end
end

function ShockAndAwe:priorityTitleQuery()
	return self.db.char.priority.titleshow
end

function ShockAndAwe:ActivatePriorityTitle()
	self.db.char.priority.titleshow = not self.db.char.priority.titleshow
	if self.db.char.priority.titleshow then
		self.PriorityFrame.topText:Show()
		self:Print(L["config_prioritytitle_on"])
	else
		self.PriorityFrame.topText:Hide()
		self:Print(L["config_prioritytitle_off"])
	end
end

---------------
-- Warnings
---------------

function ShockAndAwe:WarningFrameQuery()
	return self.db.char.warning.show
end

function ShockAndAwe:ActivateWarningFrame()
	self.db.char.warning.show = not self.db.char.warning.show
	if (self.db.char.warning.show) then
		self:Print(L["config_warnframe_on"])
	else
		self:Print(L["config_warnframe_off"])
	end
end

function ShockAndAwe:shieldWarnQuery()
	return self.db.char.warning.shield
end

function ShockAndAwe:ActivateShieldWarn()
	self.db.char.warning.shield = not self.db.char.warning.shield
	if (self.db.char.warning.shield) then
		self:Print(L["config_shieldwarn_on"])
	else
		self:Print(L["config_shieldwarn_off"])
	end
end

function ShockAndAwe:weaponWarnQuery()
	return self.db.char.warning.weapon
end

function ShockAndAwe:ActivateWeaponWarn()
	self.db.char.warning.weapon = not self.db.char.warning.weapon
	if (self.db.char.warning.weapon) then
		self:Print(L["config_weaponwarn_on"])
	else
		self:Print(L["config_weaponwarn_off"])
	end
end

function ShockAndAwe:rangeWarnQuery()
	return self.db.char.warning.range
end

function ShockAndAwe:ActivateRangeWarn()
	self.db.char.warning.range = not self.db.char.warning.range
	if (self.db.char.warning.range) then
		self:Print(L["config_rangewarn_on"])
	else
		self:Print(L["config_rangewarn_off"])
	end
end

function ShockAndAwe:groundingWarnQuery()
	return self.db.char.warning.grounding
end

function ShockAndAwe:ActivateGroundingWarn()
	self.db.char.warning.grounding = not self.db.char.warning.grounding
	if (self.db.char.warning.grounding) then
		self:Print(L["config_groundingwarn_on"])
	else
		self:Print(L["config_groundingwarn_off"])
	end
end

function ShockAndAwe:interruptWarnQuery()
	return self.db.char.warning.interrupt
end

function ShockAndAwe:ActivateInterruptWarn()
	self.db.char.warning.interrupt = not self.db.char.warning.interrupt
	if (self.db.char.warning.interrupt) then
		self:Print(L["config_interruptwarn_on"])
	else
		self:Print(L["config_interruptwarn_off"])
	end
end

function ShockAndAwe:purgeWarnQuery()
	return self.db.char.warning.purge
end

function ShockAndAwe:ActivatePurgeWarn()
	self.db.char.warning.purge = not self.db.char.warning.purge
	if (self.db.char.warning.purge) then
		self:Print(L["config_purgewarn_on"])
	else
		self:Print(L["config_purgewarn_off"])
	end
end

function ShockAndAwe:EnableDisable()
	if InCombatLockdown() then
		self:Print(L["Cannot enable/disable addon in combat"])
		return
	end
	self.db.char.disabled = not self.db.char.disabled
	if (self.db.char.disabled) then
		self:OnDisable()
		self.BaseFrame:Hide()
		self.PriorityFrame:Hide()
		self.UptimeFrame:Hide()
		self:Print(L["config_disabled_on"])
	else
		self:OnEnable()
		self:RedrawFrames()
		self.db.char.movingframes = true -- forces false in ShowHideBars to re-enable frames
		self:ShowHideBars()
		self:Print(L["config_disabled_off"])
	end
end

function ShockAndAwe:ResetImmunity()
	self.db.char.immuneTargets = {}
	self:Print(L["config_resetImmunity"])
end

function ShockAndAwe:GetMainHandImbue(info)
	return self.db.char.binding.mhspell 
end

function ShockAndAwe:SetMainHandImbue(info, value)
	self.db.char.binding.mhspell = value
	self:UpdateBindings()
end

function ShockAndAwe:GetOffHandImbue(info)
	return self.db.char.binding.ohspell 
end

function ShockAndAwe:SetOffHandImbue(info, value)
	self.db.char.binding.ohspell = value
	self:UpdateBindings()
end

function ShockAndAwe:GetMSBTareas(info)
	return self.db.char.MSBToutputarea
end

function ShockAndAwe:SetMSBTareas(info, value)
	self.db.char.MSBToutputarea = value
end

function ShockAndAwe:getWarningColour(info)
	local colours = self.db.char.warning.colour
	return colours.r, colours.g, colours.b, colours.a
end

function ShockAndAwe:setWarningColour(info,r,g,b,a)
	self.db.char.warning.colour.r = r
	self.db.char.warning.colour.g = g
	self.db.char.warning.colour.b = b
	self.db.char.warning.colour.a = a
end

function ShockAndAwe:GetWarningDuration(info)
	return self.db.char.warning.duration 
end

function ShockAndAwe:SetWarningDuration(info, priorityValue)
	self.db.char.warning.duration = priorityValue
end

function ShockAndAwe:OpenConfig()
	if InterfaceOptionsFrame_OpenToCategory then
		InterfaceOptionsFrame_OpenToCategory("ShockAndAwe");
	else
		InterfaceOptionsFrame_OpenToFrame("ShockAndAwe");
	end
end

function ShockAndAwe:GetMSBTAreaDefaults()
    local i = 0;
	self.MSBT = {}
	self.MSBT.areas = {}
    if MikSBT ~= nil and MikSBT.IterateScrollAreas ~= nil then
        for scrollAreaKey, scrollAreaName in MikSBT.IterateScrollAreas() do
            i = i + 1
            self.MSBT.areas[i] = scrollAreaName
        end
    end
end