local GetTime = GetTime;
local UnitOnTaxi = UnitOnTaxi;
local FormatTime = AzCastBar.FormatTime;

-- Extra Options
local extraOptions = {
	{
		[0] = "Colors",
		{ type = "Color", var = "colNormal", default = { 0.4, 0.6, 0.8 }, label = "Flight Bar Color" },
	},
};

-- Vars
local plugin = AzCastBar.CreateMainBar("Frame","Flight",extraOptions);
local data;

--------------------------------------------------------------------------------------------------------
--                                           Frame Scripts                                            --
--------------------------------------------------------------------------------------------------------

-- OnUpdate
local function OnUpdate(self,elapsed)
	-- Progression
	if (not self.fadeTime) then
		self.timeProgress = (GetTime() - self.startTime);
		if (self.duration ~= 0) then
			self.status:SetValue(self.timeProgress);
			self:SetTimeText(self.duration - self.timeProgress);
		else
			self:SetTimeText(self.timeProgress);
		end
		-- Check if we landed
		if (self.timeProgress > 10) and (not UnitOnTaxi("player")) then
			data[self.from.." / "..self.dest] = self.timeProgress;
			self.fadeTime = self.cfg.fadeTime;
		end
	-- FadeOut
	elseif (self.fadeElapsed < self.fadeTime) then
		self.fadeElapsed = (self.fadeElapsed + elapsed);
		self:SetAlpha(1 - self.fadeElapsed / self.fadeTime);
	else
		self:Hide();
	end
end

-- OnEvent -- Cancel Flight if User Accepts Summon or Leaves the World
local function OnEvent(self,event)
	if (self:IsVisible()) then
		self.fadeTime = self.cfg.fadeTime;
		AzMsg("|2FlightTimes|r Flight Timer Aborted, User Summoned or Zoned.");
	end
end

--------------------------------------------------------------------------------------------------------
--                                     HOOK: TaxiNodeOnButtonEnter                                    --
--------------------------------------------------------------------------------------------------------
hooksecurefunc("TaxiNodeOnButtonEnter",function(button)
	-- If enabled, Add flight time on all flightpoints except current
	if (data) and (plugin.cfg.enabled) and (TaxiNodeGetType(button:GetID()) ~= "CURRENT") then
		-- Find From and Dest Nodes
		plugin.from, plugin.dest = nil, TaxiNodeName(button:GetID());
		for i = 1, NumTaxiNodes() do
			if (TaxiNodeGetType(i) == "CURRENT") then
				plugin.from = TaxiNodeName(i);
				break;
			end
		end
		-- Continue only if both points are found
		if (plugin.from and plugin.dest) then
			plugin.time1 = data[plugin.from.." / "..plugin.dest];
			plugin.time2 = data[plugin.dest.." / "..plugin.from];
			if (plugin.time1 or plugin.time2) then
				if (plugin.time1) then
					GameTooltip:AddDoubleLine("Flight Time:",FormatTime(plugin.time1),nil,nil,nil,1,1,1);
				end
				if (plugin.time2) then
					GameTooltip:AddDoubleLine("Return Flight Time:",FormatTime(plugin.time2),nil,nil,nil,1,1,1);
				end
			else
				GameTooltip:AddLine("Unknown Flight Time");
			end
			GameTooltip:Show();
		end
	end
end);
--------------------------------------------------------------------------------------------------------
--                                         HOOK: TakeTaxiNode                                         --
--------------------------------------------------------------------------------------------------------
local TakeTaxiNode_Real = TakeTaxiNode;
function TakeTaxiNode(nodeId)
	-- Check if enabled
	if (data) and (plugin.cfg.enabled) and (TaxiNodeGetType(nodeId) ~= "CURRENT") then
		-- Find From and Dest Nodes
		plugin.from, plugin.dest = nil, TaxiNodeName(nodeId);
		for i = 1, NumTaxiNodes() do
			if (TaxiNodeGetType(i) == "CURRENT") then
				plugin.from = TaxiNodeName(i);
				break;
			end
		end
		-- Find Table Entry, but do only so if both points are found
		if (plugin.from and plugin.dest) then
			if (data[plugin.from.." / "..plugin.dest]) then
				plugin.entry = plugin.from.." / "..plugin.dest;
			elseif (data[plugin.dest.." / "..plugin.from]) then
				plugin.entry = plugin.dest.." / "..plugin.from;
			else
				plugin.entry = nil;
			end
			plugin:StartFlight();
		end
	end
	-- Take Taxi
	TakeTaxiNode_Real(nodeId);
end
--------------------------------------------------------------------------------------------------------
--                                                Code                                                --
--------------------------------------------------------------------------------------------------------

-- Init Bar for Flight
function plugin:StartFlight()
	self.startTime = GetTime();
	self.duration = (self.entry and data[self.entry] or 0);
	self.name:SetText(self.dest);
	self.status:SetMinMaxValues(0,self.duration);
	self.status:SetValue(0);
	self.totalTimeText = (self.cfg.showTotalTime and self.duration > 0 and " / "..FormatTime(self.duration) or nil);
	self.fadeTime = nil;
	self.fadeElapsed = 0;
	self:SetAlpha(self.cfg.alpha);
	self:Show();
end

-- ConfigChanged
function plugin:OnConfigChanged(cfg)
	if (FlightTimes_MergeTables) then
		FlightTimes_MergeTables();
		data = FlightTimes_Data;
	end
	if (cfg.enabled) then
		self:RegisterEvent("CONFIRM_SUMMON");
		self:RegisterEvent("PLAYER_LEAVING_WORLD");
		self.status:SetStatusBarColor(unpack(cfg.colNormal));
	else
		self:UnregisterAllEvents();
	end
end

--------------------------------------------------------------------------------------------------------
--                                          Initialise Plugin                                         --
--------------------------------------------------------------------------------------------------------

plugin.icon:SetTexture("Interface\\Icons\\Ability_Druid_FlightForm");
plugin:SetScript("OnUpdate",OnUpdate);
plugin:SetScript("OnEvent",OnEvent);