----------------------------------------------------------------------
-- 	Leatrix Maps Locale
----------------------------------------------------------------------

-- Create locale structure
local GameLocale = GetLocale()
local void, Leatrix_Maps = ...
local function localeFunc(L, key) return key end
local L = setmetatable({}, {__index = localeFunc})
Leatrix_Maps.L = L

-- Locale override (enUS, zhCN, zhTW, ruRU, koKR, deDE, esMX, frFR, itIT, ptBR)
-- GameLocale = "enUS"

-- zhCN: Simplified Chinese (People's Republic of China)
if GameLocale == "zhCN" then
L["/ltm help - Show this information."] = "/ltm help - 显示帮助信息"
L["/ltm reset - Reset the panel position."] = "/ltm reset - 重置面板位置"
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 清空所有设置并重载插件"
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "出现了一个无关痛痒的报错，它并不会影响到你的体验，你可以点击重载按钮来解决这个问题。"
L["Aerie Peak"] = "鹰巢山"
L["Ahn'Qiraj"] = "安其拉"
L["Alpha"] = "透明"
L["Alterac Mountains"] = "奥特兰克山脉"
L["Arathi Highlands"] = "阿拉希高地"
L["Ashenvale"] = "灰谷"
L["Astranaar"] = "阿斯特兰纳"
L["Auberdine"] = "奥伯丁"
L["Auto change zones"] = "自动切换区域"
L["Azshara"] = "艾萨拉"
L["Back to Main Menu"] = "返回主菜单"
L["Badlands"] = "荒芜之地"
L["Blackfathom Deeps"] = "黑暗深渊"
L["Blackrock Depths"] = "黑石深渊"
L["Blackrock Mountain"] = "黑石山"
L["Blackwing Lair"] = "黑翼之巢"
L["Blasted Lands"] = "诅咒之地"
L["Bloodvenom Post"] = "血毒岗哨"
L["Blue"] = "蓝色"
L["Boat to"] = "乘船前往"
L["Booty Bay"] = "藏宝海湾"
L["Brackenwall Village"] = "蕨墙村"
L["Burning Steppes"] = "燃烧平原"
L["Camp Mojache"] = "莫沙彻营地"
L["Camp Taurajo"] = "陶拉祖营地"
L["Cenarion Hold"] = "塞纳里奥要塞"
L["Central Mesa"] = "中部高台"
L["Chillwind Camp"] = "冰风岗"
L["Class colored icons"] = "职业颜色图标"
L["Classic"] = "经典旧世"
L["Click to configure the settings for this option."] = "点击可调整此选项的更多设置。"
L["Click to reset the position and scale of the map frame."] = "点击重置地图的尺寸和位置。"
L["Click to reset the settings on this page."] = "点击重置本页的设置。"
L["Click to return to the main menu."] = "点击返回主菜单。"
L["Configuration Panel"] = "设置面板"
L["Cursor"] = "光标"
L["Darkshire"] = "夜色镇"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "达纳苏斯"
L["Deadwind Pass"] = "逆风小径"
L["Desolace"] = "凄凉之地"
L["Dire Maul (East)"] = "厄运之槌（东）"
L["Dire Maul (North)"] = "厄运之槌（北）"
L["Dire Maul (West)"] = "厄运之槌（西）"
L["Disable reading emote when opening the map"] = "禁用阅读地图时的表情动作"
L["Drag"] = "拖拽"
L["Drag to set the amount of blue."] = "拖拽调整蓝色数值。"
L["Drag to set the amount of green."] = "拖拽调整绿色数值。"
L["Drag to set the amount of red."] = "拖拽调整红色数值。"
L["Drag to set the battlefield map size."] = "拖动以设置战场地图尺寸。"
L["Drag to set the group icon size."] = "拖动以调整队友图标大小。"
L["Drag to set the map opacity for when your character is moving."] = "拖拽调整当你移动时，地图淡化的透明度。"
L["Drag to set the map opacity for when your character is stationary."] = "拖拽调整当你站定时，地图的透明度。"
L["Drag to set the opacity."] = "拖拽调整透明度。"
L["Drag to set the player arrow size."] = "拖动以设置玩家箭头尺寸。"
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "拖动以调整玩家箭头大小。|n|n怀旧服版本游戏默认尺寸是16。|n正式服版本游戏默认为27。"
L["Druid only flight point to Darnassus"] = "至达纳苏斯（德鲁伊专属）"
L["Druid only flight point to Thunder Bluff"] = "至雷霆崖（德鲁伊专属）"
L["Dun Morogh"] = "丹莫罗"
L["Dungeon"] = "地下城"
L["Durotar"] = "杜隆塔尔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "尘泥沼泽"
L["Dwarven District"] = "矮人区"
L["Eastern Plaguelands"] = "东瘟疫之地"
L["Elements"] = "其他功能"
L["Elwynn Forest"] = "艾尔文森林"
L["Enhance battlefield map"] = "增强战场地图"
L["Enlarge player arrow"] = "放大玩家指针"
L["Enter"] = "输入"
L["Everlook"] = "永望镇"
L["Feathermoon Stronghold"] = "羽月要塞"
L["Felwood"] = "费伍德森林"
L["Feralas"] = "菲拉斯"
L["Fishing"] = "钓鱼"
L["Flame Crest"] = "烈焰峰"
L["Freewind Post"] = "乱风岗"
L["Gadgetzan"] = "加基森"
L["Gnomeregan"] = "诺莫瑞根"
L["Green"] = "绿色"
L["Grom'gol Base Camp"] = "格罗姆高营地"
L["Group Icons"] = "队友图标调整"
L["Hammerfall"] = "落锤镇"
L["Hide town and city icons"] = "隐藏城镇图标"
L["Hillsbrad Foothills"] = "希尔斯布莱德丘陵"
L["Icons"] = "图标"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "勾选后，会在地图上标记显示船舶港口，飞艇塔楼和地铁站。"
L["If checked, coordinates will be shown."] = "勾选后，会在地图上显示坐标。"
L["If checked, dungeons and raids will be shown."] = "勾选后，会在地图上标记显示地下城和团队副本入口。"
L["If checked, flight points will be shown."] = "勾选后，会在地图上标记显示飞行点。"
L["If checked, group icons will use a modern, class-colored design."] = "勾选后，地图上的队友图标会修改成职业颜色。"
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "勾选后，当你所处区域未发生变化时，打开地图会自动跳转最后一次的区域。"
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "勾选后，当你在移动中指向地图时，会停止地图的渐隐，并使用设置的站定透明度。"
L["If checked, points of interest will be shown."] = "勾选后，显示地图的标记点。"
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "勾选后，将启用默认的全屏地图。|n|n请注意，启用这个选项将锁定部分选项设置。"
L["If checked, the map border will be removed."] = "勾选后，移除地图的黑色边框。"
L["If checked, the map frame will remain open until you close it."] = "勾选后，世界地图将只能被你手动关闭。"
L["If checked, the minimap button will be shown."] = "勾选后，会启用小地图图标。"
L["If checked, the minimum fishing skill levels will be shown."] = "勾选后，会显示所需要的最低钓鱼等级。"
L["If checked, town and city icons will not be shown on the continent maps."] = "勾选后，将隐藏大陆地图上的城镇图标。"
L["If checked, unexplored areas of the map will be shown."] = "勾选后，显示未探索区域。"
L["If checked, unexplored areas will be tinted."] = "勾选后，对未探索区域进行染色。"
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "勾选后，当你改变区域时，地图将自动切换至当前区域。"
L["If checked, you will be able to customise the battlefield map."] = "勾选后，你可以自定义战场地图。"
L["If checked, you will be able to enlarge the player arrow."] = "勾选后，你可以增大玩家的箭头大小。"
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "勾选后，你可以移动并缩放地图。|n|n缩放地图是通过右下角的角标操作。|n|n移动地图可以通过拖拽边框。"
L["If checked, you will be able to set the opacity of the map."] = "勾选后，你可以设置地图的透明度。"
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "勾选后，会在地图上显示区域、副本和钓鱼的相关等级。"
L["Invalid command.  Enter /ltm help for help."] = "无效的命令。输入/ltm help来获取帮助信息。"
L["Invalid map ID."] = "无效地图ID"
L["Ironforge"] = "铁炉堡"
L["Kargath"] = "卡加斯"
L["Lake Elune'ara"] = "月神湖"
L["Lake Everstill"] = "湖畔镇"
L["Large Scarab Coffer"] = "大型圣甲虫箱"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "警告：你使用了错误的LeatrixMaps版本。"
L["Light's Hope Chapel"] = "圣光之愿礼拜堂"
L["Loch Modan"] = "洛克莫丹"
L["Lower Blackrock Spire"] = "黑石塔下层"
L["Map frame scale"] = "地图面板缩放"
L["Map Size"] = "地图尺寸"
L["Maraudon"] = "玛拉顿"
L["Marshal's Refuge"] = "马绍尔营地"
L["Mechanics"] = "地图结构"
L["Memory Usage"] = "内存占用"
L["Menethil Harbor"] = "米奈希尔港"
L["Miscellaneous"] = "杂项"
L["Molten Core"] = "熔火之心"
L["Moonglade"] = "月光林地"
L["More"] = "更多"
L["Morgan's Vigil"] = "摩根的岗哨"
L["Moving"] = "移动"
L["Mulgore"] = "莫高雷"
L["Nethergarde Keep"] = "守望堡"
L["Nighthaven"] = "永夜港"
L["Nijel's Point"] = "尼耶尔前哨站"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "注意！|n你必须重新启动你的游戏客户端才能正确加载新版本的Leatrix Maps。"
L["Onyxia's Lair"] = "奥妮克希亚的巢穴"
L["Opacity"] = "透明度"
L["or click the minimap button to open Leatrix Maps."] = "或者点击小地图按钮打开LeatrixMaps。"
L["Orgrimmar"] = "奥格瑞玛"
L["Player"] = "玩家"
L["Player Arrow"] = "玩家箭头"
L["Portal"] = "传送门"
L["Preview"] = "预览"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "团队副本"
L["Ratchet"] = "棘齿城"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼泽"
L["Red"] = "红色"
L["Redridge Mountains"] = "赤脊山"
L["Refuge Pointe"] = "避难谷地"
L["Reload"] = "重载插件"
L["Remember zoom level"] = "保存缩放等级"
L["Remove map border"] = "移除地图边框"
L["Requires UI reload."] = "需要重载插件。"
L["Reset"] = "重置"
L["Reset Map Layout"] = "重置地图设置"
L["Revantusk Village"] = "恶齿村"
L["Ruins of Ahn'Qiraj"] = "安其拉废墟"
L["Ruins of Elune'eth"] = "艾露尼斯废墟"
L["Rut'theran Village"] = "鲁瑟兰村"
L["Scale"] = "缩放"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通灵学院"
L["Searing Gorge"] = "灼热峡谷"
L["Sentinel Hill"] = "哨兵岭"
L["Set map opacity"] = "设置地图透明度"
L["Set map opacity while stationary and while moving."] = "设置当站定和移动时的地图透明度。"
L["Set the group icon size."] = "设置队友图标尺寸。"
L["Set the player arrow size."] = "设置玩家箭头大小。"
L["Settings"] = "设置"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowprey Village"] = "葬影村"
L["Show boats, zeppelins and trams"] = "显示港口/飞艇/地铁站"
L["Show coordinates"] = "显示坐标"
L["Show dungeons and raids"] = "标记副本入口"
L["Show flight points"] = "显示飞行点"
L["Show minimap button"] = "显示小地图按钮"
L["Show minimum fishing skill levels"] = "显示最低钓鱼等级"
L["Show points of interest"] = "启用地图的标记点"
L["Show scale handle"] = "允许缩放地图框体"
L["Show unexplored areas"] = "显示未探索区域"
L["Show zone levels"] = "显示区域等级"
L["Silithus"] = "希利苏斯"
L["Silverpine Forest"] = "银松森林"
L["Southshore"] = "南海镇"
L["Splintertree Post"] = "碎木岗哨"
L["Stationary"] = "站定"
L["Sticky map frame"] = "世界地图锁定"
L["Stonard"] = "斯通纳德"
L["Stonetalon Mountains"] = "石爪山脉"
L["Stonetalon Peak"] = "石爪峰"
L["Stormwind"] = "暴风城"
L["Stranglethorn Vale"] = "荆棘谷"
L["Stratholme (Main Gate)"] = "斯坦索姆（前门）"
L["Stratholme (Service Gate)"] = "斯坦索姆（侧门）"
L["Sun Rock Retreat"] = "烈日石居"
L["Swamp of Sorrows"] = "悲伤沼泽"
L["Talonbranch Glade"] = "刺枝林地"
L["Talrendis Point"] = "塔伦迪斯营地"
L["Tanaris"] = "塔纳利斯"
L["Tarren Mill"] = "塔伦米尔"
L["Teldrassil"] = "泰达希尔"
L["Temple of Ahn'Qiraj"] = "安其拉神殿"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神庙"
L["Thalanaar"] = "萨兰纳尔"
L["The Barrens"] = "贫瘠之地"
L["The Crossroads"] = "十字路口"
L["The Deadmines"] = "死亡矿井"
L["The Forgotten Coast"] = "被遗忘的海岸"
L["The Great Forge"] = "大锻炉"
L["The Hinterlands"] = "辛特兰"
L["The Sepulcher"] = "瑟伯切尔"
L["The Stockade"] = "监狱"
L["Thelsamar"] = "塞尔萨玛"
L["Theramore Isle"] = "塞拉摩岛"
L["Thorium Point"] = "瑟银哨塔"
L["Thousand Needles"] = "千针石林"
L["Thunder Bluff"] = "雷霆崖"
L["Tinker Town"] = "工匠区"
L["Tint unexplored areas"] = "未探索区域染色"
L["Tirisfal Glades"] = "提瑞斯法林地"
L["Trade District"] = "贸易区"
L["Trade Quarter"] = "贸易区"
L["Tram to"] = "乘地铁前往"
L["Transparency"] = "透明度"
L["Uldaman"] = "奥达曼"
L["Undercity"] = "幽暗城"
L["Un'Goro Crater"] = "安戈洛环形山"
L["Unlock map frame"] = "解锁地图框体"
L["Upper Blackrock Spire"] = "黑石塔上层"
L["Use default map"] = "使用默认地图"
L["Use stationary opacity while pointing at map"] = "指向地图时取消渐隐"
L["Valley of Strength"] = "力量谷"
L["Version"] = "版本"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "湿地"
L["Winterspring"] = "冬泉谷"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "为了让部分功能生效，你的插件需要重新载入。|n|n你无需立即点击重载插件按钮。可以根据自己的情况或者设置完毕后，再进行重载插件的操作。"
L["Your UI needs to be reloaded."] = "插件需要重新载入。"
L["Zeppelin to"] = "乘飞艇前往"
L["Zoram'gar Outpost"] = "佐拉姆加前哨站"
L["Zul'Farrak"] = "祖尔法拉克"
L["Zul'Gurub"] = "祖尔格拉布"

end

-- zhTW: Traditional Chinese (Taiwan)
if GameLocale == "zhTW" then
L["/ltm help - Show this information."] = "/ltm help - 顯示插件資訊。"
L["/ltm reset - Reset the panel position."] = "/ltm reset - 重設面板位置。"
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 清除所有設定並重載。"
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "一個停止錯誤發生了，但無需擔心，三不五時會發生，請點擊重載按鈕來解決它。"
L["Aerie Peak"] = "應巢山"
L["Ahn'Qiraj"] = "安其拉"
L["Alpha"] = "透明"
L["Alterac Mountains"] = "奧特蘭山脈"
L["Arathi Highlands"] = "阿拉希高地"
L["Ashenvale"] = "梣谷"
L["Astranaar"] = "阿斯特蘭納"
L["Auberdine"] = "奧伯丁"
L["Auto change zones"] = "自動變換區域"
L["Azshara"] = "艾薩拉"
L["Back to Main Menu"] = "回到主選單"
L["Badlands"] = "荒蕪之地"
L["Blackfathom Deeps"] = "黑澗深淵"
L["Blackrock Depths"] = "黑石深淵"
L["Blackrock Mountain"] = "黑石山"
L["Blackwing Lair"] = "黑翼之巢"
L["Blasted Lands"] = "詛咒之地"
L["Bloodvenom Post"] = "血毒崗哨"
L["Blue"] = "藍色"
L["Boat to"] = "船到"
L["Booty Bay"] = "藏寶海灣"
L["Brackenwall Village"] = "蕨牆村"
L["Burning Steppes"] = "燃燒平原"
L["Camp Mojache"] = "莫沙澈營地"
L["Camp Taurajo"] = "陶拉祖營地"
L["Cenarion Hold"] = "賽納里奧要塞"
L["Central Mesa"] = "中部高台"
L["Chillwind Camp"] = "冰風崗哨"
L["Class colored icons"] = "職業著色圖示"
L["Classic"] = "經典"
L["Click to configure the settings for this option."] = "點擊來設置此選項的設定。"
L["Click to reset the position and scale of the map frame."] = "點擊來重設地圖框架的位置與大小。"
L["Click to reset the settings on this page."] = "點擊來重設此頁的設定。"
L["Click to return to the main menu."] = "點擊來重返主選單。"
L["Configuration Panel"] = "設置面板"
L["Cursor"] = "鼠標"
L["Darkshire"] = "夜色鎮"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "達納蘇斯"
L["Deadwind Pass"] = "逆風小徑"
L["Desolace"] = "淒涼之地"
L["Dire Maul (East)"] = "厄運之槌 (東)"
L["Dire Maul (North)"] = "厄運之槌 (北)"
L["Dire Maul (West)"] = "厄運之槌 (西)"
L["Disable reading emote when opening the map"] = "當開啟地圖時取消閱讀表情"
L["Drag"] = "拖動"
L["Drag to set the amount of blue."] = "拖拉來設定藍色的數值。"
L["Drag to set the amount of green."] = "拖拉來設定綠色的數值。"
L["Drag to set the amount of red."] = "拖拉來設定紅色的數值。"
L["Drag to set the group icon size."] = "拖拉來設定隊伍圖示大小。"
L["Drag to set the map opacity for when your character is moving."] = "拖拉來設定當您角色移動時地圖的透明度。"
L["Drag to set the map opacity for when your character is stationary."] = "拖拉來設定當您角色靜止時地圖的透明度。"
L["Drag to set the opacity."] = "拖拉來設定透明度。"
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "拖拉以設置玩家箭頭大小。|n|n魔獸世界經典版預設為16。|n魔獸世界正式版預設為27。"
L["Druid only flight point to Darnassus"] = "到達納蘇斯的德魯伊專用鳥點"
L["Druid only flight point to Thunder Bluff"] = "到雷霆崖的德魯伊專用鳥點"
L["Dun Morogh"] = "丹莫洛"
L["Dungeon"] = "地下城"
L["Durotar"] = "杜洛塔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "塵泥沼澤"
L["Dwarven District"] = "矮人區"
L["Eastern Plaguelands"] = "東瘟疫之地"
L["Elements"] = "元素"
L["Elwynn Forest"] = "艾爾文森林"
L["Enlarge player arrow"] = "放大玩家箭頭"
L["Enter"] = "輸入"
L["Everlook"] = "永望鎮"
L["Feathermoon Stronghold"] = "羽月要塞"
L["Felwood"] = "費伍德森林"
L["Feralas"] = "菲拉斯"
L["Fishing"] = "釣魚"
L["Flame Crest"] = "烈焰峰"
L["Freewind Post"] = "亂風崗"
L["Gadgetzan"] = "加基森"
L["Gnomeregan"] = "諾姆瑞根"
L["Green"] = "綠色"
L["Grom'gol Base Camp"] = "格羅姆高營地"
L["Group Icons"] = "隊伍圖示"
L["Hammerfall"] = "落錘鎮"
L["Hide town and city icons"] = "隱藏城鎮與都市圖示"
L["Hillsbrad Foothills"] = "希爾斯布萊德丘陵"
L["Icons"] = "圖示"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "勾選後，船舶碼頭、飛艇塔樓以及地鐵站都將顯示。"
L["If checked, coordinates will be shown."] = "勾選後，將顯示座標。"
L["If checked, dungeons and raids will be shown."] = "勾選後，將顯示地下城與團隊副本。"
L["If checked, flight points will be shown."] = "勾選後，將顯示飛行鳥點。"
L["If checked, group icons will use a modern, class-colored design."] = "勾選後，隊伍圖示將使用更為摩登且職業著色的設計。"
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "勾選後，開啟地圖時會使用最後關閉地圖時的縮放等級，如果地圖區域並未改變。"
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "勾選後，當角色移動時指向地圖將會套用靜止的透明度設置。"
L["If checked, points of interest will be shown."] = "勾選後，將顯示關注點。"
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "勾選後，將使用預設的全屏地圖。|n|n請注意，啟用此選項將鎖定其他某些選項。"
L["If checked, the map border will be removed."] = "勾選後，將會移除地圖外框。"
L["If checked, the map frame will remain open until you close it."] = "勾選後，則地圖框將保持打開狀態，直到您將其關閉。"
L["If checked, the minimap button will be shown."] = "勾選後，會顯示小地圖按鈕。"
L["If checked, the minimum fishing skill levels will be shown."] = "勾選後，將顯示最低釣魚需求技能等級。"
L["If checked, town and city icons will not be shown on the continent maps."] = "勾選後，大陸地圖將不會顯示城鎮與都市圖示。"
L["If checked, unexplored areas of the map will be shown."] = "勾選後，將會顯露未探索區域。"
L["If checked, unexplored areas will be tinted."] = "勾選後，未探索區域將會著色。"
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "勾選後，當角色變換區域時，地圖將自動更改為新區域。"
L["If checked, you will be able to enlarge the player arrow."] = "勾選後，您將可以放大玩家箭頭。"
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "勾選後，您將可以縮放與移動地圖。|n|n拖拉右下角的縮放把柄來縮放地圖。|n|n透由拖動外框與框架邊緣來移動地圖。"
L["If checked, you will be able to set the opacity of the map."] = "勾選後，您將可以設定地圖的透明度。"
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "勾選後，將顯示區域、地下城以及釣魚技能等級。"
L["Invalid command.  Enter /ltm help for help."] = "無效的指令。輸入 /ltm help 取得幫助。"
L["Invalid map ID."] = "無效地圖ID"
L["Ironforge"] = "鐵爐堡"
L["Kargath"] = "卡加斯"
L["Lake Elune'ara"] = "月神湖"
L["Lake Everstill"] = "湖畔鎮"
L["Large Scarab Coffer"] = "大型聖甲蟲箱"
L["Light's Hope Chapel"] = "聖光之願大教堂"
L["Loch Modan"] = "洛克莫丹"
L["Lower Blackrock Spire"] = "黑石塔下層"
L["Map frame scale"] = "地圖框架縮放"
L["Maraudon"] = "瑪拉頓"
L["Marshal's Refuge"] = "馬紹爾營地"
L["Mechanics"] = "地圖結構"
L["Memory Usage"] = "記憶體使用量"
L["Menethil Harbor"] = "米奈希爾港"
L["Miscellaneous"] = "雜項"
L["Molten Core"] = "熔火之心"
L["Moonglade"] = "月光林地"
L["Morgan's Vigil"] = "摩根的崗哨"
L["Moving"] = "移動"
L["Mulgore"] = "莫高雷"
L["Nethergarde Keep"] = "守望堡"
L["Nighthaven"] = "永夜港"
L["Nijel's Point"] = "尼耶爾前哨站"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "注意！|n您必須完全重新啟動遊戲客戶端才能使用此版本的Leatrix Maps。"
L["Onyxia's Lair"] = "奧妮克希亞的巢穴"
L["Opacity"] = "透明度"
L["or click the minimap button to open Leatrix Maps."] = "或是點擊小地圖按鈕來開啟Leatrix Maps。"
L["Orgrimmar"] = "奧格瑪"
L["Player"] = "玩家"
L["Player Arrow"] = "玩家箭頭"
L["Portal"] = "傳送門"
L["Preview"] = "預覽"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "團隊副本"
L["Ratchet"] = "棘齒城"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼澤"
L["Red"] = "紅色"
L["Redridge Mountains"] = "赤脊山"
L["Refuge Pointe"] = "避難谷地"
L["Reload"] = "重載"
L["Remember zoom level"] = "記憶縮放等級"
L["Remove map border"] = "移除地圖外框"
L["Requires UI reload."] = "需要介面重載。"
L["Reset"] = "重置"
L["Reset Map Layout"] = "重設地圖佈局"
L["Revantusk Village"] = "惡齒村"
L["Ruins of Ahn'Qiraj"] = "安琪拉廢墟"
L["Ruins of Elune'eth"] = "伊露恩斯遺址"
L["Rut'theran Village"] = "魯瑟蘭村"
L["Scale"] = "縮放比例"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通靈學院"
L["Searing Gorge"] = "灼熱峽谷"
L["Sentinel Hill"] = "哨兵嶺"
L["Set map opacity"] = "設定地圖透明度"
L["Set map opacity while stationary and while moving."] = "設定當移動或靜止時地圖的透明度。"
L["Set the group icon size."] = "設定隊伍圖示大小。"
L["Set the player arrow size."] = "設置玩家箭頭大小。"
L["Settings"] = "設置"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowprey Village"] = "葬影村"
L["Show boats, zeppelins and trams"] = "顯示船舶、飛艇以及地鐵"
L["Show coordinates"] = "顯示座標"
L["Show dungeons and raids"] = "顯示地下城與團隊副本"
L["Show flight points"] = "顯示飛行鳥點"
L["Show minimap button"] = "顯示小地圖按鈕"
L["Show minimum fishing skill levels"] = "顯示最低釣魚技能等級"
L["Show points of interest"] = "顯示關注站點"
L["Show scale handle"] = "顯示縮放控制"
L["Show unexplored areas"] = "顯露未探索區域"
L["Show zone levels"] = "顯示區域等級"
L["Silithus"] = "希利蘇斯"
L["Silverpine Forest"] = "銀松森林"
L["Southshore"] = "南海鎮"
L["Splintertree Post"] = "碎木崗哨"
L["Stationary"] = "靜止"
L["Sticky map frame"] = "黏附地圖框架"
L["Stonard"] = "斯通納德"
L["Stonetalon Mountains"] = "石爪山脈"
L["Stonetalon Peak"] = "石爪峰"
L["Stormwind"] = "暴風城"
L["Stranglethorn Vale"] = "荊棘谷"
L["Stratholme (Main Gate)"] = "斯坦索姆 (正門)"
L["Stratholme (Service Gate)"] = "斯坦索姆 (側門)"
L["Sun Rock Retreat"] = "烈日石居"
L["Swamp of Sorrows"] = "悲傷沼澤"
L["Talonbranch Glade"] = "刺枝林地"
L["Talrendis Point"] = "塔倫迪斯營地"
L["Tanaris"] = "塔納利斯"
L["Tarren Mill"] = "塔倫米爾"
L["Teldrassil"] = "泰達希爾"
L["Temple of Ahn'Qiraj"] = "安琪拉神廟"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神廟"
L["Thalanaar"] = "薩蘭納爾"
L["The Barrens"] = "貧瘠之地"
L["The Crossroads"] = "十字路口"
L["The Deadmines"] = "死亡礦坑"
L["The Forgotten Coast"] = "被遺忘的海岸"
L["The Great Forge"] = "大鍛爐"
L["The Hinterlands"] = "辛特蘭"
L["The Sepulcher"] = "瑟伯切爾"
L["The Stockade"] = "監獄"
L["Thelsamar"] = "塞爾薩瑪"
L["Theramore Isle"] = "賽拉摩島"
L["Thorium Point"] = "瑟銀哨站"
L["Thousand Needles"] = "千針石林"
L["Thunder Bluff"] = "雷霆崖"
L["Tinker Town"] = "地精區"
L["Tint unexplored areas"] = "未探索區域色調"
L["Tirisfal Glades"] = "提瑞斯法林地"
L["Trade District"] = "貿易區"
L["Trade Quarter"] = "貿易區"
L["Tram to"] = "地鐵到"
L["Transparency"] = "透明度"
L["Uldaman"] = "奧達曼"
L["Undercity"] = "幽暗城"
L["Un'Goro Crater"] = "安戈落環形山"
L["Unlock map frame"] = "解鎖地圖框架"
L["Upper Blackrock Spire"] = "黑石塔上層"
L["Use default map"] = "使用預設地圖"
L["Use stationary opacity while pointing at map"] = "指向地圖時使用固定的透明度"
L["Valley of Strength"] = "力量之谷"
L["Version"] = "版本"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "濕地"
L["Winterspring"] = "冬泉谷"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "您的UI需要重載以讓某些更動生效。|n|n您不用立刻點擊重載按鈕，但當您做了些更動並想要更動生效的話，需要馬上重載。"
L["Your UI needs to be reloaded."] = "您的UI需要重載。"
L["Zeppelin to"] = "飛船到"
L["Zoram'gar Outpost"] = "佐拉姆加前哨站"
L["Zul'Farrak"] = "祖爾法拉克"
L["Zul'Gurub"] = "祖爾格拉布"

end

-- ruRU: Russian
if GameLocale == "ruRU" then
L["/ltm help - Show this information."] = "/ltm help - Показать эту информацию."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Сбросить положение панели."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Удалить все настройки и перезагрузить."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Возникла ошибка, но не беспокойтесь. Такое бывает время от времени. Перезагрузите интерфейс, чтобы исправить её."
L["Aerie Peak"] = "Заоблачный пик"
L["Ahn'Qiraj"] = "Ан'Кираж"
L["Alpha"] = "Альфа"
L["Alterac Mountains"] = "Альтеракские горы"
L["Arathi Highlands"] = "Нагорье Арати"
L["Ashenvale"] = "Ясеневый лес"
L["Astranaar"] = "Астранаар"
L["Auberdine"] = "Аубердин"
L["Auto change zones"] = "Авто-смена зоны"
L["Azshara"] = "Азшара"
L["Back to Main Menu"] = "В главное меню"
L["Badlands"] = "Бесплодные земли"
L["Blackfathom Deeps"] = "Непроглядная Пучина"
L["Blackrock Depths"] = "Глубины Черной горы"
L["Blackrock Mountain"] = "Черная гора"
L["Blackwing Lair"] = "Логово Крыла Тьмы"
L["Blasted Lands"] = "Выжженные земли"
L["Bloodvenom Post"] = "Застава Отравленной Крови"
L["Blue"] = "Синий"
L["Boat to"] = "Корабль в"
L["Booty Bay"] = "Пиратская Бухта"
L["Brackenwall Village"] = "Деревня Гиблотопь"
L["Burning Steppes"] = "Пылающие степи"
L["Camp Mojache"] = "Лагерь Мохаче"
L["Camp Taurajo"] = "Лагерь Таурахо"
L["Cenarion Hold"] = "Крепость Кенария"
L["Central Mesa"] = "Центральная меза"
L["Chillwind Camp"] = "Лагерь Промозглого Ветра"
L["Class colored icons"] = "Классовые цветные значки"
L["Classic"] = "Классик"
L["Click to configure the settings for this option."] = "Нажмите, чтобы перейти к интерфейсу дополнительных параметров этой настройки."
L["Click to reset the position and scale of the map frame."] = "Нажмите, чтобы сбросить положение и масштаб окна карты."
L["Click to reset the settings on this page."] = "Нажмите, чтобы сбросить настройки на этой странице."
L["Click to return to the main menu."] = "Нажмите, чтобы вернуться в главное меню."
L["Configuration Panel"] = "Панель настроек"
L["Cursor"] = "Курсор"
L["Darkshire"] = "Темнолесье"
L["Darkshore"] = "Темные берега"
L["Darnassus"] = "Дарнас"
L["Deadwind Pass"] = "Перевал Мертвого Ветра"
L["Desolace"] = "Пустоши"
L["Dire Maul (East)"] = "Забытый Город (Восток)"
L["Dire Maul (North)"] = "Забытый Город (Север)"
L["Dire Maul (West)"] = "Забытый Город (Запад)"
L["Disable reading emote when opening the map"] = "Отключить эмоцию открытия карты"
L["Drag"] = "Переместить"
L["Drag to set the amount of blue."] = "Переместите ползунок влево или вправо, чтобы установить уровень синего цвета."
L["Drag to set the amount of green."] = "Переместите ползунок влево или вправо, чтобы установить уровень зеленого цвета."
L["Drag to set the amount of red."] = "Переместите ползунок влево или вправо, чтобы установить уровень красного цвета."
L["Drag to set the battlefield map size."] = "Переместите ползунок влево или вправо, чтобы установить размер карты поля боя"
L["Drag to set the group icon size."] = "Переместите ползунок влево или вправо, чтобы установить размер значка."
L["Drag to set the map opacity for when your character is moving."] = "Переместите ползунок влево или вправо, чтобы установить прозрачность карты, когда ваш персонаж находится в движении."
L["Drag to set the map opacity for when your character is stationary."] = "Переместите ползунок влево или вправо, чтобы установить непрозрачность карты, когда ваш персонаж неподвижен."
L["Drag to set the opacity."] = "Переместите ползунок влево или вправо, чтобы установить уровень прозрачности."
L["Drag to set the player arrow size."] = "Переместите ползунок влево или вправо, чтобы установить размер стрелки игрока."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Переместите ползунок влево или вправо, чтобы установить желаемый размер указателя вашего персонажа.|n|nClassic по умолчанию 16 .|nАктуальная версия по умолчанию - 27."
L["Druid only flight point to Darnassus"] = "Пункт перелета в Дарнас (только для Друида)"
L["Druid only flight point to Thunder Bluff"] = "Пункт перелета в Громовой Утес (только для Друида)"
L["Dun Morogh"] = "Дун Морог"
L["Dungeon"] = "Подземелье"
L["Durotar"] = "Дуротар"
L["Duskwood"] = "Сумеречный лес"
L["Dustwallow Marsh"] = "Пылевые топи"
L["Dwarven District"] = "Подземный поезд"
L["Eastern Plaguelands"] = "Восточные Чумные земли"
L["Elements"] = "Элементы"
L["Elwynn Forest"] = "Элвиннский лес"
L["Enhance battlefield map"] = "Улучшить карту поля боя"
L["Enlarge player arrow"] = "Размер указателя игрока"
L["Enter"] = "Введите"
L["Everlook"] = "Круговзор"
L["Feathermoon Stronghold"] = "Крепость Оперенной Луны"
L["Felwood"] = "Оскверненный лес"
L["Feralas"] = "Фералас"
L["Fishing"] = "Рыбалка"
L["Flame Crest"] = "Пламенеющий Стяг"
L["Freewind Post"] = "Застава Вольного Ветра"
L["Gadgetzan"] = "Прибамбасск"
L["Gnomeregan"] = "Гномреган"
L["Green"] = "Зеленый"
L["Grom'gol Base Camp"] = "Гром'гол"
L["Group Icons"] = "Значки Группы"
L["Hammerfall"] = "Павший Молот"
L["Hide town and city icons"] = "Скрыть значки городов"
L["Hillsbrad Foothills"] = "Предгорья Хилсбрада"
L["Icons"] = "Иконки"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Если установлен этот флажок, на карте будут отмечаться порты и их направления, башни дирижаблей и их направления, а также входы в подземный поезд."
L["If checked, coordinates will be shown."] = "Если установлен этот флажок, на карте будут отображаться координаты."
L["If checked, dungeons and raids will be shown."] = "Если установлен этот флажок, на карте будут отображаться входы в подземелья и рейдовые подземелья."
L["If checked, flight points will be shown."] = "Если установлен этот флажок, на карте будут отображаться точки полета."
L["If checked, group icons will use a modern, class-colored design."] = "Если установлен этот флажок, то значки места нахождения участников вашей группы на карте - будут отображаться цветом класса этих персонажей."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Если установлен этот флажок, то при открытии карты будет использоваться тот же уровень масштабирования, что и при последнем закрытии карты, если зона карты не изменилась."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Если установлен этот флажок, то при наведении курсора мыши на карту во время движения вашего персонажа отменит установленный уровень прозрачности. Карта станет непрозрачной."
L["If checked, points of interest will be shown."] = "Если установлен этот флажок, на карте будут отображаться различные полезные достопримечательности."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Если установлен этот флажок, всегда будет использоваться по умолчанию карта открываемая на весь экран.|n|nПримечание: Включение данной настройки заблокирует некоторые другие."
L["If checked, the map border will be removed."] = "Если установлен этот флажок, граница окна карты будет удалена."
L["If checked, the map frame will remain open until you close it."] = "Если установлен этот флажок, окно карты будет всегда оставаться открытым до тех пор, пока вы сами не закроете его."
L["If checked, the minimap button will be shown."] = "Если установлен этот флажок, у мини-карты будет отображаться кнопка аддона."
L["If checked, the minimum fishing skill levels will be shown."] = "Если установлен этот флажок, будут показаны минимальные уровни навыка рыбной ловли."
L["If checked, town and city icons will not be shown on the continent maps."] = "Если установлен этот флажок, на картах континентов не будут отображаться значки городов и поселков."
L["If checked, unexplored areas of the map will be shown."] = "Если установлен этот флажок, будут отображаться неисследованные области карты, но с отдельным затемнением."
L["If checked, unexplored areas will be tinted."] = "Если установлен этот флажок, неисследованные области будут отображаться на карте, но будут отдельно затемнены."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Если установлен этот флажок, то когда ваш персонаж будет переходить из одной зоны в другую, карта будет автоматически меняться, чтобы показывать всегда актуальную местность нахождения вашего персонажа."
L["If checked, you will be able to customise the battlefield map."] = "Если установлен этот флажок, вы сможете настраивать карту поля боя"
L["If checked, you will be able to enlarge the player arrow."] = "Если установлен этот флажок, вы сможете установить размер указателя (стрелки), которым обозначается расположение вашего персонажа на карте."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "Если установлен этот флажок, у вас появится возможность изменять размер карты и её место расположения|n|nМасштабируйте карту, перетаскивая маркер масштаба в правом нижнем углу.|n|nПеремещайте карту, перетаскивая границу и края окна."
L["If checked, you will be able to set the opacity of the map."] = "Если установлен этот флажок, у вас появится возможность изменять прозрачность карты."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Если установлен этот флажок, на карте будут отображаться зоны, подземелья и минимальный необходимый уровень рыбной ловли."
L["Invalid command.  Enter /ltm help for help."] = "Неверная команда. Введите /ltm help для помощи."
L["Invalid map ID."] = "Неверный ID карты"
L["Ironforge"] = "Стальгорн"
L["Kargath"] = "Каргат"
L["Lake Elune'ara"] = "Озеро Элуне'ара"
L["Lake Everstill"] = "Озеро Безмолвия"
L["Large Scarab Coffer"] = "Большой сундук Скарабея"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: УСТАНОВЛЕНА НЕПРАВИЛЬНАЯ ВЕРСИЯ!"
L["Light's Hope Chapel"] = "Часовня Последней Надежды"
L["Loch Modan"] = "Лок Модан"
L["Lower Blackrock Spire"] = "Нижняя часть пика Черной горы"
L["Map frame scale"] = "Масштабирование карты"
L["Map Size"] = "Размер карты"
L["Maraudon"] = "Мародон"
L["Marshal's Refuge"] = "Укрытие Маршалла"
L["Mechanics"] = "Механика"
L["Memory Usage"] = "Использование памяти"
L["Menethil Harbor"] = "Гавань Менетилов"
L["Miscellaneous"] = "Прочее"
L["Molten Core"] = "Огненные Недра"
L["Moonglade"] = "Лунная поляна"
L["More"] = "Больше"
L["Morgan's Vigil"] = "Дозор Морганы"
L["Moving"] = "В движении"
L["Mulgore"] = "Мулгор"
L["Nethergarde Keep"] = "Крепость Стражей Пустоты"
L["Nighthaven"] = "Ночная Гавань"
L["Nijel's Point"] = "Высота Найджела"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "ВНИМАНИЕ! Вы должны полностью перезапустить свой игровой клиент, прежде чем использовать эту версию Leatrix Maps."
L["Onyxia's Lair"] = "Логово Ониксии"
L["Opacity"] = "Затемнение"
L["or click the minimap button to open Leatrix Maps."] = "или нажмите на кнопку у миникарты для открытия окна Leatrix Maps."
L["Orgrimmar"] = "Оргриммар"
L["Player"] = "Персонаж"
L["Player Arrow"] = "Указатель"
L["Portal"] = "Портал"
L["Preview"] = "Превью"
L["Ragefire Chasm"] = "Огненная Пропасть"
L["Raid"] = "Рейд"
L["Ratchet"] = "Кабестан"
L["Razorfen Downs"] = "Курганы Иглошкурых"
L["Razorfen Kraul"] = "Лабиринты Иглошкурых"
L["Red"] = "Красный"
L["Redridge Mountains"] = "Красногорье"
L["Refuge Pointe"] = "Опорный пункт"
L["Reload"] = "Перезагрузка"
L["Remember zoom level"] = "Запомнить уровень приближения"
L["Remove map border"] = "Убрать границы карты"
L["Requires UI reload."] = "Требуется перезагрузка UI"
L["Reset"] = "Сброс настроек"
L["Reset Map Layout"] = "Сброс настроек"
L["Revantusk Village"] = "Деревня Сломанного Клыка"
L["Ruins of Ahn'Qiraj"] = "Руины Ан'Киража"
L["Ruins of Elune'eth"] = "Руины Элун'ета"
L["Rut'theran Village"] = "Деревня Рут'теран"
L["Scale"] = "Масштаб"
L["Scarlet Monastery"] = "Монастырь Алого ордена"
L["Scholomance"] = "Некроситет"
L["Searing Gorge"] = "Тлеющее ущелье"
L["Sentinel Hill"] = "Сторожевой холм"
L["Set map opacity"] = "Прозрачность карты"
L["Set map opacity while stationary and while moving."] = "Настройка прозрачности карты для двух различных состояний:|nкогда вы стоите и когда вы движетесь."
L["Set the group icon size."] = "Установите размер значка, которым следует отображать|nучастник вашей группы на карте."
L["Set the player arrow size."] = "Установите желаемый размер указателя (стрелки), которым|nобозначается расположение вашего персонажа на карте."
L["Settings"] = "Настройки"
L["Shadowfang Keep"] = "Крепость Темного Клыка"
L["Shadowprey Village"] = "Деревня Ночных Охотников"
L["Show boats, zeppelins and trams"] = "Отмечать на карте порты, башни дирижаблей и подземный поезд"
L["Show coordinates"] = "Показать координаты"
L["Show dungeons and raids"] = "Отмечать на карте входы в подземелья и рейдовые подземелья"
L["Show flight points"] = "Отмечать на карте точки полёта"
L["Show minimap button"] = "Кнопка у миникарты"
L["Show minimum fishing skill levels"] = "Показать минимальный уровень рыбной ловли"
L["Show points of interest"] = "Показать достопримечательности"
L["Show scale handle"] = "Показать шкалу масштабирования"
L["Show unexplored areas"] = "Показать неисследованные области"
L["Show zone levels"] = "Показать уровни локаций"
L["Silithus"] = "Силитус"
L["Silverpine Forest"] = "Серебряный бор"
L["Southshore"] = "Южнобережье"
L["Splintertree Post"] = "Застава Расщепленного Дерева"
L["Stationary"] = "В покое"
L["Sticky map frame"] = "Закрепить окно карты"
L["Stonard"] = "Каменор"
L["Stonetalon Mountains"] = "Когтистые горы"
L["Stonetalon Peak"] = "Пик Каменного Когтя"
L["Stormwind"] = "Штормград"
L["Stranglethorn Vale"] = "Тернистая долина"
L["Stratholme (Main Gate)"] = "Стратхольм (Главные ворота)"
L["Stratholme (Service Gate)"] = "Стратхольм (Сервисные ворота)"
L["Sun Rock Retreat"] = "Приют у Солнечного Камня"
L["Swamp of Sorrows"] = "Болото Печали"
L["Talonbranch Glade"] = "Поляна Когтистых Ветвей"
L["Talrendis Point"] = "Застава Талрендис"
L["Tanaris"] = "Танарис"
L["Tarren Mill"] = "Мельница Таррен"
L["Teldrassil"] = "Тельдрассил"
L["Temple of Ahn'Qiraj"] = "Храм Ан'Кираж"
L["Temple of Atal'Hakkar"] = "Затонувший храм"
L["Thalanaar"] = "Таланаар"
L["The Barrens"] = "Степи"
L["The Crossroads"] = "Перекресток"
L["The Deadmines"] = "Мертвые копи"
L["The Forgotten Coast"] = "Забытый берег"
L["The Great Forge"] = "Великая Кузня"
L["The Hinterlands"] = "Внутренние земли"
L["The Sepulcher"] = "Гробница"
L["The Stockade"] = "Тюрьма"
L["Thelsamar"] = "Телcамар"
L["Theramore Isle"] = "Остров Терамор"
L["Thorium Point"] = "Лагерь Братства Тория"
L["Thousand Needles"] = "Тысяча Игл"
L["Thunder Bluff"] = "Громовой Утес"
L["Tinker Town"] = "Город механиков"
L["Tint unexplored areas"] = "Цвет неразведанных участков"
L["Tirisfal Glades"] = "Тирисфальские леса"
L["Trade District"] = "Торговый квартал"
L["Trade Quarter"] = "Торговый квартал"
L["Tram to"] = "Поезд в"
L["Transparency"] = "Прозрачность"
L["Uldaman"] = "Ульдаман"
L["Undercity"] = "Подгород"
L["Un'Goro Crater"] = "Кратер Ун'Горо"
L["Unlock map frame"] = "Открепить окно карты"
L["Upper Blackrock Spire"] = "Верхняя часть пика Черной горы"
L["Use default map"] = "Карта на весь экран"
L["Use stationary opacity while pointing at map"] = "Карта всегда непрозрачна если над ней курсор"
L["Valley of Strength"] = "Аллея Силы"
L["Version"] = "Версия"
L["Wailing Caverns"] = "Пещеры Стенаний"
L["Western Plaguelands"] = "Западные Чумные земли"
L["Westfall"] = "Западный Край"
L["Wetlands"] = "Болотина"
L["Winterspring"] = "Зимние Ключи"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Чтобы некоторые изменения вступили в силу, необходимо перезагрузить Ваш пользовательский интерфейс|n|nНе требуется нажимать кнопку перезагрузки интерфейса сразу после каждого изменения, но её потребуется нажать тогда, когда вы закончите вносить все изменения и захотите, чтобы они вступили в силу."
L["Your UI needs to be reloaded."] = "Вам необходимо перезагрузить UI."
L["Zeppelin to"] = "Дирижабль в"
L["Zoram'gar Outpost"] = "Застава Зорам'гар"
L["Zul'Farrak"] = "Зул'Фаррак"
L["Zul'Gurub"] = "Зул'Гуруб"

end

-- koKR: Korean
if GameLocale == "koKR" then
L["/ltm help - Show this information."] = "/ltm help - 정보 표시."
L["/ltm reset - Reset the panel position."] = "/ltm reset - 패널 위치 재설정."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 모든 설정 지우고 리로드."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "정지 오류가 발생했지만 걱정할 필요가 없습니다. 때때로 발생할 수 있습니다. 문제를 해결하려면 리로드 버튼을 클릭하십시오."
L["Aerie Peak"] = "맹금의 봉우리"
L["Ahn'Qiraj"] = "안퀴라즈"
L["Alpha"] = "투명도"
L["Alterac Mountains"] = "알터렉 산맥"
L["Arathi Highlands"] = "아라시 고원"
L["Ashenvale"] = "잿빛 골짜기"
L["Astranaar"] = "아스트라나르"
L["Auberdine"] = "아우버다인"
L["Auto change zones"] = "지역 변경 자동"
L["Azshara"] = "아즈샤라"
L["Back to Main Menu"] = "주 메뉴로 돌아가기"
L["Badlands"] = "황야의 땅"
L["Blackfathom Deeps"] = "검은 심연 나락"
L["Blackrock Depths"] = "검은바위 나락"
L["Blackrock Mountain"] = "검은바위 산"
L["Blackwing Lair"] = "검은날개 둥지"
L["Blasted Lands"] = "저주받은 땅"
L["Bloodvenom Post"] = "피멍울초소"
L["Blue"] = "블루"
L["Boat to"] = "연결된 항구:"
L["Booty Bay"] = "무법항"
L["Brackenwall Village"] = "담쟁이 마을"
L["Burning Steppes"] = "불타는 평원"
L["Camp Mojache"] = "모자케 야영지"
L["Camp Taurajo"] = "타우라조 야영지"
L["Cenarion Hold"] = "세나리온 요새"
L["Central Mesa"] = "중앙 봉우리"
L["Chillwind Camp"] = "서리바람 야영지"
L["Class colored icons"] = "직업색상 아이콘"
L["Classic"] = "클래식"
L["Click to configure the settings for this option."] = "이 옵션의 설정을 구성하려면 클릭하십시오."
L["Click to reset the position and scale of the map frame."] = "지도 프레임의 위치와 크기를 재설정하려면 클릭하십시오."
L["Click to reset the settings on this page."] = "이 페이지의 설정을 재설정하려면 클릭하십시오."
L["Click to return to the main menu."] = "클릭하면 주 메뉴로 돌아갑니다."
L["Configuration Panel"] = "설정창"
L["Cursor"] = "커서"
L["Darkshire"] = "어둠골"
L["Darkshore"] = "어둠해안"
L["Darnassus"] = "다르나서스"
L["Deadwind Pass"] = "죽음의 고개"
L["Desolace"] = "잊혀진 땅"
L["Dire Maul (East)"] = "혈투의 전장(1동쪽)"
L["Dire Maul (North)"] = "혈투의 전장(2북쪽)"
L["Dire Maul (West)"] = "혈투의 전장(3서쪽)"
L["Disable reading emote when opening the map"] = "지도 볼때 감정표현(모션) 사용안함"
L["Drag"] = "이동"
L["Drag to set the amount of blue."] = "블루 색상을 드레그 설정 하세요."
L["Drag to set the amount of green."] = "그린 색상을 드레그 설정 하세요."
L["Drag to set the amount of red."] = "레드 색상을 드레그 설정 하세요."
L["Drag to set the battlefield map size."] = "전장지도 크기를 설정하려면 드래그하세요."
L["Drag to set the group icon size."] = "그룹 아이콘 크기를 설정하려면 드래그하십시오."
L["Drag to set the map opacity for when your character is moving."] = "캐릭터가 움직일 때의 맵 불투명도를 드레그 설정하세요."
L["Drag to set the map opacity for when your character is stationary."] = "캐릭터가 정지되어있을 때의 맵 불투명도를 설정하십시오."
L["Drag to set the opacity."] = "불투명도를 드레그 설정하세요."
L["Drag to set the player arrow size."] = "플레이어 화살표 크기를 설정하려면 드래그하십시오."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "드래그하여 플레이어 화살표 크기를 설정합니다. Wow Classic 기본값:16. Wow Retail 기본값: 27."
L["Druid only flight point to Darnassus"] = "드루이드 전용 비행지점"
L["Druid only flight point to Thunder Bluff"] = "드루이드 전용 비행지점"
L["Dun Morogh"] = "던 모르"
L["Dungeon"] = "던전"
L["Durotar"] = "듀로타"
L["Duskwood"] = "그늘숲"
L["Dustwallow Marsh"] = "먼지진흙 습지대"
L["Dwarven District"] = "드워프 지구"
L["Eastern Plaguelands"] = "동부 역병지대"
L["Elements"] = "저거"
L["Elwynn Forest"] = "엘원 숲"
L["Enhance battlefield map"] = "전장지도 설정"
L["Enlarge player arrow"] = "플레이어 화살표 크게"
L["Enter"] = "Enter"
L["Everlook"] = "눈망루 마을"
L["Feathermoon Stronghold"] = "페더문 요새"
L["Felwood"] = "악령의 숲"
L["Feralas"] = "페랄라스"
L["Fishing"] = "낚시"
L["Flame Crest"] = "화염 마루"
L["Freewind Post"] = "늪새바람 봉우리"
L["Gadgetzan"] = "가젯잔"
L["Gnomeregan"] = "놈리건"
L["Green"] = "그린"
L["Grom'gol Base Camp"] = "그룸골 주둔지"
L["Group Icons"] = "그룹 아이콘"
L["Hammerfall"] = "해머폴"
L["Hide town and city icons"] = "도시와 타운 아이콘 숨김"
L["Hillsbrad Foothills"] = "힐스브래드 구릉지"
L["Icons"] = "아이콘"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "여객 항구, 비행선 타워 및 지하철역이 표시됩니다."
L["If checked, coordinates will be shown."] = "좌표가 표시됩니다."
L["If checked, dungeons and raids will be shown."] = "던전과 공격대가 표시됩니다."
L["If checked, flight points will be shown."] = "비행 지점이 표시 됩니다."
L["If checked, group icons will use a modern, class-colored design."] = "그룹 아이콘은 현대적인 직업색상 디자인을 사용합니다."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "지도를 열면 지도영역이 변경되지 않은 한 마지막으로 닫을 때와 동일한 확대 / 축소 수준이 사용됩니다."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "캐릭터가 움직이는 동안 지도를 가리키면 불투명 적용되지 않습니다."
L["If checked, points of interest will be shown."] = "주요지점이 표시됩니다."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "전체 화면 맵이 기본 사용됩니다. |n|n이 옵션을 활성화하면 다른 옵션 중 일부가 잠깁니다."
L["If checked, the map border will be removed."] = "지도 테두리가 제거됩니다."
L["If checked, the map frame will remain open until you close it."] = "맵 프레임은 닫을 때까지 열린 상태로 유지됩니다."
L["If checked, the minimap button will be shown."] = "미니 맵 버튼이 표시됩니다."
L["If checked, the minimum fishing skill levels will be shown."] = "최소 낚시 숙련도가 표시됩니다."
L["If checked, town and city icons will not be shown on the continent maps."] = "도시와 타운 아이콘은 대륙지도에 표시되지 않습니다."
L["If checked, unexplored areas of the map will be shown."] = "미 탐색 영역이 표시됩니다."
L["If checked, unexplored areas will be tinted."] = "미탐험 지역의 색상을 설정합니다."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "캐릭터의 지역이 변경되면, 지도가 새 지역으로 자동 변경됩니다."
L["If checked, you will be able to customise the battlefield map."] = "전장지도를 사용자 설정 할 수 있습니다."
L["If checked, you will be able to enlarge the player arrow."] = "플레이어 화살표를 확대 할 수 있습니다."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "지도의 크기를 조정하고 이동할 수 있습니다. 오른쪽 하단 모서리에있는 배율 조정 핸들을 드래그하여 지도의 크기을 조정합니다. 테두리와 프레임 가장자리를 드래그하여 지도를 이동합니다."
L["If checked, you will be able to set the opacity of the map."] = "지도의 불투명도를 설정할 수 있습니다."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "지역, 던전 및 낚시 레벨이 표시됩니다."
L["Invalid command.  Enter /ltm help for help."] = "잘못된 명령입니다.도움말을 확인하세요. /ltm help"
L["Invalid map ID."] = "잘못된 지도 ID입니다."
L["Ironforge"] = "아이언포지"
L["Kargath"] = "카르가스"
L["Lake Elune'ara"] = "엘룬아라 호수"
L["Lake Everstill"] = "영원의 호수"
L["Large Scarab Coffer"] = "큰 스카라베 상자"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS : 잘못된 버전이 설치되었습니다!"
L["Light's Hope Chapel"] = "희망의 빛 예배당"
L["Loch Modan"] = "모단 호수"
L["Lower Blackrock Spire"] = "검은바위 첨탑 하층"
L["Map frame scale"] = "지도 크기 변경"
L["Map Size"] = "지도 크기"
L["Maraudon"] = "마라우돈"
L["Marshal's Refuge"] = "마샬 야영지"
L["Mechanics"] = "이거"
L["Memory Usage"] = "메모리 사용량"
L["Menethil Harbor"] = "메네실 항구"
L["Miscellaneous"] = "기타"
L["Molten Core"] = "화산 심장부"
L["Moonglade"] = "달의 숲"
L["More"] = "그거"
L["Morgan's Vigil"] = "모건의 망루"
L["Moving"] = "이동할 때"
L["Mulgore"] = "멀고어"
L["Nethergarde Keep"] = "네더가드 요새"
L["Nighthaven"] = "나이트헤이븐"
L["Nijel's Point"] = "나이젤의 야영지"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "주의!|nLeatrix Maps 이 버전을 적용하려면 게임 클라이언트를 다시 시작해야합니다."
L["Onyxia's Lair"] = "오닉시아의 둥지"
L["Opacity"] = "불투명"
L["or click the minimap button to open Leatrix Maps."] = "미니맵 버튼을 클릭하여 Leatrix Maps를 엽니다."
L["Orgrimmar"] = "오그리마"
L["Player"] = "플레이어"
L["Player Arrow"] = "플레이어 화살표"
L["Portal"] = "차원문"
L["Preview"] = "미리보기"
L["Ragefire Chasm"] = "성난불길 협곡"
L["Raid"] = "공격대"
L["Ratchet"] = "톱니항"
L["Razorfen Downs"] = "가시덩굴 구릉"
L["Razorfen Kraul"] = "가시덩굴 우리"
L["Red"] = "레드"
L["Redridge Mountains"] = "붉은마루 산맥"
L["Refuge Pointe"] = "임시주둔지"
L["Reload"] = "리로드"
L["Remember zoom level"] = "확대/축소 기억"
L["Remove map border"] = "지도 테두리 제거"
L["Requires UI reload."] = "UI를 리로드 해야합니다."
L["Reset"] = "리셋"
L["Reset Map Layout"] = "지도 레이아웃 초기화"
L["Revantusk Village"] = "레반터스크 마을"
L["Ruins of Ahn'Qiraj"] = "안퀴라즈 폐허"
L["Ruins of Elune'eth"] = "엘룬에스의 페허"
L["Rut'theran Village"] = "루테란 마을"
L["Scale"] = "크기"
L["Scarlet Monastery"] = "붉은십자군 수도원"
L["Scholomance"] = "스칼로맨스"
L["Searing Gorge"] = "이글거리는 협곡"
L["Sentinel Hill"] = "감시의 언덕"
L["Set map opacity"] = "지도 불투명도 설정"
L["Set map opacity while stationary and while moving."] = "플레이어가 맵을 열고 이동할때와 고정일때의 맵 불투명도를 설정합니다."
L["Set the group icon size."] = "그룹아이콘 크기 설정"
L["Set the player arrow size."] = "플레이어 화살표 크기를 설정하십시오."
L["Settings"] = "설정"
L["Shadowfang Keep"] = "그림자송곳니 성채"
L["Shadowprey Village"] = "그늘수렵 마을"
L["Show boats, zeppelins and trams"] = "여객선,비행선,지하철 표시"
L["Show coordinates"] = "좌표 표시"
L["Show dungeons and raids"] = "던전 및 공격대 표시"
L["Show flight points"] = "비행 지점 표시"
L["Show minimap button"] = "미니맵 버튼 표시"
L["Show minimum fishing skill levels"] = "최소 낚시 숙련도 표시"
L["Show points of interest"] = "주요 지점 표시"
L["Show scale handle"] = "크기 설정 표시"
L["Show unexplored areas"] = "미탐험 지역 표시"
L["Show zone levels"] = "지역 레벨 표시"
L["Silithus"] = "실리더스"
L["Silverpine Forest"] = "은빛소나무 숲"
L["Southshore"] = "사우스쇼어"
L["Splintertree Post"] = "토막나무 주둔지"
L["Stationary"] = "움직이지 않을 때"
L["Sticky map frame"] = "지도 프레임 지속됨."
L["Stonard"] = "스토나드"
L["Stonetalon Mountains"] = "돌발톱 산맥"
L["Stonetalon Peak"] = "돌발톱 봉우리"
L["Stormwind"] = "스톰윈드"
L["Stranglethorn Vale"] = "가시덤불 골짜기"
L["Stratholme (Main Gate)"] = "스트라솔름(정문)"
L["Stratholme (Service Gate)"] = "스트라솔름(후문)"
L["Sun Rock Retreat"] = "해바위 야영지"
L["Swamp of Sorrows"] = "슬픔의 늪"
L["Talonbranch Glade"] = "바람속삭임 숲"
L["Talrendis Point"] = "탈렌디스 초소"
L["Tanaris"] = "타나리스"
L["Tarren Mill"] = "타렌 밀농장"
L["Teldrassil"] = "텔드랏실"
L["Temple of Ahn'Qiraj"] = "안퀴라즈"
L["Temple of Atal'Hakkar"] = "아탈학카르 신전"
L["Thalanaar"] = "탈라나르"
L["The Barrens"] = "불모의 땅"
L["The Crossroads"] = "크로스로드"
L["The Deadmines"] = "죽음의 폐광"
L["The Forgotten Coast"] = "잊혀진 해안"
L["The Great Forge"] = "대용광로"
L["The Hinterlands"] = "동부내륙지"
L["The Sepulcher"] = "공동묘지"
L["The Stockade"] = "지하감옥"
L["Thelsamar"] = "텔사마"
L["Theramore Isle"] = "테라모어"
L["Thorium Point"] = "토륨거점"
L["Thousand Needles"] = "버섯구름 봉우리"
L["Thunder Bluff"] = "썬더 블러프"
L["Tinker Town"] = "땜장이 마을"
L["Tint unexplored areas"] = "미탐험지역 색상"
L["Tirisfal Glades"] = "티리스팔 숲"
L["Trade District"] = "상업지구"
L["Trade Quarter"] = "상업지구"
L["Tram to"] = "지하철(다음역) "
L["Transparency"] = "투명도"
L["Uldaman"] = "울다만"
L["Undercity"] = "언더시티"
L["Un'Goro Crater"] = "운고로 분화구"
L["Unlock map frame"] = "세계지도 잠금해제"
L["Upper Blackrock Spire"] = "검은바위 첨탑 상층"
L["Use default map"] = "기본 지도 사용"
L["Use stationary opacity while pointing at map"] = "지도를 가리키는 동안 불투명도 사용 안함"
L["Valley of Strength"] = "힘의 골짜기"
L["Version"] = "버전"
L["Wailing Caverns"] = "통곡의 동굴"
L["Western Plaguelands"] = "서부 역병지대"
L["Westfall"] = "서부 몰락지대"
L["Wetlands"] = "저습지"
L["Winterspring"] = "여명의 설원"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "일부 변경 사항을(*) 적용하려면 UI를 리로드 해야합니다."
L["Your UI needs to be reloaded."] = "UI를 리로드 해야 합니다."
L["Zeppelin to"] = "연결된 비행선 지점:"
L["Zoram'gar Outpost"] = "조람가르 전초기지"
L["Zul'Farrak"] = "줄파락"
L["Zul'Gurub"] = "줄구룹"

end

-- deDE: German
if GameLocale == "deDE" then
L["/ltm help - Show this information."] = "/ltm help - Informationen anzeigen."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Panelposition Zurücksetzen."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - ALLE Einstellungen zurücksetzen und Interface neu laden."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Ein Stopp-Fehler ist aufgetreten aber keine Sorge.  Das kann von Zeit zu Zeit passieren.  Klicke auf den Reload Button und das Problem sollte behoben sein."
L["Aerie Peak"] = "Nistgipfel"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alpha"] = "Alpha"
L["Alterac Mountains"] = "Alteracgebirge"
L["Arathi Highlands"] = "Arathihochland"
L["Ashenvale"] = "Eschental"
L["Astranaar"] = "Astranaar"
L["Auberdine"] = "Auberdine"
L["Auto change zones"] = "Automatische Zonenwechsel"
L["Azshara"] = "Azshara"
L["Back to Main Menu"] = "Zurück zum Hauptmenü"
L["Badlands"] = "Ödland"
L["Blackfathom Deeps"] = "Blackfathom-Tiefe"
L["Blackrock Depths"] = "Blackrocktiefen"
L["Blackrock Mountain"] = "Der Blackrock"
L["Blackwing Lair"] = "Pechschwingenhort"
L["Blasted Lands"] = "Verwüstete Lande"
L["Bloodvenom Post"] = "Blutgiftposten"
L["Blue"] = "Blau"
L["Boat to"] = "Boot nach"
L["Booty Bay"] = "Booty Bay"
L["Brackenwall Village"] = "Brackenwall"
L["Burning Steppes"] = "Brennende Steppe"
L["Camp Mojache"] = "Camp Mojache"
L["Camp Taurajo"] = "Camp Taurajo"
L["Cenarion Hold"] = "Burg Cenarius"
L["Central Mesa"] = "Die große Anhöhe"
L["Chillwind Camp"] = "Chillwind Lager"
L["Class colored icons"] = "Symbole in Klassenfarbe"
L["Classic"] = "Classic"
L["Click to configure the settings for this option."] = "Klicken um die Einstellung dieser Option zu verändern."
L["Click to reset the position and scale of the map frame."] = "Klicken zum zurücksetzen der Position und Größe des Weltkartenfensters."
L["Click to reset the settings on this page."] = "Klicken zum zurücksetzen der Einstellungen dieses Fensters."
L["Click to return to the main menu."] = "Klicken um zurück ins Hauptmenü zu gelangen."
L["Configuration Panel"] = "Einstellungsfenster"
L["Cursor"] = "Cursor"
L["Darkshire"] = "Dunkelhain"
L["Darkshore"] = "Dunkelküste"
L["Darnassus"] = "Darnassus"
L["Deadwind Pass"] = "Gebirgspass der Totenwinde"
L["Desolace"] = "Desolace"
L["Dire Maul (East)"] = "Düsterbruch (Ost)"
L["Dire Maul (North)"] = "Düsterbruch (Nord)"
L["Dire Maul (West)"] = "Düsterbruch (West)"
L["Disable reading emote when opening the map"] = "Deaktiviert die Leseanimation wenn die Weltkarte geöffnet wird"
L["Drag"] = "Verschieben"
L["Drag to set the amount of blue."] = "Verschiebe den Regler für die Menge an blau."
L["Drag to set the amount of green."] = "Verschiebe den Regler für die Menge an grün."
L["Drag to set the amount of red."] = "Verschiebe den Regler für die Menge an rot."
L["Drag to set the group icon size."] = "Ziehen zum ändern der Gruppenicongröße"
L["Drag to set the map opacity for when your character is moving."] = "Verschiebe den Regler für die Transparenz der Weltkarte wenn sich dein Charakter bewegt."
L["Drag to set the map opacity for when your character is stationary."] = "Verschiebe den Regler für die Transparenz der Weltkarte wenn dein Charakter steht."
L["Drag to set the opacity."] = "Verschiebe den Regler für die Transparenz."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Verschieben um die Größe des Spielerpfeils einzustellen.|n|nWoW Classic größe ist 16.|nWoW Live größe ist 27."
L["Druid only flight point to Darnassus"] = "Flugpunkt nach Darnassus, nur für Druiden"
L["Druid only flight point to Thunder Bluff"] = "Flugpunkt nach Thunder Bluff, nur für Druiden"
L["Dun Morogh"] = "Dun Morogh"
L["Dungeon"] = "Instanz"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Dämmerwald"
L["Dustwallow Marsh"] = "Marschen von Dustwallow"
L["Dwarven District"] = "Der Zwergendistrikt"
L["Eastern Plaguelands"] = "Östliche Pestländer"
L["Elements"] = "Elemente"
L["Elwynn Forest"] = "Wald von Elwynn"
L["Enlarge player arrow"] = "Vergrößerter spielerpfeil"
L["Enter"] = "Enter"
L["Everlook"] = "Everlook"
L["Feathermoon Stronghold"] = "Festung Feathermoon"
L["Felwood"] = "Teufelswald"
L["Feralas"] = "Feralas"
L["Fishing"] = "Fischen"
L["Flame Crest"] = "Flammenkamm"
L["Freewind Post"] = "Freiwindposten"
L["Gadgetzan"] = "Gadgetzan"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Grün"
L["Grom'gol Base Camp"] = "Das Basislager von Grom'gol"
L["Group Icons"] = "Gruppenicons"
L["Hammerfall"] = "Hammerfall"
L["Hide town and city icons"] = "Verstecke Stadticons"
L["Hillsbrad Foothills"] = "Vorgebirge von Hillsbrad"
L["Icons"] = "Symbole"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Zeigt Schiffsanlegestellen, Zeppelintürme und Bahnstationen an wenn aktiviert."
L["If checked, coordinates will be shown."] = "Zeigt die Koordinaten an wenn aktiviert."
L["If checked, dungeons and raids will be shown."] = "Zeigt Instanz- und Schlachtzugseingänge an wenn aktiviert."
L["If checked, flight points will be shown."] = "Zeigt Flugpunkte an wenn aktiviert."
L["If checked, group icons will use a modern, class-colored design."] = "Gruppensymbole nutzen das moderne und, nach Klassenfarben, eingefärbte Aussehen wenn aktiviert."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Wenn aktiviert, öffnet sich die Weltkarte mit der selben Zoomstufe mit der Du sie zuletzt verlassen hast. Funktioniert nur solange Du nicht die Zone wechselst."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Nutzt die Transparenzeinstellung aus der 'Stehend' voreinstellung sobald sich euer Mauszeiger auf der Weltkarte befindet wenn aktiviert."
L["If checked, points of interest will be shown."] = "POI - interessante Punkte werden auf der Weltkarte mit Symbolen dargestellt wenn aktiviert."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Wenn aktiviert, wird die standard Vollbild-Karte genutzt.|n|n Hinweis - Das aktivieren dieser Option sperrt einige andere Funktionen."
L["If checked, the map border will be removed."] = "Der Fensterrand der Weltkarte wird entfernt wenn aktiviert."
L["If checked, the map frame will remain open until you close it."] = "Das Kartenfenster bleibt offen bis es manuell geschlossen wird, wenn aktiviert."
L["If checked, the minimap button will be shown."] = "Zeigt den Button an der Minikarte wenn aktiviert."
L["If checked, the minimum fishing skill levels will be shown."] = "Zeigt die benötigte Angelfertigkeit des Gebietes an wenn aktiviert."
L["If checked, town and city icons will not be shown on the continent maps."] = " Stadtsymbole werden nicht gezeigt wenn aktiviert."
L["If checked, unexplored areas of the map will be shown."] = "Zeigt unentdeckte Gebiete auf der Weltkarte wenn aktiviert."
L["If checked, unexplored areas will be tinted."] = "Färbt die unentdeckten Gebiete auf der Weltkarte ein wenn aktiviert"
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Wenn aktiviert, wechselt die Karte automatisch die Zone sobald der Charakter die neue Zone betritt."
L["If checked, you will be able to enlarge the player arrow."] = "Ermöglicht die Anpassug der Größe des Spielerpfeils wenn aktiviert."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "Ermöglicht das Verschieben und die Anpassung der Größe der Weltkarte wenn aktiviert.|n|nÄndere die Größe der Weltkarte indem Du den Anker in der rechten unteren Ecke, mit gedrückter Maustaste, ziehst.|n|nBewege die Weltkarte indem Du sie an den Rändern, mit gedrückter Maustaste, ziehst."
L["If checked, you will be able to set the opacity of the map."] = "Ermöglicht die Transparenz der Weltkarte einzustellen wenn aktiviert."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Zeigt den Levelbereich für Zonen, Instanzen und Angelfertigkeiten an wenn aktiviert."
L["Invalid command.  Enter /ltm help for help."] = "Unbekannter Befehl.  Schreibe  /ltm help  für weitere Befehle und hilfe."
L["Invalid map ID."] = "Unbekannter Weltkarten-ID."
L["Ironforge"] = "Ironforge"
L["Kargath"] = "Kargath"
L["Lake Elune'ara"] = "See von Elune'ara"
L["Lake Everstill"] = "Der Immerruhsee"
L["Large Scarab Coffer"] = "Großer Skarabäuskasten"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: FALSCHE VERSION INSTALLIERT!"
L["Light's Hope Chapel"] = "Kapelle des Hoffnungsvollen Lichts"
L["Loch Modan"] = "Loch Modan"
L["Lower Blackrock Spire"] = "Untere Blackrockspitze"
L["Map frame scale"] = "Kartenrandgröße"
L["Maraudon"] = "Maraudon"
L["Marshal's Refuge"] = "Marschalls Zuflucht"
L["Mechanics"] = "Funktionen"
L["Memory Usage"] = "Speicherauslastung"
L["Menethil Harbor"] = "Der Hafen von Menethil"
L["Miscellaneous"] = "Sonstiger"
L["Molten Core"] = "Geschmolzener Kern"
L["Moonglade"] = "Moonglade"
L["Morgan's Vigil"] = "Morgans Wacht"
L["Moving"] = "In Bewegung"
L["Mulgore"] = "Mulgore"
L["Nethergarde Keep"] = "Burg Nethergarde"
L["Nighthaven"] = "Nachthafen"
L["Nijel's Point"] = "Die Nijelspitze"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "HINWEIS!|nDu musst dein Spiel komplett neu bevor Du diese Version von Leatrix Maps benutzen kannst."
L["Onyxia's Lair"] = "Onyxias Hort"
L["Opacity"] = "Transparenz"
L["or click the minimap button to open Leatrix Maps."] = "oder klicke auf den Button an der Minikarte."
L["Orgrimmar"] = "Orgrimmar"
L["Player"] = "Spieler"
L["Player Arrow"] = "Spielerpfeil"
L["Portal"] = "Portal"
L["Preview"] = "Vorschau"
L["Ragefire Chasm"] = "Ragefireabgrund"
L["Raid"] = "Schlachtzug"
L["Ratchet"] = "Ratchet"
L["Razorfen Downs"] = "Die Hügel von Razorfen"
L["Razorfen Kraul"] = "Der Kral von Razorfen"
L["Red"] = "Rot"
L["Redridge Mountains"] = "Rotkammgebirge"
L["Refuge Pointe"] = "Die Zuflucht"
L["Reload"] = "Neu laden (UI)"
L["Remember zoom level"] = "Zoomstufe merken"
L["Remove map border"] = "Kartenrand entfernen"
L["Requires UI reload."] = "Benötigt UI-Neuladen"
L["Reset"] = "Zurücksetzen"
L["Reset Map Layout"] = "Karte Zurücksetzen"
L["Revantusk Village"] = "Dorf der Bruchhauer"
L["Ruins of Ahn'Qiraj"] = "Ruinen von Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinen von Elune'eth"
L["Rut'theran Village"] = "Rut'theran"
L["Scale"] = "Größe"
L["Scarlet Monastery"] = "Das scharlachrote Kloster"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "Sengende Schlucht"
L["Sentinel Hill"] = "Späherkuppe"
L["Set map opacity"] = "Kartentransparenz"
L["Set map opacity while stationary and while moving."] = "Einstellung für die Transparenz der Weltkarte beim stehen und bewegen."
L["Set the group icon size."] = "Setzt die Gruppenicongröße"
L["Set the player arrow size."] = "Stellt die Größe des Spielerpfeils ein."
L["Settings"] = "Einstellungen"
L["Shadowfang Keep"] = "Burg Shadowfang"
L["Shadowprey Village"] = "Shadowprey"
L["Show boats, zeppelins and trams"] = "Schiffe, Zeppeline und Bahnen"
L["Show coordinates"] = "Zeige Koordinaten"
L["Show dungeons and raids"] = "Instanzen und Schlachtzüge"
L["Show flight points"] = "Flugpunkte"
L["Show minimap button"] = "Zeige minikarten button"
L["Show minimum fishing skill levels"] = "Zeige Angelfertigkeiten"
L["Show points of interest"] = "Zeige POI"
L["Show scale handle"] = "Zeige Größenregler"
L["Show unexplored areas"] = "Zeige unentdeckte Gebiete"
L["Show zone levels"] = "Zeige Gebietsstufe"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Silberwald"
L["Southshore"] = "Southshore"
L["Splintertree Post"] = "Splintertreeposten"
L["Stationary"] = "Stehend"
L["Sticky map frame"] = "Angeheftete Karte"
L["Stonard"] = "Stonard"
L["Stonetalon Mountains"] = "Steinkrallengebirge"
L["Stonetalon Peak"] = "Der Steinkrallengipfel"
L["Stormwind"] = "Stormwind"
L["Stranglethorn Vale"] = "Schlingendorntal"
L["Stratholme (Main Gate)"] = "Stratholme: Haupttor"
L["Stratholme (Service Gate)"] = "Stratholme: Dienstboteneingang"
L["Sun Rock Retreat"] = "Sonnenfels"
L["Swamp of Sorrows"] = "Sümpfe des Elends"
L["Talonbranch Glade"] = "Nachtlaublichtung"
L["Talrendis Point"] = "Talrendisspitze"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Tarrens Mühle"
L["Teldrassil"] = "Teldrassil"
L["Temple of Ahn'Qiraj"] = "Tempel von Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Tempel von Atal'Hakkar"
L["Thalanaar"] = "Thalanaar"
L["The Barrens"] = "Das Brachland"
L["The Crossroads"] = "Crossroads"
L["The Deadmines"] = "Die Todesminen"
L["The Forgotten Coast"] = "Die vergessene Küste"
L["The Great Forge"] = "Die große Schmiede"
L["The Hinterlands"] = "Hinterland"
L["The Sepulcher"] = "Das Grabmal"
L["The Stockade"] = "Das Verlies"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Die Insel Theramore"
L["Thorium Point"] = "Thoriumspitze"
L["Thousand Needles"] = "Tausend Nadeln"
L["Thunder Bluff"] = "Thunder Bluff"
L["Tinker Town"] = "Tüftlerstadt"
L["Tint unexplored areas"] = "Färbung unentdeckter Gebiete"
L["Tirisfal Glades"] = "Tirisfal"
L["Trade District"] = "Der Handelsdistrikt"
L["Trade Quarter"] = "Das Handelsviertel"
L["Tram to"] = "Bahn nach"
L["Transparency"] = "Transparenz"
L["Uldaman"] = "Uldaman"
L["Undercity"] = "Undercity"
L["Un'Goro Crater"] = "Un'Goro-Krater"
L["Unlock map frame"] = "Löst den Kartenrand"
L["Upper Blackrock Spire"] = "Obere Blackrockspitze"
L["Use default map"] = "Benutzt die standard karte"
L["Use stationary opacity while pointing at map"] = "Nutzt die 'Stehend'-Transparenz wenn euer Mauszeiger auf der Weltkarte ist."
L["Valley of Strength"] = "Tal der Stärke"
L["Version"] = "Version"
L["Wailing Caverns"] = "Die Höhlen des Wehklagens"
L["Western Plaguelands"] = "Westliche Pestländer"
L["Westfall"] = "Westfall"
L["Wetlands"] = "Sumpfland"
L["Winterspring"] = "Winterspring"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Deine Benutzeroberfläche (UI) muss neu gestartet werden damit einige Einstellung in kraft treten.|n|nDu musst nicht sofort auf 'Neu laden (UI)' klicken aber am ende deiner Einstellungen solltest Du auf 'Neu laden (UI)' klicken damit alle Einstellungen auch wirksam werden."
L["Your UI needs to be reloaded."] = "UI neu laden."
L["Zeppelin to"] = "Zeppelin nach"
L["Zoram'gar Outpost"] = "Zoram'gar-Außenposten"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- esMX: Spanish (Mexico)
if GameLocale == "esMX" then
L["/ltm help - Show this information."] = "/ltm help - Mostrar información."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Restablecer la posición del panel."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Borrar la configuración y recargar."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Se ha producido un error de detención, pero no hay que preocuparse. Puede suceder de vez en cuando. Haga clic en el botón de recarga para resolverlo."
L["Aerie Peak"] = "Pico Nidal"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alpha"] = "Alfa"
L["Alterac Mountains"] = "Montañas de Alterac"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Ashenvale"] = "Vallefresno"
L["Astranaar"] = "Astranaar"
L["Auberdine"] = "Auberdine"
L["Auto change zones"] = "Cambiar zonas"
L["Azshara"] = "Azshara"
L["Back to Main Menu"] = "Volver a menú principal"
L["Badlands"] = "Tierras Inhóspitas"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackrock Mountain"] = "Montaña Roca Negra"
L["Blackwing Lair"] = "Guarida de Alanegra"
L["Blasted Lands"] = "Las Tierras Devastadas"
L["Bloodvenom Post"] = "Puesto del Veneno"
L["Blue"] = "Azul"
L["Boat to"] = "Barco a"
L["Booty Bay"] = "Bahía del Botín"
L["Brackenwall Village"] = "Poblado Murohelecho"
L["Burning Steppes"] = "Las Estepas Ardientes"
L["Camp Mojache"] = "Campamento Mojache"
L["Camp Taurajo"] = "Campamento Taurajo"
L["Cenarion Hold"] = "Fuerte Cenarion"
L["Central Mesa"] = "Meseta Central"
L["Chillwind Camp"] = "Campamento del Orvallo"
L["Class colored icons"] = "Iconos coloreados"
L["Classic"] = "Clásico"
L["Click to configure the settings for this option."] = "Haga clic para configurar los ajustes para esta opción."
L["Click to reset the position and scale of the map frame."] = "Haga clic para restablecer la posición y la escala del marco del mapa."
L["Click to reset the settings on this page."] = "Haga clic para restablecer la configuración en esta página."
L["Click to return to the main menu."] = "Haga clic para volver al menú principal."
L["Configuration Panel"] = "Panel de Configuración"
L["Cursor"] = "Cursor"
L["Darkshire"] = "Villa Oscura"
L["Darkshore"] = "Costa Oscura"
L["Darnassus"] = "Darnassus"
L["Deadwind Pass"] = "Paso de la Muerte"
L["Desolace"] = "Desolace"
L["Dire Maul (East)"] = "La Masacre (Este)"
L["Dire Maul (North)"] = "La Masacre (Norte)"
L["Dire Maul (West)"] = "La Masacre (Oeste)"
L["Disable reading emote when opening the map"] = "Deshabilita la lectura de emoticones al abrir el mapa"
L["Drag"] = "Arrastrar"
L["Drag to set the amount of blue."] = "Arrastra para establecer la cantidad de azul."
L["Drag to set the amount of green."] = "Arrastra para establecer la cantidad de verde."
L["Drag to set the amount of red."] = "Arrastra para establecer la cantidad de rojo."
L["Drag to set the battlefield map size."] = "Arrastra para establecer el tamaño del mapa del campo de batalla."
L["Drag to set the group icon size."] = "Arrastra para establecer el tamaño del icono de grupo."
L["Drag to set the map opacity for when your character is moving."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje se esté moviendo."
L["Drag to set the map opacity for when your character is stationary."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje esté estacionario."
L["Drag to set the opacity."] = "Arrastra para establecer la opacidad."
L["Drag to set the player arrow size."] = "Arrastra para establecer el tamaño de la flecha del jugador."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Arrastra para establecer el tamaño de la flecha del jugador.|n|nEl valor predeterminado de WoW Classic es 16.|nEl valor predeterminado de WoW Retail es 27."
L["Druid only flight point to Darnassus"] = "Punto de vuelo a Darnassus solo para druidas"
L["Druid only flight point to Thunder Bluff"] = "Punto de vuelo a Cima del Trueno solo para druidas"
L["Dun Morogh"] = "Dun Morogh"
L["Dungeon"] = "Calabozo"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Dwarven District"] = "Distrito de los Enanos"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["Elements"] = "Visibilidad"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["Enhance battlefield map"] = "Mejorar el mapa del campo de batalla"
L["Enlarge player arrow"] = "Flecha de jugador"
L["Enter"] = "Entrar"
L["Everlook"] = "Vista Eterna"
L["Feathermoon Stronghold"] = "Bastión Plumaluna"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Fishing"] = "Pesca"
L["Flame Crest"] = "Peñasco Llamarada"
L["Freewind Post"] = "Poblado Viento Libre"
L["Gadgetzan"] = "Gadgetzan"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Verde"
L["Grom'gol Base Camp"] = "Campamento Grom'gol"
L["Group Icons"] = "Iconos de grupo"
L["Hammerfall"] = "Sentencia"
L["Hide town and city icons"] = "Pueblos y ciudades"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Icons"] = "Iconos"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Si está seleccionado, se mostrarán los puertos de los barcos, las torres de los zepelines y las estaciones de tranvía."
L["If checked, coordinates will be shown."] = "Si está seleccionado, se mostrarán las coordenadas."
L["If checked, dungeons and raids will be shown."] = "Si está seleccionado, se mostrarán calabozos y bandas."
L["If checked, flight points will be shown."] = "Si está seleccionado, se mostrarán los puntos de vuelo."
L["If checked, group icons will use a modern, class-colored design."] = "Si está seleccionado, los iconos de grupo usarán un diseño moderno, de color de clase."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Si está seleccionado, al abrir el mapa se usará el mismo nivel de zoom desde la última vez que lo cerró, siempre que la zona del mapa no haya cambiado."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Si está seleccionado, apuntar al mapa mientras tu personaje se mueve hará que se aplique la configuración de opacidad estacionaria."
L["If checked, points of interest will be shown."] = "Si está seleccionado, se mostrarán puntos de interés."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Si está seleccionado, se usará el mapa predeterminado de pantalla completa.|n|nTenga en cuenta que habilitar esta opción bloqueará algunas de las otras opciones."
L["If checked, the map border will be removed."] = "Si está seleccionado, se eliminará el borde del mapa."
L["If checked, the map frame will remain open until you close it."] = "Si está seleccionado, el marco del mapa permanecerá abierto hasta que lo cierre."
L["If checked, the minimap button will be shown."] = "Si está seleccionado, se mostrará el botón del minimapa."
L["If checked, the minimum fishing skill levels will be shown."] = "Si está seleccionado, se mostrarán los niveles mínimos de habilidad de pesca."
L["If checked, town and city icons will not be shown on the continent maps."] = "Si está seleccionado, los iconos de pueblos y ciudades no se mostrarán en los mapas continentes."
L["If checked, unexplored areas of the map will be shown."] = "Si está seleccionado, se mostrarán áreas inexploradas del mapa."
L["If checked, unexplored areas will be tinted."] = "Si está seleccionado, las áreas inexploradas se teñirán."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Si está seleccionado, cuando tu personaje cambia de zona, el mapa cambiará automáticamente a la nueva zona."
L["If checked, you will be able to customise the battlefield map."] = "Si está seleccionado, podrás personalizar el mapa del campo de batalla."
L["If checked, you will be able to enlarge the player arrow."] = "Si está seleccionado, podrá ampliar la flecha del jugador."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "Si está seleccionado, podrá escalar y mover el mapa.|n|nEscale el mapa arrastrando el controlador de escala en la esquina inferior derecha.|n|nMueva el mapa arrastrando el borde y los bordes del marco."
L["If checked, you will be able to set the opacity of the map."] = "Si está seleccionado, podrá establecer la opacidad del mapa."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Si está seleccionado, se mostrarán los niveles de zona, calabozo y habilidad de pesca."
L["Invalid command.  Enter /ltm help for help."] = "Comando inválido. Escribe / ltm help para obtener ayuda."
L["Invalid map ID."] = "ID de mapa inválido."
L["Ironforge"] = "Forjaz"
L["Kargath"] = "Kargath"
L["Lake Elune'ara"] = "Lago Elune'ara"
L["Lake Everstill"] = "Lago Sempiterno"
L["Large Scarab Coffer"] = "Arca del escarabajo grande"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: ¡VERSIÓN INCORRECTA INSTALADA!"
L["Light's Hope Chapel"] = "Capilla de la Esperanza de la Luz"
L["Loch Modan"] = "Loch Modan"
L["Lower Blackrock Spire"] = "Cumbre de Roca Negra Inferior"
L["Map frame scale"] = "Escala del marco del mapa"
L["Map Size"] = "Tamaño de mapa"
L["Maraudon"] = "Maraudon"
L["Marshal's Refuge"] = "Refugio de Marshal"
L["Mechanics"] = "Mecánicas"
L["Memory Usage"] = "Uso de memoria"
L["Menethil Harbor"] = "Puerto de Menethil"
L["Miscellaneous"] = "Miscelánea"
L["Molten Core"] = "Núcleo de Magma"
L["Moonglade"] = "Claro de la Luna"
L["More"] = "Más"
L["Morgan's Vigil"] = "Vigilia de Morgan"
L["Moving"] = "Movimiento"
L["Mulgore"] = "Mulgore"
L["Nethergarde Keep"] = "Castillo de Nethergarde"
L["Nighthaven"] = "Amparo de la Noche"
L["Nijel's Point"] = "Punta de Nijel"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "¡ATENCIÓN!|nDebes reiniciar completamente tu cliente de juego antes de poder usar esta versión de Leatrix Maps."
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["Opacity"] = "Opacidad"
L["or click the minimap button to open Leatrix Maps."] = "o haga clic en el botón de minimapa para abrir Leatrix Maps."
L["Orgrimmar"] = "Orgrimmar"
L["Player"] = "Jugador"
L["Player Arrow"] = "Flecha de jugador"
L["Portal"] = "Portal"
L["Preview"] = "Prevista"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Ratchet"] = "Trinquete"
L["Razorfen Downs"] = "Zahúrda Rajacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Red"] = "Rojo"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Refuge Pointe"] = "Refugio de la Zaga"
L["Reload"] = "Recargar"
L["Remember zoom level"] = "Recordar nivel de zoom"
L["Remove map border"] = "Borde del mapa"
L["Requires UI reload."] = "Requiere recargar la IU"
L["Reset"] = "Restablecer"
L["Reset Map Layout"] = "Restablecer el diseño del mapa"
L["Revantusk Village"] = "Poblado Sañadiente"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinas de Elune'eth"
L["Rut'theran Village"] = "Aldea Rut'theran"
L["Scale"] = "Escala"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "La Garganta de Fuego"
L["Sentinel Hill"] = "Colina del Centinela"
L["Set map opacity"] = "Opacidad del mapa"
L["Set map opacity while stationary and while moving."] = "Establece la opacidad del mapa mientras está parado y en movimiento."
L["Set the group icon size."] = "Establece el tamaño del icono de grupo."
L["Set the player arrow size."] = "Establece el tamaño de la flecha del jugador."
L["Settings"] = "Configuración"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shadowprey Village"] = "Aldea Cazasombras"
L["Show boats, zeppelins and trams"] = "Mostrar barcos, zepelines y tranvías"
L["Show coordinates"] = "Coordenadas"
L["Show dungeons and raids"] = "Mostrar calabozos y bandas"
L["Show flight points"] = "Mostrar puntos de vuelo"
L["Show minimap button"] = "Botón del minimapa"
L["Show minimum fishing skill levels"] = "Mostrar niveles mínimos de habilidad de pesca"
L["Show points of interest"] = "Puntos de interés"
L["Show scale handle"] = "Mostrar asa de escala"
L["Show unexplored areas"] = "Áreas inexploradas"
L["Show zone levels"] = "Nivel de zona"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Bosque de Argénteos"
L["Southshore"] = "Costasur"
L["Splintertree Post"] = "Puesto del Hachazo"
L["Stationary"] = "Estacionario"
L["Sticky map frame"] = "Mapa pegajoso"
L["Stonard"] = "Rocal"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stonetalon Peak"] = "Cima del Espolón"
L["Stormwind"] = "Ventormenta"
L["Stranglethorn Vale"] = "Vega de Tuercespina"
L["Stratholme (Main Gate)"] = "Stratholme: Entrada Principal"
L["Stratholme (Service Gate)"] = "Stratholme: Entrada de Servicio"
L["Sun Rock Retreat"] = "Refugio Roca del Sol"
L["Swamp of Sorrows"] = "Pantanos de las Penas"
L["Talonbranch Glade"] = "Claro Ramaespolón"
L["Talrendis Point"] = "Punta Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Molino Tarren"
L["Teldrassil"] = "Teldrassil"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Thalanaar"] = "Thalanaar"
L["The Barrens"] = "Los Baldíos"
L["The Crossroads"] = "El Cruce"
L["The Deadmines"] = "Las Minas de la Muerte"
L["The Forgotten Coast"] = "La Costa Olvidada"
L["The Great Forge"] = "La Gran Fundición"
L["The Hinterlands"] = "Tierras del Interior"
L["The Sepulcher"] = "El Sepulcro"
L["The Stockade"] = "Las Mazmorras"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Isla Theramore"
L["Thorium Point"] = "Puesto del Torio"
L["Thousand Needles"] = "Las Mil Agujas"
L["Thunder Bluff"] = "Cima del Trueno"
L["Tinker Town"] = "Ciudad Manitas"
L["Tint unexplored areas"] = "Teñir áreas inexploradas"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["Trade District"] = "Distrito de Mercaderes"
L["Trade Quarter"] = "Barrio del Comercio"
L["Tram to"] = "Tranvía a"
L["Transparency"] = "Transparencia"
L["Uldaman"] = "Uldaman"
L["Undercity"] = "Entrañas"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Unlock map frame"] = "Desbloquear mapa"
L["Upper Blackrock Spire"] = "Cumbre de Roca Negra Superior"
L["Use default map"] = "Mapa predeterminado"
L["Use stationary opacity while pointing at map"] = "Usa opacidad estacionaria mientras apunta al mapa"
L["Valley of Strength"] = "El Valle de la Fuerza"
L["Version"] = "Versión"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Wetlands"] = "Los Humedales"
L["Winterspring"] = "Cuna del Invierno"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Su IU necesita ser recargada para que algunos de los cambios surtan efecto.|n|nNo tiene que hacer clic en el botón de recarga de inmediato, pero debe hacer clic en él cuando haya terminado de hacer cambios y desea que los cambios surtan efecto."
L["Your UI needs to be reloaded."] = "La IU necesita ser recargada."
L["Zeppelin to"] = "Zepelín a"
L["Zoram'gar Outpost"] = "Ensenada de Zoram'gar"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- esES: Spanish (Spain)
if GameLocale == "esES" then
L["/ltm help - Show this information."] = "/ltm help - Mostrar información."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Restablecer la posición del panel."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Borrar la configuración y recargar."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Se ha producido un error de detención, pero no hay que preocuparse. Puede suceder de vez en cuando. Haga clic en el botón de recarga para resolverlo."
L["Aerie Peak"] = "Pico Nidal"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alpha"] = "Alfa"
L["Alterac Mountains"] = "Montañas de Alterac"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Ashenvale"] = "Vallefresno"
L["Astranaar"] = "Astranaar"
L["Auberdine"] = "Auberdine"
L["Auto change zones"] = "Cambiar zonas"
L["Azshara"] = "Azshara"
L["Back to Main Menu"] = "Volver a menú principal"
L["Badlands"] = "Tierras Inhóspitas"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackrock Mountain"] = "Montaña Roca Negra"
L["Blackwing Lair"] = "Guarida de Alanegra"
L["Blasted Lands"] = "Las Tierras Devastadas"
L["Bloodvenom Post"] = "Puesto del Veneno"
L["Blue"] = "Azul"
L["Boat to"] = "Barco a"
L["Booty Bay"] = "Bahía del Botín"
L["Brackenwall Village"] = "Poblado Murohelecho"
L["Burning Steppes"] = "Las Estepas Ardientes"
L["Camp Mojache"] = "Campamento Mojache"
L["Camp Taurajo"] = "Campamento Taurajo"
L["Cenarion Hold"] = "Fuerte Cenarion"
L["Central Mesa"] = "Meseta Central"
L["Chillwind Camp"] = "Campamento del Orvallo"
L["Class colored icons"] = "Iconos coloreados"
L["Classic"] = "Clásico"
L["Click to configure the settings for this option."] = "Haga clic para configurar los ajustes para esta opción."
L["Click to reset the position and scale of the map frame."] = "Haga clic para restablecer la posición y la escala del marco del mapa."
L["Click to reset the settings on this page."] = "Haga clic para restablecer la configuración en esta página."
L["Click to return to the main menu."] = "Haga clic para volver al menú principal."
L["Configuration Panel"] = "Panel de Configuración"
L["Cursor"] = "Cursor"
L["Darkshire"] = "Villa Oscura"
L["Darkshore"] = "Costa Oscura"
L["Darnassus"] = "Darnassus"
L["Deadwind Pass"] = "Paso de la Muerte"
L["Desolace"] = "Desolace"
L["Dire Maul (East)"] = "La Masacre (Este)"
L["Dire Maul (North)"] = "La Masacre (Norte)"
L["Dire Maul (West)"] = "La Masacre (Oeste)"
L["Disable reading emote when opening the map"] = "Deshabilita la lectura de emoticones al abrir el mapa"
L["Drag"] = "Arrastrar"
L["Drag to set the amount of blue."] = "Arrastra para establecer la cantidad de azul."
L["Drag to set the amount of green."] = "Arrastra para establecer la cantidad de verde."
L["Drag to set the amount of red."] = "Arrastra para establecer la cantidad de rojo."
L["Drag to set the battlefield map size."] = "Arrastra para establecer el tamaño del mapa del campo de batalla."
L["Drag to set the group icon size."] = "Arrastra para establecer el tamaño del icono de grupo."
L["Drag to set the map opacity for when your character is moving."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje se esté moviendo."
L["Drag to set the map opacity for when your character is stationary."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje esté estacionario."
L["Drag to set the opacity."] = "Arrastra para establecer la opacidad."
L["Drag to set the player arrow size."] = "Arrastra para establecer el tamaño de la flecha del jugador."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Arrastra para establecer el tamaño de la flecha del jugador.|n|nEl valor predeterminado de WoW Classic es 16.|nEl valor predeterminado de WoW Retail es 27."
L["Druid only flight point to Darnassus"] = "Punto de vuelo a Darnassus solo para druidas"
L["Druid only flight point to Thunder Bluff"] = "Punto de vuelo a Cima del Trueno solo para druidas"
L["Dun Morogh"] = "Dun Morogh"
L["Dungeon"] = "Mazmorra"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Dwarven District"] = "Distrito de los Enanos"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["Elements"] = "Visibilidad"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["Enhance battlefield map"] = "Mejorar el mapa del campo de batalla"
L["Enlarge player arrow"] = "Flecha de jugador"
L["Enter"] = "Entrar"
L["Everlook"] = "Vista Eterna"
L["Feathermoon Stronghold"] = "Bastión Plumaluna"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Fishing"] = "Pesca"
L["Flame Crest"] = "Peñasco Llamarada"
L["Freewind Post"] = "Poblado Viento Libre"
L["Gadgetzan"] = "Gadgetzan"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Verde"
L["Grom'gol Base Camp"] = "Campamento Grom'gol"
L["Group Icons"] = "Iconos de grupo"
L["Hammerfall"] = "Sentencia"
L["Hide town and city icons"] = "Pueblos y ciudades"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Icons"] = "Iconos"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Si está seleccionado, se mostrarán los puertos de los barcos, las torres de los zepelines y las estaciones de tren."
L["If checked, coordinates will be shown."] = "Si está seleccionado, se mostrarán las coordenadas."
L["If checked, dungeons and raids will be shown."] = "Si está seleccionado, se mostrarán mazmorras y bandas."
L["If checked, flight points will be shown."] = "Si está seleccionado, se mostrarán los puntos de vuelo."
L["If checked, group icons will use a modern, class-colored design."] = "Si está seleccionado, los iconos de grupo usarán un diseño moderno, de color de clase."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Si está seleccionado, al abrir el mapa se usará el mismo nivel de zoom desde la última vez que lo cerró, siempre que la zona del mapa no haya cambiado."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Si está seleccionado, apuntar al mapa mientras tu personaje se mueve hará que se aplique la configuración de opacidad estacionaria."
L["If checked, points of interest will be shown."] = "Si está seleccionado, se mostrarán puntos de interés."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Si está seleccionado, se usará el mapa predeterminado de pantalla completa.|n|nTenga en cuenta que habilitar esta opción bloqueará algunas de las otras opciones."
L["If checked, the map border will be removed."] = "Si está seleccionado, se eliminará el borde del mapa."
L["If checked, the map frame will remain open until you close it."] = "Si está seleccionado, el marco del mapa permanecerá abierto hasta que lo cierre."
L["If checked, the minimap button will be shown."] = "Si está seleccionado, se mostrará el botón del minimapa."
L["If checked, the minimum fishing skill levels will be shown."] = "Si está seleccionado, se mostrarán los niveles mínimos de habilidad de pesca."
L["If checked, town and city icons will not be shown on the continent maps."] = "Si está seleccionado, los iconos de pueblos y ciudades no se mostrarán en los mapas continentes."
L["If checked, unexplored areas of the map will be shown."] = "Si está seleccionado, se mostrarán áreas inexploradas del mapa."
L["If checked, unexplored areas will be tinted."] = "Si está seleccionado, las áreas inexploradas se teñirán."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Si está seleccionado, cuando tu personaje cambia de zona, el mapa cambiará automáticamente a la nueva zona."
L["If checked, you will be able to customise the battlefield map."] = "Si está seleccionado, podrás personalizar el mapa del campo de batalla."
L["If checked, you will be able to enlarge the player arrow."] = "Si está seleccionado, podrá ampliar la flecha del jugador."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "Si está seleccionado, podrá escalar y mover el mapa.|n|nEscale el mapa arrastrando el controlador de escala en la esquina inferior derecha.|n|nMueva el mapa arrastrando el borde y los bordes del marco."
L["If checked, you will be able to set the opacity of the map."] = "Si está seleccionado, podrá establecer la opacidad del mapa."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Si está seleccionado, se mostrarán los niveles de zona, mazmorra y habilidad de pesca."
L["Invalid command.  Enter /ltm help for help."] = "Comando inválido. Escribe / ltm help para obtener ayuda."
L["Invalid map ID."] = "ID de mapa inválido."
L["Ironforge"] = "Forjaz"
L["Kargath"] = "Kargath"
L["Lake Elune'ara"] = "Lago Elune'ara"
L["Lake Everstill"] = "Lago Sempiterno"
L["Large Scarab Coffer"] = "Arca del escarabajo grande"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: ¡VERSIÓN INCORRECTA INSTALADA!"
L["Light's Hope Chapel"] = "Capilla de la Esperanza de la Luz"
L["Loch Modan"] = "Loch Modan"
L["Lower Blackrock Spire"] = "Cumbre de Roca Negra Inferior"
L["Map frame scale"] = "Escala del marco del mapa"
L["Map Size"] = "Tamaño de mapa"
L["Maraudon"] = "Maraudon"
L["Marshal's Refuge"] = "Refugio de Marshal"
L["Mechanics"] = "Mecánicas"
L["Memory Usage"] = "Uso de memoria"
L["Menethil Harbor"] = "Puerto de Menethil"
L["Miscellaneous"] = "Miscelánea"
L["Molten Core"] = "Núcleo de Magma"
L["Moonglade"] = "Claro de la Luna"
L["More"] = "Más"
L["Morgan's Vigil"] = "Vigilia de Morgan"
L["Moving"] = "Movimiento"
L["Mulgore"] = "Mulgore"
L["Nethergarde Keep"] = "Castillo de Nethergarde"
L["Nighthaven"] = "Amparo de la Noche"
L["Nijel's Point"] = "Punta de Nijel"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "¡ATENCIÓN!|nDebes reiniciar completamente tu cliente de juego antes de poder usar esta versión de Leatrix Maps."
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["Opacity"] = "Opacidad"
L["or click the minimap button to open Leatrix Maps."] = "o haga clic en el botón de minimapa para abrir Leatrix Maps."
L["Orgrimmar"] = "Orgrimmar"
L["Player"] = "Jugador"
L["Player Arrow"] = "Flecha de jugador"
L["Portal"] = "Portal"
L["Preview"] = "Prevista"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Ratchet"] = "Trinquete"
L["Razorfen Downs"] = "Zahúrda Rajacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Red"] = "Rojo"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Refuge Pointe"] = "Refugio de la Zaga"
L["Reload"] = "Recargar"
L["Remember zoom level"] = "Recordar nivel de zoom"
L["Remove map border"] = "Borde del mapa"
L["Requires UI reload."] = "Requiere recargar la IU"
L["Reset"] = "Restablecer"
L["Reset Map Layout"] = "Restablecer el diseño del mapa"
L["Revantusk Village"] = "Poblado Sañadiente"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinas de Elune'eth"
L["Rut'theran Village"] = "Aldea Rut'theran"
L["Scale"] = "Escala"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "La Garganta de Fuego"
L["Sentinel Hill"] = "Colina del Centinela"
L["Set map opacity"] = "Opacidad del mapa"
L["Set map opacity while stationary and while moving."] = "Establece la opacidad del mapa mientras está parado y en movimiento."
L["Set the group icon size."] = "Establece el tamaño del icono de grupo."
L["Set the player arrow size."] = "Establece el tamaño de la flecha del jugador."
L["Settings"] = "Configuración"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shadowprey Village"] = "Aldea Cazasombras"
L["Show boats, zeppelins and trams"] = "Mostrar barcos, zepelines y trens"
L["Show coordinates"] = "Coordenadas"
L["Show dungeons and raids"] = "Mostrar mazmorras y bandas"
L["Show flight points"] = "Mostrar puntos de vuelo"
L["Show minimap button"] = "Botón del minimapa"
L["Show minimum fishing skill levels"] = "Mostrar niveles mínimos de habilidad de pesca"
L["Show points of interest"] = "Puntos de interés"
L["Show scale handle"] = "Mostrar asa de escala"
L["Show unexplored areas"] = "Áreas inexploradas"
L["Show zone levels"] = "Nivel de zona"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Bosque de Argénteos"
L["Southshore"] = "Costasur"
L["Splintertree Post"] = "Puesto del Hachazo"
L["Stationary"] = "Estacionario"
L["Sticky map frame"] = "Mapa pegajoso"
L["Stonard"] = "Rocal"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stonetalon Peak"] = "Cima del Espolón"
L["Stormwind"] = "Ventormenta"
L["Stranglethorn Vale"] = "Vega de Tuercespina"
L["Stratholme (Main Gate)"] = "Stratholme: Entrada Principal"
L["Stratholme (Service Gate)"] = "Stratholme: Entrada de Servicio"
L["Sun Rock Retreat"] = "Refugio Roca del Sol"
L["Swamp of Sorrows"] = "Pantanos de las Penas"
L["Talonbranch Glade"] = "Claro Ramaespolón"
L["Talrendis Point"] = "Punta Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Molino Tarren"
L["Teldrassil"] = "Teldrassil"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Thalanaar"] = "Thalanaar"
L["The Barrens"] = "Los Baldíos"
L["The Crossroads"] = "El Cruce"
L["The Deadmines"] = "Las Minas de la Muerte"
L["The Forgotten Coast"] = "La Costa Olvidada"
L["The Great Forge"] = "La Gran Fundición"
L["The Hinterlands"] = "Tierras del Interior"
L["The Sepulcher"] = "El Sepulcro"
L["The Stockade"] = "Las Mazmorras"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Isla Theramore"
L["Thorium Point"] = "Puesto del Torio"
L["Thousand Needles"] = "Las Mil Agujas"
L["Thunder Bluff"] = "Cima del Trueno"
L["Tinker Town"] = "Ciudad Manitas"
L["Tint unexplored areas"] = "Teñir áreas inexploradas"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["Trade District"] = "Distrito de Mercaderes"
L["Trade Quarter"] = "Barrio del Comercio"
L["Tram to"] = "Tren a"
L["Transparency"] = "Transparencia"
L["Uldaman"] = "Uldaman"
L["Undercity"] = "Entrañas"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Unlock map frame"] = "Desbloquear mapa"
L["Upper Blackrock Spire"] = "Cumbre de Roca Negra Superior"
L["Use default map"] = "Mapa predeterminado"
L["Use stationary opacity while pointing at map"] = "Usa opacidad estacionaria mientras apunta al mapa"
L["Valley of Strength"] = "El Valle de la Fuerza"
L["Version"] = "Versión"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Wetlands"] = "Los Humedales"
L["Winterspring"] = "Cuna del Invierno"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Su IU necesita ser recargada para que algunos de los cambios surtan efecto.|n|nNo tiene que hacer clic en el botón de recarga de inmediato, pero debe hacer clic en él cuando haya terminado de hacer cambios y desea que los cambios surtan efecto."
L["Your UI needs to be reloaded."] = "La IU necesita ser recargada."
L["Zeppelin to"] = "Zepelín a"
L["Zoram'gar Outpost"] = "Ensenada de Zoram'gar"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- frFR: French
if GameLocale == "frFR" then
L["/ltm help - Show this information."] = "/ltm help - Affiche ces informations."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Réinitialise la position du panneau."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Effacez tous les paramètres et rechargez."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Une erreur d'arrêt s'est produite mais ne vous inquiétez pas. Cela peut arriver de temps en temps. Cliquez sur le bouton de rechargement pour le résoudre."
L["Aerie Peak"] = "Nid-de-l'Aigle"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alpha"] = "Alpha"
L["Alterac Mountains"] = "Montagnes d'Alterac"
L["Arathi Highlands"] = "Hautes-terres d'Arathi"
L["Ashenvale"] = "Orneval"
L["Astranaar"] = "Astranaar"
L["Auberdine"] = "Auberdine"
L["Auto change zones"] = "Changer les zones"
L["Azshara"] = "Azshara"
L["Back to Main Menu"] = "Retour au menu principal"
L["Badlands"] = "Terres ingrates"
L["Blackfathom Deeps"] = "Profondeurs de Brassenoire"
L["Blackrock Depths"] = "Profondeurs de Blackrock"
L["Blackrock Mountain"] = "Mont Blackrock"
L["Blackwing Lair"] = "Repaire de l'Aile noire"
L["Blasted Lands"] = "Terres foudroyées"
L["Bloodvenom Post"] = "Poste de la Vénéneuse"
L["Blue"] = "Bleu"
L["Boat to"] = "Bateau à"
L["Booty Bay"] = "Baie-du-Butin"
L["Brackenwall Village"] = "Mur-de-Fougères"
L["Burning Steppes"] = "Steppes ardentes"
L["Camp Mojache"] = "Camp Mojache"
L["Camp Taurajo"] = "Camp Taurajo"
L["Cenarion Hold"] = "Fort Cénarien"
L["Central Mesa"] = "Mesa centrale"
L["Chillwind Camp"] = "Camp du Noroît"
L["Class colored icons"] = "Icônes colorées"
L["Classic"] = "Classique"
L["Click to configure the settings for this option."] = "Cliquez pour configurer les paramètres de cette option."
L["Click to reset the position and scale of the map frame."] = "Cliquez pour réinitialiser la position et l'échelle du cadre de la carte."
L["Click to reset the settings on this page."] = "Cliquez pour réinitialiser les paramètres de cette page."
L["Click to return to the main menu."] = "Cliquez pour revenir au menu principal."
L["Configuration Panel"] = "Panneau de configuration"
L["Cursor"] = "Curseur"
L["Darkshire"] = "Darkshire"
L["Darkshore"] = "Sombrivage"
L["Darnassus"] = "Darnassus"
L["Deadwind Pass"] = "Défilé de Deuillevent"
L["Desolace"] = "Désolace"
L["Dire Maul (East)"] = "Hache-tripes (Est)"
L["Dire Maul (North)"] = "Hache-tripes (Nord)"
L["Dire Maul (West)"] = "Hache-tripes (Ouest)"
L["Disable reading emote when opening the map"] = "Désactiver l'emote lors de l'ouverture de la carte"
L["Drag"] = "Faites glisser"
L["Drag to set the amount of blue."] = "Faites glisser pour définir la quantité de bleu."
L["Drag to set the amount of green."] = "Faites glisser pour définir la quantité de vert."
L["Drag to set the amount of red."] = "Faites glisser pour définir la quantité de rouge."
L["Drag to set the battlefield map size."] = "Faites glisser pour définir la taille de la carte du champ de bataille."
L["Drag to set the group icon size."] = "Faites glisser pour définir la taille de l'icône du groupe."
L["Drag to set the map opacity for when your character is moving."] = "Faites glisser pour définir l'opacité de la carte lorsque votre personnage se déplace."
L["Drag to set the map opacity for when your character is stationary."] = "Faites glisser pour définir l'opacité de la carte lorsque votre personnage est à l'arrêt."
L["Drag to set the opacity."] = "Faites glisser pour définir l'opacité."
L["Drag to set the player arrow size."] = "Faites glisser pour définir la taille de la flèche du lecteur."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Faites glisser pour définir la taille de la flèche du lecteur.|n|nLa valeur par défaut de Wow Classic est 16.|nLa valeur par défaut de Wow Retail est 27."
L["Druid only flight point to Darnassus"] = "Point de vol réservé aux druides vers Darnassus"
L["Druid only flight point to Thunder Bluff"] = "Point de vol réservé aux druides vers Thunder Bluff"
L["Dun Morogh"] = "Dun Morogh"
L["Dungeon"] = "Donjon"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bois de la Pénombre"
L["Dustwallow Marsh"] = "Marécage d'Âprefange"
L["Dwarven District"] = "Quartier des Nains"
L["Eastern Plaguelands"] = "Maleterres de l'est"
L["Elements"] = "Visibilité"
L["Elwynn Forest"] = "Forêt d'Elwynn"
L["Enhance battlefield map"] = "Améliorer la carte du champ de bataille"
L["Enlarge player arrow"] = "Flèche du joueur"
L["Enter"] = "Entrer"
L["Everlook"] = "Long-guet"
L["Feathermoon Stronghold"] = "Bastion de Feathermoon"
L["Felwood"] = "Gangrebois"
L["Feralas"] = "Féralas"
L["Fishing"] = "Pêche"
L["Flame Crest"] = "Corniche des Flammes"
L["Freewind Post"] = "Poste de Librevent"
L["Gadgetzan"] = "Gadgetzan"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Vert"
L["Grom'gol Base Camp"] = "Campement Grom'Gol"
L["Group Icons"] = "Icônes de groupe"
L["Hammerfall"] = "Trépas-d'Orgrim"
L["Hide town and city icons"] = "Villes et cités"
L["Hillsbrad Foothills"] = "Contreforts d'Hillsbrad"
L["Icons"] = "Icônes"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Si cette option est cochée, les ports pour bateaux, les tours zeppelin et les stations de tram seront affichés."
L["If checked, coordinates will be shown."] = "Si cette option est cochée, les coordonnées seront affichées."
L["If checked, dungeons and raids will be shown."] = "Si cette option est cochée, les donjons et les raids seront affichés."
L["If checked, flight points will be shown."] = "Si cette option est cochée, les points de vol seront affichés."
L["If checked, group icons will use a modern, class-colored design."] = "Si cette option est cochée, les icônes de groupe utiliseront un design moderne de couleur de classe."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Si cette option est cochée, l'ouverture de la carte utilisera le même niveau de zoom que lors de sa dernière fermeture tant que la zone de la carte n'a pas changé."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Si cette option est cochée, le fait de pointer la carte pendant le déplacement de votre personnage entraînera l'application du paramètre d'opacité stationnaire."
L["If checked, points of interest will be shown."] = "Si cette option est cochée, les points d'intérêt seront affichés."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Si cette option est cochée, la carte plein écran par défaut sera utilisée.|n|nNotez que l'activation de cette option bloquera certaines des autres options."
L["If checked, the map border will be removed."] = "Si cette option est cochée, la bordure de la carte sera supprimée."
L["If checked, the map frame will remain open until you close it."] = "Si cette option est cochée, le cadre de la carte restera ouvert jusqu'à ce que vous le fermiez."
L["If checked, the minimap button will be shown."] = "Si cette option est cochée, le bouton de la mini-carte sera affiché."
L["If checked, the minimum fishing skill levels will be shown."] = "Si cette option est cochée, les niveaux de compétence de pêche minimum seront affichés."
L["If checked, town and city icons will not be shown on the continent maps."] = "Si cette option est cochée, les icônes de ville et de cité ne seront pas affichées sur les cartes du continent."
L["If checked, unexplored areas of the map will be shown."] = "Si cette option est cochée, les zones inexplorées de la carte seront affichées."
L["If checked, unexplored areas will be tinted."] = "Si cette option est cochée, les zones inexplorées seront teintées."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Si cette option est cochée, lorsque votre personnage change de zone, la carte passe automatiquement à la nouvelle zone."
L["If checked, you will be able to customise the battlefield map."] = "Si cette option est cochée, vous pourrez personnaliser la carte du champ de bataille."
L["If checked, you will be able to enlarge the player arrow."] = "Si cette option est cochée, vous pourrez agrandir la flèche du joueur."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "Si cette option est cochée, vous pourrez redimensionner et déplacer la carte.|n|nMettez la carte à l'échelle en traîner la poignée d'échelle dans le coin inférieur droit.|n|nDéplacez la carte en traîner la bordure et les bords du cadre."
L["If checked, you will be able to set the opacity of the map."] = "Si cette option est cochée, vous pourrez définir l'opacité de la carte."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Si cette option est cochée, les niveaux de compétence de zone, de donjon et de pêche seront affichés."
L["Invalid command.  Enter /ltm help for help."] = "Commande non valide. Entrez /ltm help pour obtenir de l'aide."
L["Invalid map ID."] = "ID de carte non valide."
L["Ironforge"] = "Ironforge"
L["Kargath"] = "Kargath"
L["Lake Elune'ara"] = "Lac Elune'ara"
L["Lake Everstill"] = "Lac Placide"
L["Large Scarab Coffer"] = "Grand coffre de scarabées"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS : UNE VERSION INCORRECTE EST INSTALLÉE !"
L["Light's Hope Chapel"] = "Chapelle de l'Espoir de Lumière"
L["Loch Modan"] = "Loch Modan"
L["Lower Blackrock Spire"] = "Pic Blackrock Inférieur"
L["Map frame scale"] = "Échelle du cadre de la carte"
L["Map Size"] = "Taille de la carte"
L["Maraudon"] = "Maraudon"
L["Marshal's Refuge"] = "Refuge des Marshal"
L["Mechanics"] = "Mécanique"
L["Memory Usage"] = "Utilisation de la mémoire"
L["Menethil Harbor"] = "Port de Menethil"
L["Miscellaneous"] = "Divers"
L["Molten Core"] = "Cœur du Magma"
L["Moonglade"] = "Reflet-de-Lune"
L["More"] = "Plus"
L["Morgan's Vigil"] = "Veille de Morgan"
L["Moving"] = "En mouvement"
L["Mulgore"] = "Mulgore"
L["Nethergarde Keep"] = "Rempart-du-Néant"
L["Nighthaven"] = "Havrenuit"
L["Nijel's Point"] = "Combe de Nijel"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "AVIS!|nVous devez redémarrer complètement votre client de jeu avant de pouvoir utiliser cette version de Leatrix Maps."
L["Onyxia's Lair"] = "Repaire d'Onyxia"
L["Opacity"] = "Opacité"
L["or click the minimap button to open Leatrix Maps."] = "ou cliquez sur le bouton de la mini-carte pour ouvrir Leatrix Maps."
L["Orgrimmar"] = "Orgrimmar"
L["Player"] = "Joueur"
L["Player Arrow"] = "Flèche du joueur"
L["Portal"] = "Portail"
L["Preview"] = "Voir en avant-première"
L["Ragefire Chasm"] = "Gouffre de Ragefeu"
L["Raid"] = "Raid"
L["Ratchet"] = "Ratchet"
L["Razorfen Downs"] = "Souilles de Tranchebauge"
L["Razorfen Kraul"] = "Kraal de Tranchebauge"
L["Red"] = "Rouge"
L["Redridge Mountains"] = "Les Carmines"
L["Refuge Pointe"] = "Refuge de l'Ornière"
L["Reload"] = "Recharger"
L["Remember zoom level"] = "Niveau de zoom"
L["Remove map border"] = "Bordure de la carte"
L["Requires UI reload."] = "Nécessite le rechargement de l'interface utilisateur."
L["Reset"] = "Réinitialiser"
L["Reset Map Layout"] = "Réinitialiser la disposition de la carte"
L["Revantusk Village"] = "Village des Revantusk"
L["Ruins of Ahn'Qiraj"] = "Ruines d'Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruines d’Elune’eth"
L["Rut'theran Village"] = "Village de Rut'theran"
L["Scale"] = "Échelle"
L["Scarlet Monastery"] = "Monastère écarlate"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "Gorge des Vents brûlants"
L["Sentinel Hill"] = "Colline des Sentinelles"
L["Set map opacity"] = "Opacité de la carte"
L["Set map opacity while stationary and while moving."] = "Définissez l'opacité de la carte à l'arrêt et en mouvement."
L["Set the group icon size."] = "Définissez la taille de l'icône du groupe."
L["Set the player arrow size."] = "Définissez la taille de la flèche du lecteur."
L["Settings"] = "Paramètres"
L["Shadowfang Keep"] = "Donjon d'Ombrecroc"
L["Shadowprey Village"] = "Proie-de-l'Ombre"
L["Show boats, zeppelins and trams"] = "Afficher les bateaux, les zeppelins et les trams"
L["Show coordinates"] = "Coordonnées"
L["Show dungeons and raids"] = "Afficher les donjons et les raids"
L["Show flight points"] = "Afficher les points de vol"
L["Show minimap button"] = "Bouton de la mini-carte"
L["Show minimum fishing skill levels"] = "Afficher les niveaux de compétence de pêche minimum"
L["Show points of interest"] = "Points d'intérêt"
L["Show scale handle"] = [=[Afficher la poignée de l'échelle

]=]
L["Show unexplored areas"] = "Zones inexplorées"
L["Show zone levels"] = "Niveaux de zone"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Forêt des Pins argentés"
L["Southshore"] = "Southshore"
L["Splintertree Post"] = "Poste de Bois-brisé"
L["Stationary"] = "Stationnaire"
L["Sticky map frame"] = "Carte collante"
L["Stonard"] = "Stonard"
L["Stonetalon Mountains"] = "Les Serres-Rocheuses"
L["Stonetalon Peak"] = "Pic des Serres-Rocheuses"
L["Stormwind"] = "Stormwind"
L["Stranglethorn Vale"] = "Vallée de Strangleronce"
L["Stratholme (Main Gate)"] = "Stratholme (Porte Principale)"
L["Stratholme (Service Gate)"] = "Stratholme (Porte de Service)"
L["Sun Rock Retreat"] = "Retraite de Roche-Soleil"
L["Swamp of Sorrows"] = "Marais des Chagrins"
L["Talonbranch Glade"] = "Clairière de Griffebranche"
L["Talrendis Point"] = "Halte de Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Moulin-de-Tarren"
L["Teldrassil"] = "Teldrassil"
L["Temple of Ahn'Qiraj"] = "Temple d'Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Le temple d'Atal'Hakkar"
L["Thalanaar"] = "Thalanaar"
L["The Barrens"] = "Les Tarides"
L["The Crossroads"] = "La Croisée"
L["The Deadmines"] = "Les Mortemines"
L["The Forgotten Coast"] = "La Côte oubliée"
L["The Great Forge"] = "La Grande Forge"
L["The Hinterlands"] = "Les Hinterlands"
L["The Sepulcher"] = "Le Sépulcre"
L["The Stockade"] = "La Prison"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Ile de Theramore"
L["Thorium Point"] = "Halte du Thorium"
L["Thousand Needles"] = "Mille pointes"
L["Thunder Bluff"] = "Thunder Bluff"
L["Tinker Town"] = "Brikabrok"
L["Tint unexplored areas"] = "Teinter des zones inexplorées"
L["Tirisfal Glades"] = "Clairières de Tirisfal"
L["Trade District"] = "Quartier Commercant"
L["Trade Quarter"] = "Quartier des Marchands"
L["Tram to"] = "Tram à"
L["Transparency"] = "Transparence"
L["Uldaman"] = "Uldaman"
L["Undercity"] = "Undercity"
L["Un'Goro Crater"] = "Cratère d'Un'Goro"
L["Unlock map frame"] = "Déverrouiller la carte"
L["Upper Blackrock Spire"] = "Pic Blackrock Supérieur"
L["Use default map"] = "Carte par défaut"
L["Use stationary opacity while pointing at map"] = "Utilisez l'opacité stationnaire tout en pointant sur la carte"
L["Valley of Strength"] = "Vallée de la Force"
L["Version"] = "Version"
L["Wailing Caverns"] = "Cavernes des lamentations"
L["Western Plaguelands"] = "Maleterres de l'ouest"
L["Westfall"] = "Marche de l'Ouest"
L["Wetlands"] = "Les Paluns"
L["Winterspring"] = "Berceau-de-l'Hiver"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Votre interface utilisateur doit être rechargée pour que certaines des modifications prennent effet.|n|nVous n'avez pas besoin de cliquer immédiatement sur le bouton de rechargement, mais vous devez le cliquer lorsque vous avez terminé d'apporter des modifications et que vous souhaitez que les modifications prennent effet."
L["Your UI needs to be reloaded."] = "Votre interface utilisateur doit être rechargée."
L["Zeppelin to"] = "Zeppelin à"
L["Zoram'gar Outpost"] = "L’Avant-poste de Zoram'gar"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- itIT: Italian
if GameLocale == "itIT" then

end

-- ptBR: Portugese (Brazil)
if GameLocale == "ptBR" then
L["/ltm help - Show this information."] = "/ltm help - Mostra essas informações."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Redefine a posição do painel."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Limpe todas as configurações e recarregue."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Ocorreu um erro de parada, mas não precisa se preocupar. Isso pode acontecer de tempos em tempos. Clique no botão recarregar para resolvê-lo."
L["Aerie Peak"] = "Ninho da Águia"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alpha"] = "Alfa"
L["Alterac Mountains"] = "Montanhas de Alterac"
L["Arathi Highlands"] = "Planalto Arathi"
L["Ashenvale"] = "Vale Gris"
L["Astranaar"] = "Astranaar"
L["Auberdine"] = "Auberdine"
L["Auto change zones"] = "Alterar zonas"
L["Azshara"] = "Azshara"
L["Back to Main Menu"] = "Voltar ao menu principal"
L["Badlands"] = "Ermos"
L["Blackfathom Deeps"] = "Profundezas Negras"
L["Blackrock Depths"] = "Abismo Rocha Negra"
L["Blackrock Mountain"] = "Montanha Rocha Negra"
L["Blackwing Lair"] = "Covil Asa Negra"
L["Blasted Lands"] = "Barreira do Inferno"
L["Bloodvenom Post"] = "Posto Peçonha"
L["Blue"] = "Azul"
L["Boat to"] = "Barco para"
L["Booty Bay"] = "Angra do Butim"
L["Brackenwall Village"] = "Aldeia Muralha Verde"
L["Burning Steppes"] = "Estepes Ardentes"
L["Camp Mojache"] = "Aldeia Mojache"
L["Camp Taurajo"] = "Acampamento Taurajo"
L["Cenarion Hold"] = "Forte Cenariano"
L["Central Mesa"] = "Mesa Central"
L["Chillwind Camp"] = "Acampamento Ventogelante"
L["Class colored icons"] = "Ícones coloridos"
L["Classic"] = "Clássico"
L["Click to configure the settings for this option."] = "Clique para definir as configurações para esta opção."
L["Click to reset the position and scale of the map frame."] = "Clique para redefinir a posição e a escala do quadro do mapa."
L["Click to reset the settings on this page."] = "Clique para redefinir as configurações nesta página."
L["Click to return to the main menu."] = "Clique para retornar ao menu principal."
L["Configuration Panel"] = "Painel de Configuração"
L["Cursor"] = "Cursor"
L["Darkshire"] = "Vila Sombria"
L["Darkshore"] = "Costa Negra"
L["Darnassus"] = "Darnassus"
L["Deadwind Pass"] = "Trilha do Vento Morto"
L["Desolace"] = "Desolação"
L["Dire Maul (East)"] = "Gládio Cruel (Leste)"
L["Dire Maul (North)"] = "Gládio Cruel (Norte)"
L["Dire Maul (West)"] = "Gládio Cruel (Oeste)"
L["Disable reading emote when opening the map"] = "Desabilitar a leitura de emote ao abrir o mapa"
L["Drag"] = "Arrastrar"
L["Drag to set the amount of blue."] = "Arraste para definir a quantidade de azul."
L["Drag to set the amount of green."] = "Arraste para definir a quantidade de verde."
L["Drag to set the amount of red."] = "Arraste para definir a quantidade de vermelho."
L["Drag to set the battlefield map size."] = "Arraste para definir o tamanho do mapa do campo de batalha."
L["Drag to set the group icon size."] = "Arraste para definir o tamanho do ícone do grupo."
L["Drag to set the map opacity for when your character is moving."] = "Arraste para definir a opacidade do mapa para quando seu personagem estiver em movimento."
L["Drag to set the map opacity for when your character is stationary."] = "Arraste para definir a opacidade do mapa quando seu personagem estiver parado."
L["Drag to set the opacity."] = [=[Arraste para definir a opacidade.
]=]
L["Drag to set the player arrow size."] = "Arrasta para definir o tamanho da seta do jogador."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Arraste para definir o tamanho da flecha do jogador.|n|nO WoW clássico do Wow é 16.|nO WoW Retail é 27."
L["Druid only flight point to Darnassus"] = "Druida apenas ponto de voo para Darnassus"
L["Druid only flight point to Thunder Bluff"] = "Druida apenas ponto de voo para Penhasco do Trovão"
L["Dun Morogh"] = "Dun Morogh"
L["Dungeon"] = "Masmorra"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Floresta do Crepúsculo"
L["Dustwallow Marsh"] = "Pântano Vadeoso"
L["Dwarven District"] = "Distrito dos Anões"
L["Eastern Plaguelands"] = "Terras Pestilentas Orientais"
L["Elements"] = "Visibilidade"
L["Elwynn Forest"] = "Floresta de Elwynn"
L["Enhance battlefield map"] = "Melhorar o mapa do campo de batalha"
L["Enlarge player arrow"] = "Flecha do jogador"
L["Enter"] = "Entrar"
L["Everlook"] = "Visteterna"
L["Feathermoon Stronghold"] = "Domínio de Plumaluna"
L["Felwood"] = "Selva Maleva"
L["Feralas"] = "Feralas"
L["Fishing"] = "Pesca"
L["Flame Crest"] = "Monte Candente"
L["Freewind Post"] = "Aldeia Vento Livre"
L["Gadgetzan"] = "Geringontzan"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Verde"
L["Grom'gol Base Camp"] = "Acampamento Grom'gol"
L["Group Icons"] = "Ícones de grupo"
L["Hammerfall"] = "Ruína do Martelo"
L["Hide town and city icons"] = "Vilas e cidades"
L["Hillsbrad Foothills"] = "Contraforte de Eira dos Montes"
L["Icons"] = "Ícones"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Se marcado, serão exibidos portos de barcos, torres zepelin e estações de metrô."
L["If checked, coordinates will be shown."] = "Se marcado, as coordenadas serão mostradas."
L["If checked, dungeons and raids will be shown."] = "Se marcado, masmorras e raides serão mostrados."
L["If checked, flight points will be shown."] = "Se marcado, os pontos de voo serão mostrados."
L["If checked, group icons will use a modern, class-colored design."] = "Se marcado, os ícones de grupo usarão um design moderno e colorido em classe."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Se marcado, a abertura do mapa usará o mesmo nível de zoom desde a última vez que você o fechou, desde que a zona do mapa não tenha sido alterada."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Se marcado, apontar para o mapa enquanto seu personagem estiver em movimento fará com que a configuração de opacidade estacionária seja aplicada."
L["If checked, points of interest will be shown."] = "Se marcado, os pontos de interesse serão mostrados."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will lock out some of the other options."] = "Se marcado, o mapa padrão em tela cheia será usado.|n|nObserve que ativar essa opção bloqueará algumas das outras opções."
L["If checked, the map border will be removed."] = "Se marcado, a borda do mapa será removida."
L["If checked, the map frame will remain open until you close it."] = "Se marcado, o quadro do mapa permanecerá aberto até você fechá-lo."
L["If checked, the minimap button will be shown."] = "Se marcado, o botão minimapa será mostrado."
L["If checked, the minimum fishing skill levels will be shown."] = "Se marcado, os níveis mínimos de habilidade de pesca serão mostrados."
L["If checked, town and city icons will not be shown on the continent maps."] = "Se marcado, os ícones de vila e cidade não serão mostrados nos mapas do continente."
L["If checked, unexplored areas of the map will be shown."] = "Se marcado, áreas inexploradas do mapa serão mostradas."
L["If checked, unexplored areas will be tinted."] = "Se marcada, áreas inexploradas serão matizadas."
L["If checked, when your character changes zones, the map will automatically change to the new zone."] = "Se marcado, quando seu personagem muda de zona, o mapa muda automaticamente para a nova zona."
L["If checked, you will be able to customise the battlefield map."] = "Se marcado, você poderá personalizar o mapa do campo de batalha."
L["If checked, you will be able to enlarge the player arrow."] = "Se marcado, você poderá ampliar a flecha do jogador."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges."] = "Se marcado, você poderá dimensionar e mover o mapa.|n|nDimensione o mapa arrastando a alça da escala no canto inferior direito.|n|nMova o mapa arrastando as bordas da borda e do quadro."
L["If checked, you will be able to set the opacity of the map."] = "Se marcado, você poderá definir a opacidade do mapa."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Se marcado, os níveis de zona, masmorra e habilidade de pesca serão mostrados."
L["Invalid command.  Enter /ltm help for help."] = "Comando inválido. Digite /ltm help para obter ajuda."
L["Invalid map ID."] = "ID de mapa inválido."
L["Ironforge"] = "Altaforja"
L["Kargath"] = "Karrath"
L["Lake Elune'ara"] = "Lago Eluna'ara"
L["Lake Everstill"] = "Lago Plácido"
L["Large Scarab Coffer"] = "Grande Arca do Escaravelho"
L["LEATRIX MAPS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: VERSÃO ERRADA INSTALADA!"
L["Light's Hope Chapel"] = "Capela Esperança da Luz"
L["Loch Modan"] = "Loch Modan"
L["Lower Blackrock Spire"] = "Pico da Rocha Negra Inferior"
L["Map frame scale"] = "Escala de quadro do mapa"
L["Map Size"] = "Tamanho do mapa"
L["Maraudon"] = "Maraudon"
L["Marshal's Refuge"] = "Refúgio do Marshal"
L["Mechanics"] = "Mecânico"
L["Memory Usage"] = "Uso de memória"
L["Menethil Harbor"] = "Porto de Menethil"
L["Miscellaneous"] = "Diversos"
L["Molten Core"] = "Núcleo Derretido"
L["Moonglade"] = "Clareira da Lua"
L["More"] = "Mais"
L["Morgan's Vigil"] = "Vigia de Morgan"
L["Moving"] = "Movendo"
L["Mulgore"] = "Mulgore"
L["Nethergarde Keep"] = "Bastilha de Etergarde"
L["Nighthaven"] = "Refúgio Noturno"
L["Nijel's Point"] = "Posto do Nijel"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "AVISO PRÉVIO!|nVocê deve reiniciar completamente o cliente do jogo antes de poder usar esta versão do Leatrix Maps."
L["Onyxia's Lair"] = "Covil da Onyxia"
L["Opacity"] = "Opacidade"
L["or click the minimap button to open Leatrix Maps."] = "ou clique no botão minimapa para abrir o Leatrix Maps."
L["Orgrimmar"] = "Orgrimmar"
L["Player"] = "Jogador"
L["Player Arrow"] = "Flecha do Jogador"
L["Portal"] = "Portal"
L["Preview"] = "Pré-visualização"
L["Ragefire Chasm"] = "Cavernas Ígneas"
L["Raid"] = "Raide"
L["Ratchet"] = "Vila Catraca"
L["Razorfen Downs"] = "Urzal dos Mortos"
L["Razorfen Kraul"] = "Urzal dos Tuscos"
L["Red"] = "Vermelho"
L["Redridge Mountains"] = "Montanhas Cristarrubra"
L["Refuge Pointe"] = "Ponta do Refúgio"
L["Reload"] = "Recarregar"
L["Remember zoom level"] = "Nível de zoom"
L["Remove map border"] = "Borda do mapa"
L["Requires UI reload."] = "Requer atualização da interface do usuário."
L["Reset"] = "Redefinir"
L["Reset Map Layout"] = "Redefinir disposição do mapa"
L["Revantusk Village"] = "Aldeia Revatusco"
L["Ruins of Ahn'Qiraj"] = "Ruínas de Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruínas de Elune'eth"
L["Rut'theran Village"] = "Vila de Rut'theran"
L["Scale"] = "Escala"
L["Scarlet Monastery"] = "Monastério Escarlate"
L["Scholomance"] = "Scolomântia"
L["Searing Gorge"] = "Garganta Abrasadora"
L["Sentinel Hill"] = "Morro da Sentinela"
L["Set map opacity"] = "Opacidade do mapa"
L["Set map opacity while stationary and while moving."] = [=[Defina a opacidade do mapa enquanto estiver parado e em movimento.

]=]
L["Set the group icon size."] = "Defina o tamanho do ícone do grupo."
L["Set the player arrow size."] = "Defina o tamanho da flecha do jogador."
L["Settings"] = "Configurações"
L["Shadowfang Keep"] = "Bastilha da Presa Negra"
L["Shadowprey Village"] = "Aldeia Pescassombra"
L["Show boats, zeppelins and trams"] = "Mostrar barcos, zepelins e metrô"
L["Show coordinates"] = "Coordenadas"
L["Show dungeons and raids"] = "Mostrar masmorras e raides"
L["Show flight points"] = "Pontos de voo"
L["Show minimap button"] = "Botão minimapa"
L["Show minimum fishing skill levels"] = "Mostrar níveis mínimos de habilidade de pesca"
L["Show points of interest"] = "Pontos de interesse"
L["Show scale handle"] = "Mostrar alça de escala"
L["Show unexplored areas"] = "Áreas inexploradas"
L["Show zone levels"] = "Níveis da zona"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Floresta de Pinhaprata"
L["Southshore"] = "Costa Sul"
L["Splintertree Post"] = "Posto Machadada"
L["Stationary"] = "Estacionário"
L["Sticky map frame"] = "Mapa pegajoso"
L["Stonard"] = "Pedregal"
L["Stonetalon Mountains"] = "Cordilheira das Torres de Pedra"
L["Stonetalon Peak"] = "Morro das Torres de Pedra"
L["Stormwind"] = "Ventobravo"
L["Stranglethorn Vale"] = "Selva do Espinhaço"
L["Stratholme (Main Gate)"] = "Stratholme (Portão Principal)"
L["Stratholme (Service Gate)"] = "Stratholme (Portão de Serviço)"
L["Sun Rock Retreat"] = "Retiro Rocha do Sol"
L["Swamp of Sorrows"] = "Pântano das Mágoas"
L["Talonbranch Glade"] = "Clareira da Galhaça"
L["Talrendis Point"] = "Campo Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Serraria Tarren"
L["Teldrassil"] = "Teldrassil"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Thalanaar"] = "Thalanaar"
L["The Barrens"] = "Sertões"
L["The Crossroads"] = "A Encruzilhada"
L["The Deadmines"] = "Minas Mortas"
L["The Forgotten Coast"] = "Costa Esquecida"
L["The Great Forge"] = "A Grande Forja"
L["The Hinterlands"] = "Terras Agrestes"
L["The Sepulcher"] = "O Sepulcro"
L["The Stockade"] = "O Cárcere"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Ilha Theramore"
L["Thorium Point"] = "Posto de Tório"
L["Thousand Needles"] = "Mil Agulhas"
L["Thunder Bluff"] = "Penhasco do Trovão"
L["Tinker Town"] = "Beco da Gambiarra"
L["Tint unexplored areas"] = "Matizar áreas inexploradas"
L["Tirisfal Glades"] = "Clareiras de Tirisfal"
L["Trade District"] = "Distrito Comercial"
L["Trade Quarter"] = "Centro Comercial"
L["Tram to"] = "Metrô para"
L["Transparency"] = "Transparência"
L["Uldaman"] = "Uldaman"
L["Undercity"] = "Cidade Baixa"
L["Un'Goro Crater"] = "Cratera Un'Goro"
L["Unlock map frame"] = "Desbloquear mapa"
L["Upper Blackrock Spire"] = "Pico da Rocha Negra Superior"
L["Use default map"] = "Mapa predefinição"
L["Use stationary opacity while pointing at map"] = "Use opacidade estacionária enquanto aponta para o mapa"
L["Valley of Strength"] = "Vale da Força"
L["Version"] = "Versão"
L["Wailing Caverns"] = "Caverna Ululante"
L["Western Plaguelands"] = "Terras Pestilentas Ocidentais"
L["Westfall"] = "Cerro Oeste"
L["Wetlands"] = "Pantanal"
L["Winterspring"] = "Hibérnia"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Sua interface do usuário precisa ser recarregada para que algumas alterações entrem em vigor.|n|nVocê não precisa clicar no botão recarregar imediatamente, mas precisa clicar nele quando concluir as alterações e desejar que as alterações entrem em vigor."
L["Your UI needs to be reloaded."] = "Sua interface do usuário precisa ser recarregada."
L["Zeppelin to"] = "Zepelin para"
L["Zoram'gar Outpost"] = "Assentamento Zoram'gar"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end
