﻿zzhuntar = LibStub("AceAddon-3.0"):NewAddon("zzhuntar", "AceConsole-3.0", "AceEvent-3.0", "AceComm-3.0")

local AceConfig = LibStub("AceConfig-3.0");
local AceCongigDialog = LibStub("AceConfigDialog-3.0");

local zzhuntar_version = "2.8.4";

local zzhuntar_Tracking = "0";

local L = LibStub("AceLocale-3.0"):GetLocale("zzhuntar")

zzhuntar_specialinstances = {
	["Icecrown Citadel"] = true,
}

zzhuntar.defaults = {
        char = {
                handle = {
				["AddonEnabled"] = true,
                		["PvPEnable"] = false,
				["prevTrack"] = "1",
				["Debug"] = "0",	
    		       },
		  },
}

zzhuntar_Options = {
	name = L["zzhuntar_config"],
	handler = zzhuntar,
	type = 'group',
	args = {
		General = {
			order = 1,
			type = "group",
			name = L["zzhuntar_general"],
			desc = L["zzhuntar_generalsettings"],
			args = {
				AddonEnabled = {
					type = "toggle",
					order = 1,
					name = L["zzhuntar_addonenabled_name"],
					desc = L["zzhuntar_addonenabled_desc"],
					get = function(info) return zzhuntar.db.char.handle["AddonEnabled"] end,
					set = function(info,input) zzhuntar.db.char.handle["AddonEnabled"] = input end,
				},
				PvPEnable = {
					type = "toggle",
					order = 2,
					name = L["zzhuntar_enablepvp_name"],
					desc = L["zzhuntar_enablepvp_desc"],
					get = function(info) return zzhuntar.db.char.handle["PvPEnable"] end,
					set = function(info,input) zzhuntar.db.char.handle["PvPEnable"] = input end,
				},
			},
		},
	},
}

function zzhuntar:OnInitialize()
    -- Called when the addon is loaded
    AceConfig:RegisterOptionsTable("zzhuntarConf", zzhuntar_Options, nil)
    self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("zzhuntarConf", "Zug Zug Huntar")

    self.db = LibStub("AceDB-3.0"):New("zzhuntarDB", zzhuntar.defaults)
    db = self.db.char
    LibStub("AceComm-3.0"):Embed(self)

end

function zzhuntar:OnEnable()
	-- Called when the addon is enabled
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("PLAYER_TARGET_CHANGED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("UNIT_AURA")
	self:RegisterChatCommand("zzhuntar", "SlashCmd")
	self:Print("ZugZug Huntar v"..zzhuntar_version.." by Darool (House of Cards @ Quel'Thalas)")
end

function zzhuntar:PLAYER_REGEN_ENABLED()
	-- Out of combat
	if self:CheckCombat() == "0" then
		self:DebugMSG("Out of combat")
		if zzhuntar_Tracking == "1" then
			self:DebugMSG("zzhuntar_Tracking == "..zzhuntar_Tracking)
			prevTrack = zzhuntar.db.char.handle["prevTrack"]
			self:DebugMSG("db Prev Tracking: "..prevTrack)

			-- If prevTracking is 0 then it should be nil
			if prevTrack == "0" then
				prevTrack = nil
			end

			SetTracking(prevTrack)
			if (self:CheckActiveTrack(prevTrack)) then
				zzhuntar_Tracking = "0"
			end
			self:DebugMSG("zzhuntar_Tracking == "..zzhuntar_Tracking)
		end
	end
end

function zzhuntar:DebugMSG(msg)
	-- Display message
	if zzhuntar.db.char.handle["Debug"] == "1" then
		self:Print("DEBUG: "..msg)
	end
end

function zzhuntar:CastTracking(TargetType)
	-- Tracking Switch
	if TargetType == L["type_humanoid"] then
			self:DebugMSG("Target is Humanoid")
			self:PlaceTracking(L["tracking_humanoid"])
	elseif TargetType == L["type_beast"] then
			self:DebugMSG("Target is Beast")
			self:PlaceTracking(L["tracking_beast"])
	elseif TargetType == L["type_demon"] then
			self:DebugMSG("Target is Demon")
			self:PlaceTracking(L["tracking_demon"])
	elseif TargetType == L["type_dragonkin"] then
			self:DebugMSG("Target is Dragonkin")
			self:PlaceTracking(L["tracking_dragonkin"])
	elseif TargetType == L["type_elemental"] then
			self:DebugMSG("Target is Elemental")
			self:PlaceTracking(L["tracking_elemental"])
	elseif TargetType == L["type_giant"] then
			self:DebugMSG("Target is Giant")
			self:PlaceTracking(L["tracking_giant"])
	elseif TargetType == L["type_undead"] then
			self:DebugMSG("Target is Undead")
			self:PlaceTracking(L["tracking_undead"])
	end
end

function zzhuntar:UNIT_AURA()
	-- Addon enabled ?
	if ( zzhuntar.db.char.handle["AddonEnabled"]) then
		self:DebugMSG("UnitAura Routine")
		
		-- Switching Routine if needed
		self:DebugMSG("Switching Routine Start")
		if self:CheckCombat() == "1" then
			self:DebugMSG("In combat")
			
			-- Check which type of target and instance
			TargetType = UnitCreatureType("target")
			inInstance, instanceType = IsInInstance()

			if not ( instanceType == "pvp" or instanceType == "arena" ) or ( zzhuntar.db.char.handle["PvPEnable"] )  or ( zzhuntar_specialinstances[GetRealZoneText()] ) then
				-- call tracking switch
				self:CastTracking(TargetType)
			end
		else
			self:DebugMSG("Out of Combat")
			if zzhuntar_Tracking == "1" then
				self:DebugMSG("zzhuntar_Tracking == "..zzhuntar_Tracking)
				prevTrack = zzhuntar.db.char.handle["prevTrack"]
                                self:DebugMSG("db Prev Tracking: "..prevTrack)
				
				-- If prevTrack is 0 then it should be nil
				if prevTrack == "0" then
					prevTrack = nil
				end

                                SetTracking(prevTrack)
                                zzhuntar_Tracking = "0"
                                self:DebugMSG("zzhuntar_Tracking == "..zzhuntar_Tracking)
			end
		end

		-- prevTrack routine
		if zzhuntar_Tracking == "0" then
			if self:CheckCombat() == "0" then
				self:DebugMSG("prevTrack routine start, out of combat")
				local count = GetNumTrackingTypes()
				nilCheck = "1"
				for i=1,count do
					local name, texture, active, category = GetTrackingInfo(i)
					if active then
						self:DebugMSG("Active tracking: "..name)
						zzhuntar.db.char.handle["prevTrack"] = i
						self:DebugMSG("Set prevTrack to: "..i)
						nilCheck = "0"
					end
				end
				
				-- Set prevTrack to 0 if it should be nil
				if nilCheck == "1" then
					zzhuntar.db.char.handle["prevTrack"] = "0"
				end
			end
		end

		self:DebugMSG("End UnitAura Routine")
	end
end

function zzhuntar:PLAYER_REGEN_DISABLED()
	if ( zzhuntar.db.char.handle["AddonEnabled"] ) then
		self:DebugMSG("Regen Disabled, Unit gains combat")
		-- Check which type of target we got
		TargetType = UnitCreatureType("target");
		inInstance, instanceType = IsInInstance()
		db_PvP_Enable = zzhuntar.db.char.handle["PvPEnable"]

		if not ( instanceType == "pvp" or instanceType == "arena")  or ( db_PvP_Enable == True ) or ( zzhuntar_specialinstances[GetRealZoneText()] ) then
			-- call tracking switch
			self:CastTracking(TargetType)
		end
	end
end

function zzhuntar:PLAYER_TARGET_CHANGED()
	if ( zzhuntar.db.char.handle["AddonEnabled"] ) then
		self:DebugMSG("Player changed target")
		-- Only when in combat
		inInstance, instanceType = IsInInstance()

		if self:CheckCombat() == "1" then
			self:DebugMSG("Unit is in combat")
			-- Check which type of target we got
			TargetType = UnitCreatureType("target");
	
			if not ( instanceType == "pvp" or instanceType == "arena")  or ( zzhuntar.db.char.handle["PvPEnable"] ) or ( zzhuntar_specialinstances[GetRealZoneText()] ) then
				-- call tracking switch
				self:CastTracking(TargetType)
			end   
		end
	end
end

function zzhuntar:PlaceTracking(TrackIt)
	-- Only set tracking when its enabled
	if ( zzhuntar.db.char.handle["AddonEnabled"] ) then
		self:DebugMSG("CastTracking Routine")
		-- Check if we are already tracking
		if zzhuntar_Tracking == "0" then
			self:DebugMSG("zzhuntar_Tracking: 0")
			-- Track the type that is wanted
			local count = GetNumTrackingTypes();
			for i=1,count do
				local name, texture, active, category = GetTrackingInfo(i);
				if name == TrackIt then
					if not active then
						self:DebugMSG("Tracking is not active for: "..TrackIt.." Setting active")
						SetTracking(i)
						if (self:CheckActiveTrack(i)) then
							self:DebugMSG("zzhuntar_Tracking: 1")
							zzhuntar_Tracking = "1"
						else
							self:DebugMSG("zzhuntar_Tracking: 0 retrying")
							zzhuntar_Tracking = "0"
						end
					end
				end
			end
		end
	end
end

function zzhuntar:CheckActiveTrack(track)
	-- Check if the current tracking method is the same as the one we check
	self:DebugMSG("CheckActiveTrack Routine")
	retval = "0"
	local count = GetNumTrackingTypes();

	for i=1,count do
		local name, texture, active, category = GetTrackingInfo(i);
		if not active then
			retval = "0"
		else
			if name == track then
				self:DebugMSG("Active tracking: "..name)
				retval = "1"
			end
		end
	end
	self:DebugMSG("End CheckActiveTrack Routine")
	
	return retval
end

function zzhuntar:CheckCombat()
	self:DebugMSG("CheckCombat Routine Start")
	RetVal = "0"

	if UnitAura("player", "Feign Death") == L["feign_death"] then
                -- Feigning Death so return 1 to mimic combat
		RetVal = "1"
		self:DebugMSG("Unit is using Feign Death")

	elseif UnitAffectingCombat("player") then
		-- Combat so return 1
		RetVal = "1"
		self:DebugMSG("Unit is in combat")

	else
		-- Not in combat so return 0
		RetVal = "0"
		self:DebugMSG("Unit is out of combat")

	end

	self:DebugMSG("CheckCombat Routine End")
	return RetVal
end

function zzhuntar:ToggleDebug()
	if zzhuntar.db.char.handle["Debug"] == "0" then
		zzhuntar.db.char.handle["Debug"] = "1"
		self:Print("Debugging enabled")
	else
		zzhuntar.db.char.handle["Debug"] = "0"
		self:Print("Debugging disabled")
	end
end

function zzhuntar:SlashCmd(Cmd)
	if ( Cmd == "debug" ) then
		self:ToggleDebug()
	elseif ( Cmd == "help" ) then
		self:DisplayHelp()
	elseif ( Cmd == "about" ) then
		self:DisplayAbout()
	elseif ( Cmd == "reportprev" ) then
		self:ReportPrevTrack()
	else
		self:DisplayHelp()
	end
end

function zzhuntar:DisplayAbout()
	-- About me and my addon
	self:Print("Zug Zug Huntar version "..zzhuntar_version)
	self:Print("Created by Darool <Zug Zug> at Quel'Thalas-EU")
end

function zzhuntar:DisplayHelp()
	-- Display Usage
	self:Print(L["zzhuntar_usage"])
	self:Print(L["zzhuntar_usage_help"])
	self:Print(L["zzhuntar_usage_about"])
end

function zzhuntar:ReportPrevTrack()
	-- Display prevTrack
	self:Print("DEBUG: prevTrack: " .. zzhuntar.db.char.handle["prevTrack"] .. "")
end

function zzhuntar:GetMessage(info)
    return self.db.profile.message
end

function zzhuntar:SetMessage(info, newValue)
    self.db.profile.message = newValue
end

function zzhuntar:IsShowInChat(info)
    return self.db.profile.showInChat
end

function zzhuntar:ToggleShowInChat(info, value)
    self.db.profile.showInChat = value
end

function zzhuntar:IsShowOnScreen(info)
    return self.db.profile.showOnScreen
end

function zzhuntar:ToggleShowOnScreen(info, value)
    self.db.profile.showOnScreen = value
end
