-----------------------------------
-----------------------------------
-- SpamSentry by Anea
-----------------------------------
-- BrokerPlugin.lua
-- LDB display button
-----------------------------------

local mod = SS:NewModule("Broker Plugin", "AceEvent-3.0")
local LibQTip = LibStub("LibQTip-1.0")
local ldb = LibStub("LibDataBroker-1.1")
local ldbIcon = LibStub("LibDBIcon-1.0", true)
local L = LibStub("AceLocale-3.0"):GetLocale("SpamSentry")
mod.modName = L["Broker Plugin"]

local brokerObject = {}

local defaults = {
  profile = {
    showSpamCounter = false,           -- Show counter in LDB button
    showStatistics = false,            -- Show advanced statistics in tooltip
    showMinimapIcon = true,            -- Show icon near the minimap
    minimapSettings = {}               -- Stores location, radius, etc
  }
}

local options = {
  minimap = {
    type = "toggle",
    name = L["minimap icon"],
    desc = L["Enable if you want to see an icon near the minimap"],
    set = function(_,v) 
      mod.db.profile.showMinimapIcon = v 
      mod:ToggleMinimapIcon()
    end,
    get = function() return mod.db.profile.showMinimapIcon end,
  },
  cspam = {
    type = "toggle",
    name = L["spam counter"],
    desc = L["Enable if you want to see the spamcounter"],
     set = function(_,v) 
      mod.db.profile.showSpamCounter = v
      mod:OnUpdate()
    end,
    get = function() return mod.db.profile.showSpamCounter end,
  },
  stat = {
    type = "toggle",
    name = L["statistics"], 
    desc = L["Enable if you want to see the advanced statistics in the tooltip"],
    set = function(_,v) 
      mod.db.profile.showStatistics = v
    end,
    get = function() return mod.db.profile.showStatistics end,
  },
  b2f = {
    type = "execute",
    name = L["Broker2FuBar options"],
    desc = L["Open the Broker2FuBar options panel"],
    hidden = function() return not IsAddOnLoaded('Broker2FuBar') end,
    func = function() LibStub("AceAddon-3.0"):GetAddon("Broker2FuBar", true):OpenGUI() end,
  },

}

function mod:OnInitialize()
  self.db = SS.db:RegisterNamespace("Broker Plugin", defaults)
  mod:CreateLDBObject()
  if ldbIcon then ldbIcon:Register("SpamSentry", mod.brokerObject, self.db.profile.minimapSettings) end
  self.db.profile.minimapSettings.hide = not self.db.profile.showMinimapIcon  -- Silly fix for ldbIcon 1.0.r9, thx radnuale
end

function mod:OnEnable()
  mod:RegisterMessage("SPAMSENTRY_REPORTLIST_UPDATED", "OnUpdate")
  mod:RegisterMessage("SPAMSENTRY_SPAM_FOUND", "OnUpdate")
  mod:OnUpdate()
end

function mod:OnDisable()
end

function mod:CreateLDBObject()
  mod.brokerObject = ldb:NewDataObject("SpamSentry", {
    type = "data source",
    text = "",
    icon = "Interface\\AddOns\\SpamSentry\\icon",
    label = "SpamSentry",
    OnClick = function(frame, button)
        if button == "RightButton" then
          SS:OpenConfig()
        else
          local report = SS:GetModule('Report', true)
          if report then
            if IsControlKeyDown() then
              report:ShowGUI("feedback")
            else
              report:ShowGUI()
            end
          else
            SS:Msg(0, "Report module not available.")
          end
        end
      end,
    OnEnter = mod.ShowTooltip,
    OnLeave = mod.HideTooltip,
  })
end

function mod:OnUpdate()
  local numspam = #SS.spamReportList
  local text = mod.db.profile.showSpamCounter and string.format("|cffffffff%d|r ", numspam) or ""
  mod.brokerObject.text = text
  mod.brokerObject.icon = (numspam == 0) and "Interface\\AddOns\\SpamSentry\\icon" or "Interface\\AddOns\\SpamSentry\\icon_red"
end


function mod:ShowTooltip()
  mod.tooltip = LibQTip:Acquire("SpamSentry_Broker", 2, "LEFT", "RIGHT")

  mod.tooltip:AddHeader("|cffffff00"..L["spam"].."|r")
  mod.tooltip:AddLine(L["total blocked"], SS.db.profile.totalBlocked)
  mod.tooltip:AddLine(L["on reportlist"], #SS.spamReportList)

  if mod.db.profile.showStatistics then
    mod.tooltip:AddLine(" ", " ")
    mod.tooltip:AddHeader("|cffffff00"..L["Session statistics"].."|r")
    mod.tooltip:AddLine(L["Messages seen:"],    SS.statistics.seen)
    mod.tooltip:AddLine(L["Messages delayed:"], SS.statistics.delayed)
    mod.tooltip:AddLine(L["Who queries:"],      SS.statistics.who)
    mod.tooltip:AddLine(L["Spam blocked:"],     SS.statistics.spam)
  end
  
  mod.tooltip:AddLine(" ", " ")
  mod.tooltip:AddLine("|cffffff00"..L["Click to submit ticket"].."|r")

  mod.tooltip:SmartAnchorTo(self)
  mod.tooltip:Show()
end

function mod:HideTooltip()
  LibQTip:Release(mod.tooltip)
  mod.tooltip = nil
end

---------------------
-- Utility functions
function mod:GetScaledCursorPosition()
  local x, y = GetCursorPosition()
  local scale = UIParent:GetEffectiveScale()
  return x / scale, y / scale, scale
end

function mod:RelPoint()
 local x,y = mod:GetScaledCursorPosition()
 local xp = mod:XPoint(x)
 return (y<GetScreenHeight() / 2) and "TOP"..xp or "BOTTOM"..xp
end

function mod:Point()
 local x,y = mod:GetScaledCursorPosition()
 local xp = mod:XPoint(x)
 return (y<GetScreenHeight() / 2) and "BOTTOM"..xp or "TOP"..xp
end

function mod:XPoint(x)
  if x < GetScreenWidth()/2 - GetScreenWidth()/4 then
    return "LEFT"
  elseif x > GetScreenWidth()/2 + GetScreenWidth()/4 then
    return "RIGHT"
  end
  return ""
end

function mod:ToggleMinimapIcon()
  if not ldbIcon then return end
  if mod.db.profile.showMinimapIcon then 
    ldbIcon:Show("SpamSentry") 
  else 
    ldbIcon:Hide("SpamSentry") 
  end
end

---------------------
-- Plugin info & options

function mod:GetOptions()
  return options
end

function mod:Info()
  return L["Allows you to quickly review the status of SpamSentry using your favourite Broker display.\n\nFor use with FuBar: Download the Broker2Fubar addon."]
end
