--[[
  Title: RuneWatch v1.2.12
  Author: Voorije (ReAn)
  Revised: 2010-06-22T08:14:57Z
--]]
local AceAddon = LibStub("AceAddon-3.0")
local AceDB = LibStub("AceDB-3.0")
local AceTimer = LibStub("AceTimer-3.0")

local L = LibStub("AceLocale-3.0"):GetLocale("RuneWatch");

RuneWatch = AceAddon:NewAddon("RuneWatch", "AceConsole-3.0", "AceEvent-3.0", "AceHook-3.0")
RuneWatch.Version = "v1.2.12";
RuneWatch.Callbacks = RuneWatch.Callbacks or LibStub("CallbackHandler-1.0"):New(RuneWatch);

-- Basic Bar

function RuneWatch:OnInitialize()

	self.dbase = LibStub("AceDB-3.0"):New("RuneWatchDB");
	self.dbase:RegisterDefaults({
		profile = {
			hideBlizzFrame = true,
			pos = { x = 0, y = 0 },
			locked = true,
			mmEnabled = true,
			scale = 1.0,
			widgets = {},
			frame = {
				runes = {
					order = "buf",
					skin = "Custom1",
					vttype = "cooldown",
					bloodCol = {
						r = 1,
						g = 0.8470488,
						b = 0.8313725,
						a = 1
					},
					frostCol = {
						r = 0.5686274,
						g = 0.7058823,
						b = 1,
						a = 1
					},
					unholyCol = {
						r = 0.7490196, 
						g = 1.0,
						b = 0.7843137,
						a = 1
					},
					deathCol = {
						r = 1,
						g = 0.494117,
						b = 0.941176,
						a = 1
					},
					bloodfCol = {
						r = 1,
						g = 0,
						b = 0,
						a = 1
					},
					frostfCol = {
						r = 0.4,
						g = 0.4,
						b = 1,
						a = 1
					},
					unholyfCol = {
						r = 0, 
						g = 1.0,
						b = 0,
						a = 1
					},
					deathfCol = {
						r = 1,
						g = 0,
						b = 1,
						a = 1
					}
				},
				rp = {
					minColor = { 
						r = 0.2392156827451, 
						g = 0.30196078431373, 
						b = 0.384313725902, 
						a = 1.0 
					},
					maxColor = { 
						r = 0.21960784313725, 
						g = 0.49411784705882, 
						b = 0.6, 
						a = 1.0 
					}
				}
			},
			behaviour = {
				fadeout = {
					enabled = true,
					opacity = 0.5,
					wait = 2,
					length = 1
				}
			},
			skin = {
				active = "full",
				theme = "Generic",
				orientation = "bottom"
			},
			minimap = {
			
			}
		}
	});
	self.db = self.dbase.profile;
	
	if (self.db.hideBlizzFrame) then
		_G["RuneFrame"]:Hide();
	else
		_G["RuneFrame"]:Show();
	end
	
	RuneWatch:populateOptions();
	
	self:InitState();
	
	-- GUI
	self:InitGui();	
	
	-- In/Out of Combat Events
	self:RegisterEvent("PLAYER_REGEN_DISABLED");
	self:RegisterEvent("PLAYER_REGEN_ENABLED");
	
	self:SendMessage("RuneWatch_Init");
	
	self.LastUpdate = 0;
end

function RuneWatch:InitState()
	self.State = {
		LastUpdate = 0,
		InCombat = false,
		FadeOut = {
			active = false,
			elapsed = 0
		}
	}
end

function RuneWatch:OnEnable()
	self:Print(L["Loaded, type /rune for options."]);
	
	RuneWatch.Skins:Init();
	RuneWatch.Widgets:Init();
	
	self:PlaceGui();
	self:UpdateGui();
	self:UpdateDrag();
	
	if (self.db.behaviour.fadeout.enabled) then
		self.Gui.Anchor:SetAlpha(self.db.behaviour.fadeout.opacity);
	end
	
	local _, uclass = UnitClass("Player");
	if (uclass ~= "DEATHKNIGHT") then
		self.Gui.Anchor:Hide();
	else
		self.Gui.Anchor:Show();
	end
end

function RuneWatch:OnDisable()

end

function RuneWatch:OnUpdate(self, elapsed)
	if (RuneWatch.State == nil) then
		self:InitState();
	end

	local State = RuneWatch.State;

	State.LastUpdate = State.LastUpdate + elapsed;
	
	if (State.FadeOut.active == true) then
		local tarOpacity = RuneWatch.db.behaviour.fadeout.opacity;
		
		State.FadeOut.elapsed = State.FadeOut.elapsed + elapsed;
		
		if (State.FadeOut.elapsed >= RuneWatch.db.behaviour.fadeout.length) then
			State.FadeOut.active = false;
			RuneWatch.Gui.Anchor:SetAlpha(tarOpacity);
		else
			local perc = 1 - (State.FadeOut.elapsed / RuneWatch.db.behaviour.fadeout.length);
			local curOpacity = ((1-tarOpacity) * perc) + tarOpacity;
			RuneWatch.Gui.Anchor:SetAlpha(curOpacity);
		end
	end
end

-- Occurs when player enters 'combat'
function RuneWatch:PLAYER_REGEN_DISABLED(event, ...)
	-- Always make sure our opacity is at full when we enter combat.
	self.State.InCombat = true;
	self.State.FadeOut.active = false;
	self.State.FadeOut.elapsed = 0;
	self.Gui.Anchor:SetAlpha(1);
end

-- Occurs when player exits 'combat'
function RuneWatch:PLAYER_REGEN_ENABLED(event, ...)
	-- If Fade-Out Is Turned on
	self.State.InCombat = false;
	if (self.db.behaviour.fadeout.enabled == true) then
		-- Schedule a timer
		AceTimer:ScheduleTimer(function() self.State.FadeOut.elapsed = 0; self.State.FadeOut.active = true; end, self.db.behaviour.fadeout.wait);
	end
end
