--[[
  Title: RuneWatch v1.2.12
  Author: Voorije (ReAn)
  Revised: 2009-02-19T10:24:20Z
--]]

-- Initialize Base Config
local options = {
	type = "group",
	arg = {}
}

local L = LibStub("AceLocale-3.0"):GetLocale("RuneWatch");

RuneWatch.configOptions = options
LibStub("AceConfig-3.0"):RegisterOptionsTable("RuneWatch", options, {"runewatch", "rune"})

local function SetValue(group, field, value)
	local dbg = group;
	
	dbg[field] = value;
end

local function GetValue(group, field)
	local dbg = group;
	
	return dbg[field];
end

function RuneWatch:populateOptions()
	local options = RuneWatch.configOptions;
	options.args = {
		config = {
			type = "execute",
			name = L["Configure"],
			order = 0,
			desc = L["Open the Configuration Dialog"],
			func = function() RuneWatch:ShowConfig() end,
			guiHidden = true
		},
		frame = {
			type = "group",
			name = L["Frame"],
			order = 10,
			desc = L["UI-Frame Options"],
			args = {
				dsc = {
					type = "description",
					order = 0,
					cmdHidden = true,
					dropdownHidden = true,
					name = L["This section of the configuration allows you to change the appearance/location of the main ui-frame."]
				},
				minimap = {
					type = "toggle",
					name = L["Show Minimap Icon"],
					width = "full",
					desc = L["Toggles the display of the minimap icon."],
					get = function(info) return RuneWatch.db.mmEnabled end,
					set = function(info,v) RuneWatch.db.mmEnabled = v; RuneWatch:UpdateMinimapIcon(); end
				},
				locked = {
					type = "toggle",
					name = L["Locked"],
					width = "full",
					desc = L["Toggles the ui's locked state, preventing it from being moved."],
					get = function(info) return RuneWatch.db.locked end,
					set = function(info, v) RuneWatch.db.locked = v; RuneWatch:UpdateDrag(); end
				},
				scale = {
					type = "range",
					name = L["UI Scale"],
					desc = L["Scales the UI to a factor of the default."],
					min = 0.1,
					max = 5,
					step = 0.1,
					get = function(info) return RuneWatch.db.scale end,
					set = function(info, v) RuneWatch.db.scale = v; RuneWatch:UpdateGui(); end
				},
				blizz = {
					type = "toggle",
					name = L["Hide Blizzard Rune Frame"],
					width = "full",
					desc = L["Hide the blizzard rune frame?"],
					get = function(info) return RuneWatch.db.hideBlizzFrame end,
					set = function(info, v) RuneWatch.db.hideBlizzFrame = v; 
						if (v) then
							_G["RuneFrame"]:Hide();
						else
							_G["RuneFrame"]:Show();
						end
					end
				},
			}
		},
		behaviour = {
			type = "group",
			name = L["Behaviour"],
			desc = L["Mod-Behaviour Options"],
			childGroups = "tab",
			order = 30,
			args = {
				dsc = {
					type = "description",
					order = 0,
					cmdHidden = true,
					dropdownHidden = true,
					name = L["This section of the configuration deals with behavioural changes to RuneWatch. The options in this section govern how RuneWatch acts and responds to various events."]
				},
				fadeout = {
					type = "group",
					order = 1,
					name = L["Fade-Out"],
					desc = L["Out of combat Fade-Out"],
					args = {
						dsc = {
							type = "description",
							order = 0,
							cmdHidden = true,
							dropdownHidden = true,
							name = L["The Fade-Out behavior allows the RuneWatch Gui to fade-out after combat has ended, this allows the user to have an un-obstructed view when they aren't in combat since RuneWatch is primarily an in-combat mod."]
						},
						enabled = {
							type = "toggle",
							name = L["Enabled"],
							desc = L["Enables/Disables the Fade-Out Behaviour"],
							order = 1,
							get = function(info) return GetValue(RuneWatch.db.behaviour.fadeout, "enabled"); end,
							set = function(info, v) 
									SetValue(RuneWatch.db.behaviour.fadeout, "enabled", v); 
									
									if ( v == false ) then
										RuneWatch.Gui.Anchor:SetAlpha(1);
									else
										if ( RuneWatch.State.InCombat == false) then
											RuneWatch.Gui.Anchor:SetAlpha(RuneWatch.db.behaviour.fadeout.opacity);
										end
									end
								  end
						},
						fo_opts = {
							type = "group",
							name = L["Fade-Out Options"],
							desc = L["Fade-Out Options"],
							order = 2,
							inline = true,
							args = {
								fade_opacity = {
									type = "range",
									name = L["Fade-Out Opacity"],
									desc = L["Determines the resulting opacity of the frame after fade-out"],
									min = 0,
									max = 1,
									step = 0.1,
									order = 3,
									width = "full",
									get = function(info) return GetValue(RuneWatch.db.behaviour.fadeout, "opacity"); end,
									set = function(info,v) 
											SetValue(RuneWatch.db.behaviour.fadeout, "opacity", v);
											
											if (RuneWatch.State.FadeOut.active == false) and (RuneWatch.State.InCombat == false) then
												RuneWatch.Gui.Anchor:SetAlpha(RuneWatch.db.behaviour.fadeout.opacity);
											end
										  end
								},
								fade_wait = {
									type = "range",
									name = L["Fade-Out Wait"],
									desc = L["Time to wait after leaving combat before fading out the frame"],
									min = 0,
									max = 10,
									step = 1,
									order = 4,
									width = "full",
									get = function(info) return GetValue(RuneWatch.db.behaviour.fadeout, "wait"); end,
									set = function(info,v) SetValue(RuneWatch.db.behaviour.fadeout, "wait", v); end
								},
								fade_length = {
									type = "range",
									name = L["Fade-Out Length"],
									desc = L["Length of the fade-out effect"],
									min = 0,
									max = 5,
									step = 1,
									order = 5,
									width = "full",
									get = function(info) return GetValue(RuneWatch.db.behaviour.fadeout, "length"); end,
									set = function(info,v) SetValue(RuneWatch.db.behaviour.fadeout, "length", v); end
								}
							}
						}
					}
				}
			}
		},
		skins = {
			type = "group",
			name = L["Skins"],
			desc = L["Skin settings"],
			childGroups = "tab",
			order = 40,
			args = RuneWatch.Skins:InitOptions();
		},
		widgets = {
			type = "group",
			name = L["Frame Widgets"],
			desc = L["Frame Widget Settings"],
			childGroups = "tab",
			order = 20,
			args = RuneWatch.Widgets:InitOptions();
		},
		profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(RuneWatch.dbase);
	}
	
	self:populateBlizzardOptions();
end

function RuneWatch:populateBlizzardOptions()
	--[[local frame = CreateFrame("frame", "RuneWatch_BlizzardOptions", UIParent);
	frame.name = "RuneWatch";
	frame:SetWidth(300);
	frame:SetHeight(200);
	frame:Show();
	
	local btn = CreateFrame("button", "$parent_OpenConfig", frame, "OptionsButtonTemplate");
	btn:SetWidth(180);
	btn:SetHeight(24);
	btn:SetPoint("TOPLEFT", frame, "TOPLEFT", 15, -15);
	btn:SetText("RuneWatch Config");
	btn:SetScript("OnClick", function() RuneWatch:ShowConfig() end);
	btn:Show();
	
	InterfaceOptions_AddCategory(frame);]]
	local ACD3 = LibStub("AceConfigDialog-3.0");
	
	
	self.oFrameAbout = LibStub("LibAboutPanel").new(nil, "RuneWatch");
	self.oFrameFrame = ACD3:AddToBlizOptions("RuneWatch", L["Frame"], "RuneWatch", "frame");
	self.oFrameWidgets = ACD3:AddToBlizOptions("RuneWatch", L["Frame Widgets"], "RuneWatch", "widgets");
	self.oFrameBehavior = ACD3:AddToBlizOptions("RuneWatch", L["Behaviour"], "RuneWatch", "behaviour");
	self.oFrameSkin = ACD3:AddToBlizOptions("RuneWatch", L["Skins"], "RuneWatch", "skins");
	self.oFrameProfile = ACD3:AddToBlizOptions("RuneWatch", "Profile...", "RuneWatch", "profile");
	
	
end

function RuneWatch:ShowConfig()
	LibStub("AceConfigDialog-3.0"):Open("RuneWatch", nil)
end
