--[[
	Basic RuneWatch GUI Widget Base Class
	Author: Voorije (ReAn)
	Last Edited: 2009-02-19T10:24:20Z
]]

local L = LibStub("AceLocale-3.0"):GetLocale("RuneWatch");

assert(RuneWatch, L["Unable to locate RuneWatch Addon Object."]);

local _Events = RuneWatch.Callbacks;

local Widget = 
{
	ID = "basewidget",
	Name = "WidgetBase", 
	Description = "Basic Widget",
	Gui = {},
	Options = {}
}

function Widget:Super(t)
	local sup = getmetatable(self)["__index"]
	return sup[t](sup == Widget and self or sup)
end

function Widget:OnInitialize()

end

function Widget:OnEnable()
	-- @debug@
	RuneWatch:Print("[Widget] "..self.Name.." Loaded...");
	-- @debug-end@
end

function Widget:OnDisable()

end

RuneWatch.WidgetBase = Widget

--[[============================= Widget: API =============================]]

RuneWatch.Widgets = {} -- Widget Namespace
RuneWatch.Widgets.Registry = {} -- Widget Registry within Widgets Namespace
RuneWatch.Widgets.configOptions = {}

local _W = RuneWatch.Widgets

--[===[ Registration ]===]--
function RuneWatch.Widgets:Register(id, obj)
	_W.Registry[id] = obj;
	_W.configOptions[id] = obj.Options;
end

--[===[ General API ]===]--
function RuneWatch.Widgets:Init()
	RuneWatch:SendMessage("RuneWatch_Widgets_Init", RuneWatch.Gui.Anchor);
end

function RuneWatch.Widgets:InitOptions()
	local args = {
		dsc = {
			type = "description",
			order = 0,
			cmdHidden = true,
			dropdownHidden = true,
			name = L["Configuration for RuneWatch Widgets"]
		}
	}
	
	_W.configOptions = args;
	
	return args;
end

--[===[ Object API ]===]--
function RuneWatch.Widgets:HideGui(id)
	local w = _W.Registry;
	
	if (w[id].HideGui ~= nil) then
		w:HideGui();
	else
		for k,v in pairs(w[id].Gui) do
			v:Hide();
		end
	end
end

function RuneWatch.Widgets:ShowGui(id)
	local w = _W.Registry;
	
	if (w[id].ShowGui ~= nil) then
		w:ShowGui();
	else
		for k,v in pairs(w[id].Gui) do
			v:Show();
		end
	end
end

--[===[ Mount Points ]===]--

