--[[
	Basic RuneWatch GUI Utility Functions
	Author: Voorije (ReAn)
	Last Edited: 2009-02-19T10:24:20Z
]]

local L = LibStub("AceLocale-3.0"):GetLocale("RuneWatch");

assert(RuneWatch, L["Unable to locate RuneWatch Addon Object."]);

-- Blends two color arrays together (no alpha)
function RuneWatch:BlendColors(col1, col2, perc)
	local invPerc = 1 - perc;
	
	local newc = { r = 0, g = 0, b = 0 }
	
	newc.r = col2.r * perc + col1.r * invPerc;
	newc.g = col2.g * perc + col1.g * invPerc;
	newc.b = col2.b * perc + col1.b * invPerc;
	
	return newc;
end
