--[[
	Basic RuneWatch GUI Mount Points
	Author: Voorije (ReAn)
	Last Edited: 2009-02-19T10:24:20Z
]]

local L = LibStub("AceLocale-3.0"):GetLocale("RuneWatch");

assert(RuneWatch, L["Unable to locate RuneWatch Addon Object."]);

RuneWatch.Mounts = {}
RuneWatch.Mounts.Registry = {}

local _M = RuneWatch.Mounts;
_M.Empty = { x = 0, y = 0, e = true }

--[===[ Registration ]===]--
function RuneWatch.Mounts:Register(id, name)
	_M.Registry[id] = name;
end

--[===[ Skins / Widgets ]===]--
function RuneWatch.Mounts:GetMount(skin, mount, ori)
	local sk = nil
	
	if (type(skin) == "table") then
		sk = skin;
	else
		sk = RuneWatch.Mounts:GetSkin(skin);
	end
	
	if (sk == nil) then
		return _M.Empty;
	end
	
	-- Ok, let's look up this point
	if (sk.Mounts[mount]) then
		local o = sk.Mounts[mount];
		
		if (o[ori]) then
			return o[ori];
		end
	end
	
	return nil;
end
