--[[
	Basic RuneWatch GUI
	Author: Voorije (ReAn)
	Last Edited: 2009-02-19T10:24:20Z
]]

local L = LibStub("AceLocale-3.0"):GetLocale("RuneWatch");

-- Check for RuneWatch
assert(RuneWatch, L["Unable to locate RuneWatch Addon Object."]);

local _Events = RuneWatch.Callbacks;

RuneWatch.Gui = {}
RuneWatch.Gui.Anchor = CreateFrame("frame", "RW_Frame", UIParent);

local _Anchor = RuneWatch.Gui.Anchor;
_Anchor:SetPoint("CENTER", UIParent, "CENTER");
_Anchor:SetWidth(100);
_Anchor:SetHeight(100);
_Anchor:SetMovable(true);
_Anchor:SetUserPlaced(true);
_Anchor:SetFrameStrata("LOW");
_Anchor:SetFrameLevel(0);
_Anchor:Show();

-- Hide the rune frame (HACK FOR XPERL)

function RuneWatch:InitGui()
	-- Basic Frame
	local Gui = RuneWatch.Gui;
	
	self:BuildAnchor();
	Gui.Drag = self:BuildDrag();
	
end

function RuneWatch:BuildAnchor()
	
	_Anchor:Show();
	_Anchor:SetScript("OnUpdate", function(self, elapsed) RuneWatch:OnUpdate(self, elapsed) end);
	
end

function RuneWatch:BuildDrag()
	local frame = CreateFrame("frame", "RW_DragFrame", UIParent);
	frame:SetFrameStrata("LOW");
	frame:SetFrameLevel(100);
	frame:EnableMouse(true);
	frame:Show();
	
	frame:SetScript("OnMouseDown", function() RuneWatch.Gui.Anchor:StartMoving() end);
	frame:SetScript("OnMouseUp", function() 
		RuneWatch.Gui.Anchor:StopMovingOrSizing()
		local _,_,_,xoff,yoff = RuneWatch.Gui.Anchor:GetPoint(1); -- Get Center Point Location
		
		RuneWatch.db.pos.x = xoff;
		RuneWatch.db.pos.y = yoff;
	end);
	
	local tex = frame:CreateTexture("$parent_T_Green", "OVERLAY");
	tex:SetTexture(0, 0.6, 0, 0.5);
	tex:Show();
	tex:SetAllPoints(frame);
	
	local txt = frame:CreateFontString("$parent_F_Text", "HIGHLIGHT", "GameFontHighlight");
	txt:SetText("Drag");
	txt:SetAllPoints(frame);
	txt:SetJustifyH("CENTER");
	txt:SetJustifyV("MIDDLE");
	txt:Show();
	
	frame.Background = tex;
	frame.Text = txt;
	
	return frame;
end

function RuneWatch:PlaceGui()
	local off = RuneWatch.db.pos;
	RuneWatch.Gui.Anchor:SetPoint("CENTER", UIParent, "CENTER", off.x, off.y);
end

function RuneWatch:UpdateGui()
	-- Update Generic Elements
	self.Gui.Anchor:SetScale(self.db.scale);
	
	-- Hide the Blizzard Rune-Frame
	if (self.db.hideBlizzFrame) then
		_G["RuneFrame"]:Hide();
	else
		_G["RuneFrame"]:Show();
	end
	
	-- Update Skin
	self:SendMessage("RuneWatch_Gui_Update");
	
	-- Attach Sub-Components to Skin
	local skinID = RuneWatch.Skins:GetCurrentID();
	local ori = self.db.skin.orientation;
	self:SendMessage("RuneWatch_Widgets_Attach", skinID, ori);
	
	RuneWatch:UpdateDrag();
end

function RuneWatch:UpdateDrag()
	if (not self.db.locked) then
		-- Call for a resize of the drag frame by the active skin
		self:SendMessage("RuneWatch_Gui_DragEnable", self.Gui.Drag);
		
		self.Gui.Drag:Show();
	else
		self.Gui.Drag:Hide();
	end
end

