--[[
	Basic RuneWatch LibDataBroker-1.1 Implementation
	Author: Voorije (ReAn)
	Last Edited: 2009-04-23T10:20:09Z
]]

local L = LibStub("AceLocale-3.0"):GetLocale("RuneWatch");

assert(RuneWatch, L["Unable to locate RuneWatch Addon Object."]);

-- LibDataBroker-1.1
local ldb = LibStub:GetLibrary("LibDataBroker-1.1");
local Broker = ldb:NewDataObject("RuneWatch", {
	type = "data source",
	icon = "Interface\\AddOns\\RuneWatch\\Artwork\\Icon",
	text = "RuneWatch",
	rp = 0,
	rpm = 100,
	rpp = 0,
	rp_col = { r = 1, g = 1, b = 1, a = 1 },
	tipShown = false
});

local Icon = LibStub("LibDBIcon-1.0");

RuneWatch.Broker = Broker;
RuneWatch.MMIcon = Icon;

function RuneWatch:UpdateMinimapIcon()
	RuneWatch:Print("Updating Minimap Icon Display ");
	if (RuneWatch.db.mmEnabled) then
		RuneWatch.db.minimap.hide = false;
		Icon:Show("RuneWatch");
	else
		RuneWatch.db.minimap.hide = true;
		Icon:Hide("RuneWatch");
	end
end

function Broker:OnClick(button)
	if button == "RightButton" then
		RuneWatch:ShowConfig();
	end
	
	if button == "LeftButton" then
		if (RuneWatch.db.locked) then
			v = false;
		else
			v = true;
		end
	
		RuneWatch.db.locked = v; 
		
		RuneWatch:UpdateDrag();
	end
end

function Broker:OnEnter()
	
	if (not Broker.tipShown) then
		GameTooltip:SetOwner(self, "ANCHOR_NONE");
		GameTooltip:SetPoint("TOPLEFT", self, "BOTTOMLEFT");
	end
	
	Broker.tipShown = true;
	
	Broker:GenerateTooltip();
	Broker:GenerateText();
end

function Broker:GenerateTooltip()
	GameTooltip:ClearLines();
	GameTooltip:AddLine("RuneWatch "..RuneWatch.Version, 1, 0.82, 0);
	GameTooltip:AddDoubleLine(L["Left-Click"], L["Lock/Unlock Frame"], 0.8, 0.6, 0.6, 0.8, 0.6, 0.6);
	GameTooltip:AddDoubleLine(L["Right-Click"], L["Open Configuration"], 0.8, 0.6, 0.6, 0.8, 0.6, 0.6);
	GameTooltip:AddLine(" ");
	
	local rpline = Broker.rp.." / "..Broker.rpm.." ("..string.format("%.1f", Broker.rpp).."%)";
	GameTooltip:AddDoubleLine(L["Runic Power"], rpline, Broker.rp_col.r, Broker.rp_col.g, Broker.rp_col.b, Broker.rp_col.r, Broker.rp_col.g, Broker.rp_col.b);
	
	GameTooltip:Show();
end

function Broker:RuneWatch_RunicPower_Update(event, ...)
	local rp, rpm, perc, col = ...;
	
	Broker.rp = rp;
	Broker.rpm = rpm;
	Broker.rpp = perc;
	Broker.rp_col = col;
	
	if (Broker.tipShown) then
		self:GenerateTooltip();
	end
end

function Broker:RuneWatch_Init(event, ...)
	Icon:Register("RuneWatch", Broker, RuneWatch.db.minimap);
	RuneWatch:UpdateMinimapIcon()
end

function Broker:GenerateText()
	
end

function Broker:OnLeave()
	Broker.tipShown = false;
	GameTooltip:Hide();
end

RuneWatch.RegisterMessage(Broker, "RuneWatch_RunicPower_Update");
RuneWatch.RegisterMessage(Broker, "RuneWatch_Init");
