----------------------------------------------------------------------
-- 	Leatrix Plus Locale
----------------------------------------------------------------------

-- Create locale structure
local GameLocale = GetLocale()
local void, Leatrix_Plus = ...
local function localeFunc(L, key) return key end
local L = setmetatable({}, {__index = localeFunc})
Leatrix_Plus.L = L

-- Locale override (enUS, zhCN, zhTW, ruRU, koKR, deDE, esMX, frFR, itIT, ptBR)
-- GameLocale = "enUS"

-- zhCN: Simplified Chinese (People's Republic of China)
if GameLocale == "zhCN" then
L["+"] = "+"
L["A Donation of Mageweave"] = "捐献魔纹布"
L["A Donation of Runecloth"] = "捐献符文布"
L["A Donation of Silk"] = "捐献丝绸"
L["A Donation of Wool"] = "捐献毛料"
L["A friend request from"] = "你有一个好友申请，来自"
L["Accept available quests automatically"] = "自动接受任务"
L["Accept resurrection"] = "自动接受战复"
L["Accept summon"] = "自动接受召唤"
L["Additional Runecloth"] = "更多的符文布"
L["Addon"] = "插件"
L["Ahn'Qiraj"] = "安其拉"
L["Alterac Mountains"] = "奥特兰克山脉"
L["Anchor"] = "锚点"
L["Angelic"] = "主题：天使"
L["Arathi Highlands"] = "阿拉希高地"
L["Ashenvale"] = "灰谷"
L["Auto loot is now enabled."] = "自动拾取已启用。"
L["AutoFollow"] = "自动跟随"
L["AutoFollow disabled."] = "已关闭自动跟随。"
L["Automate gossip"] = "对话自动交互"
L["Automate quests"] = "任务自动交接"
L["Automation"] = "自动交互"
L["Azshara"] = "艾萨拉"
L["Back to Main Menu"] = "返回"
L["Bad ID"] = "损坏的ID"
L["Badlands"] = "荒芜之地"
L["Barrens"] = "南贫瘠之地"
L["Battle"] = "主题：战争"
L["Battle of Warsong Gulch"] = "峡谷中的战斗"
L["Battlegrounds"] = "战场"
L["Blackfathom Deeps"] = "黑暗深渊"
L["Blackrock Depths"] = "黑石深渊"
L["Blackwing Lair"] = "黑翼之巢"
L["Blasted Lands"] = "诅咒之地"
L["Block duels"] = "屏蔽决斗信息"
L["Block friend requests"] = "屏蔽好友申请"
L["Block party invites"] = "屏蔽队伍邀请"
L["Blocks"] = "屏蔽"
L["Bottom"] = "底部"
L["Buffs"] = "Buffs"
L["Burning Steppes"] = "燃烧平原"
L["Buyout Only"] = "仅限一口价"
L["C"] = "披风"
L["Camera distance"] = "镜头距离"
L["Chain style"] = "边框样式"
L["Character"] = "角色"
L["Chat"] = "聊天功能"
L["Chat Frame"] = "聊天窗口"
L["Checkbox labels are Ok."] = "复选框信息检查通过"
L["Chillwind E'ko"] = "冰风魂精"
L["Cinematics"] = "过场动画"
L["Claiming Arathi Basin"] = "占领阿拉希盆地"
L["Class colored frames"] = "框体职业染色"
L["Class icon portraits"] = "职业图标替换"
L["Classic"] = "经典"
L["click here for new selection"] = "点击此处跳转下一曲目"
L["Click to configure the settings for this option."] = "点击进行额外的选项设置"
L["Click to reset the settings on this page."] = "点击重置此页面的设置。"
L["Click to resize the screen to fit between the top and bottom borders."] = "点击重设屏幕尺寸以适配上下边框"
L["Click to return to the main menu."] = "点击返回到主菜单"
L["Cloak"] = "披风"
L["Color the backdrops based on faction"] = "根据阵营着色边框"
L["Combat log cannot be hidden while undocked."] = "战斗记录窗口被分离时无法隐藏。"
L["Combat plates"] = "自动开关姓名板"
L["Completed."] = "已完成。"
L["Concerted Efforts"] = "共同的努力"
L["Configuration Panel"] = "设置面板"
L["Connections for"] = "连接到"
L["Conquering Arathi Basin"] = "征服阿拉希盆地"
L["Credits"] = "Credits"
L["Cursor"] = "光标"
L["Cursor Left"] = "光标左侧"
L["Cursor Right"] = "光标右侧"
L["Customise minimap"] = "自定义小地图"
L["D"] = "地城"
L["Darkmoon Faire"] = "暗月马戏团"
L["Darkshore"] = "黑海岸"
L["Deadmines"] = "死亡矿井"
L["Deadwind Pass"] = "逆风小径"
L["Desolace"] = "凄凉之地"
L["Dire Maul"] = "厄运之槌"
L["Disable bag automation"] = "禁用自动背包"
L["Disable chat fade"] = "禁用聊天窗口淡出"
L["Disable loot warnings"] = "禁用拾取通报"
L["Disable screen effects"] = "禁用屏幕特效"
L["Disable screen glow"] = "禁用屏幕泛光"
L["Disable sticky chat"] = "禁用聊天频道粘滞"
L["Drag the frame overlay to position the frame."] = "拖动框体边框来移动。"
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "移动面板来定位框体。|n|n如果想要改变框体尺寸，你需选定面板，然后移动滑块来选择。|n|n你一旦进入战斗，这个框体会自动关闭。"
L["Drag to set the buffs frame scale."] = "拖动以调整Buff框体缩放。"
L["Drag to set the cursor X offset."] = "拖拽以设置光标横向偏移。"
L["Drag to set the cursor Y offset."] = "拖拽以设置光标纵向偏移。"
L["Drag to set the density of weather effects."] = "拖动以调整天气效果的密度。"
L["Drag to set the font size of book text."] = "拖动以调整文本字体的大小。"
L["Drag to set the font size of mail text."] = "拖动以调整邮件文本大小。"
L["Drag to set the font size of quest text."] = "拖动以调整任务文本大小。"
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "拖到以调整小地图缩放。|n|n需要注意的是，如果你使用自带的动作条，对小地图进行缩放会影响到右侧动作条的排序。为避免这种情况，建议将此项设置为100%。"
L["Drag to set the scale of the Leatrix Plus panel."] = "拖动以调整LeatrixPlus面板缩放。"
L["Drag to set the scale of the selected frame."] = "拖动以调整所选中面板的缩放。"
L["Drag to set the size of the bottom border."] = "拖动以调整底部边框。"
L["Drag to set the size of the left border."] = "拖动以调整左侧边框。"
L["Drag to set the size of the right border."] = "拖动以调整右侧边框。"
L["Drag to set the size of the top border."] = "拖动以调整顶部边框。"
L["Drag to set the tooltip scale."] = "拖动以调整鼠标提示的缩放。"
L["Drag to set the transparency of the borders."] = "拖动以调整边框透明度。"
L["Drag to set the transparency of the Leatrix Plus panel."] = "拖动以调整LeatrixPlus面板的透明度。"
L["Dun Morogh"] = "丹莫罗"
L["Dungeons"] = "地下城"
L["Dup ID"] = "复制的ID"
L["durability"] = "耐久度"
L["Durability"] = "耐久度"
L["Durotar"] = "杜隆塔尔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "尘泥沼泽"
L["Eastern Kingdoms"] = "东部王国"
L["Eastern Plaguelands"] = "东瘟疫之地"
L["ELITE"] = "精英"
L["Elwynn Forest"] = "艾尔文森林"
L["Enable hotkey"] = "启用热键"
L["Enable viewport"] = "画面视口"
L["Enhance dressup"] = "增强换装预览"
L["Enhance professions"] = "专业面板增强"
L["Enhance quest log"] = "任务面板拓展"
L["Enhance trainers"] = "增强训练面板"
L["Enhancements"] = "增强功能"
L["Enter"] = "输入"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "输入你想要监控的法术ID。|n|n如果这个法术来自于你的宠物，请勾选宠物复选框。|n|n法术图标会按职业进行保存。"
L["enter zone or track name"] = "输入区域或者曲目名称"
L["Error messages will be hidden"] = "错误信息已屏蔽。"
L["Error messages will be shown"] = "错误信息已显示。"
L["Events"] = "事件"
L["Extras"] = "其他"
L["False"] = "错误"
L["Faster auto loot"] = "加速自动拾取"
L["Faster movie skip"] = "快速跳过短片"
L["Features"] = "功能"
L["Felwood"] = "费伍德森林"
L["Feralas"] = "菲拉斯"
L["Fight for Warsong Gulch"] = "战歌峡谷之战"
L["Find Item"] = "查找物品"
L["For Great Honor"] = "无上的荣耀"
L["Frames"] = "框体相关"
L["Frostmaul E'ko"] = "霜槌魂精"
L["Frostsaber E'ko"] = "霜刃魂精"
L["Game Options"] = "游戏设置"
L["Ghost"] = "灵魂状态框体"
L["Gloomy"] = "主题：阴暗"
L["Gnomeregan"] = "诺莫瑞根"
L["Gold Only"] = "仅输入金币"
L["Graphics and Sound"] = "界面和音效"
L["Groups"] = "队伍"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "古拉巴什、邪枝和枯木硬币"
L["H"] = "头盔"
L["Haunted"] = "主题：鬼怪"
L["Helm"] = "头盔"
L["Help"] = "帮助"
L["Hide chat buttons"] = "隐藏聊天窗口按钮"
L["Hide cooldown duration numbers (if enabled)"] = "隐藏冷却计时（若启用）"
L["Hide error messages"] = "隐藏错误信息"
L["Hide gryphons"] = "隐藏动作条狮鹫"
L["Hide portrait numbers"] = "隐藏头像数字"
L["Hide stance bar"] = "隐藏姿态条"
L["Hide the combat log"] = "隐藏战斗记录窗口"
L["Hide the zone text bar"] = "隐藏区域信息"
L["Hide the zoom buttons"] = "隐藏缩放按钮"
L["Hide tooltips for world units during combat"] = "战斗中隐藏窗口"
L["Hide zone text"] = "隐藏区域文本"
L["High"] = "高"
L["Hillsbrad Foothills"] = "希尔斯布莱德丘陵"
L["Hinterlands"] = "辛特兰"
L["Home"] = "主页"
L["Ice Thistle E'ko"] = "冰草魂精"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "勾选后，会在背包及银行界面显示搜索框。"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "勾选后，一个按钮会显示在角色框体，其鼠标提示信息会显示身上的装备耐久度。|n|n当你死后，你的整体耐久度也会显示在聊天框体。"
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "勾选后，当你未组队或者有队伍权限时，会自动邀请密语中包含预设关键词的玩家。"
L["If checked, a master volume slider will be shown in the character sheet."] = "勾选后，一个音量调整滑块会显示在你角色页面。"
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "勾选后，会启用小地图快捷按钮。|n|n左键：打开设置面板。|n|nSHIFT+左键：打开音乐播放器。|n|nCTRL+右键：开关红字错误过滤（需启用）。|n|nCTRL+SHIFT+左键：开关Zygor插件（需安装）。|n|nCTRL+SHIFT+右键：切换窗口模式。"
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "勾选后，会增强你的拍卖行窗口。|n|n一口价：商品上架时自动同步起拍价和一口价。|n|n取整：自动将铜币与银币设置为99。|n|n搜索：搜索拍卖行中你正售卖的物品。|n|n额外的，拍卖持续时间将设置为账号共享。"
L["If checked, alert frames will not be shown."] = "勾选后，通知提示框体不再显示。"
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾选后，当你访问商贩时将自动出售背包中的杂物。|n|n当你访问时按住Shift键，可以暂时忽略该功能。"
L["If checked, available quests will be accepted automatically."] = "勾选后，你将自动接受可用的任务。"
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "勾选后，信息窗口的边框会更改为蓝色（右方）或者红色（敌方）。"
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "勾选后，战网好友申请会自动屏蔽。|n|n启用后，当前待处理的申请会自动拒绝。"
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "勾选后，聊天窗口的按钮会被隐藏。|n|n点击窗口标签会自动显示最新的消息。|n|n使用鼠标滚轮可以查看历史消息。按住SHIFT进行消息页面跳转，按住CTRL将滚动至消息页首/页尾。"
L["If checked, chat text will not fade out after a time period."] = "勾选后，聊天信息不会在一定时间后淡出。"
L["If checked, class coloring will be used in the player frame and target frame."] = "勾选后，将在玩家与目标框体显示职业颜色。"
L["If checked, class colors will be used in the chat frame."] = "勾选后，职业颜色将应用于聊天窗口。"
L["If checked, class icons will be shown in the portrait frames."] = "勾选后，玩家的头像会替换为职业图标。"
L["If checked, completed quests will be turned-in automatically."] = "勾选后，已完成的任务会自动提交。"
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "勾选后，当你选择Roll点或者想要出售/邮寄一个可交易物品时，不再显示确认信息。"
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "勾选后，冷却计时数字不再显示。|n|n如果未勾选，在界面-动作条中启用冷却计时后，在相关的冷却中的法术图标会显示计时数字。"
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "勾选后，在玩家头像和宠物头像上的伤害及治疗数字不再显示。"
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "勾选后，对锁定的聊天窗口进行拖动，会使其竖直拉伸。|n|n对已解锁的聊天窗口进行拖动，会使其移动。"
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "勾选后，对于非好友和非公会成员的决斗信息会被屏蔽。"
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "勾选后，当你休息或处于黑铁酒吧时，禁用表情音效。|n|n在其他状态下，将恢复表情音效。"
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "勾选后，敌对姓名板会在战斗中自动开启，离开战斗后关闭。"
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "勾选后，自动邀请将仅限于好友及公会成员。|n|n如果未勾选，组队邀请将面向所有人。"
L["If checked, guild names will be shown.  Guild ranks will also be shown for players in your guild."] = "勾选后，将显示其公会名字。如果玩家和你处于同一公会，将同时显示其公会会阶。"
L["If checked, helm and cloak toggle checkboxes will be shown in the character sheet.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "勾选后，会在角色面板显示头盔及披风的开关复选框。|n|n你可以按住Shift键的同时，右键点击复选框切换排列。"
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "勾选后，除了部分特殊提示，大部分的错误信息（例如怒气不足）都不再显示。|n|n如果你启用了小地图按钮，你可以按住CTRL+鼠标右键来单独控制错误信息的开关。"
L["If checked, nude and tabard toggle buttons will be added to the dressup frame and model rotation controls will be removed."] = "勾选后，脱装及战袍切换按钮会显示在试衣间。同时将移除模型旋转控制按钮。"
L["If checked, party invitations from friends or guild members will be automatically accepted."] = "勾选后，自动接受来自好友及公会成员的组队邀请。"
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "勾选后，对于非好友和非公会成员的组队邀请会被屏蔽。"
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting.|n|nRepeatable battlemaster and cloth quartermaster quests can be automatically selected by holding down the alt key."] = "勾选后，将自动选择，接受并交付任务。 |n|n具有金币需求的任务不会自动上交。 |n|n与任务提供者交谈时，可以按住Shift键以覆写此设置。 |n|n通过按住alt键，可以自动选择重复的战斗大师和布料军需官任务。"
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "勾选后，团队和副本聊天信息会改为蓝色（与小队一致）。"
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat."] = "勾选后，当你不处于战斗中时，会自动接受他人对你的复活。"
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "勾选后，在Buff框体和目标头像下方的相关法术图标的鼠标提示框中，会显示它们的法术ID。"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "勾选后，会禁用聊天频道的粘滞。|n|n此选项不会影响临时对话窗口。"
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "勾选后，当你不处于战斗状态时会自动接受召唤。"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "勾选后，插件列表（游戏菜单处）会显示默认的对角色生效的插件。"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "勾选后，自动拾取的耗时将会明显降低。"
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "勾选后，背包及银行的整理按钮不再显示。"
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "勾选后，打开团队信息的按钮会显示在左侧团队管理框体的上方，而不是在其内部。|n|n此选项让你无需打开团队管理框体，就可以切换团队框体。"
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "勾选后，战斗记录会被隐藏。|n|n战斗记录窗口必须未被分离时才能生效。|n|n如果战斗记录窗口被分离了，你可以拖动其合并至主窗口（然后重载插件），或者在聊天设置中重置设置。"
L["If checked, the editbox will be moved to the top of the chat frame."] = "勾选后文本框会被移动至聊天窗口上方。"
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "勾选后，将关闭死亡后的灵魂世界特效和渐隐时的特殊光效。"
L["If checked, the main bar gryphons will not be shown."] = "勾选后，动作条两边的狮鹫不再显示。"
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "勾选后，会在行囊图标处显示剩余背包空间。"
L["If checked, the player frame background will be shown in class color."] = "勾选后，玩家头像面板的背景将用职业颜色染色。"
L["If checked, the professions frame will be larger."] = "勾选后，将拓展专业面板。"
L["If checked, the quest log frame will be larger and feature a world map button and quest levels."] = "勾选后，将增大任务日志窗口，同时显示任务等级，并添加一个显示地图的按钮。"
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "勾选后，屏幕泛光会被禁用。|n|n启用这个选项的同时，也会关闭醉酒时的泛光效果。"
L["If checked, the skill trainer frame will be larger."] = "勾选后，技能训练面板会进行拓展。"
L["If checked, the stance bar will not be shown."] = "勾选后，姿态条不再显示。"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "勾选后，对话面板不再显示。|n|n当NPC与你交流时，该框体通常出现在界面下方。"
L["If checked, the target frame background will be shown in class color."] = "勾选后，目标头像面板的背景将用职业颜色染色。"
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "勾选后，鼠标信息会被着色，你可以设置他的布局和大小尺寸。"
L["If checked, the vendor price will be shown in item tooltips."] = "勾选后，将在物品的鼠标提示中显示其卖价。"
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "勾选后，小地图的区域信息会被隐藏。追踪按钮的提示信息里会显示区域信息。"
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "勾选后，缩放按钮会被隐藏。你可以使用鼠标滚来来对小地图进行缩放。"
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "勾选后，目标的信息窗口在战斗中会被隐藏。|n|n你可以按住SHIFT键暂时忽略这个设置。"
L["If checked, unit targets will be shown."] = "勾选后，目标的目标会显示在信息窗口上。"
L["If checked, Wowhead links will be shown above the quest log frame."] = "勾选后，将在任务窗口中显示相应的Wowhead链接。"
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip item.|n|nIf the gossip item type is banker, taxi, trainer or vendor, gossip will be skipped without needing to hold the alt key.  You can hold the shift key down to prevent this."] = "勾选后，对于只有一个选项的对话窗口，你可以按住ALT键进行自动交互。|n|n如果目标是银行管理员、飞行管理员、训练师或者商贩，无需按住ALT键即可自动跳过。|n|n你可以按住SHIFT键忽略该次交互。"
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "勾选后，你可以按住CTRL键，点击聊天标签来打开相应的历史记录窗口，以供复制。"
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "勾选后，你可以使用CTRL+Z来打开Leatrix Plus。"
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "勾选后，你可以使用方向键移动文本框中的光标。|n|n如果未被勾选，方向键将保持它所绑定的按键功能。"
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "勾选后，你无需确认即可快速跳过过场短片。"
L["If checked, you will be able to change the font size of book text."] = "勾选后，你可以调整文本字体的大小。"
L["If checked, you will be able to change the font size of quest text."] = "勾选后，你可以调整任务文本的字体大小。"
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "勾选后，你可以更改邮件文本的字体大小。|n|n这个选项不会影响系统邮件模版（例如拍卖行的收据信息）。"
L["If checked, you will be able to change the position and scale of the buffs frame."] = "勾选后，你可以修改Buff框体的位置和缩放。"
L["If checked, you will be able to change the position and scale of the following frames:|n|n- Player frame|n- Target frame|n- Widget top center frame|n- Timer bar"] = "勾选后，你可以改变下列框体的位置和缩放：|n|n- 玩家框体|n- 目标框体|n- 顶部信息条|n- 计时条"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "勾选后，你会生成一个画面视口，这个可以在游戏界面周围增加黑色的边框背景。|n|n边框的层级是处于游戏界面和插件之间，所以你仍可以放置插件元素在上面。"
L["If checked, you will be able to customise the minimap."] = "勾选后，你可以开启小地图相关的自定义选项。"
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "勾选后，你可以把聊天窗口拖动到屏幕边缘。"
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "勾选后，你可以在目标框体上方监控至多5个的法术监控。"
L["If checked, you will be able to reposition the tooltip."] = "勾选后，你可以重新给鼠标提示框设置锚点。"
L["If checked, you will be able to set the density of weather effects."] = "勾选后，你可以调整天气密度。"
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "勾选后，会在玩家框体显示稀有、精英或者稀有精英的边框。"
L["If checked, you will be able to zoom out to a greater distance."] = "勾选后，你可以加大镜头的缩放距离。"
L["If checked, you will need to hold the shift key down for quests to be automated.|n|nIf unchecked, holding shift will prevent quests from being automated."] = "勾选后，你可以按住Shift键来实现自动任务交互。|n|n如果未勾选，按住Shift键则停止自动任务交互。"
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "勾选后，当你在战场中阵亡时会自动进行释放。|n|n如果你有复生能力，则不会进行自动释放。"
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "勾选后，当你打开商贩、银行或者邮箱时，背包不会自动开启或者关闭。"
L["If checked, your character will automatically stand or dismount when an action is prevented because you are either seated or mounted."] = "勾选后，你的角色会根据当前需求自动站立或者解除坐骑。"
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "勾选后，你的聊天历史记录会增涨至4096行。如果未被勾选，会保持在默认的128行。|n|n启用这个设置可能会在登录时会隐藏一些聊天信息。"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾选后，当你打开一个可供修理的商贩时，会自动修理身上的装备。|n|n当你打开商贩时，按住SHIFT键会让你当下忽略此项功能。"
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "勾选后，区域文本不再显示。"
L["Increase chat history"] = "增加聊天历史记录"
L["Interface"] = "界面设置"
L["Invaders of Alterac Valley"] = "奥特兰克的入侵者"
L["Invalid console variable."] = "无效控制台缓存。"
L["Invalid parameter."] = "无效参数"
L["Invalid quest ID."] = "无效的任务ID。"
L["Invalid sound ID"] = "无效的声音ID"
L["Invalid taint level."] = "无效的污染等级。"
L["Invalid target."] = "无效目标。"
L["Invite from whispers"] = "密语邀请"
L["Kalimdor"] = "卡利姆多"
L["Keyword"] = "关键词"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "下次登出时不会清空LeatrixPlus的插件缓存。"
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "警告：你使用了错误的LeatrixPlus插件版本。"
L["Left"] = "左边"
L["Lifetime honorable kills"] = "荣誉击杀总数"
L["Loch Modan"] = "洛克莫丹"
L["Lockout sharing"] = "成就共享锁定"
L["Low"] = "低"
L["Magic"] = "主题：魔法"
L["Main Titles"] = "主题音乐"
L["Manage buffs"] = "Buff框体管理"
L["Manage frames"] = "管理框体面板"
L["Manage tooltip"] = "鼠标信息窗口"
L["Managed by Leatrix Plus"] = "LeatrixPlus托管"
L["Map"] = "地图"
L["Maraudon"] = "玛拉顿"
L["Max camera zoom"] = "最大镜头距离"
L["Mechanics"] = "特性设置"
L["Media"] = "媒体"
L["Medium"] = "中"
L["Memory Usage"] = "内存占用"
L["message shown."] = "信息显示。"
L["messages shown."] = "信息显示。"
L["Missing console variable."] = "丢失控制台缓存。"
L["Missing mount name."] = "坐骑名字缺失。"
L["Missing movie ID."] = "影片编号不存在。"
L["Missing quest ID."] = "缺少任务ID。"
L["Missing sound file parameter."] = "缺失音频文件参数"
L["Missing sound ID."] = "缺少声音ID。"
L["Molten Core"] = "熔火之心"
L["Moonglade"] = "月光林地"
L["Mount not found."] = "无法找到该坐骑。"
L["Move editbox to top"] = "把文本框移动上方"
L["Movie not playable."] = "无法播放该影片。"
L["Movie number"] = "影片编号"
L["Movies"] = "电影"
L["Mulgore"] = "莫高雷"
L["Music"] = "音乐"
L["Musical Moments"] = "音乐主题时刻"
L["Mystery"] = "主题：神秘"
L["Narration"] = "旁白"
L["Naxxramas"] = "纳克萨玛斯"
L["No bad sound IDs found."] = "没有发现损坏的ID。"
L["No help is available for this page."] = "此页面没有帮助信息。"
L["No items with durability equipped."] = "尚未装备任何带有耐久度的物品。"
L["No media duplicates found."] = "没有发现媒体的副本。"
L["No tooltip showing."] = "目前没有任何提示信息。"
L["None"] = "无"
L["Not completed."] = "未完成。"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "注意！|n你必须重新启动游戏客户端才可以正确加载新版本的Leatrix Plus。"
L["Nude"] = "隐藏着装"
L["Onyxia's Lair"] = "奥妮克希亚的巢穴"
L["or click the minimap button to open Leatrix Plus."] = "或点击小地图按钮打开Leatrix Maps。"
L["Orgrimmar"] = "奥格瑞玛"
L["Overall"] = "总计"
L["Overlay"] = "边框"
L["Particle density"] = "粒子密度"
L["Party from friends"] = "好友组队邀请"
L["Pet"] = "宠物"
L["Player"] = "玩家框体"
L["Power"] = "能量"
L["Press CTRL/C to copy."] = "按住CTRL+C复制"
L["Queue from friends"] = "好友队列申请"
L["R"] = "团本"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "团队副本"
L["Raid frame toggle"] = "切换团队框体"
L["Random"] = "随机"
L["RARE"] = "稀有"
L["RARE ELITE"] = "稀有精英"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼泽"
L["Recent chat window"] = "临时聊天窗口"
L["Redridge Mountains"] = "赤脊山"
L["Release in PvP"] = "PvP自动释放尸体"
L["Reload"] = "重载插件"
L["Remember Alterac Valley!"] = "铭记奥特兰克！"
L["Repair automatically"] = "自动修理装备"
L["Repaired for"] = "修理花费"
L["Reposition the tooltip"] = "重设提示框锚点"
L["Require shift key for quest automation"] = "按住Shift键以自动任务交互"
L["Requires UI reload."] = "需要重载插件"
L["Reset"] = "重置"
L["Resize book text"] = "文本字体调整"
L["Resize mail text"] = "重设邮件文本"
L["Resize quest text"] = "重设任务文本"
L["Resize Screen"] = "屏幕缩放"
L["Rested bubbles"] = "休息气泡信息"
L["Restrict to friends and guild members"] = "仅限好友及公会成员"
L["result"] = "结果"
L["results"] = "结果"
L["Right"] = "右边"
L["Right-click to close"] = "右键关闭"
L["Right-click to close."] = "右键点击关闭。"
L["right-click to go back"] = "右键点击返回"
L["Ruins of Ahn'Qiraj"] = "安其拉废墟"
L["Sacred"] = "主题：恐怖"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "沙怒、碎颅和血顶硬币"
L["Scale"] = "尺寸"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通灵学院"
L["Search"] = "搜索"
L["Searing Gorge"] = "灼热峡谷"
L["Select the settings that you want to use."] = "选择你想启用的设置。"
L["Selection of music tracks"] = "音乐列表的选择"
L["Self Markers Allowed"] = "允许自我标记"
L["Self Markers Blocked"] = "屏蔽自我标记"
L["Sell junk automatically"] = "自动出售杂物"
L["SELLING JUNK"] = "出售杂物"
L["Set weather density"] = "调整天气密度"
L["Settings"] = "设置"
L["Shaders"] = "阴影"
L["Shadowfang Keep"] = "影牙城堡"
L["Shardtooth E'ko"] = "碎齿魂精"
L["Show auction controls"] = "显示拍卖行控制"
L["Show bag search box"] = "显示背包搜索框"
L["Show character addons"] = "显示角色插件"
L["Show cooldowns"] = "显示冷却计时"
L["Show durability status"] = "显示耐久度"
L["Show free bag slots"] = "显示背包剩余空间"
L["Show guild names"] = "显示公会名字"
L["Show minimap button"] = "显示小地图按钮"
L["Show player chain"] = "显示玩家边框"
L["Show player frame in class color"] = "玩家头像职业染色"
L["Show target frame in class color"] = "目标头像职业染色"
L["Show the spell ID in buff icon tooltips"] = "显示法术ID"
L["Show unit targets"] = "显示单位目标"
L["Show vanity controls"] = "显示模型控制"
L["Show vendor price"] = "显示物品卖价"
L["Show volume slider"] = "显示音量控制"
L["Show Wowhead links"] = "显示wowhead链接"
L["Silence rested emotes"] = "表情禁音"
L["Silithus"] = "希利苏斯"
L["Silverpine Forest"] = "银松森林"
L["Social"] = "社交信息"
L["Sold junk for"] = "杂物出售总计"
L["Sound system restarted."] = "声音系统已重启。"
L["Spell ID"] = "法术ID"
L["Spooky"] = "主题：阴森"
L["Stand and dismount"] = "站立和解除坐骑"
L["Stockade"] = "暴风城监狱"
L["Stonetalon Mountains"] = "石爪山脉"
L["Stop"] = "停止"
L["Stormwind"] = "暴风城"
L["Stranglethorn Vale"] = "荆棘谷"
L["Stratholme"] = "斯坦索姆"
L["Sunken Temple"] = "沉没的神庙"
L["Support"] = "帮助支持"
L["Swamp"] = "主题：沼泽"
L["Swamp of Sorrows"] = "悲伤沼泽"
L["System"] = "系统设置"
L["Tabard"] = "隐藏战袍"
L["Taint level: Basic (1)."] = "污染等级：基本(1)。"
L["Taint level: Disabled (0)."] = "污染等级：禁用(0)。"
L["Taint level: Full (2)."] = "污染等级：全面(2)。"
L["Tanaris"] = "塔纳利斯"
L["Target"] = "目标框体"
L["Target Tracking Disabled"] = "禁用目标追踪"
L["Target Tracking Enabled"] = "启用目标追踪"
L["Teldrassil"] = "泰达希尔"
L["Temple of Ahn'Qiraj"] = "安其拉神殿"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神庙"
L["Ten Years of Warcraft"] = "魔兽十周年"
L["Text"] = "文本信息"
L["Text size"] = "字体尺寸"
L["Text Size"] = "字体尺寸"
L["The summon from"] = "召唤来自"
L["Themes"] = "主题"
L["This panel will close automatically if you enter combat."] = "此面板在你进入战斗后自动关闭。"
L["Thousand Needles"] = "千针石林"
L["Timer"] = "计时框体"
L["Tirisfal Glades"] = "提瑞斯法林地"
L["To begin, choose an options page."] = "请选择一项开始使用"
L["To use the Find Item button, you need to deselect the WoW Token category."] = "你必须取消魔兽货币分类以启用寻找物品的按钮。"
L["Tooltip"] = "鼠标信息窗口"
L["Tooltip title color"] = "鼠标提示信息颜色"
L["Top"] = "顶部"
L["Top Center"] = "顶级中心"
L["Tracing started."] = "追踪开始。"
L["Tracing stopped."] = "追踪停止。"
L["Transparency"] = "透明度"
L["True"] = "正确"
L["Turn-in completed quests automatically"] = "自动提交任务"
L["Uldaman"] = "奥达曼"
L["Unclamp chat frame"] = "不限制窗口位置"
L["Undercity"] = "幽暗城"
L["Un'Goro Crater"] = "安戈洛环形山"
L["Universal group color"] = "统一队伍颜色"
L["Use arrow keys in chat"] = "允许使用方向键"
L["Use class colors in chat"] = "聊天窗口启用职业颜色"
L["Use easy resizing"] = "使用简单拉伸"
L["Value must be a number."] = "该参数必须为数字。"
L["Various"] = "其他"
L["Vendors"] = "商贩"
L["Version"] = "版本"
L["Very Low"] = "低"
L["Video"] = "视频"
L["Visibility"] = "可见性"
L["Wailing Caverns"] = "哀嚎洞穴"
L["was automatically declined."] = "已经自动拒绝。"
L["Weather density"] = "天气密度"
L["Welcome to Leatrix Plus."] = "欢迎使用Leatrix Plus"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "湿地"
L["Widget"] = "窗口小部件"
L["Wildkin E'ko"] = "枭兽魂精"
L["will be automatically accepted in 10 seconds unless cancelled."] = "除非取消否则将会在10秒内自动接受。"
L["Winter"] = "冬日"
L["Winterfall E'ko"] = "寒水魂精"
L["Winterspring"] = "冬泉谷"
L["World of Warcraft"] = "魔兽世界"
L["X Offset"] = "横向偏移"
L["Y Offset"] = "纵向偏移"
L["YOU"] = "你"
L["You cannot do that in combat."] = "你无法在战斗中进行该项操作。"
L["You have"] = "你有"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "你需要进行重载插件后才能使部分设置生效。|n|n你无需立即点击重载插件按钮，但是你完成设置并希望其生效时，必须点击它。"
L["Your UI needs to be reloaded."] = "你的插件需要重新载入。"
L["Zones"] = "区域"
L["Zul'Farrak"] = "祖尔法拉克"
L["Zul'Gurub"] = "祖尔格拉布"
L["Zulian, Razzashi, and Hakkari Coins"] = "祖利安、拉扎什和哈卡莱硬币"
L["Zygor addon not found."] = "你尚未安装Zygor插件。"

end

-- zhTW: Traditional Chinese (Taiwan)
if GameLocale == "zhTW" then
L["+"] = "+"
L["A Donation of Mageweave"] = "捐獻魔紋布"
L["A Donation of Runecloth"] = "捐獻符文布"
L["A Donation of Silk"] = "捐獻絲綢"
L["A Donation of Wool"] = "捐獻毛料"
L["A friend request from"] = "你有一個好友申請，來自"
L["Accept resurrection"] = "自動接受復活"
L["Accept summon"] = "自動接受召喚"
L["Additional Runecloth"] = "更多的符文布"
L["Addon"] = "插件"
L["Ahn'Qiraj"] = "安其拉"
L["Alterac Mountains"] = "奧特蘭克山脈"
L["Anchor"] = "定位點"
L["Angelic"] = "天使"
L["Arathi Highlands"] = "阿拉希高地"
L["Ashenvale"] = "梣谷"
L["Auto loot is now enabled."] = "自動拾取現在已啟動。"
L["AutoFollow"] = "自動跟隨"
L["AutoFollow disabled."] = "自動跟隨已停用。"
L["Automate gossip"] = "自動對話"
L["Automate quests"] = "任務自動化"
L["Automation"] = "自動化"
L["Azshara"] = "艾薩拉"
L["Back to Main Menu"] = "返回"
L["Bad ID"] = "損壞的ID"
L["Badlands"] = "荒蕪之地"
L["Barrens"] = "南貧瘠之地"
L["Battle"] = "戰爭"
L["Battle of Warsong Gulch"] = "峽谷之戰"
L["Battlegrounds"] = "戰場"
L["Blackfathom Deeps"] = "黑澗深淵"
L["Blackrock Depths"] = "黑石深淵"
L["Blackwing Lair"] = "黑翼之巢"
L["Blasted Lands"] = "詛咒之地"
L["Block duels"] = "拒絕決鬥"
L["Block friend requests"] = "封鎖好友邀請"
L["Block party invites"] = "封鎖隊伍邀請"
L["Blocks"] = "封鎖"
L["Bottom"] = "底部"
L["Buffs"] = "增益"
L["Burning Steppes"] = "燃燒平原"
L["Buyout Only"] = "僅限直購價"
L["C"] = "披"
L["Camera distance"] = "鏡頭距離"
L["Chain style"] = "邊框樣式"
L["Character"] = "角色"
L["Chat"] = "聊天功能"
L["Chat Frame"] = "聊天視窗"
L["Checkbox labels are Ok."] = "複選框標籤是OK的。"
L["Chillwind E'ko"] = "冰風魂精"
L["Cinematics"] = "過場動畫"
L["Claiming Arathi Basin"] = "資源競賽"
L["Class colored frames"] = "框架職業染色"
L["Class icon portraits"] = "職業圖示頭像"
L["Classic"] = "經典"
L["click here for new selection"] = "點擊這裡跳轉新選擇"
L["Click to configure the settings for this option."] = "點擊進行額外的選項設置"
L["Click to reset the settings on this page."] = "點擊重置此頁面的設置。"
L["Click to resize the screen to fit between the top and bottom borders."] = "點擊來重設螢幕大小以適配上下邊框。"
L["Click to return to the main menu."] = "點擊返回到主選單"
L["Cloak"] = "披風"
L["Color the backdrops based on faction"] = "根據陣營著色邊框"
L["Combat log cannot be hidden while undocked."] = "戰鬥記錄視窗被分離時無法隱藏。"
L["Combat plates"] = "自動開關姓名板"
L["Completed."] = "已完成。"
L["Concerted Efforts"] = "共同的努力"
L["Configuration Panel"] = "設置面板"
L["Connections for"] = "連結在"
L["Conquering Arathi Basin"] = "戰爭的動力"
L["Credits"] = "有功人員"
L["Cursor"] = "鼠標"
L["Cursor Left"] = "鼠標左側"
L["Cursor Right"] = "鼠標右側"
L["Customise minimap"] = "自定義小地圖"
L["D"] = "地城"
L["Darkmoon Faire"] = "暗月馬戲團"
L["Darkshore"] = "黑海岸"
L["Deadmines"] = "死亡礦坑"
L["Deadwind Pass"] = "逆風小徑"
L["Desolace"] = "淒涼之地"
L["Dire Maul"] = "厄運之槌"
L["Disable bag automation"] = "停用背包自動開啟"
L["Disable chat fade"] = "停用聊天視窗淡出"
L["Disable loot warnings"] = "停用拾取通報"
L["Disable screen effects"] = "停用螢幕特效"
L["Disable screen glow"] = "停用螢幕光暈"
L["Disable sticky chat"] = "停用聊天頻道粘附"
L["Drag the frame overlay to position the frame."] = "拖曳框架的遮罩以定位此框架。"
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "移動面板來定位框架。|n|n如果想要改變框架尺寸，你需選定面板，然後移動滑塊來選擇。|n|n你一旦進入戰鬥，這個框架會自動關閉。"
L["Drag to set the cursor X offset."] = "拖拉來設置鼠標水平偏移量。"
L["Drag to set the cursor Y offset."] = "拖拉來設置鼠標垂直偏移量。"
L["Drag to set the density of weather effects."] = "拖動來設定天氣效果的密度。"
L["Drag to set the font size of book text."] = "拖拉來設定書籍文字大小。"
L["Drag to set the font size of mail text."] = "拖動以設置郵件文字的字體大小。"
L["Drag to set the font size of quest text."] = "拖動以設置任務文字的字體大小。"
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "拖洞已設置小地圖縮放比例。|n|n注意如果您使用預設動作列，重新縮放小地圖也會在啟動時重新縮放右側動作列，因此您可能希望將其保留為100％。"
L["Drag to set the scale of the Leatrix Plus panel."] = "拖動以設置Leatrix Plus面板的縮放比例。"
L["Drag to set the scale of the selected frame."] = "拖動以設置所選框架的縮放比例。"
L["Drag to set the size of the bottom border."] = "拖動以設置底部邊框的大小。"
L["Drag to set the size of the left border."] = "拖動以設置左側邊框的大小。"
L["Drag to set the size of the right border."] = "拖動以設置右側邊框的大小。"
L["Drag to set the size of the top border."] = "拖動以設置頂部邊框的大小。"
L["Drag to set the tooltip scale."] = "拖動以設置工具提示的縮放比例。"
L["Drag to set the transparency of the borders."] = "拖動以設置邊框的透明度。"
L["Drag to set the transparency of the Leatrix Plus panel."] = "拖動以設置Leatrix Plus面板的透明度。"
L["Dun Morogh"] = "丹莫洛"
L["Dungeons"] = "地下城"
L["Dup ID"] = "重複的ID"
L["durability"] = "耐久度"
L["Durability"] = "耐久度"
L["Durotar"] = "杜洛塔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "塵泥沼澤"
L["Eastern Kingdoms"] = "東部王國"
L["Eastern Plaguelands"] = "東瘟疫之地"
L["ELITE"] = "精英"
L["Elwynn Forest"] = "艾爾文森林"
L["Enable hotkey"] = "啟用熱鍵"
L["Enable viewport"] = "啟用視窗背景"
L["Enhance dressup"] = "增強試衣間"
L["Enhance professions"] = "增強專業"
L["Enhance quest log"] = "增強任務日誌"
L["Enhance trainers"] = "加強技能訓練"
L["Enhancements"] = "增強功能"
L["Enter"] = "進入"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "輸入您要查看的冷卻圖示的法術ID。|n|n如果想要寵物框架下正常出現冷卻圖示，請選中寵物複選框。|n|n冷卻圖示會依據您的職業保存。"
L["enter zone or track name"] = "輸入區域或曲目名稱"
L["Error messages will be hidden"] = "錯誤訊息將會隱藏"
L["Error messages will be shown"] = "錯誤訊息將會顯示"
L["Events"] = "事件"
L["Extras"] = "其他"
L["False"] = "虛假"
L["Faster auto loot"] = "加速自動拾取"
L["Faster movie skip"] = "快速動畫跳過"
L["Features"] = "功能"
L["Felwood"] = "費伍德森林"
L["Feralas"] = "菲拉斯"
L["Fight for Warsong Gulch"] = "自然屏障"
L["Find Item"] = "搜尋物品"
L["For Great Honor"] = "無上的榮耀"
L["Frames"] = "框架相關"
L["Frostmaul E'ko"] = "霜槌魂精"
L["Frostsaber E'ko"] = "霜刃魂精"
L["Game Options"] = "游戲設置"
L["Ghost"] = "靈魂狀態框架"
L["Gloomy"] = "黑暗"
L["Gnomeregan"] = "諾姆瑞根"
L["Gold Only"] = "僅輸入金幣"
L["Graphics and Sound"] = "圖形和音效"
L["Groups"] = "隊伍"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "古拉巴什、邪枝和枯木硬幣"
L["H"] = "頭"
L["Haunted"] = "鬧鬼的"
L["Helm"] = "頭盔"
L["Help"] = "幫助"
L["Hide chat buttons"] = "隱藏聊天視窗按鈕"
L["Hide cooldown duration numbers (if enabled)"] = "隱藏冷卻持續時間數字(如果啟用)"
L["Hide error messages"] = "隱藏錯誤訊息"
L["Hide gryphons"] = "隱藏動作條獅鷲"
L["Hide portrait numbers"] = "隱藏頭像數字"
L["Hide stance bar"] = "隱藏姿態條"
L["Hide the combat log"] = "隱藏戰鬥記錄視窗"
L["Hide the zone text bar"] = "隱藏區域文字列"
L["Hide the zoom buttons"] = "隱藏縮放按紐"
L["Hide tooltips for world units during combat"] = "戰鬥中隱藏視窗"
L["Hide zone text"] = "隱藏區域文字"
L["High"] = "高"
L["Hillsbrad Foothills"] = "希爾斯布萊德丘陵"
L["Hinterlands"] = "辛特蘭"
L["Home"] = "首頁"
L["Ice Thistle E'ko"] = "冰草魂精"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "勾選後，背包搜尋框會顯示在背包與銀行視窗上。"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "勾選後，一個按鈕會顯示在角色框架，其鼠標提示訊息會顯示身上的裝備耐久度。|n|n當你死後，你的整體耐久度也會顯示在聊天框架。"
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "勾選後，只要你還沒組隊、或是隊伍領隊或團隊助理，所有密語你設定好的關鍵字的人將會收到隊伍邀請。"
L["If checked, a master volume slider will be shown in the character sheet."] = "勾選後，主要聲道的調整滑桿將出現在角色視窗。"
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "勾選後，小地圖按鈕將可使用。|n|n點擊 - 切換選項面板。|n|nShift+左鍵點擊 - 切換音樂。|n|nCTRL+右鍵點擊 - 切換錯誤顯示(如果可用)。|n|nCTRL+SHIFT+左鍵點擊 - 切換Zygor(如果有安裝)。|n|nCTRL+SHIFT+右鍵點擊 - 切換視窗模式。"
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "勾選後，拍賣場將加入額外功能。|n|n僅限直購 - 在不填寫起始價格的情況下建立直購拍賣。|n|n僅限金幣 - 將銅和銀價格定在99，以加快新的拍賣。|n|n搜尋物品 - 在拍賣行搜尋您正在銷售的商品。|n|n除此以外，拍賣持續時間設置將保存為帳戶通用。"
L["If checked, alert frames will not be shown."] = "勾選後，警告框架將不會顯示。"
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾選後，當你訪問商販時將自動出售背包中的垃圾。|n|n當你訪問時按住Shift鍵，可以暫時忽略該功能。"
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "勾選後，訊息視窗的邊框會更改為藍色（友方）或者紅色（敵方）。"
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "勾選後，戰網好友邀請會自動拒絕。|n|n啟用後，當前待處理的邀請會自動拒絕。"
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "勾選後，聊天視窗的按鈕會被隱藏。|n|n點擊視窗標簽會自動顯示最新的消息。|n|n使用鼠標滾輪可以查看歷史訊息。按住SHIFT進行訊息頁面跳轉，按住CTRL將滾動至訊息頁首/頁尾。"
L["If checked, chat text will not fade out after a time period."] = "勾選後，聊天訊息不會在一定時間後淡出。"
L["If checked, class coloring will be used in the player frame and target frame."] = "勾選後，玩家與目標框架將使用職業著色。"
L["If checked, class colors will be used in the chat frame."] = "勾選後，聊天框架將使用職業著色。"
L["If checked, class icons will be shown in the portrait frames."] = "勾選後，職業圖示會顯示在頭像框架。"
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "勾選後，當你選擇一個擲骰選項或是試圖出售或郵寄可交易物品將不再確認。"
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "勾選後，冷卻持續時間數字將不顯示在冷卻上。|n|n取消勾選後，冷卻持續時間數字將會顯示在冷卻上如果已在遊戲選項面板中啟用('動作條'選單)。"
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "勾選後，在玩家頭像和寵物頭像上的傷害及治療數字不再顯示。"
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "勾選後，對鎖定的聊天視窗進行拖動，會使其豎直拉伸。|n|n對已解鎖的聊天視窗進行拖動，會使其移動。"
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "勾選後，對於非好友與公會成員的決鬥請求會被封鎖。"
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "勾選後，當您的角色在黑鐵酒吧休息時表情音效將靜音。|n|n其他所有時間都會啟用表情音效。"
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "勾選後，敵對姓名板會在戰鬥中自動開啟，離開戰鬥後關閉。"
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "勾選後，組隊邀請將只發送到好友以及公會成員。|n|n如未勾選，隊伍邀請將會發送到每個人。"
L["If checked, guild names will be shown.  Guild ranks will also be shown for players in your guild."] = "勾選後，公會名稱將會顯示。在您公會中的玩家也會顯示公會會階。"
L["If checked, helm and cloak toggle checkboxes will be shown in the character sheet.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "勾選後，角色視窗會顯示頭盔與披風切換複選框。|n|n您可以按住Shift以及右鍵點擊複選框來切換布局。"
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "勾選後，大部分錯誤訊息將不顯示(像是'沒有足夠的怒氣')。部分重要錯誤將排除在外。|n|n如果你有啟用小地圖按鈕，你可以按下CTRL+右鍵來切換錯誤訊息的顯示而不管此設置。"
L["If checked, nude and tabard toggle buttons will be added to the dressup frame and model rotation controls will be removed."] = "勾選後，裸體與外袍切換顯示按鈕將加入試衣視窗，並且模型旋轉控制鈕將被移除。"
L["If checked, party invitations from friends or guild members will be automatically accepted."] = "勾選後，來自好友或公會成員的隊伍邀請會自動接受。"
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "勾選後，對於非好友與公會成員的組隊邀請會被封鎖。"
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting.|n|nRepeatable battlemaster and cloth quartermaster quests can be automatically selected by holding down the alt key."] = "勾選後，將自動選擇，接受並交付任務。|n|n具有金幣需求的任務不會自動上交。|n|n與任務提供者交談時，可以按住Shift鍵以覆寫此設置。|n|n通過按住alt鍵，可以自動選擇重複的戰鬥大師和布料軍需官任務。"
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "勾選後，團隊和副本聊天訊息會改為藍色（與小隊一致）。"
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat."] = "勾選後，只要復活你的玩家不在戰鬥中，復活請求將被自動接受。"
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "勾選後，位於增益框架與目標框架之下的增益圖標提示會顯示法術ID。"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "勾選後，會停用聊天頻道的粘附。|n|n此選項不會影響臨時視窗的對話。"
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "勾選後，當你不處於戰鬥狀態時會自動接受召喚。"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "勾選後，插件列表（游戲選單處）會顯示預設的對角色生效的插件。"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "勾選後，自動拾取所需的時間將大幅減少。"
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "勾選後，背包及銀行的整理按鈕不再顯示。"
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "勾選後，打開團隊訊息的按鈕會顯示在左側團隊管理框架的上方，而不是在其內部。|n|n此選項讓你無需打開團隊管理框架，就可以切換團隊框架。"
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "勾選後，戰鬥記錄會被隱藏。|n|n戰鬥記錄視窗必須未被分離時才能生效。|n|n如果戰鬥記錄視窗被分離了，你可以拖動其合併至主視窗（然後重載插件），或者在聊天設置中重置設置。"
L["If checked, the editbox will be moved to the top of the chat frame."] = "勾選後輸入框會被移動至聊天視窗上方。"
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "勾選後，死亡後的灰色螢幕以及靈魂世界特效將會停用。"
L["If checked, the main bar gryphons will not be shown."] = "勾選後，動作條兩邊的獅鷲不再顯示。"
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "勾選後，背包的空餘格數會顯示在背包按鈕以及提示上。"
L["If checked, the player frame background will be shown in class color."] = "勾選後，玩家框架背景將會顯示職業顏色。"
L["If checked, the professions frame will be larger."] = "勾選後，專業技能視窗將會放大。"
L["If checked, the quest log frame will be larger and feature a world map button and quest levels."] = "勾選後，任務日誌框架將會加大並配有世界地圖按鈕以及任務等級。"
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "勾選後，螢幕光暈將停用。|n|n啟用此選項同時也停用醉酒霧霾效果。"
L["If checked, the skill trainer frame will be larger."] = "勾選後，專業技能訓練框架將會增大。"
L["If checked, the stance bar will not be shown."] = "勾選後，姿態條不再顯示。"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "勾選後，對話面板不再顯示。|n|n當NPC與你交流時，該框架通常出現在界面下方。"
L["If checked, the target frame background will be shown in class color."] = "勾選後，目標框架背景將會顯示職業顏色。"
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "勾選後，提示訊息會被著色，你可以設置他的佈局和大小尺寸。"
L["If checked, the vendor price will be shown in item tooltips."] = "勾選後，物品提示中將顯示商店售價。"
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "勾選後，區域文字列將隱藏。追蹤按鈕提示將顯示區域資訊。"
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "勾選後，縮放按鈕將隱藏。無論此設置如何，您都可以使用滑鼠滾輪進行縮放。"
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "勾選後，目標的訊息視窗在戰鬥中會被隱藏。|n|n你可以按住SHIFT鍵暫時忽略這個設置。"
L["If checked, unit targets will be shown."] = "勾選後，目標的目標會顯示在訊息視窗上。"
L["If checked, Wowhead links will be shown above the quest log frame."] = "勾選後，任務日誌框架上方會顯示Wowhead連結。"
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip item.|n|nIf the gossip item type is banker, taxi, trainer or vendor, gossip will be skipped without needing to hold the alt key.  You can hold the shift key down to prevent this."] = "勾選後，您可以在打開對話視窗時按住alt鍵以自動選擇單獨的對話選項。如果對話選項類型是銀行，鳥點，訓練師或商店，無需按下alt鍵就會跳過對話。 您可以按住shift鍵以防止這種情況發生。"
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "勾選後，你可以在點擊聊天標籤時按下Ctrl鍵，在易於複製的視窗中查看最近的聊天。"
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "勾選後，你可以透過按下CTRL+Z來開啟Leatrix Plus。"
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "勾選後，你可以使用方向鍵移動聊天框中的輸入點。|n|n如果未被勾選，方向鍵將保持它所綁定的按鍵功能。"
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "勾選後，你可以取消動畫而不經確認。"
L["If checked, you will be able to change the font size of book text."] = "勾選後，您將可以更改書籍中文字的大小。"
L["If checked, you will be able to change the font size of quest text."] = "勾選後，您將可以改變任務文字的字體大小。"
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "勾選後，你可以更改郵件文字的字體大小。|n|n這個選項不會影響使用系統範本的郵件（例如拍賣行的收據訊息）。"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "勾選後，你會生成一個視窗背景，這個可以在游戲界面周圍增加黑色的邊框背景。|n|n邊框的層級是處於游戲界面和插件之間，所以你仍可以放置插件元素在上面。"
L["If checked, you will be able to customise the minimap."] = "勾選後，您將可以自定義小地圖。"
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "勾選後，你可以把聊天視窗拖動到屏幕邊緣。"
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "勾選後，你可以在目標框架上放置最多5個有用的冷卻圖標。"
L["If checked, you will be able to reposition the tooltip."] = "勾選後，您可以重新定位工具提示。"
L["If checked, you will be able to set the density of weather effects."] = "勾選後，您將可以設置天氣效果的密度。"
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "勾選後，會在玩家框架顯示稀有、精英或者稀有精英的邊框。"
L["If checked, you will be able to zoom out to a greater distance."] = "勾選後，你可以將鏡頭拉遠到更遠的距離。"
L["If checked, you will need to hold the shift key down for quests to be automated.|n|nIf unchecked, holding shift will prevent quests from being automated."] = "勾選後，你可以按住Shift鍵來實現自動任務交互。 |n|n如果未勾選，按住Shift鍵則停止自動任務交互。"
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "勾選後，您在戰場死亡時將會自動釋放。|n|n如果您具有自我復活的技能，則不會自動釋放。"
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "勾選後，當你打開商店、銀行或者郵箱時，背包不會自動開啟或者關閉。"
L["If checked, your character will automatically stand or dismount when an action is prevented because you are either seated or mounted."] = "勾選後，當您的動作因為坐下或在坐騎上而被阻止時，您的角色將會自動站立或解除坐騎。"
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "勾選後，你的聊天歷史記錄會增漲至4096行。如果未被勾選，會保持在預設的128行。|n|n啟用這個設置可能會在登錄時會隱藏一些聊天訊息。"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾選後，當你訪問適用的商店時，裝備將自動修理。|n|n當你開啟商店時可以按下Shift鍵以無視此設置。"
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "勾選後，區域文字不再顯示。"
L["Increase chat history"] = "增加聊天歷史記錄"
L["Interface"] = "界面設置"
L["Invaders of Alterac Valley"] = "奧特蘭克的入侵者"
L["Invalid console variable."] = "無效控制台變量。"
L["Invalid parameter."] = "無效參數"
L["Invalid quest ID."] = "無效任務ID。"
L["Invalid sound ID"] = "無效聲音ID"
L["Invalid taint level."] = "無效的汙染等級。"
L["Invalid target."] = "無效的目標。"
L["Invite from whispers"] = "密語邀請"
L["Kalimdor"] = "卡林多"
L["Keyword"] = "關鍵字"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus將會在下次登出時覆寫LeaPlus數據庫。"
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: 安裝了錯誤的版本！"
L["Left"] = "左側"
L["Lifetime honorable kills"] = "榮譽擊殺總數"
L["Loch Modan"] = "洛克莫丹"
L["Lockout sharing"] = "成就共享鎖定"
L["Low"] = "低"
L["Magic"] = "魔法"
L["Main Titles"] = "主標題"
L["Manage frames"] = "管理框架面板"
L["Manage tooltip"] = "管理提示訊息"
L["Managed by Leatrix Plus"] = "由Leatrix Plus管理"
L["Map"] = "地圖"
L["Maraudon"] = "瑪拉頓"
L["Max camera zoom"] = "最大鏡頭縮放"
L["Mechanics"] = "特性設置"
L["Media"] = "音樂"
L["Medium"] = "中"
L["Memory Usage"] = "記憶體占用"
L["message shown."] = "顯示訊息。"
L["messages shown."] = "顯示訊息。"
L["Missing console variable."] = "缺少控制台變量。"
L["Missing mount name."] = "缺少坐騎名稱。"
L["Missing movie ID."] = "缺少動畫ID。"
L["Missing quest ID."] = "缺少任務ID。"
L["Missing sound file parameter."] = "缺少聲音檔案參數。"
L["Missing sound ID."] = "缺少聲音ID。"
L["Molten Core"] = "熔火之心"
L["Moonglade"] = "月光林地"
L["Mount not found."] = "坐騎未找到。"
L["Move editbox to top"] = "輸入框移動至頂部"
L["Movie not playable."] = "動畫不可播放。"
L["Movie number"] = "動畫編號"
L["Movies"] = "動畫"
L["Mulgore"] = "莫高雷"
L["Music"] = "音樂"
L["Musical Moments"] = "音樂時刻"
L["Mystery"] = "秘法"
L["Narration"] = "解說"
L["Naxxramas"] = "納克薩瑪斯"
L["No bad sound IDs found."] = "沒有發現損壞的聲音ID。"
L["No help is available for this page."] = "此頁面沒有幫助訊息。"
L["No items with durability equipped."] = "沒有裝備有耐久度的物品。"
L["No media duplicates found."] = "未找到重複的媒體檔。"
L["No tooltip showing."] = "目前沒有任何提示訊息。"
L["None"] = "無"
L["Not completed."] = "未完成。"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "警示！|n您必須完全重新啟動遊戲客戶端才能使用此版本的Leatrix Plus。"
L["Nude"] = "脫光"
L["Onyxia's Lair"] = "奧妮克希亞的巢穴"
L["or click the minimap button to open Leatrix Plus."] = "或是點擊小地圖按鈕來開啟Leatrix Maps。"
L["Orgrimmar"] = "奧格瑪"
L["Overall"] = "整體"
L["Overlay"] = "覆蓋"
L["Particle density"] = "粒子密度"
L["Party from friends"] = "好友組隊邀請"
L["Pet"] = "寵物"
L["Player"] = "玩家框架"
L["Power"] = "能量"
L["Press CTRL/C to copy."] = "按下CTRL/C來複製。"
L["Queue from friends"] = "好友佇列申請"
L["R"] = "團隊"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "團隊副本"
L["Raid frame toggle"] = "切換團隊框架"
L["Random"] = "隨機"
L["RARE"] = "稀有"
L["RARE ELITE"] = "稀有精英"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼澤"
L["Recent chat window"] = "最近聊天視窗"
L["Redridge Mountains"] = "赤脊山"
L["Release in PvP"] = "PvP自動釋放屍體"
L["Reload"] = "重載插件"
L["Remember Alterac Valley!"] = "銘記奧特蘭克！"
L["Repair automatically"] = "自動修理裝備"
L["Repaired for"] = "修理花費"
L["Reposition the tooltip"] = "重新定位工具提示"
L["Require shift key for quest automation"] = "按住Shift鍵以自動任務交互"
L["Requires UI reload."] = "需要重載插件"
L["Reset"] = "重置"
L["Resize book text"] = "書籍文字大小改變"
L["Resize mail text"] = "重設郵件文字"
L["Resize quest text"] = "重設任務文字"
L["Resize Screen"] = "螢幕縮放"
L["Rested bubbles"] = "休息氣泡訊息"
L["Restrict to friends and guild members"] = "只限於好友與公會成員"
L["result"] = "結果"
L["results"] = "結果"
L["Right"] = "右側"
L["Right-click to close"] = "右鍵點擊來關閉"
L["Right-click to close."] = "右鍵點擊來關閉。"
L["right-click to go back"] = "右鍵點擊返回"
L["Ruins of Ahn'Qiraj"] = "安琪拉廢墟"
L["Sacred"] = "神聖"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "沙怒、劈顱和血頂硬幣"
L["Scale"] = "尺寸"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通靈學院"
L["Search"] = "搜尋"
L["Searing Gorge"] = "灼熱峽谷"
L["Select the settings that you want to use."] = "選擇你想啟用的設置。"
L["Selection of music tracks"] = "選擇的音樂曲目"
L["Self Markers Allowed"] = "允許自身標記"
L["Self Markers Blocked"] = "阻擋自身標記"
L["Sell junk automatically"] = "自動出售垃圾"
L["SELLING JUNK"] = "出售垃圾"
L["Set weather density"] = "設置天氣效果密度"
L["Settings"] = "設置"
L["Shaders"] = "陰影"
L["Shadowfang Keep"] = "影牙城堡"
L["Shardtooth E'ko"] = "碎齒魂精"
L["Show auction controls"] = "顯示拍賣行控制"
L["Show bag search box"] = "顯示背包搜尋框"
L["Show character addons"] = "顯示角色插件"
L["Show cooldowns"] = "顯示冷卻"
L["Show durability status"] = "顯示耐久度"
L["Show free bag slots"] = "顯示背包空餘格數"
L["Show guild names"] = "顯示公會名稱"
L["Show minimap button"] = "顯示小地圖按鈕"
L["Show player chain"] = "顯示玩家邊框"
L["Show player frame in class color"] = "玩家框架顯示職業顏色"
L["Show target frame in class color"] = "目標框架顯示職業顏色"
L["Show the spell ID in buff icon tooltips"] = "在增益圖標提示顯示法術ID"
L["Show unit targets"] = "顯示單位目標"
L["Show vanity controls"] = "顯示外觀控制鍵"
L["Show vendor price"] = "顯示商店售價"
L["Show volume slider"] = "顯示音量控制"
L["Show Wowhead links"] = "顯示Wowhead連結"
L["Silence rested emotes"] = "表情靜音"
L["Silithus"] = "希利蘇斯"
L["Silverpine Forest"] = "銀松森林"
L["Social"] = "社交訊息"
L["Sold junk for"] = "賣出垃圾為"
L["Sound system restarted."] = "聲音系統已重啟。"
L["Spell ID"] = "法術ID"
L["Spooky"] = "幽靈"
L["Stand and dismount"] = "站立與解除坐騎"
L["Stockade"] = "暴風城監獄"
L["Stonetalon Mountains"] = "石爪山脈"
L["Stop"] = "停止"
L["Stormwind"] = "暴風城"
L["Stranglethorn Vale"] = "荊棘谷"
L["Stratholme"] = "斯坦索姆"
L["Sunken Temple"] = "沉沒的神廟"
L["Support"] = "支援"
L["Swamp"] = "沼澤"
L["Swamp of Sorrows"] = "悲傷沼澤"
L["System"] = "系統設置"
L["Tabard"] = "隱藏戰袍"
L["Taint level: Basic (1)."] = "汙染等級：基本(1)"
L["Taint level: Disabled (0)."] = "汙染等級：停用(0)"
L["Taint level: Full (2)."] = "汙染等級：完整(2)"
L["Tanaris"] = "塔納利斯"
L["Target"] = "目標框架"
L["Target Tracking Disabled"] = "停用目標追蹤"
L["Target Tracking Enabled"] = "啟用目標追蹤"
L["Teldrassil"] = "泰達希爾"
L["Temple of Ahn'Qiraj"] = "安琪拉神廟"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神廟"
L["Ten Years of Warcraft"] = "魔獸十周年"
L["Text"] = "文字訊息"
L["Text size"] = "字體尺寸"
L["Text Size"] = "字體尺寸"
L["The summon from"] = "召喚來自"
L["Themes"] = "主題"
L["This panel will close automatically if you enter combat."] = "此面板將在你進入戰鬥後自動關閉。"
L["Thousand Needles"] = "千針石林"
L["Timer"] = "計時框架"
L["Tirisfal Glades"] = "提里斯法林地"
L["To begin, choose an options page."] = "請選擇一個選項開始使用"
L["To use the Find Item button, you need to deselect the WoW Token category."] = "要使用此搜尋物品按鈕，您需要取消選擇WoW的代幣類別"
L["Tooltip"] = "提示訊息"
L["Tooltip title color"] = "鼠標提示訊息顏色。"
L["Top"] = "頂部"
L["Top Center"] = "頂級中心"
L["Tracing started."] = "追蹤已開始。"
L["Tracing stopped."] = "追蹤已停止。"
L["Transparency"] = "透明度"
L["True"] = "真實"
L["Uldaman"] = "奧達曼"
L["Unclamp chat frame"] = "不限制視窗位置"
L["Undercity"] = "幽暗城"
L["Un'Goro Crater"] = "安戈洛環形山"
L["Universal group color"] = "通用的隊伍著色"
L["Use arrow keys in chat"] = "允許使用方向鍵"
L["Use class colors in chat"] = "在聊天中使用職業著色"
L["Use easy resizing"] = "使用簡單拉伸"
L["Value must be a number."] = "值必須為數字。"
L["Various"] = "雜項"
L["Vendors"] = "商店"
L["Version"] = "版本"
L["Very Low"] = "非常低"
L["Video"] = "影像"
L["Visibility"] = "可見性"
L["Wailing Caverns"] = "哀嚎洞穴"
L["was automatically declined."] = "已經自動拒絕。"
L["Weather density"] = "天氣密度"
L["Welcome to Leatrix Plus."] = "歡迎使用Leatrix Plus"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "濕地"
L["Widget"] = "窗口小部件"
L["Wildkin E'ko"] = "梟獸魂精"
L["will be automatically accepted in 10 seconds unless cancelled."] = "除非取消否則將會在10秒內自動接受。"
L["Winter"] = "寒冬"
L["Winterfall E'ko"] = "寒水魂精"
L["Winterspring"] = "冬泉谷"
L["World of Warcraft"] = "魔獸世界"
L["X Offset"] = "水平偏移"
L["Y Offset"] = "垂直偏移"
L["YOU"] = "你"
L["You cannot do that in combat."] = "你無法在戰鬥中進行該項操作。"
L["You have"] = "你有"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "你需要進行重載插件後才能使部分設置生效。|n|n你無需立即點擊重載插件按鈕，但是你完成設置並希望其生效時，必須點擊它。"
L["Your UI needs to be reloaded."] = "你的插件需要重新載入。"
L["Zones"] = "區域"
L["Zul'Farrak"] = "祖爾法拉克"
L["Zul'Gurub"] = "祖爾格拉布"
L["Zulian, Razzashi, and Hakkari Coins"] = "祖利安、拉札希和哈卡萊硬幣"
L["Zygor addon not found."] = "你尚未安裝Zygor插件。"

end

-- ruRU: Russian
if GameLocale == "ruRU" then
L["+"] = "Г"
L["A Donation of Mageweave"] = "Пожертвование: магическая ткань"
L["A Donation of Runecloth"] = "Пожертвование: рунная ткань"
L["A Donation of Silk"] = "Пожертвование: шелк"
L["A Donation of Wool"] = "Пожертвование: шерсть"
L["A friend request from"] = "Запрос дружбы от"
L["Accept available quests automatically"] = "Принимать доступные квесты автоматически"
L["Accept resurrection"] = "Принятие воскрешения"
L["Accept summon"] = "Принятие призыва"
L["Additional Runecloth"] = "Больше рунной ткани"
L["Addon"] = "Модификация"
L["Ahn'Qiraj"] = "Ан'Кираж"
L["Alterac Mountains"] = "Альтеракские горы"
L["Anchor"] = "Якорь"
L["Angelic"] = "Ангельский"
L["Arathi Highlands"] = "Нагорье Арати"
L["Ashenvale"] = "Ясеневый лес"
L["Auto loot is now enabled."] = "Автоматическая добыча включена."
L["AutoFollow"] = "Автоматическое следование"
L["AutoFollow disabled."] = "Автоматическое следование выключено"
L["Automate gossip"] = "Автоматизация общения"
L["Automate quests"] = "Автоматизация квестов"
L["Automation"] = "Автоматизация"
L["Azshara"] = "Азшара"
L["Back to Main Menu"] = "В главное меню"
L["Bad ID"] = "Плохой id"
L["Badlands"] = "Бесплодные земли"
L["Barrens"] = "Южные степи"
L["Battle"] = "Боевой"
L["Battle of Warsong Gulch"] = "Битва за Ущелье Песни Войны"
L["Battlegrounds"] = "Поля боя"
L["Blackfathom Deeps"] = "Непроглядная Пучина"
L["Blackrock Depths"] = "Глубины Черной горы"
L["Blackwing Lair"] = "Логово Крыла Тьмы"
L["Blasted Lands"] = "Выжженные земли"
L["Block duels"] = "Блок дуэлей"
L["Block friend requests"] = "Блок запросов дружбы"
L["Block party invites"] = "Блок приглашений в группу"
L["Blocks"] = "Блокировки"
L["Bottom"] = "Нижняя"
L["Buffs"] = "Бафы"
L["Burning Steppes"] = "Пылающие степи"
L["Buyout Only"] = "Только выкуп"
L["C"] = "C"
L["Camera distance"] = "Дистанция камеры"
L["Chain style"] = "Стиль контура"
L["Character"] = "Персонаж"
L["Chat"] = "Чат"
L["Chat Frame"] = "Окно чата"
L["Checkbox labels are Ok."] = "Сокращать описания."
L["Chillwind E'ko"] = "Э'ко стылодыхов"
L["Cinematics"] = "Видеоролики"
L["Claiming Arathi Basin"] = "Завоевание Низины Арати"
L["Class colored frames"] = "Фон имени в цвете класса"
L["Class icon portraits"] = "Изображение класса в портрете"
L["Classic"] = "Классик"
L["click here for new selection"] = "Нажмите сюда для создания новой подборки"
L["Click to configure the settings for this option."] = "Нажмите, чтобы перейти к интерфейсу дополнительных параметров этой настройки."
L["Click to reset the settings on this page."] = "Нажмите, чтобы сбросить настройки на этой странице."
L["Click to resize the screen to fit between the top and bottom borders."] = "Нажмите, чтобы оптимизировать размер экрана."
L["Click to return to the main menu."] = "Нажмите, чтобы вернуться в главное меню."
L["Cloak"] = "Плащ"
L["Color the backdrops based on faction"] = "Цвет фона в зависимости от фракции"
L["Combat log cannot be hidden while undocked."] = "Журнал боя не может быть скрыт, пока он не закреплен"
L["Combat plates"] = "Индикаторы"
L["Completed."] = "Завершено."
L["Concerted Efforts"] = "В едином порыве"
L["Configuration Panel"] = "Панель настроек"
L["Connections for"] = "Соединения с"
L["Conquering Arathi Basin"] = "Завоевание Низины Арати"
L["Credits"] = "Благодарности"
L["Cursor"] = "Курсор"
L["Cursor Left"] = "Курсор слева"
L["Cursor Right"] = "Курсор вправо"
L["Customise minimap"] = "Настроить миникарту"
L["D"] = "П"
L["Darkmoon Faire"] = "Ярмарка Новолуния"
L["Darkshore"] = "Темные берега"
L["Deadmines"] = "Пещеры Стенаний"
L["Deadwind Pass"] = "Перевал Мертвого Ветра"
L["Desolace"] = "Пустоши"
L["Dire Maul"] = "Забытый Город"
L["Disable bag automation"] = "Откл. автоматизац. сумок"
L["Disable chat fade"] = "Откл. затухание сообщений чата"
L["Disable loot warnings"] = "Отключить предупреждения о добыче"
L["Disable screen effects"] = "Откл. экранные эффекты"
L["Disable screen glow"] = "Откл. свечение экрана"
L["Disable sticky chat"] = "Отключить липкий чат"
L["Drag the frame overlay to position the frame."] = "Переместите рамку, чтобы изменить позицию фрейма."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Перетащите фрейм, чтобы изменить позицию. Чтобы изменить масштаб окна, щелкните по его рамке, а затем отрегулируйте масштаб ползунком на странице настроек.Эта панель закроется автоматически, если Вы начнёте бой."
L["Drag to set the buffs frame scale."] = "Переместите ползунок влево или вправо, чтобы установить размер фрейма баффов"
L["Drag to set the cursor X offset."] = "Переместите ползунок влево или вправо, чтобы установить смещение курсора по оси X."
L["Drag to set the cursor Y offset."] = "Переместите ползунок влево или вправо, чтобы установить смещение курсора по оси Y."
L["Drag to set the density of weather effects."] = "Переместите ползунок влево или вправо, чтобы установить желаемую плотность погодных эффектов."
L["Drag to set the font size of book text."] = "Переместите ползунок влево или вправо, чтобы установить размер шрифта текста книги."
L["Drag to set the font size of mail text."] = "Переместите ползунок влево или вправо, чтобы установить размер шрифта для текста почтовых сообщений"
L["Drag to set the font size of quest text."] = "Переместите ползунок влево или вправо, чтобы установить размер шрифта для текста квестов."
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "Переместите ползунок влево или вправо, чтобы изменить масштаб мини-карты.|n|nОбратите внимание, что если вы используете панели действий по умолчанию, то изменения масштаба миникарты также приведут к изменению и их масштаба. Рекомендуем оставить значение на 100%."
L["Drag to set the scale of the Leatrix Plus panel."] = "Переместите ползунок влево или вправо, чтобы установить масштаб панели Leatrix Plus."
L["Drag to set the scale of the selected frame."] = "Переместите ползунок влево или вправо, чтобы установить масштаб выбранного фрейма."
L["Drag to set the size of the bottom border."] = "Перемещайте, чтобы установить размер нижней границы."
L["Drag to set the size of the left border."] = "Перемещайте, чтобы установить размер левой границы."
L["Drag to set the size of the right border."] = "Перемещайте, чтобы установить размер правой границы."
L["Drag to set the size of the top border."] = "Перемещайте, чтобы установить размер верхней границы."
L["Drag to set the tooltip scale."] = "Переместите ползунок влево или вправо, чтобы установить масштаб всплывающей подсказки."
L["Drag to set the transparency of the borders."] = "Переместите ползунок влево или вправо, чтобы установить прозрачность границ."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Переместите ползунок влево или вправо, чтобы установить прозрачность панели Leatrix Plus."
L["Dun Morogh"] = "Дун Морог"
L["Dungeons"] = "Подземелья"
L["Dup ID"] = "Копия id"
L["durability"] = "прочность"
L["Durability"] = "Прочность"
L["Durotar"] = "Дуротар"
L["Duskwood"] = "Сумеречный лес"
L["Dustwallow Marsh"] = "Пылевые топи"
L["Eastern Kingdoms"] = "Восточные королевства"
L["Eastern Plaguelands"] = "Восточные Чумные земли"
L["ELITE"] = "Элитный"
L["Elwynn Forest"] = "Элвиннский лес"
L["Enable hotkey"] = "Горячая клавиша"
L["Enable viewport"] = "Включить полосы"
L["Enhance dressup"] = "Улучшить примерочную"
L["Enhance professions"] = "Улучшить окно профессий"
L["Enhance quest log"] = "Улучшить журнал заданий"
L["Enhance trainers"] = "Улучшить окно тренера"
L["Enhancements"] = "Улучшения"
L["Enter"] = "Войти"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "Введите ID заклинаний, иконки которых хотите видеть. Если значок перезарядки появляется под рамкой питомца, то нажмите галочку. Иконки восстановления сохраняются для вашего класса."
L["enter zone or track name"] = "введите название зоны или трека"
L["Error messages will be hidden"] = "Сообщения об ошибках будут скрыты"
L["Error messages will be shown"] = "Сообщения об ошибках будут показаны"
L["Events"] = "События"
L["Extras"] = "Дополнения"
L["False"] = "Ложь"
L["Faster auto loot"] = "Быстрый сбор добычи"
L["Faster movie skip"] = "Быстро пропускать ролики"
L["Features"] = "Особенности"
L["Felwood"] = "Оскверненный лес"
L["Feralas"] = "Фералас"
L["Fight for Warsong Gulch"] = "Битва за Ущелье Песни Войны"
L["Find Item"] = "Найти предмет"
L["For Great Honor"] = "Ради славы"
L["Frames"] = "Фреймы"
L["Frostmaul E'ko"] = "Э'ко великанов"
L["Frostsaber E'ko"] = "Э'ко ледопардов"
L["Game Options"] = "Настройки игры"
L["Ghost"] = "Призрак"
L["Gloomy"] = "Угрюмый"
L["Gnomeregan"] = "Гномреган"
L["Gold Only"] = "Только золото"
L["Graphics and Sound"] = "Графика и звук"
L["Groups"] = "Группы"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "Монеты племен: Гурубаши, Порочная Ветвь и Сухокожие"
L["H"] = "H"
L["Haunted"] = "Преследуемый"
L["Helm"] = "Шлем"
L["Help"] = "Справка"
L["Hide chat buttons"] = "Скрыть кнопки чата"
L["Hide cooldown duration numbers (if enabled)"] = "Скрыть длительность перезарядки (если включено)"
L["Hide error messages"] = "Скр. сообщ. об ошибках"
L["Hide gryphons"] = "Скрыть грифонов"
L["Hide portrait numbers"] = "Скрыть числа на портрете"
L["Hide stance bar"] = "Скрыть панель стоек"
L["Hide the combat log"] = "Скрыть журнал боя"
L["Hide the zone text bar"] = "Скрыть текстовую панель с названием зоны"
L["Hide the zoom buttons"] = "Скрыть кнопки масштабирования"
L["Hide tooltips for world units during combat"] = "Скрыть подсказки для мировых боссов во время боя"
L["Hide zone text"] = "Скрыть название зоны"
L["High"] = "Высота"
L["Hillsbrad Foothills"] = "Предгорья Хилсбрада"
L["Hinterlands"] = "Внутренние земли"
L["Home"] = "Главная"
L["Ice Thistle E'ko"] = "Э'ко йети"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "Если флажок установлен, в рюкзаке и банке будет отображаться строка поиска в сумке."
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Если флажок установлен, то в окне отображения информации о персонаже будет добавлена кнопка, при наведении указателя мыши на которую, будет показана прочность всей экипировки персонжа.|n|nКроме того, при смерти вашего персонажа, общий процент прочности будет показан сообщением в окне чата."
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "Если флажок установлен, то приглашение в группу будет автоматически отправлено всем, кто шепнёт вам с заданным ключевым словом, если тот человек еще не входит в вашу группу или рейд. Чтобы всё сработало, у вас обязательно должен быть статус лидера группы или помощника в рейде."
L["If checked, a master volume slider will be shown in the character sheet."] = "Если флажок установлен, то в окне отображения информации о персонаже будет отображаться регулятор (ползунок) общей громкости."
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "Если флажок установлен, то у миникарты будет отображаться кнопка аддона.|n|nКликните по ней, чтобы показать/скрыть окно настроек аддона.|n|nSHIFT+ЛКМ - вкл/выкл музыку. CTRL+ПКМ - вкл/выкл ошибки (если были включены).|n|nCTRL+SHIFT+ЛКМ - вкл/выкл Zygor (если установлен).|n|nCTRL+SHIFT+ПКМ - вкл/выкл оконный режим."
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "Если флажок установлен, то на аукцион будут добавлены новые функции:|n|nТолько выкуп - создание аукционов выкупа без указания начальной цены.|n|nТолько золото - установите цены на медь и серебро 99, чтобы ускорить продажу новых лотов.|n|nНайти предмет - найдите в аукционе предмет, который вы продаете.|n|nКроме того, настройка длительности лотов будет сохранена для всего аккаунта."
L["If checked, alert frames will not be shown."] = "Если флажок установлен, то фреймы с предупреждениями не будут отображаться."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Если флажок установлен, то все предметы серого качества, находящиеся в ваших сумках, будут автоматически проданы при посещении торговца.|n|nВы можете удерживать клавишу SHIFT во время общения с торговцем для временного игнорирования этой опции."
L["If checked, available quests will be accepted automatically."] = "Если установлен этот флажок, доступные для вас квесты будут приниматься автоматически"
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Если флажок установлен, то фон подсказки будет синим (дружественная цель) или красным (враждебная цель)."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Если флажок установлен, то запросы дружбы по BattleTag и Real ID будут автоматически отклоняться.|n|nВключение этого параметра автоматически отклонит любые ожидающие запросы."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Если флажок установлен, то кнопки чата будут скрыты.|n|nКлик по вкладке чата автоматически покажет последние сообщения.|n|nИспользуйте колесо мыши для прокрутки истории чата. Удерживайте клавишу SHIFT для перехода на другую страницу чата или CTRL, для перехода к верхней или нижней части истории чата."
L["If checked, chat text will not fade out after a time period."] = "Если флажок установлен, то текст чата не будет исчезать спустя некоторое время."
L["If checked, class coloring will be used in the player frame and target frame."] = "Если флажок установлен, то фон имени в рамке персонажа будет отображаться в цвете класса - как для вашего персонажа, так и для вашей цели и цели её цели."
L["If checked, class colors will be used in the chat frame."] = "Если флажок установлен, то имена персонажей, в окне чата, будут выделены цветом их класса."
L["If checked, class icons will be shown in the portrait frames."] = "Если флажок установлен, то в фреймах персонажей, вместо портретов, будут отображаться значки классов."
L["If checked, completed quests will be turned-in automatically."] = "Если установлен этот флажок, выполненные квесты будут сдаваться автоматически"
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Если флажок установлен, то больше не будет предупреждений когда вы разыгрываете (роллите) предмет или пересылаете по почте предмет, который можно передать."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Если флажок установлен, то не будут отображаться цифры длительности перезарядки.|n|nЕсли не установлен, то длительность перезарядки будет показываться в перезарядках, если они включены в настройках игры."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Если флажок установлен, то цифры урона и лечения на фреймах игрока и питомца будут скрыты."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Если флажок установлен, то перетаскивание вкладки \"Общий\" чата, когда окно чата заблокировано, развернет окно чата.|n|nЕсли окно чата разблокировано, то перетаскивание вкладки \"Общий\" приведет к перемещению окна чата."
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "Если флажок установлен, то запросы на дуэль будут заблокированы (кроме запросов из вашей гильдии и из списка друзей)."
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "Если флажок установлен, то звуки эмоций будут заглушаться, пока ваш персонаж отдыхает или находится в Трактире \"Угрюмый обжора\".|n|nВ любое другое время звуки будут включены."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Если флажок установлен, то индикаторы здоровья будут отображены только во время боя и скрыты после его завершения."
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "Если флажок установлен, то приглашение в группу будет автоматически отправляться только вашим друзьям или согильдийцам|n|nЕсли флажок снят, автоматическое приглашение будет отправляться любому кто вам шепнёт с ключевым словом."
L["If checked, guild names will be shown.  Guild ranks will also be shown for players in your guild."] = "Если флажок установлен, то будут показываться гильдейские имена. Для согильдийцев, так же будут показываться их ранги в гильдии."
L["If checked, helm and cloak toggle checkboxes will be shown in the character sheet.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "Если флажок установлен, флажки переключения головы и плаща будут отображаться на листе символов.|n|nВы можете удерживать клавишу SHIFT и щелкнуть правой кнопкой мыши по флажкам, чтобы переключить раскладки."
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "Если флажок установлен, то большинство сообщений об ошибках (например, «Недостаточно ярости») не будут отображаться. Некоторые важные ошибки останутся.|n|nЕсли у вас включена кнопка у миникарты, вы сможете удерживать CTRL и нажать ПКМ, чтобы  вкл/выкл сообщения об ошибках, не изменяя данную настройку."
L["If checked, nude and tabard toggle buttons will be added to the dressup frame and model rotation controls will be removed."] = "Если флажок установлен, то в примерочной появятся две кнопки: кнопка которая скрывает/отображает накидку и кнопка скрывающая все вещи с персонажа."
L["If checked, party invitations from friends or guild members will be automatically accepted."] = "Если флажок установлен, то приглашения в группу от друзей или согильдийцев будут приниматься автоматически."
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "Если флажок установлен, то приглашения в группу будут заблокированы, если приглашающий вас игрок не будет находиться в вашем списке друзей или гильдии."
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting.|n|nRepeatable battlemaster and cloth quartermaster quests can be automatically selected by holding down the alt key."] = "Если флажок установлен, квесты будут выбираться, приниматься и запускаться автоматически.|n|nКвесты требующие выплаты золота - не будут запускаться автоматически|n|nВы можете удерживать клавишу Shift при разговоре с персонажем дающим задание, чтобы переопределить эту настройку.|n|nПовторяемые квесты от военачальника и квартирмейстера принимающего ткань - могут быть автоматически выбраны, если вы будете удерживать клавишу Alt."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Если флажок установлен, то чаты рейдов и подземелий будут окрашены в синий цвет (чтобы они сочетались по цвету)."
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat."] = "Если флажок установлен, то подтверждение воскрешения будет происходить автоматически, если игрок который пытается вас воскресить не находится в бою."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "Если флажок установлен, то во всплывающих подсказках на фрейме с бафами, а также на целях персонажа будут отображаться ID заклинаний."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Если флажок установлен, то \"липкий\" чат будет отключен.|n|nПримечание: эта настройка не будет работать для временных чатов."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Если флажок установлен и вы не находитесь в бою, то запрос на ваш призыв будет принят автоматически."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Если флажок установлен, то список модификаций (доступный из меню игры) будет отображать по умолчанию список модификации для этого персонажа."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Если флажок установлен, то время необходимое для поднятие добычи значительно сократится."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Если флажок установлен, то кнопка сортировки вещей в сумках и в банке не будет отображаться."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Если флажок установлен, то кнопка для переключения контейнера рейда будет отображена над его окном управления (c левой стороны), а не на самом окне управления.|n|nЭто позволит переключать рамку контейнера рейда без необходимости открывать окно его управления."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Если флажок установлен, то закладка \"Журнал боя\" в окне чата будет скрыта.|n|nЧтобы эта настройка сработала, закладка \"Журнал боя\" должна находиться в окне чата.|n|n Если закладка откреплена, Вы можете закрепить её перетащив на вкладку чата (после этого необходимо перезагрузить UI) или сбросить настройки окна чата (из соответствующего меню)."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Если флажок установлен, то поле ввода текста будет перемещено в верхнюю часть окна чата. По умолчанию, оно находится в нижней части."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Если флажок установлен, то серый экран смерти и другие эффекты будут отключены."
L["If checked, the main bar gryphons will not be shown."] = "Если флажок установлен, то панель с грифонами не будет отображаться."
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "Если флажок установлен, количество свободных мест в сумке будет отображаться в значке кнопки рюкзака и во всплывающей подсказке."
L["If checked, the player frame background will be shown in class color."] = "Если флажок установлен, фон окна игрока будет отображаться в цвете класса."
L["If checked, the professions frame will be larger."] = "Если флажок установлен, то окно профессий будет больше."
L["If checked, the quest log frame will be larger and feature a world map button and quest levels."] = "Если флажок установлен, окно журнала заданий будет больше и будет содержать кнопку карты мира и уровни заданий."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Если флажок установлен, то свечение экрана будет отключено.|n|nВключение этой опции также отключит эффект \"пьяной\" дымки."
L["If checked, the skill trainer frame will be larger."] = "Если флажок установлен, то окно обучения у тренера будет больше."
L["If checked, the stance bar will not be shown."] = "Если флажок установлен, то панель стоек не будет отображаться."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Если флажок установлен, то окно разговоров не будет показываться.|n|nОкно разговоров появляется обычно в нижней части экрана, в процессе общения с некоторыми НПС."
L["If checked, the target frame background will be shown in class color."] = "Если флажок установлен, фон окна цели будет отображаться в цвете класса цели."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Если флажок установлен, то всплывающие подсказки будут выделяться цветом, и у Вас появится возможность менять их расположение и размер."
L["If checked, the vendor price will be shown in item tooltips."] = "Если флажок установлен, то во всплывающих подсказках предметов будет отображаться цена у продавца."
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "Если флажок установлен, то название зоны будет скрыто (но все ещё будет появляться во всплывающей подсказке)."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Если флажок установлен, то кнопки увеличения и уменьшения масштаба у миникарты будут скрыты. Независимо от этой настройки, вы сможете использовать колесо мыши для изменения масштаба."
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "Если флажок установлен, то подсказки для мировых боссов будут скрыты во время боя.|n|nВы можете удерживать клавишу SHIFT для временного игнорирования этой настройки."
L["If checked, unit targets will be shown."] = "Если флажок установлен, то будет отображаться цель цели."
L["If checked, Wowhead links will be shown above the quest log frame."] = "Если флажок установлен, то над окном журнала заданий будут отображаться ссылки на Wowhead."
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip item.|n|nIf the gossip item type is banker, taxi, trainer or vendor, gossip will be skipped without needing to hold the alt key.  You can hold the shift key down to prevent this."] = "Если флажок установлен, то вы можете удерживать клавишу ALT при открытии окна c разговорами, чтобы автоматически выбрать один вариантов диалога.|n|nЕсли ваш диалог с банкиром, распорядителем полетов, тренером или продавцом, то такие диалоги будут пропущены без необходимости удерживать клавишу ALT. Вы так же можете удерживать клавишу SHIFT, чтобы временно отключить эту автоматизацию."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Если флажок установлен, то удерживая нажатой клавишу CTRL и щелкнув по закладке чата, вы сможете просмотреть последние записи чата в отдельном окне, из которого сможете легко скопировать текст."
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "Если флажок установлен, то вы сможете открыть окно настроек Leatrix Plus, нажав CTRL+Z."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Если флажок установлен, то Вы сможете нажимать кнопки со стрелками для перемещения курсора влево и вправо, в строке ввода текста, в окне чата.|n|nЕсли флажок снят, то клавиши со стрелками будут использовать настройки назначения клавиш по умолчанию."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Если флажок установлен, то вы сможете пропускать ролики без подтверждения."
L["If checked, you will be able to change the font size of book text."] = "Если флажок установлен, вы сможете изменять размер шрифта текста в книгах."
L["If checked, you will be able to change the font size of quest text."] = "Если флажок установлен, вы сможете изменять размер шрифта текста квестов."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Если флажок установлен, вы сможете изменить размер шрифта текста в почтовых сообщениях (письмах).|n|nЭта настройка не будет иметь силы для писем созданных по шаблону (к примеру писем с аукциона)."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "Если этот флажок установлен, у вас будет возможность изменять расположение и размеры фрейма баффов"
L["If checked, you will be able to change the position and scale of the following frames:|n|n- Player frame|n- Target frame|n- Widget top center frame|n- Timer bar"] = [=[Если этот флажок установлен, вам будет доступно управление следующие фреймами:
|n|n- Фрейм игрока|n- Фрейм цели игрока|n- Фрейм верхнего центрального виджета|n- Фрейм таймеров]=]
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Если флажок установлен, вы сможете создать \"зону видимости\". Создание такой зоны - добавляет сверху и снизу основного экрана игры черные полосы.|n|nНа этих полосах вы сможете разместить элементы интерфейса, тем самым не перекрывая обзор основного экрана игры."
L["If checked, you will be able to customise the minimap."] = "Если флажок установлен, вы сможете настроить миникарту."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Если флажок установлен, то вы сможете переместить фрейм чата к краю экрана."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Если флажок установлен, вы сможете разместить над фреймом цели дополнительно до пяти пиктограмм отображающих таймеры восстановления."
L["If checked, you will be able to reposition the tooltip."] = "Если флажок установлен, вы сможете изменить положение всплывающей подсказки."
L["If checked, you will be able to set the density of weather effects."] = "Если флажок установлен, вы сможете установить плотность погодных эффектов."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Если флажок установлен, то вы сможете изменить контур рамки своего персонажа с обычного на редкий, элитный или редко-элитный."
L["If checked, you will be able to zoom out to a greater distance."] = "Если флажок установлен, вы сможете максимально далеко отдалять камеру.|nПримечание: Это может приводить к неожиданным результатам, так как мир классического WoW не был на это рассчитан."
L["If checked, you will need to hold the shift key down for quests to be automated.|n|nIf unchecked, holding shift will prevent quests from being automated."] = "Если этот флажок установлен, вам нужно будет удерживать клавишу shift нажатой, чтобы задания были автоматизированы.|n|nЕсли этот флажок не установлен, удержание shift предотвратит автоматизацию заданий."
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "Если флажок установлен, то вы будете автоматически покидать тело после смерти на поле битвы.|n|nОднако, вы не возродитесь автоматически, если у вас есть возможность самовоскрешения (камень души, реинкарнация и т. д.)."
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "Если флажок установлен, то ваши сумки не будут открываться или закрываться автоматически, когда вы взаимодействуете с торговцами, банком или почтовым ящиком."
L["If checked, your character will automatically stand or dismount when an action is prevented because you are either seated or mounted."] = "Если флажок установлен, ваш персонаж будет автоматически вставать или спешиваться, когда действие будет предотвращено, в связи с тем, что вы уже сидите или находитесь на ездовом животном."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Если флажок установлен, история чата увеличится до 4096 строк. Если флажок снят, будут использовать настройки по умолчанию (128 строк).|n|nВключение этой настройки может помешать отображению некоторого текста во время входа в игру."
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Если флажок установлен, то ваше снаряжение будет починено автоматически, когда вы поговорите с подходящим торговцем.|n|nВы можете удерживать клавишу SHIFT, перед разговором, чтобы временно игнорировать эту настройку."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Если флажок установлен, то текст названия зоны не будет отображаться (например \"Стальгорн\")."
L["Increase chat history"] = "Увеличить историю чата"
L["Interface"] = "Интерфейс"
L["Invaders of Alterac Valley"] = "Вторжение в Альтеракскую долину"
L["Invalid console variable."] = "Недопустимая консольная переменная."
L["Invalid parameter."] = "Неверный параметр."
L["Invalid quest ID."] = "Неверный id квеста"
L["Invalid sound ID"] = "Неверный id звука"
L["Invalid taint level."] = "Неверный уровень taint."
L["Invalid target."] = "Неверная цель."
L["Invite from whispers"] = "Приглашать по шепоту"
L["Kalimdor"] = "Калимдор"
L["Keyword"] = "Ключевое слово"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus не будет перезаписывать LeaPlusDB при следующем выходе из системы."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: УСТАНОВЛЕНА НЕПРАВИЛЬНАЯ ВЕРСИЯ!"
L["Left"] = "Левая"
L["Lifetime honorable kills"] = "Всего почетных побед"
L["Loch Modan"] = "Лок Модан"
L["Lockout sharing"] = "Совместная блокировка"
L["Low"] = "Низкий"
L["Magic"] = "Магия"
L["Main Titles"] = "Главные названия"
L["Manage buffs"] = "Управление баффами"
L["Manage frames"] = "Управление рамками"
L["Manage tooltip"] = "Упр. вспл. подсказками"
L["Managed by Leatrix Plus"] = "Настройки Leatrix Plus"
L["Map"] = "Карта"
L["Maraudon"] = "Мародон"
L["Max camera zoom"] = "Max отдаление камеры"
L["Mechanics"] = "Механики"
L["Media"] = "Медиа"
L["Medium"] = "Средняя"
L["Memory Usage"] = "Использовано памяти"
L["message shown."] = "сообщение показано."
L["messages shown."] = "сообщения показаны."
L["Missing console variable."] = "Отсутствует переменная консоли."
L["Missing mount name."] = "Отсутствует имя маунта."
L["Missing movie ID."] = "Отсутствует ID видео-ролика."
L["Missing quest ID."] = "Отсутствует идентификатор квеста."
L["Missing sound file parameter."] = "Отсутствует параметр звукового файла."
L["Missing sound ID."] = "ID ролика не найден."
L["Molten Core"] = "Огненные Недра"
L["Moonglade"] = "Лунная поляна"
L["Mount not found."] = "Маунт не найден."
L["Move editbox to top"] = "Поле ввода над чатом"
L["Movie not playable."] = "Видео-ролик не может быть воспроизведён."
L["Movie number"] = "Номер видео-ролика"
L["Movies"] = "Видео-ролики"
L["Mulgore"] = "Мулгор"
L["Music"] = "Музыка"
L["Musical Moments"] = "Музыкальные Моменты"
L["Mystery"] = "Тайна"
L["Narration"] = "Повествование"
L["Naxxramas"] = "Наксрамас"
L["No bad sound IDs found."] = "Не найдено неверных звуковых id."
L["No help is available for this page."] = "Справка недоступна для этой страницы."
L["No items with durability equipped."] = "Нет экипированных предметов с прочностью."
L["No media duplicates found."] = "Дубликаты медиа не найдены."
L["No tooltip showing."] = "Подсказки не показываются."
L["None"] = "Нет"
L["Not completed."] = "Не завершено."
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "ВНИМАНИЕ!|nВы должны полностью перезапустить свой игровой клиент, прежде чем использовать эту версию Leatrix Plus."
L["Nude"] = "Снять"
L["Onyxia's Lair"] = "Логово Ониксии"
L["or click the minimap button to open Leatrix Plus."] = "или нажмите на кнопку у миникарты, чтобы открыть Leatrix Plus."
L["Orgrimmar"] = "Оргриммар"
L["Overall"] = "Всего"
L["Overlay"] = "Оверлей"
L["Particle density"] = "Плотность частиц"
L["Party from friends"] = "Приглашения от друзей"
L["Pet"] = "Питомец"
L["Player"] = "Персонаж"
L["Power"] = "Мощность"
L["Press CTRL/C to copy."] = "Нажмите CTRL/C, чтобы скопировать."
L["Queue from friends"] = "Очереди от друзей"
L["R"] = "Р"
L["Ragefire Chasm"] = "Огненная Пропасть"
L["Raid"] = "Рейд"
L["Raid frame toggle"] = "Вкл/выкл рейдовые рамки"
L["Random"] = "Случайно"
L["RARE"] = "Редкий"
L["RARE ELITE"] = "Редкий элитный"
L["Razorfen Downs"] = "Курганы Иглошкурых"
L["Razorfen Kraul"] = "Лабиринты Иглошкурых"
L["Recent chat window"] = "Окно недавнего чата"
L["Redridge Mountains"] = "Красногорье"
L["Release in PvP"] = "Покидание тела в PvP"
L["Reload"] = "Перезагрузить"
L["Remember Alterac Valley!"] = "Помни Альтеракскую долину!"
L["Repair automatically"] = "Ремонт снаряжения"
L["Repaired for"] = "Стоимость ремонта"
L["Reposition the tooltip"] = "Переместите подсказку"
L["Require shift key for quest automation"] = "Требуется клавиша shift для автоматизации задания"
L["Requires UI reload."] = "Требуется перезагрузка интерфейса (UI)."
L["Reset"] = "Сброс настроек"
L["Resize book text"] = "Изменить размер книги"
L["Resize mail text"] = "Размер текста писем"
L["Resize quest text"] = "Размер текста заданий"
L["Resize Screen"] = "Изменить размер экрана"
L["Rested bubbles"] = "Бонус отдыха"
L["Restrict to friends and guild members"] = "Только для друзей и членов гильдии"
L["result"] = "Результат"
L["results"] = "Результаты"
L["Right"] = "Правая"
L["Right-click to close"] = "Щелчок ПКМ, чтобы закрыть"
L["Right-click to close."] = "Щелчок ПКМ, чтобы закрыть."
L["right-click to go back"] = "Щелчок ПКМ, чтобы вернуться"
L["Ruins of Ahn'Qiraj"] = "Руины Ан'Киража"
L["Sacred"] = "Священный"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "Монеты племен: Песчаная Буря, Дробители Черепов и Кровавый Скальп"
L["Scale"] = "Масштаб"
L["Scarlet Monastery"] = "Монастырь Алого ордена"
L["Scholomance"] = "Некроситет"
L["Search"] = "Поиск"
L["Searing Gorge"] = "Тлеющее ущелье"
L["Select the settings that you want to use."] = "Выберите параметры, которые вы хотите использовать."
L["Selection of music tracks"] = "Подборка музыкальных треков"
L["Self Markers Allowed"] = "Разрешены самомаркировки"
L["Self Markers Blocked"] = "Самомаркировки запрещены"
L["Sell junk automatically"] = "Продажа хлама из сумок"
L["SELLING JUNK"] = "Продаю хлам"
L["Set weather density"] = "Плотность погодных эффектов"
L["Settings"] = "Параметры"
L["Shaders"] = "Тени"
L["Shadowfang Keep"] = "Крепость Темного Клыка"
L["Shardtooth E'ko"] = "Э'ко щербозубов"
L["Show auction controls"] = "Отображать элементы управления аукционом"
L["Show bag search box"] = "Показать строку поиска в сумки"
L["Show character addons"] = "Показывать модификации персонажа"
L["Show cooldowns"] = "Показать кулдауны"
L["Show durability status"] = "Прочность экипировки"
L["Show free bag slots"] = "Показать свободные слоты для сумок"
L["Show guild names"] = "Показать названия гильдий"
L["Show minimap button"] = "Кнопка у миникарты"
L["Show player chain"] = "Контур рамки персонажа"
L["Show player frame in class color"] = "Показать окно персонажа в цвете класса"
L["Show target frame in class color"] = "Показать окно цели в цвете класса"
L["Show the spell ID in buff icon tooltips"] = "Отображать ID заклинаний в подсказках"
L["Show unit targets"] = "Показывать цели врагов"
L["Show vanity controls"] = "Показать настройки \"тщеславия\""
L["Show vendor price"] = "Показывать цену у торговца"
L["Show volume slider"] = "Регулятор громкости"
L["Show Wowhead links"] = "Ссылки на Wowhead"
L["Silence rested emotes"] = "Заглушать звуки эмоций"
L["Silithus"] = "Силитус"
L["Silverpine Forest"] = "Серебряный бор"
L["Social"] = "Общение"
L["Sold junk for"] = "Продать мусор за"
L["Sound system restarted."] = "Звуковая система перезапустилась."
L["Spell ID"] = "ID заклинания"
L["Spooky"] = "Ужасный"
L["Stand and dismount"] = "Стоять и спешиться"
L["Stockade"] = "Тюрьма"
L["Stonetalon Mountains"] = "Когтистые горы"
L["Stop"] = "Стоп"
L["Stormwind"] = "Штормград"
L["Stranglethorn Vale"] = "Тернистая долина"
L["Stratholme"] = "Стратхольм"
L["Sunken Temple"] = "Затонувший храм"
L["Support"] = "Поддержка"
L["Swamp"] = "Болотный"
L["Swamp of Sorrows"] = "Болото печали"
L["System"] = "Система"
L["Tabard"] = "Накидка"
L["Taint level: Basic (1)."] = "Уровень заражения: Базовый (1)."
L["Taint level: Disabled (0)."] = "Уровень заражения: Отключен (0)."
L["Taint level: Full (2)."] = "Уровень заражения: Полный (2)."
L["Tanaris"] = "Танарис"
L["Target"] = "Цель"
L["Target Tracking Disabled"] = "Отслеживание цели отключено"
L["Target Tracking Enabled"] = "Отслеживание цели включено"
L["Teldrassil"] = "Тельдрассил"
L["Temple of Ahn'Qiraj"] = "Храм Ан'Кираж"
L["Temple of Atal'Hakkar"] = "Храм Атал'Хаккара"
L["Ten Years of Warcraft"] = "Десять лет варкрафта"
L["Text"] = "Текст"
L["Text size"] = "Размер текста"
L["Text Size"] = "Размер текста"
L["The summon from"] = "Призыв для"
L["Themes"] = "Темы"
L["This panel will close automatically if you enter combat."] = "Это окно будет автоматически закрыто, если Вы вступите в бой."
L["Thousand Needles"] = "Тысяча Игл"
L["Timer"] = "Таймер"
L["Tirisfal Glades"] = "Тирисфальские леса"
L["To begin, choose an options page."] = "Чтобы начать, выберите страницу настроек."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Чтобы использовать кнопку «Найти предмет», вам нужно отменить выбор категории токена."
L["Tooltip"] = "Подсказка"
L["Tooltip title color"] = "Цвет заголовка подсказки"
L["Top"] = "Верхняя"
L["Top Center"] = "Верхний центральный"
L["Tracing started."] = "Отслеживание началось."
L["Tracing stopped."] = "Слежение остановилась."
L["Transparency"] = "Прозрачность"
L["True"] = "Правда"
L["Turn-in completed quests automatically"] = "Сдавать выполненные квесты автоматически"
L["Uldaman"] = "Ульдаман"
L["Unclamp chat frame"] = "Открепить окно чата"
L["Undercity"] = "Подгород"
L["Un'Goro Crater"] = "Кратер Ун'Горо"
L["Universal group color"] = "Единый цвет текста групп"
L["Use arrow keys in chat"] = "Использовать кнопки в чате"
L["Use class colors in chat"] = "Имена в цвете класса в чате"
L["Use easy resizing"] = "Лёгкое изменение размера"
L["Value must be a number."] = "Значение должно быть числом."
L["Various"] = "Разное"
L["Vendors"] = "Торговцы"
L["Version"] = "Версия"
L["Very Low"] = "Очень низко"
L["Video"] = "Видео"
L["Visibility"] = "Видимость"
L["Wailing Caverns"] = "Пещеры Стенаний"
L["was automatically declined."] = "был автоматически отклонён."
L["Weather density"] = "Плотность погодных эффектов"
L["Welcome to Leatrix Plus."] = "Добро пожаловать в Leatrix Plus."
L["Western Plaguelands"] = "Западные Чумные земли"
L["Westfall"] = "Западный Край"
L["Wetlands"] = "Болотина"
L["Widget"] = "Виджет"
L["Wildkin E'ko"] = "Э'ко диких совухов"
L["will be automatically accepted in 10 seconds unless cancelled."] = "будет автоматически принят в течение 10 секунд, если не будет отменен."
L["Winter"] = "Зима"
L["Winterfall E'ko"] = "Э'ко фурболгов племени Зимней Спячки"
L["Winterspring"] = "Зимние Ключи"
L["World of Warcraft"] = "World of Warcraft"
L["X Offset"] = "Х Смещение"
L["Y Offset"] = "Y Смещение"
L["YOU"] = "ВЫ"
L["You cannot do that in combat."] = "Вы не можете сделать это в бою."
L["You have"] = "У Вас"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Вам нужно перезагрузить пользовательский интерфейс (UI), чтобы некоторые внесенные вами изменения вступили в силу.|n|nВы можете выполнить перезагрузку не сразу, а когда полностью завершите работу с настройками."
L["Your UI needs to be reloaded."] = "Вам необходимо перезагрузить пользовательский интерфейс."
L["Zones"] = "Зоны"
L["Zul'Farrak"] = "Зул'Фаррак"
L["Zul'Gurub"] = "Зул'Гуруб"
L["Zulian, Razzashi, and Hakkari Coins"] = "Монеты племен: Зулиан, Раззаши и Хаккари"
L["Zygor addon not found."] = "Модификация Zygor не найдена."

end

-- koKR: Korean
if GameLocale == "koKR" then
L["+"] = "+"
L["A Donation of Mageweave"] = "마법 옷감 기부"
L["A Donation of Runecloth"] = "룬무늬 옷감 기부"
L["A Donation of Silk"] = "비단 옷감 기부"
L["A Donation of Wool"] = "양모 옷감 기부"
L["A friend request from"] = "친구 신청"
L["Accept available quests automatically"] = "퀘스트 자동 수락"
L["Accept resurrection"] = "부활 수락"
L["Accept summon"] = "소환 수락"
L["Additional Runecloth"] = "룬무늬 옷감 추가 기부"
L["Addon"] = "애드온"
L["Ahn'Qiraj"] = "안퀴라즈"
L["Alterac Mountains"] = "알터랙 산맥"
L["Anchor"] = "이동"
L["Angelic"] = "천사"
L["Arathi Highlands"] = "아라시 고원"
L["Ashenvale"] = "잿빛 골짜기"
L["Auto loot is now enabled."] = "자동 전리품이 활성화되었습니다."
L["AutoFollow"] = "따라가기 설정됨"
L["AutoFollow disabled."] = "따라가기 해제."
L["Automate gossip"] = "대화 자동 넘김"
L["Automate quests"] = "퀘스트 자동 수락"
L["Automation"] = "자동화"
L["Azshara"] = "아즈샤라"
L["Back to Main Menu"] = "주 메뉴로 돌아가기"
L["Bad ID"] = "잘못된 ID"
L["Badlands"] = "황야의 땅"
L["Barrens"] = "남부 불모의 땅"
L["Battle"] = "전투"
L["Battle of Warsong Gulch"] = "전쟁노래 협곡 전투"
L["Battlegrounds"] = "전장"
L["Blackfathom Deeps"] = "검은 심연 나락"
L["Blackrock Depths"] = "검은바위 나락"
L["Blackwing Lair"] = "검은날개 둥지"
L["Blasted Lands"] = "저주받은 땅"
L["Block duels"] = "결투 차단"
L["Block friend requests"] = "친구요청 차단"
L["Block party invites"] = "파티초대 차단"
L["Blocks"] = "차단"
L["Bottom"] = "하단"
L["Buffs"] = "버프"
L["Burning Steppes"] = "불타는 평원"
L["Buyout Only"] = "즉시구입가 만!"
L["C"] = "C"
L["Camera distance"] = "카메라 거리"
L["Chain style"] = "테두리 스타일"
L["Character"] = "캐릭터"
L["Chat"] = "채팅"
L["Chat Frame"] = "채팅창"
L["Checkbox labels are Ok."] = "체크박스를 확인합니다."
L["Chillwind E'ko"] = "서리바람 키메라의 에코"
L["Cinematics"] = "시네마틱"
L["Claiming Arathi Basin"] = "아라시 분지 공격"
L["Class colored frames"] = "유닛프레임 직업색상"
L["Class icon portraits"] = "초상화 직업아이콘"
L["Classic"] = "클래식"
L["click here for new selection"] = "목록을 갱신하려면 여기를 클릭하세요."
L["Click to configure the settings for this option."] = "설정을 구성하려면 클릭합니다."
L["Click to reset the settings on this page."] = "이 페이지를 재설정 하려면 클릭합니다."
L["Click to resize the screen to fit between the top and bottom borders."] = "상,하단간 화면에 맞게 화면 크기를 설정합니다. "
L["Click to return to the main menu."] = "주 메뉴 돌아가기 클릭"
L["Cloak"] = "망토"
L["Color the backdrops based on faction"] = "진영에 따른 배경색상"
L["Combat log cannot be hidden while undocked."] = "** 창(일반/전투) 연결이 해제되면 숨길수 없습니다."
L["Combat plates"] = "전투시 이름표 표시"
L["Completed."] = "완료"
L["Concerted Efforts"] = "공동의 노력"
L["Configuration Panel"] = "설정창"
L["Connections for"] = "연결된 서버"
L["Conquering Arathi Basin"] = "아라시 분지 정복"
L["Credits"] = "크레딧"
L["Cursor"] = "커서"
L["Cursor Left"] = "커서 왼쪽"
L["Cursor Right"] = "커서 오른쪽"
L["Customise minimap"] = "미니맵 설정"
L["D"] = "D"
L["Darkmoon Faire"] = "다크문 축제"
L["Darkshore"] = "어둠해안"
L["Deadmines"] = "죽음의 폐광"
L["Deadwind Pass"] = "죽음의 고개"
L["Desolace"] = "잊혀진 땅"
L["Dire Maul"] = "혈투의 전장"
L["Disable bag automation"] = "가방 자동열림 비활성"
L["Disable chat fade"] = "챗 사라짐 비활성"
L["Disable loot warnings"] = "전리품 경고 비활성"
L["Disable screen effects"] = "이펙트 비활성"
L["Disable screen glow"] = "빛 효과 비활성"
L["Disable sticky chat"] = "채널고정 사용안함"
L["Drag the frame overlay to position the frame."] = "위치 변경은 프레임 드레그 이동하세요."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "위치는 드레그 이동, 크기는 슬라이더 조정 설정."
L["Drag to set the buffs frame scale."] = "버프 프레임 스케일을 설정하려면 드래그하십시오."
L["Drag to set the cursor X offset."] = "드래그하여 커서 X 오프셋을 설정합니다."
L["Drag to set the cursor Y offset."] = "드래그하여 커서 Y 오프셋을 설정합니다."
L["Drag to set the density of weather effects."] = "날씨효과 밀도를 설정합니다."
L["Drag to set the font size of book text."] = "책 텍스트의 글꼴 크기를 설정하려면 드래그하십시오."
L["Drag to set the font size of mail text."] = "드래그하여 우편 글꼴 크기를 설정하십시오."
L["Drag to set the font size of quest text."] = "드래그하여 퀘스트 글꼴 크기를 설정하십시오."
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "드래그하여 미니맵 크기를 설정하십시오. |n|n블리자드(기본) 액션바를 사용시, 변경후 시작마다 오른쪽 액션바가 다시 조정되므로 100 %로 두는 것이 좋습니다."
L["Drag to set the scale of the Leatrix Plus panel."] = "드래그하여 Leatrix Plus 패널 크기를 설정하십시오."
L["Drag to set the scale of the selected frame."] = "드래그하여 선택된 프레임의 크기를 설정하십시오."
L["Drag to set the size of the bottom border."] = "드래그하여 아래쪽 테두리의 크기를 설정하십시오."
L["Drag to set the size of the left border."] = "드래그하여 왼쪽 테두리의 크기를 설정하십시오."
L["Drag to set the size of the right border."] = "드래그하여 오른쪽 테두리의 크기를 설정하십시오."
L["Drag to set the size of the top border."] = "드래그하여 윗쪽 테두리의 크기를 설정하십시오."
L["Drag to set the tooltip scale."] = "드래그하여 툴팁 크기를 설정하십시오."
L["Drag to set the transparency of the borders."] = "드래그하여  테두리의 투명도를 설정하십시오."
L["Drag to set the transparency of the Leatrix Plus panel."] = "드래그하여 Leatrix Plus 패널의 투명도를 설정하십시요."
L["Dun Morogh"] = "던 모로"
L["Dungeons"] = "던전"
L["Dup ID"] = "중복ID"
L["durability"] = "당신의"
L["Durability"] = "내구도"
L["Durotar"] = "듀로타"
L["Duskwood"] = "그늘숲"
L["Dustwallow Marsh"] = "먼지진흙 습지대"
L["Eastern Kingdoms"] = "동부 왕국"
L["Eastern Plaguelands"] = "동부 역병지대"
L["ELITE"] = "정예"
L["Elwynn Forest"] = "엘윈 숲"
L["Enable hotkey"] = "단축키 사용"
L["Enable viewport"] = "뷰포트 사용"
L["Enhance dressup"] = "미리보기 강화"
L["Enhance professions"] = "전문기술창 확장"
L["Enhance quest log"] = "퀘스트창 확장"
L["Enhance trainers"] = "트레이너 확장"
L["Enhancements"] = "기능 향상"
L["Enter"] = "Enter"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "표시할 주문 ID를 입력하세요.|n|n소환수 프레임 아래 표시하려면 소환수 박스를 체크하세요.|n|n쿨다운아이콘은 직업으로 저장됩니다."
L["enter zone or track name"] = "지역 또는 트랙이름을 입력하세요."
L["Error messages will be hidden"] = "오류메시지 숨김"
L["Error messages will be shown"] = "오류메시지 표시"
L["Events"] = "이벤트"
L["Extras"] = "기타"
L["False"] = "거짓"
L["Faster auto loot"] = "빠른 전리품 획득"
L["Faster movie skip"] = "빠른 무비 넘김"
L["Features"] = "특징"
L["Felwood"] = "악령숲"
L["Feralas"] = "페랄라스"
L["Fight for Warsong Gulch"] = "전쟁노래 협곡 전투"
L["Find Item"] = "아이템찾기"
L["For Great Honor"] = "커다란 영광을 위하여"
L["Frames"] = "프레임"
L["Frostmaul E'ko"] = "서리망치거인의 에코"
L["Frostsaber E'ko"] = "눈호랑이의 에코"
L["Game Options"] = "게임 설정"
L["Ghost"] = "유령"
L["Gloomy"] = "Gloomy"
L["Gnomeregan"] = "놈리건"
L["Gold Only"] = "골드 만!"
L["Graphics and Sound"] = "그래픽,소리"
L["Groups"] = "그룹"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "구루바시, 썩은가지, 마른나무껍질부족 주화"
L["H"] = "H"
L["Haunted"] = "Haunted"
L["Helm"] = "투구"
L["Help"] = "도움말"
L["Hide chat buttons"] = "채팅 버튼 숨김"
L["Hide cooldown duration numbers (if enabled)"] = "주문 지속시간 숨김"
L["Hide error messages"] = "에러메시지 숨김"
L["Hide gryphons"] = "그리핀 문양 숨김"
L["Hide portrait numbers"] = "초상화 전투수치 숨김"
L["Hide stance bar"] = "태세바 숨김"
L["Hide the combat log"] = "전투기록 숨김"
L["Hide the zone text bar"] = "지역명 숨김"
L["Hide the zoom buttons"] = "확대축소 버튼 숨김"
L["Hide tooltips for world units during combat"] = "전투중 월드유닛 툴팁 숨김"
L["Hide zone text"] = "지역명 숨김"
L["High"] = "높음"
L["Hillsbrad Foothills"] = "언덕마루 구릉지"
L["Hinterlands"] = "동부 내륙지"
L["Home"] = "홈"
L["Ice Thistle E'ko"] = "얼음엉겅퀴설인의 에코"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "가방 검색 창이 가방 프레임과 은행 프레임에 표시됩니다."
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "케릭창에 내구도 정보 추가"
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "그룹에 속하지 않거나 파티장 또는 부공장인 경우 설정된 키워드로 귓속말 대상에게 그룹초대가 발송됩니다."
L["If checked, a master volume slider will be shown in the character sheet."] = "마스터 볼륨 조절이 케릭터 정보 하단에 표시됩니다."
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "\"선택하면 Leatrix_Plus 미니맵버튼을 사용할 수 있습니다.|n|n왼클릭-설정창.|n|nShift/왼클릭-배경음악 켜기/끄기.|n|nCtrl/오른클릭-오류 표시/해제(설정활성된 경우).|n|nCtrl/Shift/왼클릭-Zygor(설치된 경우).|n|nCtrl/Shift/오른클릭-원도우 모드 전환.\""
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = [=[경매창의 추가 기능. |n|n즉시구입가 만! :시작가 없이 즉구가 입력만 생성.|n|n골드 만! :경매 99은99동 자동입력. |n|n아이템찾기 :경매에 아이템찾기 버튼 생성. |n|n경매 유형,기간 설정은 계정전체에 저장됩니다.

addition, the auction duration setting will be saved account-wide.]=]
L["If checked, alert frames will not be shown."] = "경고,알림 프레임이 표시되지 않습니다."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "상인과 대화시 가방에 있는 모든 회색템이 자동 판매됩니다. |n|n이 설정을 무시하려면 shift 누르고 대화 합니다."
L["If checked, available quests will be accepted automatically."] = "사용 가능한 퀘스트는 자동으로 수락됩니다."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "적대적-붉은색, 우호적-파란색"
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "BattleTag과 실명ID 친구 요청이 자동으로 거절됩니다."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "채팅창의 버튼을 숨깁니다. 최근메시지 표시-탭 클릭. 마우스휠 사용가능."
L["If checked, chat text will not fade out after a time period."] = "채팅글이 일정시간후 사라짐 비활성."
L["If checked, class coloring will be used in the player frame and target frame."] = "플레이어 프레임과 대상 프레임에서 클래스 색상이 사용됩니다."
L["If checked, class colors will be used in the chat frame."] = "이 옵션을 선택하면 채팅 프레임에서 직업색상이 사용됩니다."
L["If checked, class icons will be shown in the portrait frames."] = "프레임의 초상화 대신 클래스 아이콘이 표시됩니다."
L["If checked, completed quests will be turned-in automatically."] = "퀘스트 자동 완료(..."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "전리품 판매,우편발송 시 확인경고 표시안함."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "주문 지속시간 숨김"
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "유닛프레임 초상화에 표시되는 데미지,힐 수치 표시 숨김."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "채팅창 잠긴 경우 탭(일반/전투)드레그로 위쪽을 길이 조절 할수있습니다."
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "친구목록,길드원 제외"
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "케릭터가 다음 경우 감정표현이 음소거:|n|n- 휴식.|n- 애완동물 대전.|n- 언덕골 시장.|n- 주정뱅이 선술집.|n|n감정표현 소리는 위의 상황에 적용되지 않을때 활성화 됩니다."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "전투시에만 이름표가 표시되고 비전투시 표시되지 않습니다."
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "그룹 초대가 친구 및 길드원에게만 발송됩니다. 체크하지 않으면 그룹 초대가 모든 사람에게 발송됩니다."
L["If checked, guild names will be shown.  Guild ranks will also be shown for players in your guild."] = "길드 이름이 표시됩니다. 길드 플레이어는 길드 등급도 표시됩니다."
L["If checked, helm and cloak toggle checkboxes will be shown in the character sheet.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "투구(H) 및 망토(C) 전환 체크박스가 케릭터 정보창에 표시됩니다.  체크박스를 Shift + 마우스 오른쪽 버튼으로 클릭하여 레이아웃을 변경 할 수 있습니다."
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "오류 메시지를 숨깁니다.(예:\"잘못된 대상입니다.\")|n|n몇가지 중요한 오류는 제외됩니다."
L["If checked, nude and tabard toggle buttons will be added to the dressup frame and model rotation controls will be removed."] = "휘장 및 옷벗기 토글 버튼이 스타일링 프레임에 추가되고 모델 회전 컨트롤이 제거됩니다."
L["If checked, party invitations from friends or guild members will be automatically accepted."] = "친구 또는 길드원의 파티 초대장은 자동으로 수락됩니다."
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "친구목록,길드원 제외"
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting.|n|nRepeatable battlemaster and cloth quartermaster quests can be automatically selected by holding down the alt key."] = "퀘스트는 자동으로 선택, 수락 및 시작됩니다. |n|n 골드 요구 사항이있는 퀘스트는 자동으로 켜지지 않습니다. |n|n 퀘스트 제공자와 대화 할 때 Shift 키를 누르고 있으면이 설정을 무시할 수 있습니다. |n|n alt 키를 누르면 반복 가능한 지휘관,천 방어구 병참장교의 퀘스트를 자동으로 선택할 수 있습니다."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "파티,공격대 챗색상 모두 같은색(파티)으로"
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat."] = "부활을 요청하는 플레이어가 전투 중이 아닌 한 부활 요청은 자동으로 수락됩니다."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "버프,디버프 툴팁에 주문id 표시"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "길드,파티,공격대..대화채널을 고정 되지 않게합니다."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "비전투시 소환 자동수락"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "게임옵션의 애드온 열때 해당 케릭터의 목록 표시(기본-전체)"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "자동 전리품 획득 시간이 크게 줄어듭니다."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "소지품,은행 정리버튼 숨김"
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "블리자드 공격대 프레임을 토글(숨김/표시)하는 버튼을  공격대 관리 창 (화면의 왼쪽)  위에 표시됩니다."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "전투 로그 창을 숨깁니다."
L["If checked, the editbox will be moved to the top of the chat frame."] = "채팅입력창을 프레임 상단으로 이동 설정됩니다."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "죽음시 회색화면과 netherworld 효과가 비활성화됩니다."
L["If checked, the main bar gryphons will not be shown."] = "스킬바의 그리핀 문양 제거"
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "사용 가능한 가방 슬롯 수는 배낭 버튼 아이콘 및 툴팁에 표시됩니다."
L["If checked, the player frame background will be shown in class color."] = "플레이어 프레임이 클래스 색상으로 표시됩니다."
L["If checked, the professions frame will be larger."] = "전문기술창이 더 커집니다."
L["If checked, the quest log frame will be larger and feature a world map button and quest levels."] = "퀘스트창이 더 커지고 월드맵 버튼과 퀘스트 레벨이 표시됩니다."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "빛 효과가 비활성 됩니다.|n|n사용시 술취한 어지럼 효과가 비활성 됩니다."
L["If checked, the skill trainer frame will be larger."] = "기술 트레이너 프레임이 더 커집니다."
L["If checked, the stance bar will not be shown."] = "태세바 숨김.(전사,도적,성기사,드루...)"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "화면 하단의 NPC 대화 프레임 숨김"
L["If checked, the target frame background will be shown in class color."] = "대상 프레임이 클래스 색상으로 표시됩니다."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "툴팁의 크기,위치,배경색 설정"
L["If checked, the vendor price will be shown in item tooltips."] = "상점 판매 가격이 아이템 툴팁에 표시 됩니다."
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "상단의 지역명을 숨깁니다.추적 버튼 툴팁에 지역정보가 표시됩니다."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "줌 버튼을 숨깁니다.설정과 상관없이 마우스휠로 확대/축소 할수있습니다."
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "전투 중 월드 유닛에 대한 툴팁을 숨깁니다.|n|nShift 키를 누르고 있으면 이 설정을 무시할 수 있습니다."
L["If checked, unit targets will be shown."] = "대상의 대상 표시"
L["If checked, Wowhead links will be shown above the quest log frame."] = "와우 헤드 링크는 퀘스트 로그 프레임 위에 표시됩니다."
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip item.|n|nIf the gossip item type is banker, taxi, trainer or vendor, gossip will be skipped without needing to hold the alt key.  You can hold the shift key down to prevent this."] = "Alt키 누르고 대화창을 열면 단일 항목의 대화를 자동으로 선택합니다. 대화 유형이 은행가,택시,트레이너 또는 상인 경우 Alt키를 누르지 않아도 됩니다. 자동 대화 넘김을 방지 하려면 Shift 키를 사용합니다."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Ctrl키를 누른 상태에서 채팅창 탭을 클릭하면 복사하기 쉬운 최근의 채팅을 볼수 있습니다."
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "Ctrl/Z 키로 Leatrix Plus를 열수 있습니다."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "채팅 입력에서 삽입 포인터를 방향키로 이동 할수 있습니다."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "재생 중지 확인 없이 무비를 취소 할수 있습니다."
L["If checked, you will be able to change the font size of book text."] = "책 텍스트의 글꼴 크기를 변경할 수 있습니다."
L["If checked, you will be able to change the font size of quest text."] = "퀘스트 텍스트의 글꼴 크기를 변경할 수 있습니다."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "우편글자 크기를 변경할수 있습니다."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "버프 프레임의 위치와 스케일을 변경할 수 있습니다."
L["If checked, you will be able to change the position and scale of the following frames:|n|n- Player frame|n- Target frame|n- Widget top center frame|n- Timer bar"] = "다음 프레임의 위치와 크기를 변경할 수 있습니다.|n-플레이어 프레임|n-대상 프레임|n-상단 중앙 위젯 프레임|n-타이머 바"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "UI배치를 위한 상.하 검은색 배경 생성"
L["If checked, you will be able to customise the minimap."] = "미니맵을 사용자 정의 할 수 있습니다."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "화면 모서리로 채팅창을 옮길수 있습니다."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "대상창(기본프레임) 위에 최대 5개의 쿨다운(버프류) 아이콘을 배치 할 수 있습니다."
L["If checked, you will be able to reposition the tooltip."] = "툴팁의 위치를 변경할수 있습니다."
L["If checked, you will be able to set the density of weather effects."] = "날씨 효과의 밀도를 설정할 수 있습니다."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "플레이어 프레임에 희귀,정예 문양 표시"
L["If checked, you will be able to zoom out to a greater distance."] = "사용시 게임설정-시점-최대시야거리: Max 고정."
L["If checked, you will need to hold the shift key down for quests to be automated.|n|nIf unchecked, holding shift will prevent quests from being automated."] = "이 설정을 사용시, Shift 키를 누르고 있어야 퀘스트가 자동화 됩니다.|n|n이 설정을 끄면, Shift 키를 누를때 퀘스트가 자동화 안 됩니다!!"
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "전장에서 사망 한 후 자동으로 해제됩니다. |n|n 자기 부활 능력이 있으면 자동으로 해제되지 않습니다."
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "상인,은행 NPC 대화 할때"
L["If checked, your character will automatically stand or dismount when an action is prevented because you are either seated or mounted."] = "앉거나 탈것에 타고 있는 행동이 금지 될 때 캐릭터가 자동으로 서거나 탈것에 내립니다.??"
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "기본 128행을 4096행으로 증가"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "상인을 방문 할때 장비가 자동으로 수리됩니다.|n|nShift키 누른채 대화시 자동 무시."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "화면 가운데 표시되는 지역명 숨김. (예: 아이언포지)"
L["Increase chat history"] = "채팅 기록 증가"
L["Interface"] = "인터페이스"
L["Invaders of Alterac Valley"] = "알터랙 계곡의 침략자"
L["Invalid console variable."] = "잘못된 콘솔 변수."
L["Invalid parameter."] = "잘못된 매개변수"
L["Invalid quest ID."] = "잘못된 퀘스트ID"
L["Invalid sound ID"] = "잘못된 사운드 ID"
L["Invalid taint level."] = "잘못된 오염 레벨입니다."
L["Invalid target."] = "잘못된 대상"
L["Invite from whispers"] = "귓속말 초대"
L["Kalimdor"] = "칼림도어"
L["Keyword"] = "키워드"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus는 다음 로그 아웃시 LeaPlusDB를 덮어 쓰지 않습니다."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS : 잘못된 버전이 설치되었습니다!"
L["Left"] = "왼쪽"
L["Lifetime honorable kills"] = "전체 명예 승수"
L["Loch Modan"] = "모단 호수"
L["Lockout sharing"] = "업적공유 잠금"
L["Low"] = "Low"
L["Magic"] = "Magic"
L["Main Titles"] = "메인 타이틀"
L["Manage buffs"] = "버프 설정"
L["Manage frames"] = "프레임 설정"
L["Manage tooltip"] = "툴팁 설정"
L["Managed by Leatrix Plus"] = "Leatrix Plus 에서 설정"
L["Map"] = "지도"
L["Maraudon"] = "마라우돈"
L["Max camera zoom"] = "시야거리 최대 고정"
L["Mechanics"] = "기능"
L["Media"] = "미디어"
L["Medium"] = "중간"
L["Memory Usage"] = "메모리 사용"
L["message shown."] = "메시지가 표시됩니다."
L["messages shown."] = "메시지가 표시됩니다."
L["Missing console variable."] = "누락된 콘솔 변수."
L["Missing mount name."] = "누락된 탈거."
L["Missing movie ID."] = "잘못된 무비 ID."
L["Missing quest ID."] = "퀘스트ID 없음"
L["Missing sound file parameter."] = "소리 파일 매개변수 에러"
L["Missing sound ID."] = "누락 된 사운드 ID."
L["Molten Core"] = "화산 심장부"
L["Moonglade"] = "달숲"
L["Mount not found."] = "탈거를 찾을수 없습니다."
L["Move editbox to top"] = "입력창 상단"
L["Movie not playable."] = "무비를 재생할수 없습니다."
L["Movie number"] = "무비 번호"
L["Movies"] = "무비"
L["Mulgore"] = "멀고어"
L["Music"] = "배경음악"
L["Musical Moments"] = "Musical Moments"
L["Mystery"] = "Mystery"
L["Narration"] = "Narration"
L["Naxxramas"] = "낙스라마스"
L["No bad sound IDs found."] = "잘못된 ID를 찾을수 없습니다."
L["No help is available for this page."] = "도움말을 사용할수 없습니다."
L["No items with durability equipped."] = "내구성 갖춘 아이템이 없습니다."
L["No media duplicates found."] = "중복된 미디어가 없습니다."
L["No tooltip showing."] = "툴팁이 없습니다."
L["None"] = "없음"
L["Not completed."] = "미완료"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "주의!|nLeatrix Plus 이 버전을 적용하려면 게임 클라이언트를 다시 시작해야합니다."
L["Nude"] = "옷벗기"
L["Onyxia's Lair"] = "오닉시아의 둥지"
L["or click the minimap button to open Leatrix Plus."] = "미니 맵 버튼을 클릭하여 Leatrix Maps를 엽니 다."
L["Orgrimmar"] = "오그리마"
L["Overall"] = "전체"
L["Overlay"] = "오버레이"
L["Particle density"] = "입자 밀도"
L["Party from friends"] = "친구의 파티"
L["Pet"] = "소환수"
L["Player"] = "플레이어"
L["Power"] = "파워"
L["Press CTRL/C to copy."] = "Ctrl+C 를 눌러 복사."
L["Queue from friends"] = "친구의 대기열"
L["R"] = "R"
L["Ragefire Chasm"] = "성난불길 협곡"
L["Raid"] = "공격대"
L["Raid frame toggle"] = "레이드 프레임 토글"
L["Random"] = "무작위 재생"
L["RARE"] = "희귀"
L["RARE ELITE"] = "희귀 정예"
L["Razorfen Downs"] = "가시덩굴 구릉"
L["Razorfen Kraul"] = "가시덩굴 우리"
L["Recent chat window"] = "최근 채팅 창"
L["Redridge Mountains"] = "붉은마루 산맥"
L["Release in PvP"] = "PvP지역 부활 수락 해제"
L["Reload"] = "리로드"
L["Remember Alterac Valley!"] = "잊지 말자, 알터랙 계곡!"
L["Repair automatically"] = "자동 수리"
L["Repaired for"] = "수리비"
L["Reposition the tooltip"] = "툴팁 위치 설정"
L["Require shift key for quest automation"] = "퀘스트 자동화를 위해 Shift 키 필요"
L["Requires UI reload."] = "UI 리로드 필요."
L["Reset"] = "재설정"
L["Resize book text"] = "책 글꼴크기 변경"
L["Resize mail text"] = "우편 글자 설정"
L["Resize quest text"] = "퀘스트 글자 설정"
L["Resize Screen"] = "화면 크기 조정"
L["Rested bubbles"] = "휴식 버블"
L["Restrict to friends and guild members"] = "친구와 길드원으로 제한"
L["result"] = "결과"
L["results"] = "결과들"
L["Right"] = "오른쪽"
L["Right-click to close"] = "창닫기:우클릭."
L["Right-click to close."] = "창닫기:우클릭. ."
L["right-click to go back"] = "마우스 오른쪽 클릭으로 뒤로 이동."
L["Ruins of Ahn'Qiraj"] = "안퀴라즈 폐허"
L["Sacred"] = "Sacred"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "성난모래, 백골가루, 붉은머리부족 주화"
L["Scale"] = "크기"
L["Scarlet Monastery"] = "붉은십자군 수도원"
L["Scholomance"] = "스칼로맨스"
L["Search"] = "검색"
L["Searing Gorge"] = "이글거리는 협곡"
L["Select the settings that you want to use."] = "사용하려는 설정을 선택합니다."
L["Selection of music tracks"] = "음악 트랙 선택"
L["Self Markers Allowed"] = "전술 징표 허용 "
L["Self Markers Blocked"] = "전술 징표 차단"
L["Sell junk automatically"] = "회색템 자동 판매"
L["SELLING JUNK"] = "자동판매"
L["Set weather density"] = "날씨 밀도 설정"
L["Settings"] = "설정"
L["Shaders"] = "쉐이더"
L["Shadowfang Keep"] = "그림자송곳니 성채"
L["Shardtooth E'ko"] = "톱니이빨곰의 에코"
L["Show auction controls"] = "경매 추가 기능"
L["Show bag search box"] = "가방 검색창 표시"
L["Show character addons"] = "케릭터 애드온 표시"
L["Show cooldowns"] = "쿨다운 아이콘 표시"
L["Show durability status"] = "내구도 표시"
L["Show free bag slots"] = "가방 빈칸 수 표시"
L["Show guild names"] = "길드명 표시"
L["Show minimap button"] = "미니맵 버튼 표시"
L["Show player chain"] = "플레이어 테두리 표시"
L["Show player frame in class color"] = "플레이어 프레임 직업색상 표시"
L["Show target frame in class color"] = "대상 프레임 직업색상 표시"
L["Show the spell ID in buff icon tooltips"] = "툴팁 주문ID 표시"
L["Show unit targets"] = "Show unit targets"
L["Show vanity controls"] = "투구,망토 설정 표시"
L["Show vendor price"] = "상점 판매가 표시"
L["Show volume slider"] = "소리 조절 표시"
L["Show Wowhead links"] = "와우헤드 링크 표시"
L["Silence rested emotes"] = "감정표현 음소거"
L["Silithus"] = "실리더스"
L["Silverpine Forest"] = "은빛소나무 숲"
L["Social"] = "소셜"
L["Sold junk for"] = "회색템 판매"
L["Sound system restarted."] = "사운드 시스템 재시작."
L["Spell ID"] = "주문 ID"
L["Spooky"] = "Spooky"
L["Stand and dismount"] = "서거나 탈것내림"
L["Stockade"] = "스톰윈드 지하감옥"
L["Stonetalon Mountains"] = "돌발톱 산맥"
L["Stop"] = "중지"
L["Stormwind"] = "스톰윈드"
L["Stranglethorn Vale"] = "가시덤불 골짜기"
L["Stratholme"] = "스트라솔름"
L["Sunken Temple"] = "가라앉은 사원"
L["Support"] = "지원"
L["Swamp"] = "Swamp"
L["Swamp of Sorrows"] = "슬픔의 늪"
L["System"] = "시스템"
L["Tabard"] = "휘장숨김"
L["Taint level: Basic (1)."] = "오염 레벨: Basic (1)"
L["Taint level: Disabled (0)."] = "오염 레벨: 비활성(0)"
L["Taint level: Full (2)."] = "오염 레벨: Full (2)"
L["Tanaris"] = "타나리스"
L["Target"] = "대상"
L["Target Tracking Disabled"] = "대상 추적 사용안함"
L["Target Tracking Enabled"] = "대상 추적 사용"
L["Teldrassil"] = "텔드랏실"
L["Temple of Ahn'Qiraj"] = "안퀴라즈"
L["Temple of Atal'Hakkar"] = "아탈학카르 신전"
L["Ten Years of Warcraft"] = "워크래프트 10주년"
L["Text"] = "글자"
L["Text size"] = "글자 크기"
L["Text Size"] = "글자 크기"
L["The summon from"] = "당신을 소환하는 자"
L["Themes"] = "테마"
L["This panel will close automatically if you enter combat."] = "전투시 자동으로 닫힙니다."
L["Thousand Needles"] = "버섯구름 봉우리"
L["Timer"] = "미러바"
L["Tirisfal Glades"] = "티리스팔 숲"
L["To begin, choose an options page."] = "설정 페이지를 선택합니다."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "아이템찾기 사용하려면, 'WoW토큰' 카테고리 선택을 취소 해야 합니다. "
L["Tooltip"] = "툴팁"
L["Tooltip title color"] = "툴팁 제목 색상"
L["Top"] = "상단"
L["Top Center"] = "탑 센터"
L["Tracing started."] = "추적 시작."
L["Tracing stopped."] = "추적 중지."
L["Transparency"] = "투명도"
L["True"] = "참된"
L["Turn-in completed quests automatically"] = "퀘스트 자동 완료"
L["Uldaman"] = "울다만"
L["Unclamp chat frame"] = "채팅창 고정 해제"
L["Undercity"] = "언더시티"
L["Un'Goro Crater"] = "운고로 분화구"
L["Universal group color"] = "그룹 색상 통합"
L["Use arrow keys in chat"] = "방향키 사용"
L["Use class colors in chat"] = "채팅 직업색상 사용"
L["Use easy resizing"] = "쉬운 크기조절"
L["Value must be a number."] = "값은 숫자 이여야 합니다."
L["Various"] = "기타"
L["Vendors"] = "상인"
L["Version"] = "버전"
L["Very Low"] = "아주 낮음"
L["Video"] = "비디오"
L["Visibility"] = "가시성"
L["Wailing Caverns"] = "통곡의 동굴"
L["was automatically declined."] = "자동으로 거절되었습니다."
L["Weather density"] = "기상 밀도"
L["Welcome to Leatrix Plus."] = "Leatrix Plus 에 오신 것을 환영합니다."
L["Western Plaguelands"] = "서부 역병지대"
L["Westfall"] = "서부 몰락지대"
L["Wetlands"] = "저습지"
L["Widget"] = "위젯"
L["Wildkin E'ko"] = "올빼미야수의 에코"
L["will be automatically accepted in 10 seconds unless cancelled."] = "취소하지 않으면 10 초 후에 자동으로 수락됩니다."
L["Winter"] = "겨울"
L["Winterfall E'ko"] = "눈사태일족의 에코"
L["Winterspring"] = "여명의 설원"
L["World of Warcraft"] = "월드 오브 워크래프트"
L["X Offset"] = "X 오프셋"
L["Y Offset"] = "Y 오프셋"
L["YOU"] = "당신"
L["You cannot do that in combat."] = "전투중으로 할수 없습니다."
L["You have"] = "장비 내구도"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "일부 변경사항을 적용하려면 UI를 다시 로드 하여야 합니다. 요구시 리로드 버튼 활성화."
L["Your UI needs to be reloaded."] = "당신의 UI는 다시 로드 해야 합니다."
L["Zones"] = "지역"
L["Zul'Farrak"] = "줄파락"
L["Zul'Gurub"] = "줄구룹"
L["Zulian, Razzashi, and Hakkari Coins"] = "줄리안, 래즈자쉬, 학카리부족 주화"
L["Zygor addon not found."] = "Zygor 애드온 찾을수 없음."

end

-- esMX: Spanish (Mexico)
if GameLocale == "esMX" then
L["+"] = "+"
L["A Donation of Mageweave"] = "Un donativo de tejido mágico"
L["A Donation of Runecloth"] = "Un donativo de paño rúnico"
L["A Donation of Silk"] = "Un donativo de seda"
L["A Donation of Wool"] = "Un donativo de lana"
L["A friend request from"] = "Una solicitud de amistad de"
L["Accept available quests automatically"] = "Aceptar misiones disponibles automáticamente"
L["Accept resurrection"] = "Aceptar resucitación"
L["Accept summon"] = "Aceptar invocación"
L["Additional Runecloth"] = "Un donativo extra de paño rúnico"
L["Addon"] = "Addon"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alterac Mountains"] = "Montañas de Alterac"
L["Anchor"] = "Anclar"
L["Angelic"] = "Angélico"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Ashenvale"] = "Vallefresno"
L["Auto loot is now enabled."] = "Despojar automáticamente se ha habilitado."
L["AutoFollow"] = "Seguir automáticamente"
L["AutoFollow disabled."] = "Seguir automáticamente se ha deshabilitado"
L["Automate gossip"] = "Automatizar diálogo"
L["Automate quests"] = "Automatizar misiones"
L["Automation"] = "Automatizar"
L["Azshara"] = "Azshara"
L["Back to Main Menu"] = "Volver a menú principal"
L["Bad ID"] = "ID inválida"
L["Badlands"] = "Tierras Inhóspitas"
L["Barrens"] = "Los Baldíos"
L["Battle"] = "Batalla"
L["Battle of Warsong Gulch"] = "La batalla por Garganta Grito de Guerra"
L["Battlegrounds"] = "Campos de Batalla"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackwing Lair"] = "Guarida de Alanegra"
L["Blasted Lands"] = "Las Tierras Devastadas"
L["Block duels"] = "Duelos"
L["Block friend requests"] = "Solicitudes de amistad"
L["Block party invites"] = "Invitaciones de grupo"
L["Blocks"] = "Rechazar"
L["Bottom"] = "Inferior"
L["Buffs"] = "Buffs"
L["Burning Steppes"] = "Las Estepas Ardientes"
L["Buyout Only"] = "Sola compra"
L["C"] = "C"
L["Camera distance"] = "Distancia de cámara"
L["Chain style"] = "Estilo de cadena"
L["Character"] = "Personaje"
L["Chat"] = "Chat"
L["Chat Frame"] = "Marco de chat"
L["Checkbox labels are Ok."] = "Las etiquetas de las casillas de verificación están bien."
L["Chillwind E'ko"] = "E'ko Orvallo"
L["Cinematics"] = "Cinemáticas"
L["Claiming Arathi Basin"] = "Reclamo por la Cuenca de Arathi"
L["Class colored frames"] = "Marcos coloreados"
L["Class icon portraits"] = "Retratos de clase"
L["Classic"] = "Clásico"
L["click here for new selection"] = "haga clic para nueva selección"
L["Click to configure the settings for this option."] = "Haga clic para configurar la configuración para esta opción"
L["Click to reset the settings on this page."] = "Haga clic para restablecer la configuración en esta página"
L["Click to resize the screen to fit between the top and bottom borders."] = "Haga clic para cambiar el tamaño de la pantalla para que se ajuste entre los bordes superior e inferior."
L["Click to return to the main menu."] = "Haga clic para volver al menú principal"
L["Cloak"] = "Espalda"
L["Color the backdrops based on faction"] = "Colorea los fondos según la facción"
L["Combat log cannot be hidden while undocked."] = "El registro de combate no se puede ocultar mientras está desacoplado."
L["Combat plates"] = "Placas de combate"
L["Completed."] = "Completado."
L["Concerted Efforts"] = "Esfuerzos concertados"
L["Configuration Panel"] = "Panel de Configuración"
L["Connections for"] = "Conexiones de"
L["Conquering Arathi Basin"] = "La conquista de la Cuenca de Arathi"
L["Credits"] = "Créditos"
L["Cursor"] = "Cursor"
L["Cursor Left"] = "Cursor izquierdo"
L["Cursor Right"] = "Cursor derecho"
L["Customise minimap"] = "Minimapa"
L["D"] = "C"
L["Darkmoon Faire"] = "Feria de la Luna Negra"
L["Darkshore"] = "Costa Oscura"
L["Deadmines"] = "Minas de la Muerte"
L["Deadwind Pass"] = "Paso de la Muerte"
L["Desolace"] = "Desolace"
L["Dire Maul"] = "La Masacre"
L["Disable bag automation"] = "Bolsas"
L["Disable chat fade"] = "Desvanecimiento"
L["Disable loot warnings"] = "Advertencias del botín"
L["Disable screen effects"] = "Efectos de pantalla"
L["Disable screen glow"] = "Brillo de pantalla"
L["Disable sticky chat"] = "Chat pegajoso"
L["Drag the frame overlay to position the frame."] = "Arrastra la superposición del marco para colocar el marco."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Arrastra la superposición de los marco para colocar los marcos.|n|nPara cambiar la escala de un marco, haga clic para seleccionarlo y luego ajuste el control deslizante de escala.|n|nEste panel se cerrará automáticamente si entras en combate."
L["Drag to set the buffs frame scale."] = "Arrastra para establecer la escala del marco de los bufos."
L["Drag to set the cursor X offset."] = "Arrastra para establecer el desplazamiento del cursor X."
L["Drag to set the cursor Y offset."] = "Arrastra para establecer el desplazamiento del cursor Y."
L["Drag to set the density of weather effects."] = "Arrastra para establecer la densidad de los efectos entornos."
L["Drag to set the font size of book text."] = "Arrastra para establecer el tamaño de fuente del texto de libro."
L["Drag to set the font size of mail text."] = "Arrastra para establecer el tamaño de fuente del texto de correo."
L["Drag to set the font size of quest text."] = "Arrastra para establecer el tamaño de fuente del texto de misión."
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "Arrastra para establecer la escala del minimapa.|n|nTenga en cuenta que si está utilizando las barras de acción predeterminadas, volver a escalar el minimapa también volverá a escalar las barras de acción derecha al inicio, por lo que es posible que desee dejar esto al 100%."
L["Drag to set the scale of the Leatrix Plus panel."] = "Arrastra para establecer la escala del panel Leatrix Plus."
L["Drag to set the scale of the selected frame."] = "Arrastra para establecer la escala del marco seleccionado."
L["Drag to set the size of the bottom border."] = "Arrastra para establecer el tamaño del borde inferior."
L["Drag to set the size of the left border."] = "Arrastra para establecer el tamaño del borde izquierdo."
L["Drag to set the size of the right border."] = "Arrastra para establecer el tamaño del borde derecho."
L["Drag to set the size of the top border."] = "Arrastra para establecer el tamaño del borde superior."
L["Drag to set the tooltip scale."] = "Arrastra para establecer la escala del tooltip."
L["Drag to set the transparency of the borders."] = "Arrastra para establecer la transparencia de los bordes."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Arrastra para establecer la transparencia del panel Leatrix Plus."
L["Dun Morogh"] = "Dun Morogh"
L["Dungeons"] = "Calabozos"
L["Dup ID"] = "ID Copia"
L["durability"] = "durabilidad"
L["Durability"] = "Durabilidad"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Eastern Kingdoms"] = "Reinos del Este"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["ELITE"] = "ÉLITE"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["Enable hotkey"] = "Habilitar teclado"
L["Enable viewport"] = "Vista de ventana"
L["Enhance dressup"] = "Probador"
L["Enhance professions"] = "Profesiones"
L["Enhance quest log"] = "Registro de misiones"
L["Enhance trainers"] = "Instructores"
L["Enhancements"] = "Mejoras"
L["Enter"] = "Entrar"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "Entra la ID de hechizo para los iconos de reutilización que desea ver.|n|nSi normalmente aparece un icono de reutilización debajo del marco de la mascota, marca la casilla de verificación mascota.|n|Los iconos de reutilización se guardan en tu clase."
L["enter zone or track name"] = "entra zona o rastrea el nombre"
L["Error messages will be hidden"] = "Mensajes de error se ocultarán"
L["Error messages will be shown"] = "Mensajes de error se mostrarán"
L["Events"] = "Eventos"
L["Extras"] = "Excesos"
L["False"] = "Falso"
L["Faster auto loot"] = "Despojar rápido"
L["Faster movie skip"] = "Saltar película rápido"
L["Features"] = "Caracteristicas"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Fight for Warsong Gulch"] = "Lucha por Garganta Grito de Guerra"
L["Find Item"] = "Buscar objeto"
L["For Great Honor"] = "Cuestión de honor"
L["Frames"] = "Marcos"
L["Frostmaul E'ko"] = "E'ko de los Machacahielo"
L["Frostsaber E'ko"] = "E'ko de sable de hielo"
L["Game Options"] = "Opciones de juego"
L["Ghost"] = "Fantasma"
L["Gloomy"] = "Melancólico"
L["Gnomeregan"] = "Gnomeregan"
L["Gold Only"] = "Solo oro"
L["Graphics and Sound"] = "Gráficos y sonido"
L["Groups"] = "Grupos"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "Las monedas Gurubashi, Vilrama y Secacorteza"
L["H"] = "H"
L["Haunted"] = "Encantado"
L["Helm"] = "Cabeza"
L["Help"] = "Ayuda"
L["Hide chat buttons"] = "Botones de chat"
L["Hide cooldown duration numbers (if enabled)"] = "Ocultar números de reutilización (si habilitado)"
L["Hide error messages"] = "Mensajes de error"
L["Hide gryphons"] = "Grifos"
L["Hide portrait numbers"] = "Números del retrato"
L["Hide stance bar"] = "Barra de actitud"
L["Hide the combat log"] = "Registro de combate"
L["Hide the zone text bar"] = "Ocultar texto de zona"
L["Hide the zoom buttons"] = "Ocultar los botones de acercar/alejar"
L["Hide tooltips for world units during combat"] = "Ocultar tooltips para unidades del mundo si estés en combate"
L["Hide zone text"] = "Texto de zona"
L["High"] = "Alto"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Hinterlands"] = "Tierras del Interior"
L["Home"] = "Principal"
L["Ice Thistle E'ko"] = "E'ko de los Cardo Nevado"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "Si está seleccionado, se mostrará un cuadro de búsqueda de bolsas en el marco de la mochila y el marco del banco."
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Si está seleccionado, se agregará un botón a la información del personaje que mostrará la durabilidad de su equipo cuando pase el puntero sobre él.|n|nAdemás, se mostrará un porcentaje general en el marco del chat cuando muera."
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "Si está seleccionado, se enviará una invitación a grupo a cualquier persona que te susurre con una palabra clave establecida siempre y cuando estés desagrupado, líder de grupo o asistente de banda."
L["If checked, a master volume slider will be shown in the character sheet."] = "Si está seleccionado, se mostrará un control deslizante de volumen maestro en la información del personaje."
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "Si está seleccionado, un botón de minimapa estará disponible.|n|nClic - Alternar panel de opciones.|n|nShift+Clic izquierdo: alternar música.|n|nCtrl+Clic derecho - Alternar errores (si está habilitado).|n|nCtrl+Shift+Clic izquierdo - Alternar Zygor (si está instalado)|n|nCtrl+Shift+Clic derecho - Alternar el modo de ventana."
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "Si está seleccionado, se agregará funcionalidad adicional a la casa de subastas.|n|nSolo compra: cree subastas de compra sin completar el precio inicial.|n|nSolo oro: establezca los precios del cobre y la plata en 99 para acelerar las nuevas subastas.|n|nBuscar objeto: busca en la casa de subastas el objeto que estás vendiendo.|n|nAdemás, la configuración de duración de la subasta se guardará en toda la cuenta."
L["If checked, alert frames will not be shown."] = "Si está seleccionado, no se mostrarán los marcos de alerta."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si está seleccionado, todos los objetos de calidad pobre en sus bolsas se venderán automáticamente cuando visite a un mercader.|n|nPuede mantener presionada la tecla shift cuando hable con un mercader para anular esta configuración."
L["If checked, available quests will be accepted automatically."] = "Si está seleccionado, las misiones disponibles se aceptarán automáticamente."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Si está seleccionado, los fondos se teñirán de azul (amigable) o rojo (hostil)."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Si está seleccionado, las solicitudes de amistad de BattleTag y Real ID se rechazarán automáticamente.|n|nHabilitar esta opción rechazará automáticamente cualquier solicitud pendiente."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Si está seleccionado, los botones del marco de chat estarán ocultos.|n|nAl hacer clic en las pestañas de chat, se mostrarán automáticamente los últimos mensajes.|n|nUsa la rueda del ratón para desplazarse por el historial de chat. Mantenga presionada la tecla shift para saltar de página o Ctrl para saltar a la parte superior o inferior del historial de chat."
L["If checked, chat text will not fade out after a time period."] = "Si está seleccionado, el texto del chat no se desvanecerá después de un período de tiempo."
L["If checked, class coloring will be used in the player frame and target frame."] = "Si está seleccionado, se usará el color de la clase en el marco del jugador y el marco del objetivo."
L["If checked, class colors will be used in the chat frame."] = "Si está seleccionado, los colores de la clase se usarán en el marco del chat."
L["If checked, class icons will be shown in the portrait frames."] = "Si está seleccionado, los iconos de clase se mostrarán en los marcos de retrato."
L["If checked, completed quests will be turned-in automatically."] = "Si está seleccionado, las misiones completadas se entregarán automáticamente."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Si está seleccionado, las confirmaciones ya no aparecerán cuando elija una opción de botín o cuando intente vender o enviar un objeto comercializable."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Si está seleccionado, los números de reutilización no se mostrarán sobre el hechizo.|n|nSi no está marcado, los números de reutilización se mostrarán sobre el hechizo si están habilitados en el panel de opciones del juego (menú 'Barras de Acción')."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Si está seleccionado, se ocultarán los números de daño y sanación en los marcos de retrato de jugador y mascota."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Si está seleccionado, arrastrando la pestaña de chat General mientras el marco de chat está bloqueado expandirá el marco de chat hacia arriba.|n|nSi el marco de chat está desbloqueado, arrastrando la pestaña de chat General se moverá el marco de chat."
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "Si está seleccionado, las solicitudes de duelo se rechazarán a menos que el jugador que solicita el duelo esté en tu lista de amigos o hermandad."
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "Si está seleccionado, los sonidos de emoción se silenciarán mientras tu personaje esté descansando o en El Tragapenas.|n|nLos sonidos de emoción se habilitarán en cualquier otro momento."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Si está seleccionado, las placas identificativas del enemigo se mostrarán durante el combate y se ocultarán cuando finalice el combate."
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "Si está seleccionado, las invitaciones a grupos solo se enviarán a amigos y miembros de la hermandad.|n|nSi no está marcado, se enviarán invitaciones a grupos a todos."
L["If checked, guild names will be shown.  Guild ranks will also be shown for players in your guild."] = "Si está seleccionado, se mostrarán los nombres de las hermandades. Los rangos de hermandad también se mostrarán para los jugadores de tu hermandad."
L["If checked, helm and cloak toggle checkboxes will be shown in the character sheet.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "Si está seleccionado, las casillas de alternar cabeza y espalda se mostrarán en la información del personaje.|n|nPuede mantener presionada la tecla shift y hacer clic con el botón derecho en las casillas de verificación para cambiar de visualización."
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "Si está seleccionado, la mayoría de los mensajes de error (como 'No tienes suficiente ira') no se mostrarán. Se excluyen algunos errores importantes.|n|nSi tiene habilitado el botón de minimapa, puede mantener presionada la tecla de control y hacer clic con el botón derecho para alternar los mensajes de error sin afectar esta configuración."
L["If checked, nude and tabard toggle buttons will be added to the dressup frame and model rotation controls will be removed."] = "Si está seleccionado, se agregarán botones de alternancia desnudos y de tabardo al marco de probador y se eliminarán los controles de rotación del modelo."
L["If checked, party invitations from friends or guild members will be automatically accepted."] = "Si está seleccionado, las invitaciones a grupos de amigos o miembros de la hermandad serán aceptadas automáticamente."
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "Si está seleccionado, las invitaciones a grupos se rechazarán a menos que el jugador que te invite esté en tu lista de amigos o hermandad."
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting.|n|nRepeatable battlemaster and cloth quartermaster quests can be automatically selected by holding down the alt key."] = "Si está seleccionado, las misiones serán seleccionadas, aceptadas y entregadas automáticamente.|n|nLas misiones que tienen un requisito de oro no se entregarán automáticamente.|n|nPuede mantener presionada la tecla Shift cuando hable con un asignador de misiones para anular esta configuración.|n|nLas misiones repetibles de maestro de batalla y de intendente de tela se pueden seleccionar automáticamente manteniendo presionada la tecla alt."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Si está seleccionado, el chat de banda y el chat de instancia serán de color azul (para que coincida con el color predeterminado del chat del grupo)."
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat."] = "Si está seleccionado, las solicitudes de resucitación se aceptarán automáticamente siempre que el jugador que te resucite no esté en combate."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "Si está seleccionado, la ID de hechizo se mostrarán en el tooltip del icono de buff ubicado en el marco de buff y debajo del marco de objetivo."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Si está seleccionado, el chat pegajoso se deshabilitará.|n|nTenga en cuenta que esto no se aplica a las ventanas de chat temporales."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Si está seleccionado, las solicitudes de invocación serán aceptadas automáticamente a menos que estés en combate."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Si está seleccionado, la lista de addons (accesible desde el menú del juego) mostrará addons basados en personajes de forma predeterminada."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Si está seleccionado, el tiempo que se tarda en despojar automáticamente a las criaturas se reducirá significativamente."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Si está seleccionado, el botón de limpieza de la mochila y el botón de limpieza del marco del banco no se mostrarán."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Si está seleccionado, el botón para alternar el marco del contenedor de banda se mostrará justo encima del marco de administración de banda (lado izquierdo de la pantalla) en lugar de en el marco de administración de banda en sí.|n|nEsto le permite alternar el marco del contenedor de banda sin necesidad de abrir el marco de administración de banda."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Si está seleccionado, el registro de combate estará oculto.|n|nEl registro de combate debe estar acoplado para que esta opción funcione.|n|nSi el registro de combate está desacoplado, puedes acoplarlo arrastrando la pestaña (y recargando tu IU) o restableciendo las ventanas de chat (desde el menú de chat)."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Si está seleccionado, el cuadro de edición se moverá a la parte superior del marco de chat."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Si está seleccionado, la pantalla gris de la muerte y el efecto del inframundo se deshabilitarán."
L["If checked, the main bar gryphons will not be shown."] = "Si está seleccionado, no se mostrarán los grifos de la barra principal."
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "Si está seleccionado, la cantidad de casillas para bolsas disponibles se mostrará en el icono del botón de la mochila y en el tooltip."
L["If checked, the player frame background will be shown in class color."] = "Si está seleccionado, el fondo del marco del jugador se mostrará en color de clase."
L["If checked, the professions frame will be larger."] = "Si está seleccionado, el marco de profesiones será más grande."
L["If checked, the quest log frame will be larger and feature a world map button and quest levels."] = "Si está seleccionado, el marco de registro de misiones será más grande y contará con un botón de mapa mundial y niveles de misión."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Si está seleccionado, el brillo de la pantalla se deshabilitará.|n|nHabilitar esta opción también deshabilitará el efecto de borracho."
L["If checked, the skill trainer frame will be larger."] = "Si está seleccionado, el marco del instructor de habilidades será más grande."
L["If checked, the stance bar will not be shown."] = "Si está seleccionado, la barra de actitud no mostrará."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Si está seleccionado, el marco de conversación no se mostrará.|n|nEl marco de conversación normalmente aparece en la parte inferior de la pantalla cuando ciertos PNJs se comunican con usted."
L["If checked, the target frame background will be shown in class color."] = "Si está seleccionado, el fondo del marco de objetivo se mostrará en color de clase."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Si está seleccionado, el tooltip estará codificada por colores y podrá modificar la visualización y la escala del tooltip."
L["If checked, the vendor price will be shown in item tooltips."] = "Si está seleccionado, el precio de venta se mostrará en el tooltip del objeto."
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "Si está seleccionado, el texto de la zona estará oculta. El tooltip del botón de rastreo mostrará información de la zona."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Si está seleccionado, los botones de acercar/alejar estarán ocultos. Puede usar la rueda del ratón para acercar independientemente de esta configuración."
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "Si está seleccionado, el tooltip para las unidades mundiales se ocultará durante el combate.|n|nPuede mantener presionada la tecla shift para anular esta configuración."
L["If checked, unit targets will be shown."] = "Si está seleccionado, se mostrarán los objetivos de la unidad."
L["If checked, Wowhead links will be shown above the quest log frame."] = "Si está seleccionado, los enlaces de Wowhead se mostrarán sobre el marco del registro de misiones."
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip item.|n|nIf the gossip item type is banker, taxi, trainer or vendor, gossip will be skipped without needing to hold the alt key.  You can hold the shift key down to prevent this."] = "Si está seleccionado, puede mantener presionada la tecla alt mientras abre una ventana de diálogo para seleccionar automáticamente un solo tipo de diálogo.|n|nSi el tipo de diálogo es banquero, taxi, instructor o vendedor, se omitirán los diálogos sin necesidad de mantener presionada la tecla alt. Puede mantener presionada la tecla shift para evitar esto."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Si está seleccionado, puede mantener presionada la tecla de control y hacer clic en una pestaña de chat para ver el chat reciente en una ventana fácil de copiar."
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "Si está seleccionado, puede abrir Leatrix Plus presionando Ctrl+Z."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Si está seleccionado, puede presionar las teclas de flecha para mover el punto de inserción hacia la izquierda y hacia la derecha en el marco del chat.|n|nSi no está marcado, las teclas de flecha utilizarán la configuración predeterminada del teclado."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Si está seleccionado, podrá cancelar cinemáticas sin que se le solicite confirmación."
L["If checked, you will be able to change the font size of book text."] = "Si está seleccionado, podrá cambiar el tamaño de fuente del texto de libro."
L["If checked, you will be able to change the font size of quest text."] = "Si está seleccionado, podrá cambiar el tamaño de fuente del texto de misión."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Si está seleccionado, podrá cambiar el tamaño de fuente del texto de correo.|n|nEsto no afecta el correo creado con plantillas (como las facturas de la casa de subastas)."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "Si está seleccionado, podrá cambiar la posición y la escala del marco de los bufos."
L["If checked, you will be able to change the position and scale of the following frames:|n|n- Player frame|n- Target frame|n- Widget top center frame|n- Timer bar"] = "Si está seleccionado, podrá cambiar la posición y la escala de los siguientes marcos:|n|n- Marco del jugador|n- Marco del objetivo|n- Marco central superior del artilugio|n- Barra de temporizador"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Si está seleccionado, podrá crear una ventana de vista. Una ventana de vista agrega bordes negros ajustables alrededor del mundo del juego.|n|nLos bordes se colocan en la parte superior del mundo del juego pero debajo de la interfaz de usuario para que pueda colocar elementos de la interfaz de usuario sobre ellos."
L["If checked, you will be able to customise the minimap."] = "Si está seleccionado, podrá personalizar el minimapa."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Si está seleccionado, podrá arrastrar el marco del chat al borde de la pantalla."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Si está seleccionado, podrá colocar hasta cinco iconos de reutilización sobre el marco del objetivo."
L["If checked, you will be able to reposition the tooltip."] = "Si está seleccionado, podrá reposicionar el tooltip."
L["If checked, you will be able to set the density of weather effects."] = "Si está seleccionado, podrá establecer la densidad de los efectos entornos."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Si está seleccionado, podrá mostrar una cadena de élite rara, élite o rara alrededor del marco del jugador."
L["If checked, you will be able to zoom out to a greater distance."] = "Si está seleccionado, podrá alejarse a una distancia mayor."
L["If checked, you will need to hold the shift key down for quests to be automated.|n|nIf unchecked, holding shift will prevent quests from being automated."] = "Si está seleccionado, deberás mantener presionada la tecla Shift para que las misiones se automaticen.|n|nSi no está seleccionado, mantener presionada la tecla Shift evitará que las misiones se automaticen."
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "Si está seleccionado, liberarás automáticamente después de morir en un campo de batalla.|n|nNo lo liberarás automáticamente si tienes la capacidad de resucitarte a ti mismo."
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "Si está seleccionado, sus bolsas no se abrirán o cerrarán automáticamente cuando interactúe con un mercader, banco o buzón."
L["If checked, your character will automatically stand or dismount when an action is prevented because you are either seated or mounted."] = "Si está seleccionado, tu personaje se levantará o desmontará automáticamente cuando se evite una acción porque estás sentado o montado."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Si está seleccionado, su historial de chat aumentará a 4096 líneas. Si no está marcado, se usará el valor predeterminado (128 líneas).|n|nHabilitar esta opción puede evitar que se muestre texto de chat durante el inicio de sesión."
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si está seleccionado, su equipo se reparará automáticamente cuando visite a un mercader adecuado.|n|nPuede mantener presionada la tecla shift cuando hable con un mercader para anular esta configuración."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Si está seleccionado, el texto de la zona no se mostrará (por ejemplo, 'Forjaz')."
L["Increase chat history"] = "Aumentar el historial"
L["Interface"] = "Interfaz"
L["Invaders of Alterac Valley"] = "Invasores del Valle de Alterac"
L["Invalid console variable."] = "Consola variable inválida."
L["Invalid parameter."] = "Parámetro inválido"
L["Invalid quest ID."] = "ID de misión inválida"
L["Invalid sound ID"] = "ID de sonido inválida"
L["Invalid taint level."] = "Nivel de contaminación inválido."
L["Invalid target."] = "Objetivo inválido"
L["Invite from whispers"] = "Invitación de susurros"
L["Kalimdor"] = "Kalimdor"
L["Keyword"] = "Palabra clave"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus no sobrescribirá LeaPlusDB en el próximo cierre de sesión."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: ¡VERSIÓN INCORRECTA INSTALADA!"
L["Left"] = "Izquierdo"
L["Lifetime honorable kills"] = "Muertes con honor de vida"
L["Loch Modan"] = "Loch Modan"
L["Lockout sharing"] = "Bloquear compartiendo"
L["Low"] = "Bajo"
L["Magic"] = "Magia"
L["Main Titles"] = "Títulos principales"
L["Manage buffs"] = "Gestionar bufos"
L["Manage frames"] = "Gestionar marcos"
L["Manage tooltip"] = "Tooltip"
L["Managed by Leatrix Plus"] = "Gestionado por LeatrixPlus"
L["Map"] = "Mapa"
L["Maraudon"] = "Maraudon"
L["Max camera zoom"] = "Distancia máxima de cámara"
L["Mechanics"] = "Mecánicas"
L["Media"] = "Media"
L["Medium"] = "Medio"
L["Memory Usage"] = "Uso de Memoria"
L["message shown."] = "mensaje mostrado."
L["messages shown."] = "mensajes mostrados."
L["Missing console variable."] = "Falta variable de consola"
L["Missing mount name."] = "Falta nombre de montura"
L["Missing movie ID."] = "Falta ID de película"
L["Missing quest ID."] = "Falta ID de hechizo"
L["Missing sound file parameter."] = "Falta el parámetro del archivo de sonido."
L["Missing sound ID."] = "Falta ID de sonido."
L["Molten Core"] = "Núcleo de Magma"
L["Moonglade"] = "Claro de la Luna"
L["Mount not found."] = "No se busca montura."
L["Move editbox to top"] = "Cuadro de edición"
L["Movie not playable."] = "Película no jugable."
L["Movie number"] = "Número de la película"
L["Movies"] = "Películas"
L["Mulgore"] = "Mulgore"
L["Music"] = "Música"
L["Musical Moments"] = "Momentos musicales"
L["Mystery"] = "Misterio"
L["Narration"] = "Narración"
L["Naxxramas"] = "Naxxramas"
L["No bad sound IDs found."] = "No se encontraron ID de sonido inválidos."
L["No help is available for this page."] = "No hay ayuda disponible para esta página."
L["No items with durability equipped."] = "No hay objetos con durabilidad equipados."
L["No media duplicates found."] = "No se encontraron duplicados de medios."
L["No tooltip showing."] = "No se muestra tooltip."
L["None"] = "Ninguno"
L["Not completed."] = "No completado."
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "¡AVISO!|nDebe reiniciar completamente su cliente de juego antes de poder usar esta versión de Leatrix Plus."
L["Nude"] = "Nudo"
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["or click the minimap button to open Leatrix Plus."] = "o haga clic el botón minimapa para abrir Leatrix Plus."
L["Orgrimmar"] = "Orgrimmar"
L["Overall"] = "Todo"
L["Overlay"] = "Superposición"
L["Particle density"] = "Densidad de particula"
L["Party from friends"] = "Grupo de amigos"
L["Pet"] = "Mascota"
L["Player"] = "Jugador"
L["Power"] = "Poder"
L["Press CTRL/C to copy."] = "Pulsa Ctrl+C para copiar."
L["Queue from friends"] = "Cola de amigos"
L["R"] = "B"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Raid frame toggle"] = "Marco de banda"
L["Random"] = "Aleatorio"
L["RARE"] = "RARO"
L["RARE ELITE"] = "ÉLITE RARO"
L["Razorfen Downs"] = "Zahúrda Rajacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Recent chat window"] = "Chat reciente"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Release in PvP"] = "Liberar espíritu en JcJ"
L["Reload"] = "Recargar"
L["Remember Alterac Valley!"] = "¡Recuerda el Valle de Alterac!"
L["Repair automatically"] = "Reparar"
L["Repaired for"] = "Reparado por"
L["Reposition the tooltip"] = "Reposicionar el tooltip"
L["Require shift key for quest automation"] = "Requerir la tecla shift para la automatización de misiones"
L["Requires UI reload."] = "Requiere recargar la IU."
L["Reset"] = "Restablecer"
L["Resize book text"] = "Texto de libro"
L["Resize mail text"] = "Texto de correo"
L["Resize quest text"] = "Texto de misión"
L["Resize Screen"] = "Redimensionar pantalla"
L["Rested bubbles"] = "Burbujas descansadas"
L["Restrict to friends and guild members"] = "Restringir a amigos y miembros de la hermandad"
L["result"] = "resultado"
L["results"] = "resultados"
L["Right"] = "Derecho"
L["Right-click to close"] = "Haga clic derecho para cerrar"
L["Right-click to close."] = "Haga clic derecho para cerrar."
L["right-click to go back"] = "haga clic derecho para volver"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Sacred"] = "Sagrado"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "Las monedas Furiarena, Machacacráneos y Sangrapellejo"
L["Scale"] = "Escala"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Scholomance"] = "Scholomance"
L["Search"] = "Buscar"
L["Searing Gorge"] = "La Garganta de Fuego"
L["Select the settings that you want to use."] = "Selecciona la configuración que desea usar."
L["Selection of music tracks"] = "Selección de pistas de música"
L["Self Markers Allowed"] = "Auto marcadores permitidos"
L["Self Markers Blocked"] = "Auto marcadores bloqueados"
L["Sell junk automatically"] = "Vender objetos pobres"
L["SELLING JUNK"] = "Vendiendo objetos pobres"
L["Set weather density"] = "Densidad del entorno"
L["Settings"] = "Configuración"
L["Shaders"] = "Sombreadores"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shardtooth E'ko"] = "E'ko Dentoesquirla"
L["Show auction controls"] = "Subasta"
L["Show bag search box"] = "Búsqueda de bolsas"
L["Show character addons"] = "Addons del personaje"
L["Show cooldowns"] = "Reutilización"
L["Show durability status"] = "Durabilidad"
L["Show free bag slots"] = "Casillas de bolsas vacías"
L["Show guild names"] = "Mostrar nombres de hermandad"
L["Show minimap button"] = "Botón del minimapa"
L["Show player chain"] = "Cadena de jugador"
L["Show player frame in class color"] = "Mostrar marco de jugador en color de clase"
L["Show target frame in class color"] = "Mostrar marco de objetivo en color de clase"
L["Show the spell ID in buff icon tooltips"] = "Mostrar ID de hechizo en tooltips del icono de buff"
L["Show unit targets"] = "Mostrar objetivos de unidad"
L["Show vanity controls"] = "Vanidad"
L["Show vendor price"] = "Precio de venta"
L["Show volume slider"] = "Volumen"
L["Show Wowhead links"] = "Enlaces de Wowhead"
L["Silence rested emotes"] = "Emociones de descanso"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Bosque de Argénteos"
L["Social"] = "Social"
L["Sold junk for"] = "Objetos pobres vendido por"
L["Sound system restarted."] = "Sistema de sonido reiniciado."
L["Spell ID"] = "ID de hechizo"
L["Spooky"] = "Escalofriante"
L["Stand and dismount"] = "Levantar y desmontar"
L["Stockade"] = "Las Mazmorras"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stop"] = "Parar"
L["Stormwind"] = "Ventormenta"
L["Stranglethorn Vale"] = "Vega de Tuercespina"
L["Stratholme"] = "Stratholme"
L["Sunken Temple"] = "Templo Sumergido"
L["Support"] = "Soporte"
L["Swamp"] = "Pantano"
L["Swamp of Sorrows"] = "Pantano de las Penas"
L["System"] = "Sistema"
L["Tabard"] = "Tabardo"
L["Taint level: Basic (1)."] = "Nivel de contaminación: básico (1)."
L["Taint level: Disabled (0)."] = "Nivel de contaminación: deshabilitado (0)."
L["Taint level: Full (2)."] = "Nivel de contaminación: lleno (2)."
L["Tanaris"] = "Tanaris"
L["Target"] = "Objetivo"
L["Target Tracking Disabled"] = "Rastreo de objetivo se ha deshabilitado"
L["Target Tracking Enabled"] = "Rastreo de objetivo se ha habilitado"
L["Teldrassil"] = "Teldrassil"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Ten Years of Warcraft"] = "Diez años de Warcraft"
L["Text"] = "Texto"
L["Text size"] = "Tamaño de texto"
L["Text Size"] = "Tamaño de texto"
L["The summon from"] = "La invocación de"
L["Themes"] = "Temas"
L["This panel will close automatically if you enter combat."] = "Este panel se cerrará automáticamente si entras en combate."
L["Thousand Needles"] = "Las Mil Agujas"
L["Timer"] = "Temporizador"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["To begin, choose an options page."] = "Para comenzar, elija una pestaña de opciones."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Para usar el botón Buscar objeto, debe anular la selección de la categoría Token de WoW."
L["Tooltip"] = "Tooltip"
L["Tooltip title color"] = "Color de título del tooltip"
L["Top"] = "Superior"
L["Top Center"] = "Central Superior"
L["Tracing started."] = "El seguimiento comenzó."
L["Tracing stopped."] = "El seguimiento se detuvo."
L["Transparency"] = "Transparencia"
L["True"] = "Cierto"
L["Turn-in completed quests automatically"] = "Entregar misiones completadas automáticamente"
L["Uldaman"] = "Uldaman"
L["Unclamp chat frame"] = "Desbloquear el marco"
L["Undercity"] = "Entrañas"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Universal group color"] = "Color de grupo universal"
L["Use arrow keys in chat"] = "Teclas de flecha"
L["Use class colors in chat"] = "Colores de clase"
L["Use easy resizing"] = "Cambio de tamaño"
L["Value must be a number."] = "Valor debe ser un número."
L["Various"] = "Varios"
L["Vendors"] = "Vendedores"
L["Version"] = "Versión"
L["Very Low"] = "Muy Bajo"
L["Video"] = "Vídeo"
L["Visibility"] = "Visibilidad"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["was automatically declined."] = "fue rechazado automáticamente."
L["Weather density"] = "Densidad del entorno"
L["Welcome to Leatrix Plus."] = "Bienvenido a Leatrix Plus"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Wetlands"] = "Los Humedales"
L["Widget"] = "Artilugio"
L["Wildkin E'ko"] = "E'ko de lechúcico salvaje"
L["will be automatically accepted in 10 seconds unless cancelled."] = "será aceptado automáticamente en 10 segundos a menos que se cancele."
L["Winter"] = "Invierno"
L["Winterfall E'ko"] = "E'ko Nevada"
L["Winterspring"] = "Cuna del Invierno"
L["World of Warcraft"] = "World of Warcraft"
L["X Offset"] = "Compensación X"
L["Y Offset"] = "Compensación Y"
L["YOU"] = "Tú"
L["You cannot do that in combat."] = "No puedes hacerlo mientras estés en combate."
L["You have"] = "Tienes"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Su IU necesita ser recargada para que algunos de los cambios surtan efecto.|n|nNo tiene que hacer clic en el botón de recarga de inmediato, pero debe hacer clic en él cuando haya terminado de hacer cambios y desea que los cambios surtan efecto."
L["Your UI needs to be reloaded."] = "Tiene que recargar la IU."
L["Zones"] = "Zonas"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"
L["Zulian, Razzashi, and Hakkari Coins"] = "Las monedas Zulian, Razzashi y Hakkari"
L["Zygor addon not found."] = "No se encuentra el addon Zygor."

end

-- esES: Spanish (Spain)
if GameLocale == "esES" then
L["+"] = "+"
L["A Donation of Mageweave"] = "Un donativo de paño mágico"
L["A Donation of Runecloth"] = "Un donativo de paño rúnico"
L["A Donation of Silk"] = "Un donativo de seda"
L["A Donation of Wool"] = "Un donativo de lana"
L["A friend request from"] = "Una solicitud de amistad de"
L["Accept available quests automatically"] = "Aceptar misiones disponibles automáticamente"
L["Accept resurrection"] = "Aceptar resucitación"
L["Accept summon"] = "Aceptar invocación"
L["Additional Runecloth"] = "Un donativo extra de paño rúnico"
L["Addon"] = "Addon"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alterac Mountains"] = "Montañas de Alterac"
L["Anchor"] = "Anclar"
L["Angelic"] = "Angélico"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Ashenvale"] = "Vallefresno"
L["Auto loot is now enabled."] = "Despojar automáticamente se ha habilitado."
L["AutoFollow"] = "Seguir automáticamente"
L["AutoFollow disabled."] = "Seguir automáticamente se ha deshabilitado"
L["Automate gossip"] = "Automatizar diálogo"
L["Automate quests"] = "Automatizar misiones"
L["Automation"] = "Automatizar"
L["Azshara"] = "Azshara"
L["Back to Main Menu"] = "Volver a menú principal"
L["Bad ID"] = "ID inválida"
L["Badlands"] = "Tierras Inhóspitas"
L["Barrens"] = "Los Baldíos"
L["Battle"] = "Batalla"
L["Battle of Warsong Gulch"] = "La batalla por Garganta Grito de Guerra"
L["Battlegrounds"] = "Campos de Batalla"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackwing Lair"] = "Guarida de Alanegra"
L["Blasted Lands"] = "Las Tierras Devastadas"
L["Block duels"] = "Duelos"
L["Block friend requests"] = "Solicitudes de amistad"
L["Block party invites"] = "Invitaciones de grupo"
L["Blocks"] = "Rechazar"
L["Bottom"] = "Inferior"
L["Buffs"] = "Buffs"
L["Burning Steppes"] = "Las Estepas Ardientes"
L["Buyout Only"] = "Sola compra"
L["C"] = "C"
L["Camera distance"] = "Distancia de cámara"
L["Chain style"] = "Estilo de cadena"
L["Character"] = "Personaje"
L["Chat"] = "Chat"
L["Chat Frame"] = "Marco de chat"
L["Checkbox labels are Ok."] = "Las etiquetas de las casillas de verificación están bien."
L["Chillwind E'ko"] = "E'ko de los venfresco"
L["Cinematics"] = "Cinemáticas"
L["Claiming Arathi Basin"] = "Reclamo por la Cuenca de Arathi"
L["Class colored frames"] = "Marcos coloreados"
L["Class icon portraits"] = "Retratos de clase"
L["Classic"] = "Clásico"
L["click here for new selection"] = "haga clic para nueva selección"
L["Click to configure the settings for this option."] = "Haga clic para configurar la configuración para esta opción"
L["Click to reset the settings on this page."] = "Haga clic para restablecer la configuración en esta página"
L["Click to resize the screen to fit between the top and bottom borders."] = "Haga clic para cambiar el tamaño de la pantalla para que se ajuste entre los bordes superior e inferior."
L["Click to return to the main menu."] = "Haga clic para volver al menú principal"
L["Cloak"] = "Espalda"
L["Color the backdrops based on faction"] = "Colorea los fondos según la facción"
L["Combat log cannot be hidden while undocked."] = "El registro de combate no se puede ocultar mientras está desacoplado."
L["Combat plates"] = "Placas de combate"
L["Completed."] = "Completado."
L["Concerted Efforts"] = "Esfuerzos concertados"
L["Configuration Panel"] = "Panel de Configuración"
L["Connections for"] = "Conexiones de"
L["Conquering Arathi Basin"] = "La conquista de la Cuenca de Arathi"
L["Credits"] = "Créditos"
L["Cursor"] = "Cursor"
L["Cursor Left"] = "Cursor izquierdo"
L["Cursor Right"] = "Cursor derecho"
L["Customise minimap"] = "Minimapa"
L["D"] = "M"
L["Darkmoon Faire"] = "Feria de la Luna Negra"
L["Darkshore"] = "Costa Oscura"
L["Deadmines"] = "Minas de la Muerte"
L["Deadwind Pass"] = "Paso de la Muerte"
L["Desolace"] = "Desolace"
L["Dire Maul"] = "La Masacre"
L["Disable bag automation"] = "Bolsas"
L["Disable chat fade"] = "Desvanecimiento"
L["Disable loot warnings"] = "Advertencias del botín"
L["Disable screen effects"] = "Efectos de pantalla"
L["Disable screen glow"] = "Brillo de pantalla"
L["Disable sticky chat"] = "Chat pegajoso"
L["Drag the frame overlay to position the frame."] = "Arrastra la superposición del marco para colocar el marco."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Arrastra la superposición de los marco para colocar los marcos.|n|nPara cambiar la escala de un marco, haga clic para seleccionarlo y luego ajuste el control deslizante de escala.|n|nEste panel se cerrará automáticamente si entras en combate."
L["Drag to set the buffs frame scale."] = "Arrastra para establecer la escala del marco de los bufos."
L["Drag to set the cursor X offset."] = "Arrastra para establecer el desplazamiento del cursor X."
L["Drag to set the cursor Y offset."] = "Arrastra para establecer el desplazamiento del cursor Y."
L["Drag to set the density of weather effects."] = "Arrastra para establecer la densidad de los efectos entornos."
L["Drag to set the font size of book text."] = "Arrastra para establecer el tamaño de fuente del texto de libro."
L["Drag to set the font size of mail text."] = "Arrastra para establecer el tamaño de fuente del texto de correo."
L["Drag to set the font size of quest text."] = "Arrastra para establecer el tamaño de fuente del texto de misión."
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "Arrastra para establecer la escala del minimapa.|n|nTenga en cuenta que si está utilizando las barras de acción predeterminadas, volver a escalar el minimapa también volverá a escalar las barras de acción derecha al inicio, por lo que es posible que desee dejar esto al 100%."
L["Drag to set the scale of the Leatrix Plus panel."] = "Arrastra para establecer la escala del panel Leatrix Plus."
L["Drag to set the scale of the selected frame."] = "Arrastra para establecer la escala del marco seleccionado."
L["Drag to set the size of the bottom border."] = "Arrastra para establecer el tamaño del borde inferior."
L["Drag to set the size of the left border."] = "Arrastra para establecer el tamaño del borde izquierdo."
L["Drag to set the size of the right border."] = "Arrastra para establecer el tamaño del borde derecho."
L["Drag to set the size of the top border."] = "Arrastra para establecer el tamaño del borde superior."
L["Drag to set the tooltip scale."] = "Arrastra para establecer la escala del tooltip."
L["Drag to set the transparency of the borders."] = "Arrastra para establecer la transparencia de los bordes."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Arrastra para establecer la transparencia del panel Leatrix Plus."
L["Dun Morogh"] = "Dun Morogh"
L["Dungeons"] = "Mazmorras"
L["Dup ID"] = "ID Copia"
L["durability"] = "durabilidad"
L["Durability"] = "Durabilidad"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Eastern Kingdoms"] = "Reinos del Este"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["ELITE"] = "ÉLITE"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["Enable hotkey"] = "Habilitar teclado"
L["Enable viewport"] = "Vista de ventana"
L["Enhance dressup"] = "Probador"
L["Enhance professions"] = "Profesiones"
L["Enhance quest log"] = "Registro de misiones"
L["Enhance trainers"] = "Instructores"
L["Enhancements"] = "Mejoras"
L["Enter"] = "Entrar"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "Entra la ID de hechizo para los iconos de reutilización que desea ver.|n|nSi normalmente aparece un icono de reutilización debajo del marco de la mascota, marca la casilla de verificación mascota.|n|Los iconos de reutilización se guardan en tu clase."
L["enter zone or track name"] = "entra zona o rastrea el nombre"
L["Error messages will be hidden"] = "Mensajes de error se ocultarán"
L["Error messages will be shown"] = "Mensajes de error se mostrarán"
L["Events"] = "Eventos"
L["Extras"] = "Excesos"
L["False"] = "Falso"
L["Faster auto loot"] = "Despojar rápido"
L["Faster movie skip"] = "Saltar película rápido"
L["Features"] = "Caracteristicas"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Fight for Warsong Gulch"] = "Lucha por Garganta Grito de Guerra"
L["Find Item"] = "Buscar objeto"
L["For Great Honor"] = "Por Gran Honor"
L["Frames"] = "Marcos"
L["Frostmaul E'ko"] = "E'ko de los Machacahielo"
L["Frostsaber E'ko"] = "E'ko de Sable de Hielo"
L["Game Options"] = "Opciones de juego"
L["Ghost"] = "Fantasma"
L["Gloomy"] = "Melancólico"
L["Gnomeregan"] = "Gnomeregan"
L["Gold Only"] = "Solo oro"
L["Graphics and Sound"] = "Gráficos y sonido"
L["Groups"] = "Grupos"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "Las monedas Gurubashi, Vilrama y Secacorteza"
L["H"] = "H"
L["Haunted"] = "Encantado"
L["Helm"] = "Cabeza"
L["Help"] = "Ayuda"
L["Hide chat buttons"] = "Botones de chat"
L["Hide cooldown duration numbers (if enabled)"] = "Ocultar números de reutilización (si habilitado)"
L["Hide error messages"] = "Mensajes de error"
L["Hide gryphons"] = "Grifos"
L["Hide portrait numbers"] = "Números del retrato"
L["Hide stance bar"] = "Barra de actitud"
L["Hide the combat log"] = "Registro de combate"
L["Hide the zone text bar"] = "Ocultar texto de zona"
L["Hide the zoom buttons"] = "Ocultar los botones de acercar/alejar"
L["Hide tooltips for world units during combat"] = "Ocultar tooltips para unidades del mundo si estés en combate"
L["Hide zone text"] = "Texto de zona"
L["High"] = "Alto"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Hinterlands"] = "Tierras del Interior"
L["Home"] = "Principal"
L["Ice Thistle E'ko"] = "E'ko de los Cardo Nevado"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "Si está seleccionado, se mostrará un cuadro de búsqueda de bolsas en el marco de la mochila y el marco del banco."
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Si está seleccionado, se agregará un botón a la información del personaje que mostrará la durabilidad de su equipo cuando pase el puntero sobre él.|n|nAdemás, se mostrará un porcentaje general en el marco del chat cuando muera."
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "Si está seleccionado, se enviará una invitación a grupo a cualquier persona que te susurre con una palabra clave establecida siempre y cuando estés desagrupado, líder de grupo o asistente de banda."
L["If checked, a master volume slider will be shown in the character sheet."] = "Si está seleccionado, se mostrará un control deslizante de volumen maestro en la información del personaje."
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "Si está seleccionado, un botón de minimapa estará disponible.|n|nClic - Alternar panel de opciones.|n|nShift+Clic izquierdo: alternar música.|n|nCtrl+Clic derecho - Alternar errores (si está habilitado).|n|nCtrl+Shift+Clic izquierdo - Alternar Zygor (si está instalado)|n|nCtrl+Shift+Clic derecho - Alternar el modo de ventana."
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "Si está seleccionado, se agregará funcionalidad adicional a la casa de subastas.|n|nSolo compra: cree subastas de compra sin completar el precio inicial.|n|nSolo oro: establezca los precios del cobre y la plata en 99 para acelerar las nuevas subastas.|n|nBuscar objeto: busca en la casa de subastas el objeto que estás vendiendo.|n|nAdemás, la configuración de duración de la subasta se guardará en toda la cuenta."
L["If checked, alert frames will not be shown."] = "Si está seleccionado, no se mostrarán los marcos de alerta."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si está seleccionado, todos los objetos de calidad pobre en sus bolsas se venderán automáticamente cuando visite a un mercader.|n|nPuede mantener presionada la tecla shift cuando hable con un mercader para anular esta configuración."
L["If checked, available quests will be accepted automatically."] = "Si está seleccionado, las misiones disponibles se aceptarán automáticamente."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Si está seleccionado, los fondos se teñirán de azul (amigable) o rojo (hostil)."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Si está seleccionado, las solicitudes de amistad de BattleTag y Real ID se rechazarán automáticamente.|n|nHabilitar esta opción rechazará automáticamente cualquier solicitud pendiente."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Si está seleccionado, los botones del marco de chat estarán ocultos.|n|nAl hacer clic en las pestañas de chat, se mostrarán automáticamente los últimos mensajes.|n|nUsa la rueda del ratón para desplazarse por el historial de chat. Mantenga presionada la tecla shift para saltar de página o Ctrl para saltar a la parte superior o inferior del historial de chat."
L["If checked, chat text will not fade out after a time period."] = "Si está seleccionado, el texto del chat no se desvanecerá después de un período de tiempo."
L["If checked, class coloring will be used in the player frame and target frame."] = "Si está seleccionado, se usará el color de la clase en el marco del jugador y el marco del objetivo."
L["If checked, class colors will be used in the chat frame."] = "Si está seleccionado, los colores de la clase se usarán en el marco del chat."
L["If checked, class icons will be shown in the portrait frames."] = "Si está seleccionado, los iconos de clase se mostrarán en los marcos de retrato."
L["If checked, completed quests will be turned-in automatically."] = "Si está seleccionado, las misiones completadas se entregarán automáticamente."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Si está seleccionado, las confirmaciones ya no aparecerán cuando elija una opción de botín o cuando intente vender o enviar un objeto comercializable."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Si está seleccionado, los números de reutilización no se mostrarán sobre el hechizo.|n|nSi no está marcado, los números de reutilización se mostrarán sobre el hechizo si están habilitados en el panel de opciones del juego (menú 'Barras de Acción')."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Si está seleccionado, se ocultarán los números de daño y sanación en los marcos de retrato de jugador y mascota."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Si está seleccionado, arrastrando la pestaña de chat General mientras el marco de chat está bloqueado expandirá el marco de chat hacia arriba.|n|nSi el marco de chat está desbloqueado, arrastrando la pestaña de chat General se moverá el marco de chat."
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "Si está seleccionado, las solicitudes de duelo se rechazarán a menos que el jugador que solicita el duelo esté en tu lista de amigos o hermandad."
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "Si está seleccionado, los sonidos de emoción se silenciarán mientras tu personaje esté descansando o en El Tragapenas.|n|nLos sonidos de emoción se habilitarán en cualquier otro momento."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Si está seleccionado, las placas identificativas del enemigo se mostrarán durante el combate y se ocultarán cuando finalice el combate."
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "Si está seleccionado, las invitaciones a grupos solo se enviarán a amigos y miembros de la hermandad.|n|nSi no está marcado, se enviarán invitaciones a grupos a todos."
L["If checked, guild names will be shown.  Guild ranks will also be shown for players in your guild."] = "Si está seleccionado, se mostrarán los nombres de las hermandades. Los rangos de hermandad también se mostrarán para los jugadores de tu hermandad."
L["If checked, helm and cloak toggle checkboxes will be shown in the character sheet.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "Si está seleccionado, las casillas de alternar cabeza y espalda se mostrarán en la información del personaje.|n|nPuede mantener presionada la tecla shift y hacer clic con el botón derecho en las casillas de verificación para cambiar de visualización."
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "Si está seleccionado, la mayoría de los mensajes de error (como 'No tienes suficiente ira') no se mostrarán. Se excluyen algunos errores importantes.|n|nSi tiene habilitado el botón de minimapa, puede mantener presionada la tecla de control y hacer clic con el botón derecho para alternar los mensajes de error sin afectar esta configuración."
L["If checked, nude and tabard toggle buttons will be added to the dressup frame and model rotation controls will be removed."] = "Si está seleccionado, se agregarán botones de alternancia desnudos y de tabardo al marco de probador y se eliminarán los controles de rotación del modelo."
L["If checked, party invitations from friends or guild members will be automatically accepted."] = "Si está seleccionado, las invitaciones a grupos de amigos o miembros de la hermandad serán aceptadas automáticamente."
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "Si está seleccionado, las invitaciones a grupos se rechazarán a menos que el jugador que te invite esté en tu lista de amigos o hermandad."
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting.|n|nRepeatable battlemaster and cloth quartermaster quests can be automatically selected by holding down the alt key."] = "Si está seleccionado, las misiones serán seleccionadas, aceptadas y entregadas automáticamente.|n|nLas misiones que tienen un requisito de oro no se entregarán automáticamente.|n|nPuede mantener presionada la tecla Shift cuando hable con un asignador de misiones para anular esta configuración.|n|nLas misiones repetibles de maestro de batalla y de intendente de tela se pueden seleccionar automáticamente manteniendo presionada la tecla alt."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Si está seleccionado, el chat de banda y el chat de instancia serán de color azul (para que coincida con el color predeterminado del chat del grupo)."
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat."] = "Si está seleccionado, las solicitudes de resucitación se aceptarán automáticamente siempre que el jugador que te resucite no esté en combate."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "Si está seleccionado, la ID de hechizo se mostrarán en el tooltip del icono de buff ubicado en el marco de buff y debajo del marco de objetivo."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Si está seleccionado, el chat pegajoso se deshabilitará.|n|nTenga en cuenta que esto no se aplica a las ventanas de chat temporales."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Si está seleccionado, las solicitudes de invocación serán aceptadas automáticamente a menos que estés en combate."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Si está seleccionado, la lista de addons (accesible desde el menú del juego) mostrará addons basados en personajes de forma predeterminada."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Si está seleccionado, el tiempo que se tarda en despojar automáticamente a las criaturas se reducirá significativamente."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Si está seleccionado, el botón de limpieza de la mochila y el botón de limpieza del marco del banco no se mostrarán."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Si está seleccionado, el botón para alternar el marco del contenedor de banda se mostrará justo encima del marco de administración de banda (lado izquierdo de la pantalla) en lugar de en el marco de administración de banda en sí.|n|nEsto le permite alternar el marco del contenedor de banda sin necesidad de abrir el marco de administración de banda."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Si está seleccionado, el registro de combate estará oculto.|n|nEl registro de combate debe estar acoplado para que esta opción funcione.|n|nSi el registro de combate está desacoplado, puedes acoplarlo arrastrando la pestaña (y recargando tu IU) o restableciendo las ventanas de chat (desde el menú de chat)."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Si está seleccionado, el cuadro de edición se moverá a la parte superior del marco de chat."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Si está seleccionado, la pantalla gris de la muerte y el efecto del inframundo se deshabilitarán."
L["If checked, the main bar gryphons will not be shown."] = "Si está seleccionado, no se mostrarán los grifos de la barra principal."
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "Si está seleccionado, la cantidad de casillas para bolsas disponibles se mostrará en el icono del botón de la mochila y en el tooltip."
L["If checked, the player frame background will be shown in class color."] = "Si está seleccionado, el fondo del marco del jugador se mostrará en color de clase."
L["If checked, the professions frame will be larger."] = "Si está seleccionado, el marco de profesiones será más grande."
L["If checked, the quest log frame will be larger and feature a world map button and quest levels."] = "Si está seleccionado, el marco de registro de misiones será más grande y contará con un botón de mapa mundial y niveles de misión."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Si está seleccionado, el brillo de la pantalla se deshabilitará.|n|nHabilitar esta opción también deshabilitará el efecto de borracho."
L["If checked, the skill trainer frame will be larger."] = "Si está seleccionado, el marco del instructor de habilidades será más grande."
L["If checked, the stance bar will not be shown."] = "Si está seleccionado, la barra de actitud no mostrará."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Si está seleccionado, el marco de conversación no se mostrará.|n|nEl marco de conversación normalmente aparece en la parte inferior de la pantalla cuando ciertos PNJs se comunican con usted."
L["If checked, the target frame background will be shown in class color."] = "Si está seleccionado, el fondo del marco de objetivo se mostrará en color de clase."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Si está seleccionado, el tooltip estará codificada por colores y podrá modificar la visualización y la escala del tooltip."
L["If checked, the vendor price will be shown in item tooltips."] = "Si está seleccionado, el precio de venta se mostrará en el tooltip del objeto."
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "Si está seleccionado, el texto de la zona estará oculta. El tooltip del botón de rastreo mostrará información de la zona."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Si está seleccionado, los botones de acercar/alejar estarán ocultos. Puede usar la rueda del ratón para acercar independientemente de esta configuración."
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "Si está seleccionado, el tooltip para las unidades mundiales se ocultará durante el combate.|n|nPuede mantener presionada la tecla shift para anular esta configuración."
L["If checked, unit targets will be shown."] = "Si está seleccionado, se mostrarán los objetivos de la unidad."
L["If checked, Wowhead links will be shown above the quest log frame."] = "Si está seleccionado, los enlaces de Wowhead se mostrarán sobre el marco del registro de misiones."
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip item.|n|nIf the gossip item type is banker, taxi, trainer or vendor, gossip will be skipped without needing to hold the alt key.  You can hold the shift key down to prevent this."] = "Si está seleccionado, puede mantener presionada la tecla alt mientras abre una ventana de diálogo para seleccionar automáticamente un solo tipo de diálogo.|n|nSi el tipo de diálogo es banquero, taxi, instructor o vendedor, se omitirán los diálogos sin necesidad de mantener presionada la tecla alt. Puede mantener presionada la tecla shift para evitar esto."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Si está seleccionado, puede mantener presionada la tecla de control y hacer clic en una pestaña de chat para ver el chat reciente en una ventana fácil de copiar."
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "Si está seleccionado, puede abrir Leatrix Plus presionando Ctrl+Z."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Si está seleccionado, puede presionar las teclas de flecha para mover el punto de inserción hacia la izquierda y hacia la derecha en el marco del chat.|n|nSi no está marcado, las teclas de flecha utilizarán la configuración predeterminada del teclado."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Si está seleccionado, podrá cancelar cinemáticas sin que se le solicite confirmación."
L["If checked, you will be able to change the font size of book text."] = "Si está seleccionado, podrá cambiar el tamaño de fuente del texto de libro."
L["If checked, you will be able to change the font size of quest text."] = "Si está seleccionado, podrá cambiar el tamaño de fuente del texto de misión."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Si está seleccionado, podrá cambiar el tamaño de fuente del texto de correo.|n|nEsto no afecta el correo creado con plantillas (como las facturas de la casa de subastas)."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "Si está seleccionado, podrá cambiar la posición y la escala del marco de los bufos."
L["If checked, you will be able to change the position and scale of the following frames:|n|n- Player frame|n- Target frame|n- Widget top center frame|n- Timer bar"] = "Si está seleccionado, podrá cambiar la posición y la escala de los siguientes marcos:|n|n- Marco del jugador|n- Marco del objetivo|n- Marco central superior del artilugio|n- Barra de temporizador"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Si está seleccionado, podrá crear una ventana de vista. Una ventana de vista agrega bordes negros ajustables alrededor del mundo del juego.|n|nLos bordes se colocan en la parte superior del mundo del juego pero debajo de la interfaz de usuario para que pueda colocar elementos de la interfaz de usuario sobre ellos."
L["If checked, you will be able to customise the minimap."] = "Si está seleccionado, podrá personalizar el minimapa."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Si está seleccionado, podrá arrastrar el marco del chat al borde de la pantalla."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Si está seleccionado, podrá colocar hasta cinco iconos de reutilización sobre el marco del objetivo."
L["If checked, you will be able to reposition the tooltip."] = "Si está seleccionado, podrá reposicionar el tooltip."
L["If checked, you will be able to set the density of weather effects."] = "Si está seleccionado, podrá establecer la densidad de los efectos entornos."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Si está seleccionado, podrá mostrar una cadena de élite rara, élite o rara alrededor del marco del jugador."
L["If checked, you will be able to zoom out to a greater distance."] = "Si está seleccionado, podrá alejarse a una distancia mayor."
L["If checked, you will need to hold the shift key down for quests to be automated.|n|nIf unchecked, holding shift will prevent quests from being automated."] = "Si está seleccionado, deberás mantener presionada la tecla Shift para que las misiones se automaticen.|n|nSi no está seleccionado, mantener presionada la tecla Shift evitará que las misiones se automaticen."
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "Si está seleccionado, liberarás automáticamente después de morir en un campo de batalla.|n|nNo lo liberarás automáticamente si tienes la capacidad de resucitarte a ti mismo."
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "Si está seleccionado, sus bolsas no se abrirán o cerrarán automáticamente cuando interactúe con un mercader, banco o buzón."
L["If checked, your character will automatically stand or dismount when an action is prevented because you are either seated or mounted."] = "Si está seleccionado, tu personaje se levantará o desmontará automáticamente cuando se evite una acción porque estás sentado o montado."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Si está seleccionado, su historial de chat aumentará a 4096 líneas. Si no está marcado, se usará el valor predeterminado (128 líneas).|n|nHabilitar esta opción puede evitar que se muestre texto de chat durante el inicio de sesión."
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si está seleccionado, su equipo se reparará automáticamente cuando visite a un mercader adecuado.|n|nPuede mantener presionada la tecla shift cuando hable con un mercader para anular esta configuración."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Si está seleccionado, el texto de la zona no se mostrará (por ejemplo, 'Forjaz')."
L["Increase chat history"] = "Aumentar el historial"
L["Interface"] = "Interfaz"
L["Invaders of Alterac Valley"] = "Invasores del Valle de Alterac"
L["Invalid console variable."] = "Consola variable inválida."
L["Invalid parameter."] = "Parámetro inválido"
L["Invalid quest ID."] = "ID de misión inválida"
L["Invalid sound ID"] = "ID de sonido inválida"
L["Invalid taint level."] = "Nivel de contaminación inválido."
L["Invalid target."] = "Objetivo inválido"
L["Invite from whispers"] = "Invitación de susurros"
L["Kalimdor"] = "Kalimdor"
L["Keyword"] = "Palabra clave"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus no sobrescribirá LeaPlusDB en el próximo cierre de sesión."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: ¡VERSIÓN INCORRECTA INSTALADA!"
L["Left"] = "Izquierdo"
L["Lifetime honorable kills"] = "Muertes con honor de vida"
L["Loch Modan"] = "Loch Modan"
L["Lockout sharing"] = "Bloquear compartiendo"
L["Low"] = "Bajo"
L["Magic"] = "Magia"
L["Main Titles"] = "Títulos principales"
L["Manage buffs"] = "Gestionar bufos"
L["Manage frames"] = "Gestionar marcos"
L["Manage tooltip"] = "Tooltip"
L["Managed by Leatrix Plus"] = "Gestionado por LeatrixPlus"
L["Map"] = "Mapa"
L["Maraudon"] = "Maraudon"
L["Max camera zoom"] = "Distancia máxima de cámara"
L["Mechanics"] = "Mecánicas"
L["Media"] = "Media"
L["Medium"] = "Medio"
L["Memory Usage"] = "Uso de Memoria"
L["message shown."] = "mensaje mostrado."
L["messages shown."] = "mensajes mostrados."
L["Missing console variable."] = "Falta variable de consola"
L["Missing mount name."] = "Falta nombre de montura"
L["Missing movie ID."] = "Falta ID de película"
L["Missing quest ID."] = "Falta ID de hechizo"
L["Missing sound file parameter."] = "Falta el parámetro del archivo de sonido."
L["Missing sound ID."] = "Falta ID de sonido."
L["Molten Core"] = "Núcleo de Magma"
L["Moonglade"] = "Claro de la Luna"
L["Mount not found."] = "No se busca montura."
L["Move editbox to top"] = "Cuadro de edición"
L["Movie not playable."] = "Película no jugable."
L["Movie number"] = "Número de la película"
L["Movies"] = "Películas"
L["Mulgore"] = "Mulgore"
L["Music"] = "Música"
L["Musical Moments"] = "Momentos musicales"
L["Mystery"] = "Misterio"
L["Narration"] = "Narración"
L["Naxxramas"] = "Naxxramas"
L["No bad sound IDs found."] = "No se encontraron ID de sonido inválidos."
L["No help is available for this page."] = "No hay ayuda disponible para esta página."
L["No items with durability equipped."] = "No hay objetos con durabilidad equipados."
L["No media duplicates found."] = "No se encontraron duplicados de medios."
L["No tooltip showing."] = "No se muestra tooltip."
L["None"] = "Ninguno"
L["Not completed."] = "No completado."
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "¡AVISO!|nDebe reiniciar completamente su cliente de juego antes de poder usar esta versión de Leatrix Plus."
L["Nude"] = "Nudo"
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["or click the minimap button to open Leatrix Plus."] = "o haga clic el botón minimapa para abrir Leatrix Plus."
L["Orgrimmar"] = "Orgrimmar"
L["Overall"] = "Todo"
L["Overlay"] = "Superposición"
L["Particle density"] = "Densidad de particula"
L["Party from friends"] = "Grupo de amigos"
L["Pet"] = "Mascota"
L["Player"] = "Jugador"
L["Power"] = "Poder"
L["Press CTRL/C to copy."] = "Pulsa Ctrl+C para copiar."
L["Queue from friends"] = "Cola de amigos"
L["R"] = "B"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Raid frame toggle"] = "Marco de banda"
L["Random"] = "Aleatorio"
L["RARE"] = "RARO"
L["RARE ELITE"] = "ÉLITE RARO"
L["Razorfen Downs"] = "Zahúrda Rajacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Recent chat window"] = "Chat reciente"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Release in PvP"] = "Liberar espíritu en JcJ"
L["Reload"] = "Recargar"
L["Remember Alterac Valley!"] = "¡Recuerda el Valle de Alterac!"
L["Repair automatically"] = "Reparar"
L["Repaired for"] = "Reparado por"
L["Reposition the tooltip"] = "Reposicionar el tooltip"
L["Require shift key for quest automation"] = "Requerir la tecla shift para la automatización de misiones"
L["Requires UI reload."] = "Requiere recargar la IU."
L["Reset"] = "Restablecer"
L["Resize book text"] = "Texto de libro"
L["Resize mail text"] = "Texto de correo"
L["Resize quest text"] = "Texto de misión"
L["Resize Screen"] = "Redimensionar pantalla"
L["Rested bubbles"] = "Burbujas descansadas"
L["Restrict to friends and guild members"] = "Restringir a amigos y miembros de la hermandad"
L["result"] = "resultado"
L["results"] = "resultados"
L["Right"] = "Derecho"
L["Right-click to close"] = "Haga clic derecho para cerrar"
L["Right-click to close."] = "Haga clic derecho para cerrar."
L["right-click to go back"] = "haga clic derecho para volver"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Sacred"] = "Sagrado"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "Las monedas Furiarena, Machacacráneos y Sangrapellejo"
L["Scale"] = "Escala"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Scholomance"] = "Scholomance"
L["Search"] = "Buscar"
L["Searing Gorge"] = "La Garganta de Fuego"
L["Select the settings that you want to use."] = "Selecciona la configuración que desea usar."
L["Selection of music tracks"] = "Selección de pistas de música"
L["Self Markers Allowed"] = "Auto marcadores permitidos"
L["Self Markers Blocked"] = "Auto marcadores bloqueados"
L["Sell junk automatically"] = "Vender objetos pobres"
L["SELLING JUNK"] = "Vendiendo objetos pobres"
L["Set weather density"] = "Densidad del entorno"
L["Settings"] = "Configuración"
L["Shaders"] = "Sombreadores"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shardtooth E'ko"] = "E'ko de los dentoesquirla"
L["Show auction controls"] = "Subasta"
L["Show bag search box"] = "Búsqueda de bolsas"
L["Show character addons"] = "Addons del personaje"
L["Show cooldowns"] = "Reutilización"
L["Show durability status"] = "Durabilidad"
L["Show free bag slots"] = "Casillas de bolsas vacías"
L["Show guild names"] = "Mostrar nombres de hermandad"
L["Show minimap button"] = "Botón del minimapa"
L["Show player chain"] = "Cadena de jugador"
L["Show player frame in class color"] = "Mostrar marco de jugador en color de clase"
L["Show target frame in class color"] = "Mostrar marco de objetivo en color de clase"
L["Show the spell ID in buff icon tooltips"] = "Mostrar ID de hechizo en tooltips del icono de buff"
L["Show unit targets"] = "Mostrar objetivos de unidad"
L["Show vanity controls"] = "Vanidad"
L["Show vendor price"] = "Precio de venta"
L["Show volume slider"] = "Volumen"
L["Show Wowhead links"] = "Enlaces de Wowhead"
L["Silence rested emotes"] = "Emociones de descanso"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Bosque de Argénteos"
L["Social"] = "Social"
L["Sold junk for"] = "Objetos pobres vendido por"
L["Sound system restarted."] = "Sistema de sonido reiniciado."
L["Spell ID"] = "ID de hechizo"
L["Spooky"] = "Escalofriante"
L["Stand and dismount"] = "Levantar y desmontar"
L["Stockade"] = "Las Mazmorras"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stop"] = "Parar"
L["Stormwind"] = "Ventormenta"
L["Stranglethorn Vale"] = "Vega de Tuercespina"
L["Stratholme"] = "Stratholme"
L["Sunken Temple"] = "Templo Sumergido"
L["Support"] = "Soporte"
L["Swamp"] = "Pantano"
L["Swamp of Sorrows"] = "Pantano de las Penas"
L["System"] = "Sistema"
L["Tabard"] = "Tabardo"
L["Taint level: Basic (1)."] = "Nivel de contaminación: básico (1)."
L["Taint level: Disabled (0)."] = "Nivel de contaminación: deshabilitado (0)."
L["Taint level: Full (2)."] = "Nivel de contaminación: lleno (2)."
L["Tanaris"] = "Tanaris"
L["Target"] = "Objetivo"
L["Target Tracking Disabled"] = "Rastreo de objetivo se ha deshabilitado"
L["Target Tracking Enabled"] = "Rastreo de objetivo se ha habilitado"
L["Teldrassil"] = "Teldrassil"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Ten Years of Warcraft"] = "Diez años de Warcraft"
L["Text"] = "Texto"
L["Text size"] = "Tamaño de texto"
L["Text Size"] = "Tamaño de texto"
L["The summon from"] = "La invocación de"
L["Themes"] = "Temas"
L["This panel will close automatically if you enter combat."] = "Este panel se cerrará automáticamente si entras en combate."
L["Thousand Needles"] = "Las Mil Agujas"
L["Timer"] = "Temporizador"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["To begin, choose an options page."] = "Para comenzar, elija una pestaña de opciones."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Para usar el botón Buscar objeto, debe anular la selección de la categoría Token de WoW."
L["Tooltip"] = "Tooltip"
L["Tooltip title color"] = "Color de título del tooltip"
L["Top"] = "Superior"
L["Top Center"] = "Central Superior"
L["Tracing started."] = "El seguimiento comenzó."
L["Tracing stopped."] = "El seguimiento se detuvo."
L["Transparency"] = "Transparencia"
L["True"] = "Cierto"
L["Turn-in completed quests automatically"] = "Entregar misiones completadas automáticamente"
L["Uldaman"] = "Uldaman"
L["Unclamp chat frame"] = "Desbloquear el marco"
L["Undercity"] = "Entrañas"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Universal group color"] = "Color de grupo universal"
L["Use arrow keys in chat"] = "Teclas de flecha"
L["Use class colors in chat"] = "Colores de clase"
L["Use easy resizing"] = "Cambio de tamaño"
L["Value must be a number."] = "Valor debe ser un número."
L["Various"] = "Varios"
L["Vendors"] = "Vendedores"
L["Version"] = "Versión"
L["Very Low"] = "Muy Bajo"
L["Video"] = "Vídeo"
L["Visibility"] = "Visibilidad"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["was automatically declined."] = "fue rechazado automáticamente."
L["Weather density"] = "Densidad del entorno"
L["Welcome to Leatrix Plus."] = "Bienvenido a Leatrix Plus"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Wetlands"] = "Los Humedales"
L["Widget"] = "Artilugio"
L["Wildkin E'ko"] = "E'ko de lechúcico"
L["will be automatically accepted in 10 seconds unless cancelled."] = "será aceptado automáticamente en 10 segundos a menos que se cancele."
L["Winter"] = "Invierno"
L["Winterfall E'ko"] = "E'ko de los Nevada"
L["Winterspring"] = "Cuna del Invierno"
L["World of Warcraft"] = "World of Warcraft"
L["X Offset"] = "Compensación X"
L["Y Offset"] = "Compensación Y"
L["YOU"] = "Tú"
L["You cannot do that in combat."] = "No puedes hacerlo mientras estés en combate."
L["You have"] = "Tienes"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Su IU necesita ser recargada para que algunos de los cambios surtan efecto.|n|nNo tiene que hacer clic en el botón de recarga de inmediato, pero debe hacer clic en él cuando haya terminado de hacer cambios y desea que los cambios surtan efecto."
L["Your UI needs to be reloaded."] = "Tiene que recargar la IU."
L["Zones"] = "Zonas"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"
L["Zulian, Razzashi, and Hakkari Coins"] = "Las monedas Zulian, Razzashi y Hakkari"
L["Zygor addon not found."] = "No se encuentra el addon Zygor."

end

-- frFR: French
if GameLocale == "frFR" then
L["+"] = "+"
L["A Donation of Mageweave"] = "Un don de tisse-mage"
L["A Donation of Runecloth"] = "Un don d'étoffe runique"
L["A Donation of Silk"] = "Un don de soie"
L["A Donation of Wool"] = "Un don de laine"
L["A friend request from"] = "Une demande de contact de"
L["Accept available quests automatically"] = "Accepter automatiquement les quêtes disponibles"
L["Accept resurrection"] = "Accepter ressuscitation"
L["Accept summon"] = "Accepter invocation"
L["Additional Runecloth"] = "Encore de l'étoffe runique"
L["Addon"] = "Add-on"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alterac Mountains"] = "Montagnes d'Alterac"
L["Anchor"] = "Ancre"
L["Angelic"] = "Angélique"
L["Arathi Highlands"] = "Hautes-terres d'Arathi"
L["Ashenvale"] = "Orneval"
L["Auto loot is now enabled."] = "La fouille automatique est maintenant activée."
L["AutoFollow"] = "Suivi automatique"
L["AutoFollow disabled."] = "Suivi automatique désactivé"
L["Automate gossip"] = "Automatiser le dialogue"
L["Automate quests"] = "Automatiser les quêtes"
L["Automation"] = "Automatisation"
L["Azshara"] = "Azshara"
L["Back to Main Menu"] = "Retour au menu principal"
L["Bad ID"] = "ID incorrect"
L["Badlands"] = "Terres ingrates"
L["Barrens"] = "Les Tarides"
L["Battle"] = "Bataille"
L["Battle of Warsong Gulch"] = "La bataille du goulet des Warsong"
L["Battlegrounds"] = "Champs de bataille"
L["Blackfathom Deeps"] = "Profondeurs de Brassenoire"
L["Blackrock Depths"] = "Profondeurs de Blackrock"
L["Blackwing Lair"] = "Repaire de l'Aile noire"
L["Blasted Lands"] = "Terres foudroyées"
L["Block duels"] = "Duels"
L["Block friend requests"] = "Demandes de contact"
L["Block party invites"] = "Invitations de groupe"
L["Blocks"] = "Bloquer"
L["Bottom"] = "Bas"
L["Buffs"] = "Buffs"
L["Burning Steppes"] = "Steppes ardentes"
L["Buyout Only"] = "Acheter seulement"
L["C"] = "C"
L["Camera distance"] = "Distance de la caméra"
L["Chain style"] = "Style de chaîne"
L["Character"] = "Personnage"
L["Chat"] = "Discussion"
L["Chat Frame"] = "Cadre de discussion"
L["Checkbox labels are Ok."] = "Les étiquettes des cases à cocher sont correctes."
L["Chillwind E'ko"] = "L'E'ko de Noroît"
L["Cinematics"] = "Cinématique"
L["Claiming Arathi Basin"] = "La revendication du bassin d'Arathi"
L["Class colored frames"] = "Cadres colorés"
L["Class icon portraits"] = "Portraits de classe"
L["Classic"] = "Classique"
L["click here for new selection"] = "cliquez ici pour une nouvelle sélection"
L["Click to configure the settings for this option."] = "Cliquez pour configurer les paramètres de cette option."
L["Click to reset the settings on this page."] = "Cliquez pour réinitialiser les paramètres de cette page."
L["Click to resize the screen to fit between the top and bottom borders."] = "Cliquez pour redimensionner l'écran pour qu'il s'adapte entre les bordures supérieure et inférieure."
L["Click to return to the main menu."] = "Cliquez pour revenir au menu principal."
L["Cloak"] = "Manteau"
L["Color the backdrops based on faction"] = "Colorier les décors en fonction de la faction"
L["Combat log cannot be hidden while undocked."] = "Le journal de combat ne peut pas être masqué lorsqu'il n'est pas ancré."
L["Combat plates"] = "Plaques de combat"
L["Completed."] = "Terminé."
L["Concerted Efforts"] = "Des efforts concertés"
L["Configuration Panel"] = "Panneau de configuration"
L["Connections for"] = "Connexions pour"
L["Conquering Arathi Basin"] = "La conquête du bassin d'Arathi"
L["Credits"] = "Crédits"
L["Cursor"] = "Curseur"
L["Cursor Left"] = "Curseur gauche"
L["Cursor Right"] = "Curseur droit"
L["Customise minimap"] = "Mini-carte"
L["D"] = "D"
L["Darkmoon Faire"] = "Foire de Sombrelune"
L["Darkshore"] = "Sombrivage"
L["Deadmines"] = "Les Mortemines"
L["Deadwind Pass"] = "Défilé de Deuillevent"
L["Desolace"] = "Désolace"
L["Dire Maul"] = "Hache-tripes"
L["Disable bag automation"] = "Sac"
L["Disable chat fade"] = "Fondu de discussion"
L["Disable loot warnings"] = "Avertissements de butin"
L["Disable screen effects"] = "Effets d'écran"
L["Disable screen glow"] = "L'éclat de l'écran"
L["Disable sticky chat"] = "Discussion collante"
L["Drag the frame overlay to position the frame."] = "Faites glisser la superposition de cadre pour positionner le cadre."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Faites glisser les superpositions de cadres pour positionner les cadres.|n|nPour modifier l'échelle d'un cadre, cliquez dessus pour le sélectionner, puis ajustez le curseur d'échelle.|n|nCe panneau se fermera automatiquement si vous entrez en combat."
L["Drag to set the buffs frame scale."] = "Faites glisser pour définir l'échelle du cadre des buffs."
L["Drag to set the cursor X offset."] = "Faites glisser pour définir le décalage X du curseur."
L["Drag to set the cursor Y offset."] = "Faites glisser pour définir le décalage Y du curseur."
L["Drag to set the density of weather effects."] = "Faites glisser pour définir la densité des effets météorologiques."
L["Drag to set the font size of book text."] = "Faites glisser pour définir la taille de police du texte du livre."
L["Drag to set the font size of mail text."] = "Faites glisser pour définir la taille de la police du texte du courrier."
L["Drag to set the font size of quest text."] = "Faites glisser pour définir la taille de la police du texte de la quête."
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "Faites glisser pour définir l'échelle de la minicarte.|n|nNotez que si vous utilisez les barres d'action par défaut, le redimensionnement de la mini-carte redimensionnera également les bonnes barres d'action au démarrage, vous voudrez donc peut-être laisser cela à 100%."
L["Drag to set the scale of the Leatrix Plus panel."] = "Faites glisser pour définir l'échelle du panneau Leatrix Plus."
L["Drag to set the scale of the selected frame."] = "Faites glisser pour définir l'échelle du cadre sélectionné."
L["Drag to set the size of the bottom border."] = "Faites glisser pour définir la taille de la bordure inférieure."
L["Drag to set the size of the left border."] = "Faites glisser pour définir la taille de la bordure gauche."
L["Drag to set the size of the right border."] = "Faites glisser pour définir la taille de la bordure droite."
L["Drag to set the size of the top border."] = "Faites glisser pour définir la taille de la bordure supérieure."
L["Drag to set the tooltip scale."] = "Faites glisser pour définir l'échelle de l'infobulle."
L["Drag to set the transparency of the borders."] = "Faites glisser pour définir la transparence des bordures."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Faites glisser pour définir la transparence du panneau Leatrix Plus."
L["Dun Morogh"] = "Dun Morogh"
L["Dungeons"] = "Donjons"
L["Dup ID"] = "Dup ID"
L["durability"] = "durabilité"
L["Durability"] = "Durabilité"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bois de la Pénombre"
L["Dustwallow Marsh"] = "Marécage d'Âprefange"
L["Eastern Kingdoms"] = "Royaumes de l'Est"
L["Eastern Plaguelands"] = "Maleterres de l'est"
L["ELITE"] = "ÉLITE"
L["Elwynn Forest"] = "Forêt d'Elwynn"
L["Enable hotkey"] = "Activer le raccourci"
L["Enable viewport"] = "Activer la fenêtre"
L["Enhance dressup"] = "Cabine d'essayage"
L["Enhance professions"] = "Professions"
L["Enhance quest log"] = "Journal des quêtes"
L["Enhance trainers"] = "Maîtres"
L["Enhancements"] = "Améliorations"
L["Enter"] = "Entrer"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "Entrez les ID des sorts pour les icônes de temps de recharge que vous souhaitez voir.|n|nSi une icône de temps de recharge apparaît normalement sous le cadre de le familier, cochez la case de le familier.|n|nLes icônes de temps de recharge sont enregistrées dans votre classe."
L["enter zone or track name"] = "entrer dans la zone ou suivre le nom"
L["Error messages will be hidden"] = "Les messages d'erreur seront masqués"
L["Error messages will be shown"] = "Des messages d'erreur seront affichés"
L["Events"] = "Événements"
L["Extras"] = "Suppléments"
L["False"] = "Faux"
L["Faster auto loot"] = "La fouille plus rapide"
L["Faster movie skip"] = "Saut de film plus rapide"
L["Features"] = "Traits"
L["Felwood"] = "Gangrebois"
L["Feralas"] = "Féralas"
L["Fight for Warsong Gulch"] = "La lutte pour le goulet des Warsong"
L["Find Item"] = "Rechercher un objet"
L["For Great Honor"] = "Pour un grand honneur"
L["Frames"] = "Cadres"
L["Frostmaul E'ko"] = "L'E'ko de Cognegivre"
L["Frostsaber E'ko"] = "L'E'ko des sabres-de-givre"
L["Game Options"] = "Options de jeu"
L["Ghost"] = "Fantôme"
L["Gloomy"] = "Cafardeux"
L["Gnomeregan"] = "Gnomeregan"
L["Gold Only"] = "Or seulement"
L["Graphics and Sound"] = "Graphisme et son"
L["Groups"] = "Groupes"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "Pièces Gurubashi, Vilebranch et Witherbark"
L["H"] = "H"
L["Haunted"] = "Hanté"
L["Helm"] = "Heaume"
L["Help"] = "Aide"
L["Hide chat buttons"] = "Boutons de discussion"
L["Hide cooldown duration numbers (if enabled)"] = "Masquer les numéros de durée de recharge (si activé)"
L["Hide error messages"] = "Messages d'erreur"
L["Hide gryphons"] = "Griffons"
L["Hide portrait numbers"] = "Numéros de portrait"
L["Hide stance bar"] = "Barre de posture"
L["Hide the combat log"] = "Journal de combat"
L["Hide the zone text bar"] = "Masquer la barre de texte de la zone"
L["Hide the zoom buttons"] = "Masquer les boutons de zoom"
L["Hide tooltips for world units during combat"] = "Masquer les infobulles des unités mondiales pendant le combat"
L["Hide zone text"] = "Texte de la zone"
L["High"] = "Haut"
L["Hillsbrad Foothills"] = "Contreforts d'Hillsbrad"
L["Hinterlands"] = "Les Hinterlands"
L["Home"] = "Principal"
L["Ice Thistle E'ko"] = "L'E'ko des Chardon de Glace"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "Si cette option est cochée, une boîte de recherche de sac sera affichée dans le cadre du sac à dos et le cadre de la banque."
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Si cette option est cochée, un bouton sera ajouté à la feuille de personnage qui montrera la durabilité de votre objet équipé lorsque vous passez le pointeur dessus.|n|nDe plus, un pourcentage global sera affiché dans le cadre de discussion lorsque vous mourrez."
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "Si cette option est cochée, une invitation de groupe sera envoyée à toute personne qui vous chuchote avec un mot clé défini tant que vous n'êtes pas groupé, chef de groupe ou assistant de raid."
L["If checked, a master volume slider will be shown in the character sheet."] = "Si cette option est cochée, un curseur de volume principal sera affiché dans la feuille de personnage."
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "Si cette option est cochée, un bouton de minicarte sera disponible.|n|nCliquez sur - Basculer le panneau d'options.|n|nMaj+clic gauche - Basculer la musique.|n|nCtrl+Clic droit - Basculer les erreurs (si activé).|n|nCtrl+Maj+Clic gauche - Basculer Zygor (si installé).|n|nCtrl+Maj+Clic droit - Basculer en mode fenêtré."
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "Si cette option est cochée, des fonctionnalités supplémentaires seront ajoutées à l'hôtel des ventes|n|nAcheter seulement - créer des enchères de rachat sans renseigner le prix de départ.|n|nOr uniquement - fixez les prix du cuivre et de l'argent à 99 pour accélérer les nouvelles enchères.|n|nRechercher un objet - recherchez dans l'hôtel des ventes l'objet que vous vendez.|n|nEn outre, le paramètre de durée de l'enchère sera enregistré dans l'ensemble du compte."
L["If checked, alert frames will not be shown."] = "Si cette option est cochée, les cadres d'alerte ne seront pas affichés."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si cette option est cochée, tous les objets de qualité médiocre dans vos sacs seront vendus automatiquement lors de votre visite chez un marchand.|n|nVous pouvez maintenir la touche Maj enfoncée lorsque vous parlez à un marchand pour remplacer ce paramètre."
L["If checked, available quests will be accepted automatically."] = "Si cette option est cochée, les quêtes disponibles seront acceptées automatiquement."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Si cette option est cochée, les fonds seront teintés en bleu (amical) ou en rouge (hostile)."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Si cette option est cochée, les demandes de contact BattleTag et Nom réel seront automatiquement refusées.|n|nL'activation de cette option refusera automatiquement toutes les demandes en attente."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Si cette option est cochée, les boutons du cadre de discussion seront masqués.|n|nCliquer sur les onglets de discussion affichera automatiquement les derniers messages.|n|nUtilisez la molette de la souris pour faire défiler l'historique du discussion. Maintenez Maj pour le saut de page ou Ctrl pour sauter vers le haut ou le bas de l'historique de discussion."
L["If checked, chat text will not fade out after a time period."] = "Si cette option est cochée, le texte de discussion ne disparaîtra pas après un certain temps."
L["If checked, class coloring will be used in the player frame and target frame."] = "Si cette option est cochée, la coloration de la classe sera utilisée dans le cadre du joueur et le cadre cible."
L["If checked, class colors will be used in the chat frame."] = "Si cette option est cochée, les couleurs de classe seront utilisées dans le cadre de discussion."
L["If checked, class icons will be shown in the portrait frames."] = "Si cette option est cochée, les icônes de classe seront affichées dans les cadres de portrait."
L["If checked, completed quests will be turned-in automatically."] = "Si cette option est cochée, les quêtes terminées seront retournées automatiquement."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Si cette option est cochée, les confirmations n'apparaîtront plus lorsque vous choisissez une option de rouleau de butin ou tentez de vendre ou d'envoyer un objet échangeable."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Si cette option est cochée, les numéros de durée de temps de recharge ne seront pas affichés au cours des temps de recharge.|n|nSi il n'est pas coché, les numéros de durée des temps de recharge seront affichés au-dessus des temps de recharge s'ils sont activés dans le panneau d'options de jeu (menu 'Barres d'action')."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Si cette option est cochée, les nombres de dégâts et de soins dans les cadres de portrait de joueur et du familier seront cachés."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Si cette option est cochée, le fait de faire glisser l'onglet Général de discussion alors que le cadre de discussion est verrouillé étendra le cadre de discussion vers le haut.|n|nSi le cadre de discussion est déverrouillé, le fait de faire glisser l'onglet Général de discussion déplace le cadre de discussion."
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "Si cette option est cochée, les demandes de duel seront bloquées sauf si le joueur qui demande le duel est dans votre liste d'amis ou votre guilde."
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "Si cette option est cochée, les sons d'émote seront réduits au silence pendant que votre personnage se repose ou dans Le Sinistre écluseur.|n|nLes sons d'émote seront activés à tout autre moment."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Si cette option est cochée, les barres d'info des ennemis seront affichées pendant le combat et cachées à la fin du combat."
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "Si cette option est cochée, les invitations de groupe ne seront envoyées qu'aux amis et aux membres de la guilde.|n|nSi elle n'est pas cochée, les invitations de groupe seront envoyées à tout le monde."
L["If checked, guild names will be shown.  Guild ranks will also be shown for players in your guild."] = "Si cette option est cochée, les noms de guilde seront affichés. Les grades de guilde seront également affichés pour les joueurs de votre guilde."
L["If checked, helm and cloak toggle checkboxes will be shown in the character sheet.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "Si cette option est cochée, les cases à cocher de l'heaume et de la cape seront affichées dans la feuille de personnage.|n|nVous pouvez maintenir la touche Maj enfoncée et cliquer avec le bouton droit sur les cases à cocher pour changer de disposition."
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "Si cette option est cochée, la plupart des messages d'erreur ne seront pas affichés. Certaines erreurs importantes sont exclues.|n|nSi le bouton de la mini-carte est activé, vous pouvez maintenir la touche de contrôle enfoncée et cliquer dessus avec le bouton droit pour basculer les messages d'erreur sans affecter ce paramètre."
L["If checked, nude and tabard toggle buttons will be added to the dressup frame and model rotation controls will be removed."] = "Si cette option est cochée, des boutons à bascule nude et tabard seront ajoutés au cadre de la cabine d'essayage et les commandes de rotation du modèle seront supprimées."
L["If checked, party invitations from friends or guild members will be automatically accepted."] = "Si cette option est cochée, les invitations de groupe d'amis ou de membres de guilde seront automatiquement acceptées."
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "Si cette option est cochée, les invitations de groupe seront bloquées sauf si le joueur qui vous invite se trouve dans votre liste d'amis ou votre guilde."
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting.|n|nRepeatable battlemaster and cloth quartermaster quests can be automatically selected by holding down the alt key."] = "Si cette option est cochée, les quêtes seront sélectionnées, acceptées et rendues automatiquement.|n|nLes quêtes nécessitant de l'or ne seront pas rendues automatiquement.|n|nVous pouvez maintenir la touche Maj enfoncée lorsque vous parlez à un donneur de quête pour annuler ce paramètre.|n|nLes quêtes de maître de guerre et de intendant des étoffes répétables peuvent être sélectionnées automatiquement en maintenant la touche Alt enfoncée."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Si cette option est cochée, la discussion de raid et la discussion d'instance seront tous les deux colorés en bleu (pour correspondre à la couleur de chat du groupe par défaut)."
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat."] = "Si cette option est cochée, les demandes de ressuscitation seront acceptées automatiquement tant que le joueur qui vous ressuscite n'est pas en combat."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "Si cette option est cochée, les ID des sorts seront affichés dans les infobulles des icônes de buff situées dans le cadre du buff et sous le cadre cible."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Si cette option est cochée, le chat collant sera désactivé.|n|nNotez que cela ne s'applique pas aux fenêtres de discussion temporaires."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Si cette option est cochée, les demandes d'invocation seront acceptées automatiquement, sauf si vous êtes en combat."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Si cette option est cochée, la liste des add-ons (accessible depuis le menu du jeu) affichera les add-ons basés sur les personnages par défaut."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Si cette option est cochée, le temps qu'il faut pour fouiller automatiquement les créatures sera considérablement réduit."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Si cette option est cochée, le bouton de nettoyage du sac à dos et le bouton de nettoyage du cadre de la banque ne seront pas affichés."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Si cette option est cochée, le bouton permettant de basculer le cadre du conteneur de raid sera affiché juste au-dessus du cadre de gestion du raid (côté gauche de l'écran) plutôt que dans le cadre de gestion du raid lui-même.|n|nCela vous permet de basculer le cadre du conteneur de raid sans avoir à ouvrir le cadre de gestion du raid."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Si cette option est cochée, le journal de combat sera caché.|n|nLe journal de combat doit être ancré pour que cette option fonctionne.|n|nSi le journal de combat n'est pas ancré, vous pouvez l'ancrer en faisant glisser l'onglet (et en rechargeant votre interface utilisateur) ou en réinitialisant les fenêtres de discussion (à partir du menu de discussion)."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Si cette option est cochée, la boîte d'édition sera déplacée en haut du cadre de discussion."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Si cette option est cochée, l'écran gris de la mort et l'effet du monde inférieur seront désactivés."
L["If checked, the main bar gryphons will not be shown."] = "Si cette option est cochée, les griffons de la barre principale ne seront pas affichés."
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "Si cette option est cochée, le nombre d'emplacements de sac vides sera affiché dans l'icône du bouton du sac à dos et dans l'infobulle."
L["If checked, the player frame background will be shown in class color."] = "Si cette option est cochée, l'arrière-plan du cadre du joueur sera affiché en couleur de la classe."
L["If checked, the professions frame will be larger."] = "Si cette option est cochée, le cadre des professions sera plus grand."
L["If checked, the quest log frame will be larger and feature a world map button and quest levels."] = "Si cette option est cochée, le cadre du journal de quête sera plus grand et comportera un bouton de carte du monde et des niveaux de quête."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Si cette option est cochée, la lueur de l'écran sera désactivée.|n|nL'activation de cette option désactivera également l'effet de trouble ivre."
L["If checked, the skill trainer frame will be larger."] = "Si cette option est cochée, le cadre du maître sera plus grand."
L["If checked, the stance bar will not be shown."] = "Si cette option est cochée, la barre de posture ne sera pas affichée."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Si cette option est cochée, le cadre parlant ne sera pas affiché.|n|nLe cadre parlant apparaît normalement dans la partie inférieure de l'écran lorsque certains PNJ communiquent avec vous."
L["If checked, the target frame background will be shown in class color."] = "Si cette option est cochée, l'arrière-plan du cadre cible sera affiché dans la couleur de la classe."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Si cette option est cochée, l'infobulle sera codée par couleur et vous pourrez modifier la disposition et l'échelle de l'infobulle."
L["If checked, the vendor price will be shown in item tooltips."] = "Si cette option est cochée, le prix marchand sera affiché dans les infobulles des objets."
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "Si cette option est cochée, la barre de texte de la zone sera masquée. L'infobulle du bouton de suivi affiche des informations sur la zone."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Si cette option est cochée, les boutons de zoom seront masqués. Vous pouvez utiliser la molette pour zoomer quel que soit ce paramètre."
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "Si cette option est cochée, les infobulles des unités mondiales seront masquées pendant le combat.|n|nVous pouvez maintenir la touche Maj enfoncée pour remplacer ce paramètre."
L["If checked, unit targets will be shown."] = "Si cette option est cochée, les cibles des unités seront affichées."
L["If checked, Wowhead links will be shown above the quest log frame."] = "Si cette option est cochée, les liens Wowhead seront affichés au-dessus du cadre de journal de quête."
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip item.|n|nIf the gossip item type is banker, taxi, trainer or vendor, gossip will be skipped without needing to hold the alt key.  You can hold the shift key down to prevent this."] = "Si cette option est cochée, vous pouvez maintenir la touche alt enfoncée tout en ouvrant une fenêtre de dialogue pour sélectionner automatiquement un seul élément de dialogue.|n|nSi le type de dialogue est banquier, taxi, maître ou vendeur, le dialogue sera ignoré sans avoir besoin de maintenir la touche alt. Vous pouvez maintenir la touche Maj enfoncée pour éviter cela."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = [=[Si cette option est cochée, vous pouvez maintenir la touche de contrôle enfoncée et cliquer sur un onglet de discussion pour afficher la discussion récente dans une fenêtre de copie.

]=]
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "Si cette option est cochée, vous pouvez ouvrir Leatrix Plus en appuyant sur Ctrl+Z."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Si cette option est cochée, vous pouvez appuyer sur les touches fléchées pour déplacer le point d'insertion vers la gauche et la droite dans le cadre de discussion.|n|nSi elle n'est pas cochée, les touches fléchées utiliseront le paramètre de liaison de touches par défaut."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Si cette option est cochée, vous pourrez annuler les cinématiques sans être invité à confirmer."
L["If checked, you will be able to change the font size of book text."] = "Si cette option est cochée, vous pourrez modifier la taille de la police du texte du livre."
L["If checked, you will be able to change the font size of quest text."] = "Si cette option est cochée, vous pourrez modifier la taille de la police du texte de la quête."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Si cette option est cochée, vous pourrez modifier la taille de police du texte de courrier standard.|n|nCela n'affecte pas le courrier créé à l'aide de modèles (tels que les factures de l'hôtel des ventes)."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "Si cette option est cochée, vous pourrez modifier la position et l'échelle du cadre des buffs."
L["If checked, you will be able to change the position and scale of the following frames:|n|n- Player frame|n- Target frame|n- Widget top center frame|n- Timer bar"] = "Si cette option est cochée, vous pourrez modifier la position et l'échelle des cadres suivants:|n|n- Cadre du joueur|n- Cadre du cible|n- Cadre central supérieur du widget|n- Barre de minuterie"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Si cette option est cochée, vous pourrez créer une fenêtre. Une fenêtre ajoute des bordures noires réglables dans le monde du jeu.|n|nLes bordures sont placées au-dessus du monde du jeu mais sous l'interface utilisateur afin que vous puissiez placer des éléments d'interface sur eux."
L["If checked, you will be able to customise the minimap."] = "Si cette option est cochée, vous pourrez personnaliser la minicarte."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Si cette option est cochée, vous pourrez faire glisser le cadre de discussion vers le bord de l'écran."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Si cette option est cochée, vous pourrez placer jusqu'à cinq icônes de recharge bénéfiques au-dessus du cadre cible."
L["If checked, you will be able to reposition the tooltip."] = "Si cette option est cochée, vous pourrez repositionner l'infobulle."
L["If checked, you will be able to set the density of weather effects."] = "Si cette option est cochée, vous pourrez définir la densité des effets météorologiques."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Si cette option est cochée, vous pourrez montrer une chaîne rare, d'élite ou d'élite rare autour du cadre du joueur."
L["If checked, you will be able to zoom out to a greater distance."] = "Si cette option est cochée, vous pourrez effectuer un zoom arrière sur une plus grande distance."
L["If checked, you will need to hold the shift key down for quests to be automated.|n|nIf unchecked, holding shift will prevent quests from being automated."] = "Si cette option est cochée, vous devrez maintenir la touche Maj enfoncée pour que les quêtes soient automatisées.|n|nSi cette option n'est pas cochée, le maintien de la touche Maj empêchera l'automatisation des quêtes."
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "Si cette option est cochée, vous serez automatiquement libéré après votre mort sur un champ de bataille.|n|nVous ne vous libérerez pas automatiquement si vous avez la capacité de ressusciter automatiquement."
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "Si cette option est cochée, vos sacs ne seront pas ouverts ou fermés automatiquement lorsque vous interagissez avec un marchand, une banque ou une boîte aux lettres."
L["If checked, your character will automatically stand or dismount when an action is prevented because you are either seated or mounted."] = "Si cette option est cochée, votre personnage se lèvera ou se descendra automatiquement lorsqu'une action est empêchée parce que vous êtes assis ou monté."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Si cette option est cochée, votre historique de discussion passera à 4096 lignes. Si elle n'est pas cochée, la valeur par défaut sera utilisée (128 lignes).|n|nL'activation de cette option peut empêcher certains textes de discussion de s'afficher pendant la connexion."
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = [=[Si cette option est cochée, votre équipement sera réparé automatiquement lorsque vous rendrez visite à un marchand approprié.|n|nVous pouvez maintenir la touche Maj enfoncée lorsque vous parlez à un marchand pour remplacer ce paramètre.

]=]
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Si cette option est cochée, le texte de la zone ne sera pas affiché (par exemple, «Ironforge»)."
L["Increase chat history"] = "Augmenter l'historique"
L["Interface"] = "Interface"
L["Invaders of Alterac Valley"] = "Les envahisseurs de la vallée d'Alterac"
L["Invalid console variable."] = "Variable de console non valide."
L["Invalid parameter."] = "Paramètre invalide."
L["Invalid quest ID."] = "ID de quête non valide."
L["Invalid sound ID"] = "ID de son invalide"
L["Invalid taint level."] = "Niveau de souillure non valide."
L["Invalid target."] = "Cible invalide."
L["Invite from whispers"] = "Inviter des chuchotements"
L["Kalimdor"] = "Kalimdor"
L["Keyword"] = "Mot-clé"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus n'écrasera pas LeaPlusDB à la prochaine déconnexion."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: UNE VERSION INCORRECTE EST INSTALLÉE!"
L["Left"] = "Gauche"
L["Lifetime honorable kills"] = "Victoires honorables à vie"
L["Loch Modan"] = "Loch Modan"
L["Lockout sharing"] = "Partage de verrouillage"
L["Low"] = "Faible"
L["Magic"] = "Magie"
L["Main Titles"] = "Titres principaux"
L["Manage buffs"] = "Gérer les buffs"
L["Manage frames"] = "Gérer les cadres"
L["Manage tooltip"] = "Gérer l'infobulle"
L["Managed by Leatrix Plus"] = "Géré par Leatrix Plus"
L["Map"] = "Carte"
L["Maraudon"] = "Maraudon"
L["Max camera zoom"] = "Zoom max de la caméra"
L["Mechanics"] = "Mécanique"
L["Media"] = "Médias"
L["Medium"] = "Moyen"
L["Memory Usage"] = "Utilisation de la mémoire"
L["message shown."] = "message affiché."
L["messages shown."] = "messages affichés."
L["Missing console variable."] = "Variable de console manquante."
L["Missing mount name."] = "Nom de monture manquant."
L["Missing movie ID."] = "ID de film manquant."
L["Missing quest ID."] = "ID de quête manquant."
L["Missing sound file parameter."] = "Paramètre de fichier son manquant."
L["Missing sound ID."] = "ID de son manquant."
L["Molten Core"] = "Cœur du Magma"
L["Moonglade"] = "Reflet-de-Lune"
L["Mount not found."] = "Monture introuvable."
L["Move editbox to top"] = "Boîte d'édition"
L["Movie not playable."] = "Film non jouable."
L["Movie number"] = "Numéro de film"
L["Movies"] = "Films"
L["Mulgore"] = "Mulgore"
L["Music"] = "Musique"
L["Musical Moments"] = "Moments musicaux"
L["Mystery"] = "Mystère"
L["Narration"] = "Narration"
L["Naxxramas"] = "Naxxramas"
L["No bad sound IDs found."] = "Aucun mauvais ID sonore trouvé."
L["No help is available for this page."] = "Aucune aide n'est disponible pour cette page."
L["No items with durability equipped."] = "Aucun objet avec durabilité équipé."
L["No media duplicates found."] = [=[Aucun doublon de média trouvé.
]=]
L["No tooltip showing."] = "Aucune infobulle ne s'affiche."
L["None"] = "Aucun"
L["Not completed."] = "Pas terminé."
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "AVIS!|nVous devez redémarrer complètement votre client de jeu avant de pouvoir utiliser cette version de Leatrix Plus."
L["Nude"] = "Nu"
L["Onyxia's Lair"] = "Repaire d'Onyxia"
L["or click the minimap button to open Leatrix Plus."] = "ou cliquez sur le bouton de la mini-carte pour ouvrir Leatrix Maps."
L["Orgrimmar"] = "Orgrimmar"
L["Overall"] = "Total"
L["Overlay"] = "Superposition"
L["Particle density"] = "Densité de particules"
L["Party from friends"] = "Groupe d'amis"
L["Pet"] = "Familier"
L["Player"] = "Joueur"
L["Power"] = "Puissance"
L["Press CTRL/C to copy."] = "Appuyez sur Ctrl+C pour copier."
L["Queue from friends"] = "File d'attente d'amis"
L["R"] = "R"
L["Ragefire Chasm"] = "Gouffre de Ragefeu"
L["Raid"] = "Raid"
L["Raid frame toggle"] = "Cadre de raid"
L["Random"] = "Aléatoire"
L["RARE"] = "RARE"
L["RARE ELITE"] = "RARE ÉLITE"
L["Razorfen Downs"] = "Souilles de Tranchebauge"
L["Razorfen Kraul"] = "Kraal de Tranchebauge"
L["Recent chat window"] = "Discussion récente"
L["Redridge Mountains"] = "Les Carmines"
L["Release in PvP"] = "Libérer en JcJ"
L["Reload"] = "Recharger"
L["Remember Alterac Valley!"] = "Souvenez-vous de la vallée d'Alterac !"
L["Repair automatically"] = "Réparer"
L["Repaired for"] = "Réparé pour"
L["Reposition the tooltip"] = "Repositionner l'infobulle"
L["Require shift key for quest automation"] = "Nécessite une touche Maj pour l'automatisation des quêtes"
L["Requires UI reload."] = "Nécessite le rechargement de l'interface utilisateur."
L["Reset"] = "Réinitialiser"
L["Resize book text"] = "Texte du livre"
L["Resize mail text"] = "Texte du courrier"
L["Resize quest text"] = "Texte de la quête"
L["Resize Screen"] = "Redimensionner l'écran"
L["Rested bubbles"] = "Bulles reposées"
L["Restrict to friends and guild members"] = "Restreindre aux amis et aux membres de la guilde"
L["result"] = "résultat"
L["results"] = "résultats"
L["Right"] = "Droit"
L["Right-click to close"] = "Clic droit pour fermer"
L["Right-click to close."] = "Clic droit pour fermer."
L["right-click to go back"] = "clic droit pour revenir"
L["Ruins of Ahn'Qiraj"] = "Ruines d'Ahn'Qiraj"
L["Sacred"] = "Sacré"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "Pièces Sandfury, Skullsplitter et Bloodscalp"
L["Scale"] = "Échelle"
L["Scarlet Monastery"] = "Monastère écarlate"
L["Scholomance"] = "Scholomance"
L["Search"] = "Chercher"
L["Searing Gorge"] = "Gorge des Vents brûlants"
L["Select the settings that you want to use."] = "Sélectionnez les paramètres que vous souhaitez utiliser."
L["Selection of music tracks"] = "Sélection de morceaux de musique"
L["Self Markers Allowed"] = "Marqueurs auto autorisés"
L["Self Markers Blocked"] = "Auto marqueurs bloqués"
L["Sell junk automatically"] = "Vendre objets médiocre"
L["SELLING JUNK"] = "Vendre des objets de qualité médiocre"
L["Set weather density"] = "Densité météorologique"
L["Settings"] = "Paramètres"
L["Shaders"] = "Shaders"
L["Shadowfang Keep"] = "Donjon d'Ombrecroc"
L["Shardtooth E'ko"] = "L'E'ko des Crocs acérés"
L["Show auction controls"] = "Hôtel des ventes"
L["Show bag search box"] = "Recherche de sacs"
L["Show character addons"] = "Add-ons de personnage"
L["Show cooldowns"] = "Temps de recharge"
L["Show durability status"] = "Durabilité"
L["Show free bag slots"] = "Emplacements de sac vides"
L["Show guild names"] = "Afficher les noms de guilde"
L["Show minimap button"] = "Bouton de la mini-carte"
L["Show player chain"] = "Chaîne du joueur"
L["Show player frame in class color"] = "Afficher le cadre du joueur dans la couleur de la classe"
L["Show target frame in class color"] = "Afficher le cadre cible dans la couleur de la classe"
L["Show the spell ID in buff icon tooltips"] = "Afficher l'ID du sort dans les infobulles des icônes de buff"
L["Show unit targets"] = "Afficher les cibles des unités"
L["Show vanity controls"] = "Afficher les commandes de vanité"
L["Show vendor price"] = "Prix marchand"
L["Show volume slider"] = "Volume"
L["Show Wowhead links"] = "Liens Wowhead"
L["Silence rested emotes"] = "Emotes reposés"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Forêt des Pins argentés"
L["Social"] = "Social"
L["Sold junk for"] = "Vendu des objets de qualité médiocre pour"
L["Sound system restarted."] = "Le système audio a redémarré."
L["Spell ID"] = "ID de sort"
L["Spooky"] = "Effrayant"
L["Stand and dismount"] = "Se lever et descendre"
L["Stockade"] = "La Prison"
L["Stonetalon Mountains"] = "Les Serres-Rocheuses"
L["Stop"] = "Arrêt"
L["Stormwind"] = "Stormwind"
L["Stranglethorn Vale"] = "Vallée de Strangleronce"
L["Stratholme"] = "Stratholme"
L["Sunken Temple"] = "Temple englouti"
L["Support"] = "Soutien"
L["Swamp"] = "Marais"
L["Swamp of Sorrows"] = "Marais des Chagrins"
L["System"] = "Système"
L["Tabard"] = "Tabard"
L["Taint level: Basic (1)."] = "Niveau de souillure: basique (1)."
L["Taint level: Disabled (0)."] = "Niveau de souillure: désactivé (0)."
L["Taint level: Full (2)."] = "Niveau de souillure: Complet (2)."
L["Tanaris"] = "Tanaris"
L["Target"] = "Cible"
L["Target Tracking Disabled"] = "Pistage de cible désactivé"
L["Target Tracking Enabled"] = "Pistage de cible activé"
L["Teldrassil"] = "Teldrassil"
L["Temple of Ahn'Qiraj"] = "Temple d'Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Le temple d'Atal'Hakkar"
L["Ten Years of Warcraft"] = "Dix ans de Warcraft"
L["Text"] = "Texte"
L["Text size"] = "Taille du texte"
L["Text Size"] = "Taille du texte"
L["The summon from"] = "L'invocation de"
L["Themes"] = "Thèmes"
L["This panel will close automatically if you enter combat."] = "Ce panneau se fermera automatiquement si vous entrez en combat."
L["Thousand Needles"] = "Mille pointes"
L["Timer"] = "Minuteur"
L["Tirisfal Glades"] = "Clairières de Tirisfal"
L["To begin, choose an options page."] = "Pour commencer, choisissez une page d'options."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Pour utiliser le bouton Rechercher un objet, vous devez désélectionner la catégorie Token WoW."
L["Tooltip"] = "Infobulle"
L["Tooltip title color"] = "Couleur du titre de l'infobulle"
L["Top"] = "Haut"
L["Top Center"] = "Haut Centre"
L["Tracing started."] = "Le traçage a commencé."
L["Tracing stopped."] = "Le traçage s'est arrêté."
L["Transparency"] = "Transparence"
L["True"] = "Vrai"
L["Turn-in completed quests automatically"] = "Retourner automatiquement les quêtes terminées"
L["Uldaman"] = "Uldaman"
L["Unclamp chat frame"] = "Déverrouiller le cadre"
L["Undercity"] = "Undercity"
L["Un'Goro Crater"] = "Cratère d'Un'Goro"
L["Universal group color"] = "Couleur de groupe universelle"
L["Use arrow keys in chat"] = "Touches fléchées"
L["Use class colors in chat"] = "Couleurs de classe"
L["Use easy resizing"] = "Redimensionnement"
L["Value must be a number."] = "La valeur doit être un nombre."
L["Various"] = "Divers"
L["Vendors"] = "Marchands"
L["Version"] = "Version"
L["Very Low"] = "Très faible"
L["Video"] = "Vidéo"
L["Visibility"] = "Visibilité"
L["Wailing Caverns"] = "Cavernes des lamentations"
L["was automatically declined."] = "a été automatiquement refusé."
L["Weather density"] = "Densité météorologique"
L["Welcome to Leatrix Plus."] = "Bienvenue dans Leatrix Plus."
L["Western Plaguelands"] = "Maleterres de l'ouest"
L["Westfall"] = "Marche de l'Ouest"
L["Wetlands"] = "Les Paluns"
L["Widget"] = "Widget"
L["Wildkin E'ko"] = "L'E'ko des Indomptables"
L["will be automatically accepted in 10 seconds unless cancelled."] = "sera automatiquement accepté dans 10 secondes sauf annulation."
L["Winter"] = "Hiver"
L["Winterfall E'ko"] = "L'E'ko des Tombe-hiver"
L["Winterspring"] = "Berceau-de-l'Hiver"
L["World of Warcraft"] = "World of Warcraft"
L["X Offset"] = "Décalage X"
L["Y Offset"] = "Décalage Y"
L["YOU"] = "VOUS"
L["You cannot do that in combat."] = "Vous ne pouvez pas faire cela au combat."
L["You have"] = "Vous avez"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = [=[Votre interface utilisateur doit être rechargée pour que certaines des modifications prennent effet.|n|nVous n'avez pas besoin de cliquer immédiatement sur le bouton de rechargement, mais vous devez le cliquer lorsque vous avez terminé d'apporter des modifications et que vous souhaitez que les modifications prennent effet.

]=]
L["Your UI needs to be reloaded."] = "Votre interface utilisateur doit être rechargée."
L["Zones"] = "Zones"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"
L["Zulian, Razzashi, and Hakkari Coins"] = "Pièces zuliennes, razzashi et hakkari"
L["Zygor addon not found."] = "Add-on Zygor introuvable."

end

-- itIT: Italian
if GameLocale == "itIT" then

end

-- ptBR: Portugese (Brazil)
if GameLocale == "ptBR" then
L["+"] = "+"
L["A Donation of Mageweave"] = "Uma doação de magitrama"
L["A Donation of Runecloth"] = "Uma doação de runatrama"
L["A Donation of Silk"] = "Uma doação de seda"
L["A Donation of Wool"] = "Uma doação de lã"
L["A friend request from"] = "Uma solicitação de confirmação de amigo de"
L["Accept available quests automatically"] = "Aceitar missões disponíveis automaticamente"
L["Accept resurrection"] = "Aceitar ressuscitação"
L["Accept summon"] = "Aceitar evocação"
L["Additional Runecloth"] = "Runatrama extra"
L["Addon"] = "Addon"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alterac Mountains"] = "Montanhas de Alterac"
L["Anchor"] = "Âncora"
L["Angelic"] = "Angélico"
L["Arathi Highlands"] = "Planalto Arathi"
L["Ashenvale"] = "Vale Gris"
L["Auto loot is now enabled."] = "Saque automático agora está ativado."
L["AutoFollow"] = "Seguir automático"
L["AutoFollow disabled."] = "Seguir automático desativado."
L["Automate gossip"] = "Automatizar diálogo"
L["Automate quests"] = "Automatizar missões"
L["Automation"] = "Automação"
L["Azshara"] = "Azshara"
L["Back to Main Menu"] = "Voltar ao menu principal"
L["Bad ID"] = "ID inválido"
L["Badlands"] = "Ermos"
L["Barrens"] = "Sertões"
L["Battle"] = "Batalha"
L["Battle of Warsong Gulch"] = "Batalha da Ravina Brado Guerreiro"
L["Battlegrounds"] = "Campo de Batalha"
L["Blackfathom Deeps"] = "Profundezas Negras"
L["Blackrock Depths"] = "Abismo Rocha Negra"
L["Blackwing Lair"] = "Covil Asa Negra"
L["Blasted Lands"] = "Barreira do Inferno"
L["Block duels"] = "Duelos"
L["Block friend requests"] = "Solicitações de confirmação de amigo"
L["Block party invites"] = "Convites de grupo"
L["Blocks"] = "Bloquear"
L["Bottom"] = "Inferior"
L["Buffs"] = "Buffs"
L["Burning Steppes"] = "Estepes Ardentes"
L["Buyout Only"] = "Somente Compra"
L["C"] = "C"
L["Camera distance"] = "Distância da câmera"
L["Chain style"] = "Estilo cadeia"
L["Character"] = "Personagem"
L["Chat"] = "Bate-papo"
L["Chat Frame"] = "Quadro de bate-papo"
L["Checkbox labels are Ok."] = "Os rótulos das caixas de seleção estão OK."
L["Chillwind E'ko"] = "E'ko de ventogelante"
L["Cinematics"] = "Cinemático"
L["Claiming Arathi Basin"] = "Reivindicando a Bacia Arathi"
L["Class colored frames"] = "Quadros coloridos"
L["Class icon portraits"] = "Retratos de classe"
L["Classic"] = "Clássico"
L["click here for new selection"] = "clique aqui para nova seleção"
L["Click to configure the settings for this option."] = "Clique para definir as configurações para esta opção."
L["Click to reset the settings on this page."] = "Clique para redefinir as configurações nesta página."
L["Click to resize the screen to fit between the top and bottom borders."] = "Clique para redimensionar a tela para caber entre as bordas superior e inferior."
L["Click to return to the main menu."] = "Clique para retornar ao menu principal."
L["Cloak"] = "Capa"
L["Color the backdrops based on faction"] = "Colorir os cenários com base em facção"
L["Combat log cannot be hidden while undocked."] = "O registro de combate não pode ser oculto enquanto desencaixado."
L["Combat plates"] = "Placas de combate"
L["Completed."] = "Completo."
L["Concerted Efforts"] = "Esforços combinados"
L["Configuration Panel"] = "Painel de Configuração"
L["Connections for"] = "Conexões para"
L["Conquering Arathi Basin"] = "Conquistando a Bacia Arathi"
L["Credits"] = "Créditos"
L["Cursor"] = "Cursor"
L["Cursor Left"] = "Cursor esquerdo"
L["Cursor Right"] = "Cursor direito"
L["Customise minimap"] = "Personalizar minimapa"
L["D"] = "M"
L["Darkmoon Faire"] = "Feira de Negraluna"
L["Darkshore"] = "Costa Negra"
L["Deadmines"] = "Minas Mortas"
L["Deadwind Pass"] = "Trilha do Vento Morto"
L["Desolace"] = "Desolação"
L["Dire Maul"] = "Gládio Cruel"
L["Disable bag automation"] = "Automação de bolsa"
L["Disable chat fade"] = "Esmaecimento"
L["Disable loot warnings"] = "Avisos de butim"
L["Disable screen effects"] = "Efeitos de tela"
L["Disable screen glow"] = "Brilho da tela"
L["Disable sticky chat"] = "Bate-papo pegajoso"
L["Drag the frame overlay to position the frame."] = "Arraste a sobreposição do quadro para posicionar o quadro."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Arraste as sobreposições de quadros para posicionar os quadros.|n|nPara alterar a escala de um quadro, clique nele para selecioná-lo e ajuste o controle deslizante da escala.|n|nThis panel will close automatically if you enter combat."
L["Drag to set the buffs frame scale."] = "Arrasta para definir a escala do quadro de buffs."
L["Drag to set the cursor X offset."] = "Arraste para definir o deslocamento X do cursor."
L["Drag to set the cursor Y offset."] = "Arraste para definir o deslocamento Y do cursor."
L["Drag to set the density of weather effects."] = "Arraste para definir a densidade dos efeitos climáticos."
L["Drag to set the font size of book text."] = "Arraste para definir o tamanho da fonte do texto do livro."
L["Drag to set the font size of mail text."] = "Arraste para definir o tamanho da fonte do texto do correio."
L["Drag to set the font size of quest text."] = "Arraste para definir o tamanho da fonte do texto da missão."
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "Arraste para definir a escala do minimapa.|n|nObserve que, se você estiver usando as barras de ação padrão, o redimensionamento do minimapa também redimensionará as barras de ação corretas na inicialização. Portanto, você pode deixar isso em 100%."
L["Drag to set the scale of the Leatrix Plus panel."] = "Arraste para definir a escala do painel Leatrix Plus."
L["Drag to set the scale of the selected frame."] = "Arraste para definir a escala do quadro selecionado."
L["Drag to set the size of the bottom border."] = "Arraste para definir o tamanho da borda inferior."
L["Drag to set the size of the left border."] = "Arraste para definir o tamanho da borda esquerda."
L["Drag to set the size of the right border."] = "Arraste para definir o tamanho da borda direita."
L["Drag to set the size of the top border."] = "Arraste para definir o tamanho da borda superior."
L["Drag to set the tooltip scale."] = "Arraste para definir a escala da dica de ferramenta."
L["Drag to set the transparency of the borders."] = "Arraste para definir a transparência das bordas."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Arraste para definir a transparência do painel Leatrix Plus."
L["Dun Morogh"] = "Dun Morogh"
L["Dungeons"] = "Masmorras"
L["Dup ID"] = "ID Dup"
L["durability"] = "durabilidade"
L["Durability"] = "Durabilidade"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Floresta do Crepúsculo"
L["Dustwallow Marsh"] = "Pântano Vadeoso"
L["Eastern Kingdoms"] = "Reinos do Leste"
L["Eastern Plaguelands"] = "Terras Pestilentas Orientais"
L["ELITE"] = "ELITE"
L["Elwynn Forest"] = "Floresta de Elwynn"
L["Enable hotkey"] = "Ativar tecla de atalho"
L["Enable viewport"] = "Porta de visualização"
L["Enhance dressup"] = "Provador"
L["Enhance professions"] = "Profissões"
L["Enhance quest log"] = "Registro de missões"
L["Enhance trainers"] = "Instrutores"
L["Enhancements"] = "Melhorias"
L["Enter"] = "Entrar"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "Entra os IDs do feitiço dos ícones de recarga que você deseja ver.|n|nSe um ícone de recarga normalmente aparecer embaixo do quadro do ajudante, marque a caixa de seleção ajudante.|n|nOs ícones de recarga são salvos na sua classe."
L["enter zone or track name"] = "entrar o nome da zona ou faixa"
L["Error messages will be hidden"] = "Mensagens de erro serão ocultadas"
L["Error messages will be shown"] = "Mensagens de erro serão mostradas"
L["Events"] = "Eventos"
L["Extras"] = "Extras"
L["False"] = "Falso"
L["Faster auto loot"] = "Saque rápido"
L["Faster movie skip"] = "Pular filme mais rápido"
L["Features"] = "Características"
L["Felwood"] = "Selva Maleva"
L["Feralas"] = "Feralas"
L["Fight for Warsong Gulch"] = "Luta pela Ravina Brado Guerreiro"
L["Find Item"] = "Encontrar objeto"
L["For Great Honor"] = "Por grande honra"
L["Frames"] = "Quadros"
L["Frostmaul E'ko"] = "E'ko de Friomalho"
L["Frostsaber E'ko"] = "E'ko de sabre-de-gelo"
L["Game Options"] = "Opções de jogo"
L["Ghost"] = "Fantasma"
L["Gloomy"] = "Sombrio"
L["Gnomeregan"] = "Gnomeregan"
L["Gold Only"] = "Apenas ouro"
L["Graphics and Sound"] = "Gráficos e som"
L["Groups"] = "Grupos"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "As moedas Cascasseca, Ramatorpe e Gurubashi"
L["H"] = "H"
L["Haunted"] = "Assombrado"
L["Helm"] = "Elmo"
L["Help"] = "Ajuda"
L["Hide chat buttons"] = "Botões de bate-papo"
L["Hide cooldown duration numbers (if enabled)"] = "Ocultar números de duração da recarga (se ativado)"
L["Hide error messages"] = "Mensagens de erro"
L["Hide gryphons"] = "Grifos"
L["Hide portrait numbers"] = "Números de retrato"
L["Hide stance bar"] = "Barra de postura"
L["Hide the combat log"] = "Registro de combate"
L["Hide the zone text bar"] = "Ocultar a barra de texto da zona"
L["Hide the zoom buttons"] = "Ocultar os botões de zoom"
L["Hide tooltips for world units during combat"] = "Ocultar dicas de ferramentas para unidades mundiais durante o combate"
L["Hide zone text"] = "Texto da zona"
L["High"] = "Alto"
L["Hillsbrad Foothills"] = "Contraforte de Eira dos Montes"
L["Hinterlands"] = "Terras Agrestes"
L["Home"] = "Principal"
L["Ice Thistle E'ko"] = "E'ko de cardo de gelo"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "Se marcado, uma caixa de pesquisa de bolsas será mostrada no quadro da mochila e no quadro do banco."
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Se marcado, um botão será adicionado à ficha de personagem que mostrará a durabilidade do objeto equipado quando você passar o cursor sobre ele.|n|nAlém disso, uma porcentagem geral será mostrada no quadro de bate-papo quando você morrer."
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "Se marcado, um convite de grupo será enviado a qualquer pessoa que o sussurre com uma palavra-chave definida, desde que você não esteja agrupado, líder de grupo ou assistente de raide."
L["If checked, a master volume slider will be shown in the character sheet."] = "Se marcado, um controle deslizante de volume principal será mostrado na folha do personagem."
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "Se marcado, um botão de minimapa estará disponível.|n|nClique - Alternar painel de opções.|n|nShift+Clique esquerdo - Alterna música.|n|nCtrl+Clique direito - Alterna erros (se ativado).|n|nCtrl+Shift+Clique esquerdo - Alterna Zygor (se instalado).|n|nCtrl+Shift+Clique direito - Alterna o modo de janela."
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "Se marcado, funcionalidades adicionais serão adicionadas à casa de leilões.|n|nSomente compra - crie leilões de compra sem preencher o preço inicial.|n|nSomente ouro - defina os preços do cobre e da prata em 99 para acelerar novos leilões.|n|nLocalizar objeto - pesquise na casa de leilões o objeto que você está vendendo.|n|nAlém disso, a configuração de duração do leilão será salva em toda a conta."
L["If checked, alert frames will not be shown."] = "Se marcado, os quadros de alerta não serão mostrados."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Se marcado, todos os objetos de pobre qualidade em suas bolsas serão vendidos automaticamente quando você visitar um comerciante.|n|nVocê pode manter pressionada a tecla Shift ao conversar com um comerciante para substituir essa configuração."
L["If checked, available quests will be accepted automatically."] = "Se marcada, as missões disponíveis serão aceitas automaticamente."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Se marcado, o fundo será colorido em azul (amigável) ou vermelho (hostil)."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Se marcado, as solicitações de confirmação de amigo do BattleTag e do Real ID serão automaticamente recusadas.|n|nA ativação desta opção recusará automaticamente quaisquer solicitações pendentes."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Se marcado, os botões do quadro de bate-papo serão ocultados.|n|nClicar nas guias de bate-papo mostrará automaticamente as mensagens mais recentes.|n|nUse a roda do mouse para rolar pelo histórico de bate-papo. Mantenha pressionada a tecla Shift para pular a página ou Ctrl para pular para a parte superior ou inferior do histórico de bate-papo."
L["If checked, chat text will not fade out after a time period."] = "Se marcado, o texto do bate-papo não desaparecerá após um período de tempo."
L["If checked, class coloring will be used in the player frame and target frame."] = "Se marcada, a coloração da classe será usada no quadro do jogador e no quadro de alvo."
L["If checked, class colors will be used in the chat frame."] = "Se marcado, as cores da classe serão usadas no quadro de bate-papo."
L["If checked, class icons will be shown in the portrait frames."] = "Se marcado, os ícones de classe serão mostrados nos quadros de retrato."
L["If checked, completed quests will be turned-in automatically."] = "Se marcada, as missões concluídas serão entregues automaticamente."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Se marcado, as confirmações não aparecerão mais quando você escolher uma opção de saque ou tentar vender ou enviar um objeto comercializável."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Se marcado, os números de duração da recarga não serão mostrados sobre as recargas.|n|nSe desmarcada, os números de duração da recarga serão exibidos sobre as recargas, se estiverem ativados no painel de opções do jogo (menu 'Barras de ação')."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Se marcado, os números de dano e cura nos quadros de retrato do jogador e do ajudante serão ocultados."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Se marcado, arrastar a guia Geral enquanto o quadro estiver bloqueado expandirá o quadro para cima.|n|nSe o quadro de bate-papo estiver desbloqueado, arrastar a guia Geral do bate-papo moverá o quadro de bate-papo."
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "Se marcado, os solicitações de duelo serão bloqueados, a menos que o jogador que está solicitando o duelo esteja na sua lista de amigos ou guilda."
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "Se marcado, os sons de emote serão silenciados enquanto seu personagem estiver descansando ou no Glutão Implacável.|n|nOs sons de emoção serão ativados em todos os outros momentos."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Se marcado, as placas de nomes do inimigo serão mostradas durante o combate e ocultas quando o combate terminar."
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "Se marcado, os convites para grupos serão enviados apenas para amigos e membros da guilda.|n|nSe desmarcado, os convites para grupos serão enviados a todos."
L["If checked, guild names will be shown.  Guild ranks will also be shown for players in your guild."] = "Se marcado, os nomes das guildas serão mostrados. Os postos da guilda também serão mostradas para os jogadores da sua guilda."
L["If checked, helm and cloak toggle checkboxes will be shown in the character sheet.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "Se marcado, as caixas de seleção de elmo e capa serão mostradas na folha do personagem.|n|nVocê pode pressionar Shift e clicar com o botão direito do mouse nas caixas de seleção para mudar a disposição."
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "Se marcada, a maioria das mensagens de erro (como 'Não há raiva suficiente') não será exibida. Alguns erros importantes são excluídos.|n|nSe você tiver o botão minimapa ativado, mantenha pressionada a tecla Control e clique com o botão direito do mouse para alternar entre as mensagens de erro sem afetar essa configuração."
L["If checked, nude and tabard toggle buttons will be added to the dressup frame and model rotation controls will be removed."] = "Se marcado, os botões de alternância nu e tabardo serão adicionados ao quadro de provador e os controles de rotação do modelo serão removidos."
L["If checked, party invitations from friends or guild members will be automatically accepted."] = "Se marcado, convites para grupos de amigos ou membros da guilda serão automaticamente aceitos."
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "Se marcado, os convites para grupos serão bloqueados, a menos que o jogador que o convida esteja na sua lista de amigos ou guilda."
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting.|n|nRepeatable battlemaster and cloth quartermaster quests can be automatically selected by holding down the alt key."] = "Se marcada, as missões serão selecionadas, aceitas e entregues automaticamente.|n|nAs missões que têm um requisito de ouro não serão entregues automaticamente.|n|nVocê pode manter a tecla Shift pressionada ao conversar com um doador de missões para substituir essa configuração.|n|nMissões repetitivas de mestre de batalha e intendente de tecidos podem ser selecionadas automaticamente pressionando a tecla alt."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Se marcado, o bate-papo raide e o bate-papo da instância terão a cor azul (para corresponder à cor padrão do bate-papo de grupo)."
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat."] = "Se marcado, as solicitações de ressuscitação serão aceitas automaticamente, desde que o jogador que ressuscite você não esteja em combate."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = [=[Se marcado, os IDs de feitiço serão mostrados nas dicas de ferramentas dos ícones de buffs localizados no quadro de buff e abaixo do quadro de alvo.
]=]
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Se marcado, o bate-papo pegajoso será desativado.|n|nObserve que isso não se aplica a janelas de bate-papo temporárias."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Se marcado, os solicitações de evocação serão aceitos automaticamente, a menos que você esteja em combate."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Se marcada, a lista de addons (acessível no menu do jogo) mostrará addons baseados em personagens por padrão."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Se marcado, a quantidade de tempo que leva para saquear criaturas automaticamente será significativamente reduzida."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Se marcado, o botão de limpeza da mochila e o botão de limpeza do banco não serão mostrados."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Se marcado, o botão para alternar o quadro de contêiner de raide será mostrado logo acima do quadro de gerenciamento de raide (lado esquerdo da tela) em vez de no próprio quadro de gerenciamento de raide.|n|nIsso permite que você alterne o quadro de contêiner de raide, sem precisar abrir o quadro de gerenciamento de raide."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Se marcado, o registro de combate será oculto.|n|nO registro de combate deve estar ancorado para que esta opção funcione.|n|nSe o registro de combate estiver desencaixado, você poderá encaixá-lo arrastando a guia (e recarregando a interface do usuário) ou redefinindo as janelas de bate-papo (no menu de bate-papo)."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Se marcada, a caixa de edição será movida para a parte superior do quadro de bate-papo."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Se marcado, a tela cinza da morte e o efeito submundo serão desativados."
L["If checked, the main bar gryphons will not be shown."] = "Se marcado, os grifos da barra principal não serão mostrados."
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "Se marcado, o número de compartimentos de bolsa vazios será mostrado no ícone do botão da mochila e na dica de ferramenta."
L["If checked, the player frame background will be shown in class color."] = "Se marcado, o fundo do quadro do jogador será mostrado na cor da classe."
L["If checked, the professions frame will be larger."] = "Se marcado, o quadro de profissões será maior."
L["If checked, the quest log frame will be larger and feature a world map button and quest levels."] = [=[Se marcado, o quadro de registro de missões será maior e apresentará um botão de mapa do mundo e níveis de missões.

]=]
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Se marcado, o brilho da tela será desativado.|n|nA ativação dessa opção também desativará o efeito de neblina bêbado."
L["If checked, the skill trainer frame will be larger."] = "Se marcado, o quadro do instrutor de habilidades será maior."
L["If checked, the stance bar will not be shown."] = "Se marcada, a barra de postura não será mostrada."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Se marcado, o quadro de diálogo não será mostrado.|n|nO quadro de diálogo normalmente aparece na parte inferior da tela quando certos PNJs se comunicam com você."
L["If checked, the target frame background will be shown in class color."] = "Se marcado, o fundo do quadro de alvo será mostrado na cor da classe."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Se marcado, a dica de ferramenta será codificada por cores e você poderá modificar a disposição e a escala da dica de ferramenta."
L["If checked, the vendor price will be shown in item tooltips."] = "Se marcado, o preço do comerciante será mostrado nas dicas de ferramentas do objeto."
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "Se marcado, a barra de texto da zona ficará oculta. A dica do botão de rastreamento mostra as informações da zona."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Se marcado, os botões de zoom serão ocultados. Você pode usar o botão do mouse para aplicar zoom, independentemente desta configuração."
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "Se marcado, as dicas de ferramentas para unidades mundiais serão ocultadas durante o combate.|n|nVocê pode manter a tecla Shift pressionada para substituir essa configuração."
L["If checked, unit targets will be shown."] = "Se marcado, os alvos da unidade serão mostrados."
L["If checked, Wowhead links will be shown above the quest log frame."] = "Se marcado, os links Wowhead serão mostrados acima do quadro de registro de missões."
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip item.|n|nIf the gossip item type is banker, taxi, trainer or vendor, gossip will be skipped without needing to hold the alt key.  You can hold the shift key down to prevent this."] = "Se marcado, você pode manter pressionada a tecla alt enquanto abre uma janela de diálogo para selecionar automaticamente um único diálogo.|n|nSe o tipo de diálogo for banqueiro, táxi, instrutor ou comerciante, o diálogo será ignorado sem a necessidade de pressionar a tecla alt. Você pode manter a tecla Shift pressionada para evitar isso."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Se marcado, você pode manter pressionada a tecla Control e clicar em uma guia de bate-papo para exibir o bate-papo recente em uma janela de cópia amigável."
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "Se marcado, você pode abrir o Leatrix Plus pressionando Ctrl+Z."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Se marcado, você pode pressionar as teclas de flecha para mover o ponto de inserção para a esquerda e para a direita no quadro de bate-papo.|n|nSe desmarcado, as teclas de flecha usarão a configuração padrão de ligação de teclas."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Se marcado, você poderá cancelar o cinema sem ser solicitado a confirmar."
L["If checked, you will be able to change the font size of book text."] = "Se marcado, você poderá alterar o tamanho da fonte do texto do livro."
L["If checked, you will be able to change the font size of quest text."] = "Se marcado, você poderá alterar o tamanho da fonte do texto da missão."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Se marcado, você poderá alterar o tamanho da fonte do texto de correio padrão.|n|nIsso não afeta as mensagens criadas usando modelos (como faturas da casa de leilões)."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "Se marcado, você poderá alterar a posição e a escala do quadro de buffs."
L["If checked, you will be able to change the position and scale of the following frames:|n|n- Player frame|n- Target frame|n- Widget top center frame|n- Timer bar"] = "Se marcado, você poderá alterar a posição e a escala dos seguintes quadros:|n|n- Quadro do jogador|n- Quadro do alvo|n- Quadro central superior do widget|n- Barra do cronômetro"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Se marcado, você poderá criar uma porta de visualização. Uma porta de visualização adiciona bordas pretas ajustáveis ​​ao redor do mundo do jogo.|n|nAs bordas são colocadas no topo do mundo do jogo, mas sob a interface do usuário, para que você possa colocar elementos da interface do usuário sobre elas."
L["If checked, you will be able to customise the minimap."] = "Se marcado, você poderá personalizar o minimapa."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Se marcado, você poderá arrastar o quadro de bate-papo para a borda da tela."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Se marcado, você poderá colocar até cinco ícones de recarga benéficos acima do quadro de alvo."
L["If checked, you will be able to reposition the tooltip."] = "Se marcado, você poderá reposicionar a dica de ferramenta."
L["If checked, you will be able to set the density of weather effects."] = "Se marcado, você poderá definir a densidade dos efeitos climáticos."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Se marcado, você poderá mostrar uma cadeia rara, elite ou elite rara em torno do quadro do jogador."
L["If checked, you will be able to zoom out to a greater distance."] = "Se marcado, você poderá diminuir o zoom para uma distância maior."
L["If checked, you will need to hold the shift key down for quests to be automated.|n|nIf unchecked, holding shift will prevent quests from being automated."] = "Se marcado, você precisará manter a tecla Shift pressionada para que as missões sejam automatizadas.|n|nSe desmarcada, manter a tecla Shift impedirá que as missões sejam automatizadas."
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "Se marcado, você será liberado automaticamente após a morte em um campo de batalha.|n|nVocê não será liberado automaticamente se tiver a capacidade de ressuscitar automaticamente."
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = [=[Se marcada, suas bolsas não serão abertas ou fechadas automaticamente quando você interagir com um comerciante, banco ou caixa de correio.

]=]
L["If checked, your character will automatically stand or dismount when an action is prevented because you are either seated or mounted."] = "Se marcado, seu personagem irá automaticamente parar ou desmontar quando uma ação for impedida porque você está sentado ou montado."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = [=[Se marcado, seu histórico de bate-papo aumentará para 4096 linhas. Se desmarcado, o padrão será usado (128 linhas).|n|nA ativação dessa opção pode impedir a exibição de algum texto de bate-papo durante a conexão.

]=]
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Se marcado, seu equipamento será reparado automaticamente quando você visitar um comerciante adequado.|n|nVocê pode manter pressionada a tecla Shift ao conversar com um comerciante para substituir essa configuração."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Se marcado, o texto da zona não será exibido (por exemplo, 'Altaforja')."
L["Increase chat history"] = "Aumentar histórico"
L["Interface"] = "Interface"
L["Invaders of Alterac Valley"] = "Invasores do Vale Alterac"
L["Invalid console variable."] = "Variável de console inválida."
L["Invalid parameter."] = "Parâmetro inválido."
L["Invalid quest ID."] = "ID de missão inválido."
L["Invalid sound ID"] = "ID de som inválido"
L["Invalid taint level."] = "Nível de mancha inválido."
L["Invalid target."] = "Alvo inválido."
L["Invite from whispers"] = "Convidar de sussurros"
L["Kalimdor"] = "Kalimdor"
L["Keyword"] = "Palavra-chave"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "O Leatrix Plus não substituirá o LeaPlusDB na próxima desconexão."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: VERSÃO ERRADA INSTALADA!"
L["Left"] = "Esquerdo"
L["Lifetime honorable kills"] = "Jogadores abatidos honrosamente da vida inteira"
L["Loch Modan"] = "Loch Modan"
L["Lockout sharing"] = "Bloquear compartilhamento"
L["Low"] = "Baixo"
L["Magic"] = "Magia"
L["Main Titles"] = "Principais Títulos"
L["Manage buffs"] = "Gerenciar buffs"
L["Manage frames"] = "Gerenciar quadros"
L["Manage tooltip"] = "Dica de ferramenta"
L["Managed by Leatrix Plus"] = "Gerenciado por Leatrix Plus"
L["Map"] = "Mapa"
L["Maraudon"] = "Maraudon"
L["Max camera zoom"] = "Zoom máximo da câmera"
L["Mechanics"] = "Mecânico"
L["Media"] = "Mídia"
L["Medium"] = "Médio"
L["Memory Usage"] = "Uso de memória"
L["message shown."] = "mensagem mostrada."
L["messages shown."] = "mensagens mostradas."
L["Missing console variable."] = "Variável de console ausente."
L["Missing mount name."] = "Nome de montaria ausente."
L["Missing movie ID."] = "ID do filme ausente."
L["Missing quest ID."] = "ID da missão ausente."
L["Missing sound file parameter."] = "Parâmetro de arquivo de som ausente."
L["Missing sound ID."] = "ID de som ausente."
L["Molten Core"] = "Núcleo Derretido"
L["Moonglade"] = "Clareira da Lua"
L["Mount not found."] = "Montaria não encontrada."
L["Move editbox to top"] = "Caixa de edição"
L["Movie not playable."] = "Filme não reproduzível."
L["Movie number"] = "Número do filme"
L["Movies"] = "Filmes"
L["Mulgore"] = "Mulgore"
L["Music"] = "Música"
L["Musical Moments"] = "Momentos musicais"
L["Mystery"] = "Mistério"
L["Narration"] = "Narração"
L["Naxxramas"] = "Naxxramas"
L["No bad sound IDs found."] = "Nenhum ID de som ruim encontrado."
L["No help is available for this page."] = "Nenhuma ajuda está disponível para esta página."
L["No items with durability equipped."] = "Nenhum objeto com durabilidade equipada."
L["No media duplicates found."] = "Nenhuma duplicata de mídia encontrada."
L["No tooltip showing."] = "Nenhuma dica de ferramenta sendo exibida."
L["None"] = "Nenhum"
L["Not completed."] = "Não completo."
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "AVISO!|nVocê deve reiniciar completamente o cliente do jogo antes de poder usar esta versão do Leatrix Plus."
L["Nude"] = "Nu"
L["Onyxia's Lair"] = "Covil da Onyxia"
L["or click the minimap button to open Leatrix Plus."] = "ou clique no botão minimapa para abrir o Leatrix Maps."
L["Orgrimmar"] = "Orgrimmar"
L["Overall"] = "Total"
L["Overlay"] = "Sobreposição"
L["Particle density"] = "Densidade de partículas"
L["Party from friends"] = "Grupo de amigos"
L["Pet"] = "Ajudante"
L["Player"] = "Jogador"
L["Power"] = "Poder"
L["Press CTRL/C to copy."] = "Pressione Ctrl+C para copiar."
L["Queue from friends"] = "Fila de amigos"
L["R"] = "R"
L["Ragefire Chasm"] = "Cavernas Ígneas"
L["Raid"] = "Raide"
L["Raid frame toggle"] = "Quadro de raide"
L["Random"] = "Aleatório"
L["RARE"] = "RARO"
L["RARE ELITE"] = "ELITE RARO"
L["Razorfen Downs"] = "Urzal dos Mortos"
L["Razorfen Kraul"] = "Urzal dos Tuscos"
L["Recent chat window"] = "Bate-papo recente"
L["Redridge Mountains"] = "Montanhas Cristarrubra"
L["Release in PvP"] = "Libertar em JxJ"
L["Reload"] = "Recarregar"
L["Remember Alterac Valley!"] = "Lembrem-se do Vale Alterac!"
L["Repair automatically"] = "Reparar"
L["Repaired for"] = "Reparado para"
L["Reposition the tooltip"] = "Reposicionar a dica de ferramenta"
L["Require shift key for quest automation"] = "Requerer tecla Shift para automação de missões"
L["Requires UI reload."] = "Requer atualização da interface do usuário."
L["Reset"] = "Redefinir"
L["Resize book text"] = "Texto do livro"
L["Resize mail text"] = "Texto do correio"
L["Resize quest text"] = "Texto da missão"
L["Resize Screen"] = "Redimensionar tela"
L["Rested bubbles"] = "Bolhas descansadas"
L["Restrict to friends and guild members"] = "Restringir a amigos e membros da guilda"
L["result"] = "resultado"
L["results"] = "resultados"
L["Right"] = "Direito"
L["Right-click to close"] = "Clique com o botão direito para fechar"
L["Right-click to close."] = "Clique com o botão direito para fechar"
L["right-click to go back"] = "clique com o botão direito para voltar"
L["Ruins of Ahn'Qiraj"] = "Ruínas de Ahn'Qiraj"
L["Sacred"] = "Sagrado"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "As moedas Sanguescalpo, Rachacrânio e Zangareia"
L["Scale"] = "Escala"
L["Scarlet Monastery"] = "Monastério Escarlate"
L["Scholomance"] = "Scolomântia"
L["Search"] = "Procurar"
L["Searing Gorge"] = "Garganta Abrasadora"
L["Select the settings that you want to use."] = "Selecione as configurações que você deseja usar."
L["Selection of music tracks"] = "Seleção de faixas de música"
L["Self Markers Allowed"] = "Marcadores auto permitidos"
L["Self Markers Blocked"] = "Marcadores auto bloqueados"
L["Sell junk automatically"] = "Vender objetos pobres"
L["SELLING JUNK"] = "Vendendo objetos de pobre qualidade"
L["Set weather density"] = "Densidade do tempo"
L["Settings"] = "Configurações"
L["Shaders"] = "Shaders"
L["Shadowfang Keep"] = "Bastilha da Presa Negra"
L["Shardtooth E'ko"] = "E'ko de Dentilhaço"
L["Show auction controls"] = "Casa de leilões"
L["Show bag search box"] = "Pesquisa de bolsas"
L["Show character addons"] = "Addons do personagem"
L["Show cooldowns"] = "Recargas"
L["Show durability status"] = "Durabilidade"
L["Show free bag slots"] = "Compartimentos de bolsa vazios"
L["Show guild names"] = "Mostrar nomes de guilda"
L["Show minimap button"] = "Botão minimapa"
L["Show player chain"] = "Cadeia de jogador"
L["Show player frame in class color"] = "Mostrar quadro do jogador na cor da classe"
L["Show target frame in class color"] = "Mostrar quadro de alvo na cor da classe"
L["Show the spell ID in buff icon tooltips"] = "Mostrar o ID do feitiço nas dicas de ferramentas do ícone de buff"
L["Show unit targets"] = "Mostrar alvos de unidade"
L["Show vanity controls"] = "Personalizados"
L["Show vendor price"] = "Preço do comerciante"
L["Show volume slider"] = "Volume"
L["Show Wowhead links"] = "Links do Wowhead"
L["Silence rested emotes"] = "Silenciar emotes descansados"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Floresta de Pinhaprata"
L["Social"] = "Social"
L["Sold junk for"] = "Vendeu objetos de pobre qualidade por"
L["Sound system restarted."] = "Sistema de som reiniciado."
L["Spell ID"] = "ID do feitiço"
L["Spooky"] = "Assustador"
L["Stand and dismount"] = "Levante-se e desmonte"
L["Stockade"] = "O Cárcere"
L["Stonetalon Mountains"] = "Cordilheira das Torres de Pedra"
L["Stop"] = "Pare"
L["Stormwind"] = "Ventobravo"
L["Stranglethorn Vale"] = "Selva do Espinhaço"
L["Stratholme"] = "Stratholme"
L["Sunken Temple"] = "Templo Submerso"
L["Support"] = "Suporte"
L["Swamp"] = "Pântano"
L["Swamp of Sorrows"] = "Pântano das Mágoas"
L["System"] = "Sistema"
L["Tabard"] = "Tabardo"
L["Taint level: Basic (1)."] = "Nível de mancha: Básico (1)."
L["Taint level: Disabled (0)."] = "Nível de mancha: desativado (0)."
L["Taint level: Full (2)."] = "Nível de mancha: Completo (2)."
L["Tanaris"] = "Tanaris"
L["Target"] = "Alvo"
L["Target Tracking Disabled"] = "Rastreamento de alvo desativado"
L["Target Tracking Enabled"] = "Rastreamento de alvo ativado"
L["Teldrassil"] = "Teldrassil"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Ten Years of Warcraft"] = "Dez anos de Warcraft"
L["Text"] = "Texto"
L["Text size"] = "Tamanho do texto"
L["Text Size"] = "Tamanho do texto"
L["The summon from"] = "A evocação de"
L["Themes"] = "Temas"
L["This panel will close automatically if you enter combat."] = "Este painel será fechado automaticamente se você entrar em combate."
L["Thousand Needles"] = "Mil Agulhas"
L["Timer"] = "Cronômetro"
L["Tirisfal Glades"] = "Clareiras de Tirisfal"
L["To begin, choose an options page."] = "Para começar, escolha uma página de opções."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Para usar o botão Encontrar objeto, você precisa desmarcar a categoria WoW Token."
L["Tooltip"] = "Dica de ferramenta"
L["Tooltip title color"] = "Cor do título da dica de ferramenta"
L["Top"] = "Topo"
L["Top Center"] = "Topo central"
L["Tracing started."] = "Rastreamento iniciado."
L["Tracing stopped."] = "Rastreamento parou."
L["Transparency"] = "Transparência"
L["True"] = "Verdade"
L["Turn-in completed quests automatically"] = "Entregar missões concluídas automaticamente"
L["Uldaman"] = "Uldaman"
L["Unclamp chat frame"] = "Desatar quadro"
L["Undercity"] = "Cidade Baixa"
L["Un'Goro Crater"] = "Cratera Un'Goro"
L["Universal group color"] = "Cor do grupo universal"
L["Use arrow keys in chat"] = "Teclas de flecha"
L["Use class colors in chat"] = "Cores da classe"
L["Use easy resizing"] = "Redimensionamento"
L["Value must be a number."] = "O valor deve ser um número."
L["Various"] = "Vários"
L["Vendors"] = "Comerciantes"
L["Version"] = "Versão"
L["Very Low"] = "Muito baixo"
L["Video"] = "Vídeo"
L["Visibility"] = "Visibilidade"
L["Wailing Caverns"] = "Caverna Ululante"
L["was automatically declined."] = "foi recusado automaticamente."
L["Weather density"] = "Densidade do tempo"
L["Welcome to Leatrix Plus."] = "Bem-vindo ao Leatrix Plus."
L["Western Plaguelands"] = "Terras Pestilentas Ocidentais"
L["Westfall"] = "Cerro Oeste"
L["Wetlands"] = "Pantanal"
L["Widget"] = "Ferramenta"
L["Wildkin E'ko"] = "E'ko de coruscante"
L["will be automatically accepted in 10 seconds unless cancelled."] = "será aceito automaticamente em 10 segundos, a menos que seja cancelado."
L["Winter"] = "Inverno"
L["Winterfall E'ko"] = "E'ko de invernoso"
L["Winterspring"] = "Hibérnia"
L["World of Warcraft"] = "World of Warcraft"
L["X Offset"] = "Deslocamento X"
L["Y Offset"] = "Deslocamento Y"
L["YOU"] = "VOCÊ"
L["You cannot do that in combat."] = "Você não pode fazer isso em combate."
L["You have"] = "Você tem"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Sua interface do usuário precisa ser recarregada para que algumas alterações entrem em vigor.|n|nVocê não precisa clicar no botão recarregar imediatamente, mas precisa clicar nele quando concluir as alterações e desejar que as alterações entrem em vigor."
L["Your UI needs to be reloaded."] = "Sua interface do usuário precisa ser recarregada."
L["Zones"] = "Zonas"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"
L["Zulian, Razzashi, and Hakkari Coins"] = "As moedas Hakkari, Zulian e Razzashi"
L["Zygor addon not found."] = "Addon Zygor não encontrado."

end

-- deDE: German
if GameLocale == "deDE" then
L["+"] = "+"
L["A Donation of Mageweave"] = "Spendet Magiestoff"
L["A Donation of Runecloth"] = "Spendet Runenstoff"
L["A Donation of Silk"] = "Spendet Seide"
L["A Donation of Wool"] = "Spendet Wolle"
L["A friend request from"] = "Eine Freundschaftsanfrage von"
L["Accept resurrection"] = "Wiederbelebung annehmen"
L["Accept summon"] = "Beschwörung annehmen"
L["Additional Runecloth"] = "Noch mehr Runenstoff"
L["Addon"] = "Erweiterung"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alterac Mountains"] = "Alteracgebirge"
L["Anchor"] = "Anker"
L["Angelic"] = "Engels"
L["Arathi Highlands"] = "Arathihochland"
L["Ashenvale"] = "Ashenvale"
L["AutoFollow"] = "Automatisches verfolgen"
L["AutoFollow disabled."] = "Automatisches verfolgen ausgeschaltet."
L["Automate gossip"] = "Automatischer Verkauf von Müll"
L["Automate quests"] = "Automatische Questannahme"
L["Automation"] = "Auto"
L["Azshara"] = "Azshara"
L["Back to Main Menu"] = "Zurück zum Hauptmenü"
L["Bad ID"] = "Schlechte ID"
L["Badlands"] = "Ödland"
L["Barrens"] = "Brachland"
L["Battle"] = "Schlacht"
L["Battle of Warsong Gulch"] = "Schlacht der Warsongschlucht"
L["Battlegrounds"] = "Kampfgebiete"
L["Blackfathom Deeps"] = "Blackfathom-Tiefe"
L["Blackrock Depths"] = "Blackrocktiefen"
L["Blackwing Lair"] = "Pechschwingenhort"
L["Blasted Lands"] = "Verwüstete Lande"
L["Block duels"] = "Duelle blockieren"
L["Block friend requests"] = "Freundschaftsanfragen blockieren"
L["Block party invites"] = "Gruppeneinladungen blockieren"
L["Blocks"] = "Blocken"
L["Bottom"] = "Unterseite"
L["Buffs"] = "Buffs"
L["Burning Steppes"] = "Brennende Steppe"
L["C"] = "C"
L["Camera distance"] = "Kamera-Distanz"
L["Character"] = "Charakter"
L["Chat"] = "Chat"
L["Chillwind E'ko"] = "E'ko der Eiswindschimären"
L["Cinematics"] = "Film"
L["Claiming Arathi Basin"] = "Inbesitznahme des Arathibeckens"
L["Classic"] = "Classic"
L["click here for new selection"] = "für eine neue Auswahl hier klicken"
L["Click to reset the settings on this page."] = "Hier klicken um die Einstellungen dieser Seite zurückzusetzen."
L["Click to return to the main menu."] = "Hier klicken um zurück zum Hauptmenü zu gelangen."
L["Cloak"] = "Umhang"
L["Concerted Efforts"] = "Gemeinsames Bestreben"
L["Configuration Panel"] = "Einstellungen"
L["Conquering Arathi Basin"] = "Eroberung des Arathibeckens"
L["Credits"] = "Credits"
L["Cursor"] = "Cursor"
L["Cursor Left"] = "Cursor Links"
L["Cursor Right"] = "Cursor Rechts"
L["Customise minimap"] = "Minimap anpassen"
L["D"] = "D"
L["Darkmoon Faire"] = "Dunkelmond-Jahrmarkt"
L["Darkshore"] = "Die Dunkelküste"
L["Deadmines"] = "Todesminen"
L["Deadwind Pass"] = "Gebirgspass der Totenwinde"
L["Desolace"] = "Desolace"
L["Dire Maul"] = "Düsterbruch"
L["Disable bag automation"] = "Automatisches öffnen aller Taschen deaktivieren "
L["Disable chat fade"] = "Ausblenden des Chats deaktivieren"
L["Disable loot warnings"] = "Loot-Warnungen deaktivieren"
L["Disable screen effects"] = "Bildschirmeffekte deaktivieren"
L["Disable screen glow"] = "Aufleuchten des Bildschirms deaktivieren "
L["Dun Morogh"] = "Dun Morogh"
L["Dungeons"] = "Dungeons"
L["Dup ID"] = "Dup ID"
L["durability"] = "haltbarkeit"
L["Durability"] = "Haltbarkeit"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Dämmerwald"
L["Dustwallow Marsh"] = "Marschen von Dustwallow"
L["Eastern Kingdoms"] = "Östliche Königreiche"
L["Eastern Plaguelands"] = "Östliche Pestländer"
L["ELITE"] = "ELITE"
L["Elwynn Forest"] = "Wald von Elwynn"
L["Enable hotkey"] = "Hotkey aktivieren"
L["Enter"] = "Eingeben"
L["Error messages will be hidden"] = "Fehlermeldungen werden versteckt"
L["Error messages will be shown"] = "Fehlermeldungen werden angezeigt"
L["Events"] = "Veranstaltungen"
L["Extras"] = "Extras"
L["False"] = "Falsch"
L["Faster auto loot"] = "Schnelleres Auto looten"
L["Faster movie skip"] = "Schnelleres überspringen von Filmsequenzen"
L["Features"] = "Features"
L["Felwood"] = "Teufelswald"
L["Feralas"] = "Feralas"
L["Fight for Warsong Gulch"] = "Kampf um die Warsongschlucht"
L["Find Item"] = "Gegenstand finden"
L["For Great Honor"] = "Große Ehre"
L["Frostmaul E'ko"] = "E'ko der Frosthagelriesen"
L["Frostsaber E'ko"] = "E'ko der Frostsäbler"
L["Game Options"] = "Spieloptionen"
L["Ghost"] = "Geist"
L["Gloomy"] = "Düster"
L["Gnomeregan"] = "Gnomeregan"
L["Gold Only"] = "Ausschließlich Gold"
L["Graphics and Sound"] = "Grafik und Sound"
L["Groups"] = "Gruppen"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "Münzen der Gurubashi, Vilebranch und Witherbark"
L["H"] = "H"
L["Haunted"] = "Verfolgt"
L["Helm"] = "Helm"
L["Help"] = "Hilfe"
L["Hide chat buttons"] = "Chat-Buttons verstecken"
L["Hide cooldown duration numbers (if enabled)"] = "Nummern der Cooldown Anzeige verbergen (wenn aktiviert)"
L["Hide error messages"] = "Fehlermeldungen verstecken"
L["Hide portrait numbers"] = "Portraitnummern verbergen"
L["Hide the combat log"] = "Kampflog verstecken"
L["Hide the zoom buttons"] = "Zoom Buttons verbergen"
L["Hide zone text"] = "Gebietstext verbergen"
L["High"] = "Hoch"
L["Hillsbrad Foothills"] = "Vorgebirge des Hügellands"
L["Hinterlands"] = "Hinterlande"
L["Home"] = "Home"
L["Ice Thistle E'ko"] = "E'ko der Eisdistelyetis"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Wenn du einen passenden Händler aufsuchst wird deine Rüstung automatisch repariert, falls aktiviert.|n|nWenn, während der Händler angesprochen wird, die Shift Taste gedrückt gehalten wird, kann diese Einstellung überschrieben werden."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Gebietstext (z.B, 'Eisenschmiede') wird nicht angezeigt, falls ausgewählt."
L["Interface"] = "Interface"
L["Invaders of Alterac Valley"] = "Die Invasoren des Alteractals"
L["Invalid parameter."] = "Ungültiger Parameter."
L["Invalid quest ID."] = "Ungültige Quest ID."
L["Invalid sound ID"] = "Ungültige Sound ID"
L["Invalid target."] = "Ungültiges Ziel."
L["Invite from whispers"] = "Einladen via flüstern"
L["Kalimdor"] = "Kalimdor"
L["Keyword"] = "Stichwort"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Beim nächsten Logout wird LeaPlusDB nicht durch Leatrix Plus überschrieben."
L["Left"] = "Links"
L["Loch Modan"] = "Loch Modan"
L["Low"] = "Niedrige "
L["Magic"] = "Magie"
L["Main Titles"] = "Haupttitel"
L["Managed by Leatrix Plus"] = "Verwaltet durch Leatrix Plus"
L["Map"] = "Karte"
L["Maraudon"] = "Maraudon"
L["Max camera zoom"] = "Maximaler Kamera-Zoom"
L["Mechanics"] = "Mechaniken"
L["Media"] = "Medien"
L["Medium"] = "Mittel"
L["Memory Usage"] = "Speicherverbrauch"
L["message shown."] = "nachricht angezeigt."
L["messages shown."] = "angezeigte Nachrichten."
L["Missing mount name."] = "Fehlender Mountname."
L["Missing movie ID."] = "Fehlende Film ID."
L["Missing quest ID."] = "Fehlende Quest ID."
L["Missing sound ID."] = "Fehlende Sound ID."
L["Molten Core"] = "Geschmolzener Kern"
L["Moonglade"] = "Mondlichtung"
L["Mount not found."] = "Reittier nicht gefunden."
L["Movie not playable."] = "Film nicht abspielbar."
L["Movie number"] = "Filmnummer"
L["Movies"] = "Filme"
L["Mulgore"] = "Mulgore"
L["Music"] = "Musik"
L["Musical Moments"] = "Musikalische Momente"
L["Mystery"] = "Geheimnis"
L["Narration"] = "Erzählung"
L["Naxxramas"] = "Naxxramas"
L["None"] = "Keiner"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "WICHTIG|nDu musst deinen Spielclient komplett neu starten, bevor du diese Version von Leatrix Plus nutzen kannst."
L["Nude"] = "Nackt"
L["Onyxia's Lair"] = "Onyxias Hort"
L["Orgrimmar"] = "Orgrimmar"
L["Overall"] = "Insgesamt"
L["Overlay"] = "Überlagerung"
L["Pet"] = "Haustier"
L["Player"] = "Spieler"
L["Power"] = "Leistung"
L["Press CTRL/C to copy."] = "Zum kopieren STRG+C drücken."
L["R"] = "S"
L["Ragefire Chasm"] = "Der Flammenschlund"
L["Raid"] = "Schlachtzüge"
L["Random"] = "Zufällig"
L["Razorfen Downs"] = "Hügel der Klingenhauer"
L["Razorfen Kraul"] = "Kral der Klingenhauer"
L["Redridge Mountains"] = "Rotkammgebirge"
L["Release in PvP"] = "Geist im PvP freilassen"
L["Reload"] = "Neu laden"
L["Remember Alterac Valley!"] = "Vergesst das Alteractal nicht!"
L["Repair automatically"] = "Automatisch reparieren"
L["Repaired for"] = "Repariert für"
L["Requires UI reload."] = "Erfordert das neu laden des UI."
L["Reset"] = "Zurücksetzen"
L["result"] = "Ergebnis"
L["results"] = "Ergebnisse"
L["Right"] = "Rechts"
L["Right-click to close"] = "Rechtsklick zum schließen"
L["Right-click to close."] = "Rechtsklick zum schließen."
L["right-click to go back"] = "Rechtsklick um zurück zu gelangen"
L["Ruins of Ahn'Qiraj"] = "Die Ruinen von Ahn'Qiraj"
L["Sacred"] = "Heilig"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "Münzen der Sandfury, Skullsplitter und Bloodscalp"
L["Scale"] = "Rahmen"
L["Scarlet Monastery"] = "Das Scharlachrote Kloster"
L["Scholomance"] = "Scholomance"
L["Search"] = "Suche"
L["Searing Gorge"] = "Sengende Schlucht"
L["Settings"] = "Einstellungen"
L["Shaders"] = "Shaders"
L["Shadowfang Keep"] = "Burg Shadowfang"
L["Shardtooth E'ko"] = "E'ko eines Splitterzahns"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Silberwald"
L["Spell ID"] = "Zauber ID"
L["Spooky"] = "Gruslig"
L["Stockade"] = "Verlies"
L["Stonetalon Mountains"] = "Steinkrallengebirge"
L["Stop"] = "Stop"
L["Stormwind"] = "Sturmwind"
L["Stranglethorn Vale"] = "Schlingendorntal"
L["Stratholme"] = "Stratholme"
L["Sunken Temple"] = "Versunkener Tempel"
L["Support"] = "Support"
L["Swamp"] = "Sümpfe"
L["Swamp of Sorrows"] = "Sümpfe des Elends"
L["System"] = "System"
L["Tabard"] = "Wappenrock"
L["Tanaris"] = "Tanaris"
L["Target"] = "Ziel"
L["Teldrassil"] = "Teldrassil"
L["Temple of Ahn'Qiraj"] = "Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Der Tempel von Atal'Hakkar"
L["Text"] = "Text"
L["Text size"] = "Textgröße"
L["Text Size"] = "Textgröße"
L["Themes"] = "Themes"
L["Thousand Needles"] = "Tausend Nadeln"
L["Timer"] = "Timer"
L["Tirisfal Glades"] = "Tirisfal"
L["Top"] = "oben"
L["Top Center"] = "Oben in der Mitte"
L["Transparency"] = "Transparenz"
L["True"] = "Wahr"
L["Uldaman"] = "Uldaman"
L["Undercity"] = "Undercity"
L["Un'Goro Crater"] = "Un'Goro-Krater"
L["Value must be a number."] = "Wert muss eine Nummer sein."
L["Various"] = "Verschiedenes"
L["Vendors"] = "Anbieter"
L["Version"] = "Version"
L["Very Low"] = "Sehr Niedrig"
L["Video"] = "Video"
L["Visibility"] = "Sichtbarkeit"
L["Wailing Caverns"] = "Die Höhlen des Wehklagens"
L["Western Plaguelands"] = "Westliche Pestländer"
L["Westfall"] = "Westfall"
L["Wetlands"] = "Sumpfland"
L["Widget"] = "Widget"
L["Wildkin E'ko"] = "E'ko der Wildekin"
L["Winter"] = "Winter"
L["Winterfall E'ko"] = "E'ko der Winterfelle"
L["Winterspring"] = "Winterspring"
L["World of Warcraft"] = "World of Warcraft"
L["YOU"] = "DU"
L["You cannot do that in combat."] = "Dies kannst du in einem Kampf nicht tun."
L["You have"] = "Du hast"
L["Zones"] = "Gebiete"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"
L["Zulian, Razzashi, and Hakkari Coins"] = "Münzen der Razzashi, Hakkari und zulianische Münzen"
L["Zygor addon not found."] = "Das Addon Zygor wurde nicht gefunden."

end
