local _, parentAddonTable = ...
local addon = parentAddonTable.BugGrabber
-- Bail out in case we didn't load up for some reason, which
-- happens for example when an embedded BugGrabber finds a
-- standalone !BugGrabber addon.
if not addon then return end

-- We don't need to bail out here if BugGrabber has been loaded from
-- some other embedding addon already, because :LoadTranslations is
-- only invoked on login. All we do is replace the method with a new
-- one that will never be invoked.

function addon:LoadTranslations(locale, L)
	if locale == "koKR" then
L["%s is: %s."] = "%s|1은;는; %s입니다."
L["... including incomplete stacks"] = "... 최대 수량이 아닌 아이템 포함"
L["6.0"] = "6.0"
L["Add a dropdown menu to bags that allow to hide the sections."] = "가방에 항목을 숨길 수 있는 드롭다운 메뉴를 추가합니다."
L["Add association"] = "연결 추가"
L["Add more information in tooltips related to items in your bags."] = "가방의 아이템과 관련된 추가 정보를 툴팁에 표시합니다."
L["AdiBags Anchor"] = "AdiBags 고정기"
L["Adjust the maximum height of the bags, relative to screen size."] = "화면 크기에 맞춰 가방의 최대 높이를 조절합니다."
L["Adjust the width of the bag columns."] = "가방의 열 폭을 조절합니다."
L["AH category"] = "경매장 분류"
L["AH subcategory"] = "경매장 하위 분류"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "아이템의 분류 항목을 직접 지정합니다. 항목 이름 위에 아이템을 드래그하세요."
L["Alt-right-click to configure manual filtering."] = "Alt-오른쪽 클릭으로 수동 필터를 설정합니다."
L["Alt-right-click to configure the Junk module."] = "Alt-오른쪽 클릭으로 잡동사니 모듈을 설정합니다."
L["Alt-right-click to switch to anchored placement."] = "Alt-오른쪽 클릭하여 고정된 위치로 전환합니다."
L["Alt-right-click to switch to manual placement."] = "Alt-오른쪽 클릭하여 수동 위치로 전환합니다."
L["Always"] = "항상"
L["AMMO_TAG"] = "탄약"
L["Ammunition"] = "탄약류"
L["Anchored"] = "위치 고정시키기"
L["Are you sure you want to remove this section ?"] = "정말로 이 항목을 제거할까요?"
L["Assign %s to ..."] = "%s|1을;를; 할당합니다: "
L["At merchants', bank, auction house, ..."] = "상점, 은행, 경매장에서..."
L["auto-deposit"] = "자동 보관"
L["Automatically open the bags at merchant's, bank, ..."] = "상점과 은행 등을 사용할 때 자동으로 가방을 엽니다."
L["auto-sort"] = "자동 정렬"
L["Auto-sort can cause freeze when the bag is closed."] = "가방을 닫을 때 자동 정렬 기능이 오류를 발생시킬 수 있습니다."
L["Backpack"] = "소지품"
L["Backpack color"] = "소지품 색상"
L["Bag #%d"] = "가방 #%d"
L["Bag background"] = "가방 배경"
L["Bag number"] = "가방 번호"
L["Bag title"] = "가방 제목"
L["Bag type"] = "가방 유형"
L["Bag usage format"] = "가방 사용량 형식"
L["Bags"] = "가방"
L["Bank"] = "은행"
L["Bank bag #%d"] = "은행 가방 #%d"
L["Bank color"] = "은행 색상"
L["Bank Switcher"] = "은행 전환기"
L["Bind type"] = "귀속 유형"
L["Border"] = "테두리"
L["Border width"] = "테두리 너비"
L["By category, subcategory, quality and item level (default)"] = "분류, 하위 분류, 품질과 레벨 별(기본값)"
L["By name"] = "아이템 이름 별"
L["By quality and item level"] = "아이템 품질과 레벨 별"
L["Category"] = "분류"
L["Change stacking at merchants', auction house, bank, mailboxes or when trading."] = "상점, 은행, 경매장, 우편함 또는 거래 중일 때 아이템 수량을 변경합니다."
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "특별한 \"구성\" 항목으로 합칠 장비 구성을 선택하세요. 이 설정은 캐릭터 별로 저장됩니다."
L["Check this so armors are dispatched in four sections by type."] = "방어구를 유형에 따라 네가지 항목으로 분류합니다.(판금/사슬/가죽/천)"
L["Check this to display a bag type tag in the top left corner of items."] = "아이템의 좌측 상단 모서리에 가방 유형 태그를 표시합니다."
L["Check this to display a colored border around items, based on item quality."] = "아이템 테두리에 품질 색상을 표시합니다."
L["Check this to display an icon after usage of each type of bags."] = "각 유형의 가방 사용량 다음에 아이콘을 표시합니다."
L["Check this to display an indicator on quest items."] = "퀘스트 아이템의 테두리를 강조합니다."
L["Check this to display an textual tag before usage of each type of bags."] = "각 유형의 가방 사용량 앞에 문자 태그를 표시합니다."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "장비 구성을 하나의 개별 항목으로 표시합니다. 비활성하면 하나의 큰 \"장비 구성\" 항목으로 표시됩니다."
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "착용한 모든 가방을 유형을 무시하고 하나의 값으로 표시합니다."
L["Check this to have poor quality items dimmed."] = "하급 아이템을 흐릿하게 표시합니다."
L["Check this to show space at your bank in the plugin."] = "플러그인에 은행의 공간을 표시합니다."
L["Check this to show this section. Uncheck to hide it."] = "이 항목을 표시합니다. 해제하면 숨깁니다."
L["Check to disable error reporting."] = "오류 보고 기능을 사용하지 않습니다."
L["Check to enable this module."] = "이 모듈을 사용하려면 체크하세요."
L["Click on a item to remove it from the list. You can drop an item on the empty slot to add it to the list."] = "목록에서 제거할 아이템을 클릭하세요. 빈 칸에 아이템을 끌어다 놓으면 목록에 추가할 수 있습니다."
L["Click on this button to create the new association."] = "이 버튼을 클릭하면 새로운 연결을 만듭니다."
L["Click or drag this item to remove it."] = "이 아이템을 제거하려면 클릭하거나 드래그하세요."
L["Click there to reset the bag positions and sizes."] = "가방 위치와 크기를 초기화합니다."
L["Click to purchase"] = "구매하려면 클릭하세요"
L["Click to reset item status."] = "아이템 상태를 초기화합니다."
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "표시하거나 숨길 항목을 클릭하세요. 항목 표시 설정은 모든 가방에 적용됩니다."
L["Click to swap between %s and %s."] = "클릭하여 %s|1과;와; %s|1을;를; 전환합니다."
L["Click to toggle the bag anchor."] = "가방 위치 고정기를 표시 전환합니다."
L["Click to toggle the equipped bag panel, so you can change them."] = "가방을 변경할 수 있도록 착용 중인 가방 창을 표시 전환합니다."
L["Close"] = "닫기"
L["Color"] = "색상"
L["Color scheme"] = "색상화 방식"
L["Column width"] = "열 너비"
L["Configure"] = "설정"
L["Consider gems as a subcategory of trade goods"] = "보석을 직업 용품으로 간주합니다"
L["Consider glyphs as a subcategory of trade goods"] = "문양을 직업 용품으로 간주합니다"
L["Container information"] = "아이템 위치 정보"
L["COOKING_BAR_TAG"] = "요리"
L["Currencies to show"] = "표시할 화폐"
L["Currency"] = "화폐"
L["Dim junk"] = "잡동사니 흐릿하게"
L["disabled"] = "사용 안함"
L["Display a smaller money frame. This setting will take effect on next reload."] = "소지금 창을 작게 표시합니다. 이 설정은 UI를 다시 불러온 이후 적용됩니다."
L["Display character currency at bottom left of the backpack."] = "소지품의 좌측 하단에 캐릭터 화폐를 표시합니다."
L["Display character money at bottom right of the backpack."] = "소지품 우측 하단에 캐릭터 소지금을 표시합니다."
L["Display the level of equippable item in the top left corner of the button."] = "버튼의 좌측 상단 모서리에 장착 가능한 아이템의 레벨을 표시합니다."
L["Do not show anchor point"] = "고정 지점 표시 안함"
L["Do not show level of heirloom items."] = "계승품의 레벨을 표시하지 않습니다."
L["Do not show level of items that cannot be equipped."] = "장착할 수 없는 아이템의 레벨을 표시하지 않습니다."
L["Do not show level of poor quality items."] = "하급 아이템의 레벨을 표시하지 않습니다."
L["Do not show levels under this threshold."] = "이 설정값보다 낮은 레벨은 표시하지 않습니다."
L["Drag to move this bag."] = "이 가방을 움직이려면 드래그하세요."
L["Drop an item there to add it to the list."] = "목록에 추가하려면 아이템을 끌어다 놓으세요."
L["Drop your item there to add it to this section."] = "추가할 아이템을 이 항목에 끌어다 놓으세요."
L["Enabled"] = "사용"
L["enabled"] = "사용"
L["Enabled bags"] = "가방 적용"
L["ENCHANTING_BAG_TAG"] = "마부"
L["ENGINEERING_BAG_TAG"] = "기공"
L["Enter the name of the section to associate with the item."] = "아이템과 연결시킬 항목의 이름을 입력하세요."
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "항목과 연결시킬 아이템의 이름, 링크 또는 아이템id를 입력하세요. 아이템을 이 박스에 끌어다 놓을 수 있습니다."
L["Equipment"] = "착용 장비"
L["Equipped bags"] = "착용한 가방"
L["Error in %s: %s -- details: %s"] = "%s에서 오류: %s -- 상세 내용: %s"
L["Exclude list"] = "제외할 목록"
L["Filter"] = "필터"
L["Filtering information"] = "필터 정보"
L["Filters"] = "필터"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "필터는 가방 항목으로 아이템을 보내기 위해 사용됩니다. 하나의 항목에 하나의 아이템만 나타날 수 있습니다. 여러 필터에 동일한 아이템이 선택되면 우선 순위가 높은 항목에 표시됩니다."
L["Font"] = "글꼴"
L["Four general sections."] = "장비 유형별(무기/방어구/장신구/기타)"
L["Free space"] = "빈 공간"
L["Free space / total space"] = "빈 공간 / 전체 공간"
L["Gear manager item sets"] = "장비 관리 아이템 구성"
L["GEM_BAG_TAG"] = "보세"
L["Gems are trade goods"] = "보석을 직업 용품으로"
L["Glyphs are trade goods"] = "문양을 직업 용품으로"
L["HERB_BAG_TAG"] = "약초"
L["Hide the colored corner shown when you move the bag."] = "가방을 이동할 때 색상화된 모서리 표시를 숨깁니다."
L["Hide zeroes"] = "보유량 0 숨기기"
L["Highlight changes"] = "변경 사항 강조"
L["Highlight color"] = "강조 색상"
L["Highlight scale"] = "강조 크기 비율"
L["Highlight style"] = "강조 스타일"
L["Highlight what changes in bags with a little sparkle."] = "가방에 변경 사항이 있을 경우 해당 아이콘이 반짝입니다."
L["If the addon seems not to work properly, please re-enable error reporting and check again before filing a bug ticket."] = "애드온이 제대로 동작하지 않을 경우, 버그 티켓을 제출하기 전에 오류 보고 기능을 켜고 다시 확인해주세요."
L["Ignore currencies with null amounts."] = "보유량이 0인 화폐를 표시하지 않습니다."
L["Ignore heirloom items"] = "계승품 무시"
L["Ignore low quality items"] = "하급 아이템 무시"
L["Include list"] = "포함할 목록"
L["Included categories"] = "분류 포함"
L["INSCRIPTION_BAG_TAG"] = "주각"
L["Insets"] = "삽입"
L["Item"] = "아이템"
L["Item category"] = "아이템 분류"
L["Item information"] = "아이템 정보"
L["Item level"] = "아이템 레벨"
L["Items"] = "아이템"
L["Items in this list are always considered as junk. Click an item to remove it from the list."] = "이 목록의 아이템들은 항상 잡동사니로 간주됩니다. 아이템을 클릭하면 목록에서 제거합니다."
L["Items in this list are never considered as junk. Click an item to remove it from the list."] = "이 목록의 아이템들은 잡동사니로 간주하지 않습니다. 아이템을 클릭하면 목록에서 제거합니다."
L["Jewelry"] = "장신구"
L["Junk category"] = "잡동사니"
L["Keep all stacks together."] = "모든 수량을 함께 유지합니다."
L["KEYRING_TAG"] = "열쇠"
L["LDB Plugin"] = "LDB 플러그인"
L["LEATHERWORKING_BAG_TAG"] = "가세"
L["Legacy"] = "기존 스타일"
L["Let SyLevel handle the the display."] = "SyLevel이 표시를 조절하게 합니다."
L["Lock anchor"] = "위치 고정기 잠그기"
L["Low quality items"] = "하급 아이템"
L["Manual"] = "수동"
L["Manual filtering"] = "수동 필터"
L["Maximum bag height"] = "가방 최대 높이"
L["Maximum stack size"] = "최대 수량 크기"
L["Merge bag types"] = "가방 유형 병합"
L["Merge free space"] = "빈 칸 합치기"
L["Merge incomplete stacks with complete ones."] = "최대 수량이 아닌 아이템들을 합칩니다."
L["Merge stackable items"] = "겹칠 수 있는 아이템 합치기"
L["Merge unstackable items"] = "겹칠 수 없는 아이템 합치기"
L["Merged sets"] = "장비 구성 병합"
L["MINING_BAG_TAG"] = "채광"
L["Mininum level"] = "최소 레벨"
L["Money"] = "소지금"
L["Move items from and to the bank by right-clicking on section headers."] = "항목 이름을 오른쪽 클릭하면 아이템을 은행에 맡기거나 찾습니다."
L["Never"] = "표시하지 않음"
L["New"] = "새 아이템"
L["New Override"] = "새 아이템 추가"
L["New section"] = "새 항목"
L["No error reports"] = "오류 보고 없음"
L["None"] = "없음"
L["Nothing to sell."] = "판매할 물건이 없습니다."
L["One section per item slot."] = "착용 부위 별 하나의 항목."
L["One section per set"] = "장비 구성 당 하나의 항목"
L["Only equippable items"] = "착용 가능한 아이템만"
L["Only one section."] = "하나의 항목."
L["Opacity"] = "불투명도"
L["Open automatically"] = "자동으로 열기"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "이 필터는 모든 아이템에 적용됩니다. 이 필터보다 낮은 우선 순위를 가진 필터는 적용되지 않습니다."
L["Plugins"] = "플러그인"
L["Position mode"] = "위치 모드"
L["Press Alt while doing so to open a dropdown menu."] = "드롭다운 메뉴를 열려면 Alt키를 누르세요."
L["Priority"] = "우선 순위"
L["Provides a LDB data source to be displayed by LDB display addons."] = "LDB 표시 애드온에 표시될 LDB 데이터 소스를 제공합니다."
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "착용할 수 있는 모든 아이템(가방 포함)을 \"장비\" 항목으로 분류합니다."
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "하나 이상의 장비 관리 구성에 포함된 아이템을 특정 항목으로 분류합니다."
L["Put items in sections depending on their first-level category at the Auction House."] = "경매장의 1차 범주에 따라 아이템을 항목으로 분류합니다."
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "하급 아이템이나 잡동사니 아이템을 \"잡동사니\" 항목으로 분류합니다."
L["Put quest-related items in their own section."] = "퀘스트 관련 아이템을 항목으로 분류합니다."
L["Quality highlight"] = "아이템 품질 강조"
L["Quest indicator"] = "퀘스트 지시기"
L["Quest Items"] = "퀘스트 아이템"
L["QUIVER_TAG"] = "화살"
L["Recent Items"] = "최근 획득한 아이템"
L["Related to player level"] = "플레이어 레벨을 기준으로"
L["Remove"] = "제거"
L["Reset"] = "초기화"
L["Reset new items"] = "새 아이템 초기화"
L["Reset position"] = "위치 초기화"
L["Right-click to (un)lock the bag anchor."] = "오른쪽 클릭하여 가방 위치 고정기를 잠그거나 잠금해제합니다."
L["Right-click to configure."] = "오른쪽 클릭하여 설정합니다."
L["Right-click to move these items."] = "오른쪽 클릭으로 이 아이템들을 이동합니다."
L["Right-click to open options"] = "오른쪽 클릭으로 옵션 열기"
L["Right-click to sell these items."] = "오른쪽 클릭으로 이 아이템들을 판매합니다."
L["Right-click to toggle %s."] = "오른쪽 클릭으로 %s|1을;를; 토글합니다."
L["Right-click to try to empty this bag."] = "오른쪽 클릭으로 이 가방을 비웁니다."
L["Same as InventoryItemLevels"] = "캐릭터 창 아이템 레벨을 기준으로"
L["Scale"] = "크기 비율"
L["Section"] = "항목"
L["Section category"] = "항목 분류"
L["Section header"] = "항목 이름"
L["Section setup"] = "항목 설정"
L["Section visibility"] = "항목 표시"
L["Section visibility button"] = "항목 표시 버튼"
L["Select how bag usage should be formatted in the plugin."] = "플러그인에서 가방 사용량을 어떻게 형식화 할지 선택합니다."
L["Select how items should be sorted within each section."] = "각 항목 내에서 아이템을 정렬할 방법을 선택합니다."
L["Select how the bags are positionned."] = "가방의 위치 설정 방법을 선택합니다."
L["Select the category of the section to associate. This is used to group sections together."] = "연결시킬 항목의 분류를 선택하세요. 그룹 항목과 함께 사용됩니다."
L["Select the sections in which the items should be dispatched."] = "아이템이 분류될 항목을 선택하세요."
L["Select which bags AdiBags should display."] = "AdiBags가 표시할 가방을 선택하세요."
L["Select which first-level categories should be split by sub-categories."] = "하위 분류로 분리할 1차 분류를 선택하세요."
L["Separate incomplete stacks."] = "최대 수량이 아닌 아이템을 분리합니다."
L["Separate unstackable items."] = "겹칠 수 없는 아이템을 분리합니다."
L["Set: %s"] = "구성: %s"
L["Sets"] = "장비 구성"
L["Show %s"] = "%s 표시"
L["Show bag type icons"] = "가방 유형 아이콘 표시"
L["Show bag type tags"] = "가방 유형 태그 표시"
L["Show bank usage"] = "은행 사용량 표시"
L["Show container information..."] = "아이템의 위치 정보 표시..."
L["Show every distinct item stacks."] = "모든 아이템 수량을 별개로 표시합니다."
L["Show filtering information..."] = "필터 정보 표시..."
L["Show item information..."] = "아이템 정보 표시..."
L["Show only one free slot for each kind of bags."] = "가방의 종류에 따라 빈 공간을 하나로 표시합니다."
L["Show only one slot of items that can be stacked."] = "겹칠 수 있는 아이템을 하나의 칸에 표시합니다."
L["Show only one slot of items that cannot be stacked."] = "겹칠 수 없는 아이템을 하나의 칸에 표시합니다."
L["Size"] = "크기"
L["Skin"] = "스킨"
L["Slot number"] = "슬롯 번호"
L["Small"] = "작게"
L["Sort items by bind type."] = "귀속 유형에 따라 아이템을 정렬합니다."
L["Sorting order"] = "정렬 순서"
L["SOUL_BAG_TAG"] = "조각"
L["Space in use"] = "사용한 공간"
L["Space in use / total space"] = "사용한 공간 / 전체 공간"
L["Split armors by types"] = "유형 별 방어구 분리"
L["Split by subcategories"] = "하위 분류로 분리"
L["TACKLE_BOX_TAG"] = "낚시"
L["Text"] = "문자"
L["Texture"] = "텍스쳐"
L["Toggle and configure item filters."] = "아이템 필터를 설정하고 켜고 끕니다."
L["Toggle and configure plugins."] = "플러그인을 설정하고 켜고 끕니다."
L["Tooltip information"] = "툴팁 정보"
L["Track new items"] = "새 아이템 추적"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "각 가방에서 새로운 아이템을 추적합니다, 빛나는 오라가 주변에 표시되며 특별한 항목으로 분류합니다. \"새 아이템\" 상태는 가방의 좌측 상단에 있는 작은 \"N\" 버튼을 클릭하면 초기화됩니다."
L["Uncheck this to disable AdiBags."] = "해제하면 AdiBags를 사용하지 않습니다."
L["Unlock anchor"] = "위치 고정기 잠금 해제"
L["Use SyLevel"] = "SyLevel 사용"
L["Use this section to define any item-section association."] = "모든 아이템-항목 연결을 정의하는데 이 항목을 사용합니다."
L["Use this to adjust the bag scale."] = "가방 크기 비율을 조절합니다."
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "품질에 따른 테두리의 투명도를 조절합니다. 100%는 투명도를 적용하지 않습니다."
L["Virtual stack slots"] = "가상 겹치기 칸"
L["Virtual stacks"] = "가상으로 겹치기"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "가상으로 겹치기는 실제로 여러 가방 칸에 흩어져 있는 아이템들을 한 곳에 표시합니다."
L["When alt is held down"] = "Alt키를 누르고 있을 때"
L["When any modifier key is held down"] = "보조 키를 누르고 있을 때"
L["When checked, right-clicking on an empty space of a bag opens the configuration panel."] = "체크하면 가방의 빈 공간을 오른쪽 클릭으로 설정 창을 엽니다."
L["When ctrl is held down"] = "Ctrl키를 누르고 있을 때"
L["When shift is held down"] = "Shift키를 누르고 있을 때"
L["Which color scheme should be used to display the item level ?"] = "아이템 레벨에 어떤 색상화 방식을 사용할까요 ?"
L["You can block auto-deposit ponctually by pressing a modified key while talking to the banker."] = "은행원과 대화할 때 보조 키를 누르고 있으면 자동 보관 기능을 방지할 수 있습니다."

	elseif locale == "deDE" then
L["%s is: %s."] = "%s ist: %s."
L["... including incomplete stacks"] = "...einschliesslich unvollständiger Stapel"
L["6.0"] = "6.0"
L["Add a dropdown menu to bags that allow to hide the sections."] = "Fügt den Taschen ein Auswahlmenü hinzu, womit Bereiche versteckt werden können."
L["Add association"] = "Füge Zuweisung hinzu"
L["Add more information in tooltips related to items in your bags."] = "Fügt mehr Informationen bezüglich der Gegenstände in deinen Taschen zum Tooltip hinzu."
L["AdiBags Anchor"] = "AdiBags-Anker"
L["Adjust the maximum height of the bags, relative to screen size."] = "Passt die maximale Höhe der Taschen in Relation zur Monitorauflösung an."
L["Adjust the width of the bag columns."] = "Ändere die Breite der Taschenspalten."
L["AH category"] = "AH-Kategorie"
L["AH subcategory"] = "AH-Unterkategorie"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Erlaubt eine manuelle Festlegung des Bereiches, in dem ein Gegenstand abgelegt werden soll. Ziehe den Gegenstand einfach auf den betreffenden Bereichsnamen."
L["Alt-right-click to configure manual filtering."] = "Alt-Rechtsklick, um die manuelle Filterung einzustellen."
L["Alt-right-click to configure the Junk module."] = "Alt-Rechtsklick, um die Plunder-Einstellungen zu bearbeiten."
L["Alt-right-click to switch to anchored placement."] = "Alt-Rechtsklick schaltet zu verankerter Positionierung um."
L["Alt-right-click to switch to manual placement."] = "Alt-Rechtsklick schaltet zu manueller Positionierung um."
L["Always"] = "Immer"
L["AMMO_TAG"] = "Mu"
L["Ammunition"] = "Munition"
L["Anchored"] = "Verankert"
L["Are you sure you want to remove this section ?"] = "Bist Du sicher, dass Du diesen Bereich entfernen möchtest?"
L["Assign %s to ..."] = "Zuweisung von %s an ..."
L["At merchants', bank, auction house, ..."] = "Bei Händlern, in der Bank, im Auktionshaus, ..."
L["auto-deposit"] = "Automatisches Einlagern"
L["Automatically open the bags at merchant's, bank, ..."] = "Öffnet Taschen bei Händlern, in der Bank, usw. automatisch"
L["auto-sort"] = "Automatisches Sortieren"
L["Auto-sort can cause freeze when the bag is closed."] = "Das automatische Sortieren kann ein Einfrieren der Anzeige bewirken, wenn die Tasche geschlossen ist."
L["Backpack"] = "Rucksack"
L["Backpack color"] = "Rucksackfarbe"
L["Bag #%d"] = "Tasche #%d"
L["Bag background"] = "Taschenhintergrund"
L["Bag number"] = "Taschennummer"
L["Bag title"] = "Taschenname"
L["Bag type"] = "Taschenart"
L["Bag usage format"] = "Format der Taschennutzung"
L["Bags"] = "Taschen"
L["Bank"] = "Bank"
L["Bank bag #%d"] = "Banktasche #%d"
L["Bank color"] = "Bankfarbe"
L["Bank Switcher"] = "Banktransfer"
L["Bind type"] = "Art der Gegenstandsbindung"
L["Border"] = "Umrandung"
L["Border width"] = "Randdicke"
L["By category, subcategory, quality and item level (default)"] = "Nach Kategorie, Unterkategorie, Qualität und Gegenstandsstufe. (Standard)"
L["By name"] = "Nach Name"
L["By quality and item level"] = "Nach Qualität und Gegenstandsstufe"
L["Category"] = "Kategorie"
L["Change stacking at merchants', auction house, bank, mailboxes or when trading."] = "Ändere das Stapelverhalten bei Händlern, im Auktionshaus, in der Bank, beim Postfach oder beim Handeln."
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "Wähle diejenigen Sets aus, welche in einem individuellen Set-Bereich zusammengeführt werden sollen. Das ist eine Einstellung, die für jeden Charakter einzeln konfiguriert wird."
L["Check this so armors are dispatched in four sections by type."] = "Auswählen, um Rüstungen gemäß ihrer Art (Stoff, Leder, Kette, Platte) in vier Bereiche einzuteilen."
L["Check this to display a bag type tag in the top left corner of items."] = "Aktivieren, um die Taschenart in der oberen linken Ecke eines Gegenstandes anzuzeigen."
L["Check this to display a colored border around items, based on item quality."] = "Aktivieren, um einen nach Qualität gefärbten Rahmen um Gegenstände herum anzuzeigen."
L["Check this to display an icon after usage of each type of bags."] = "Aktivieren, um ein Symbol für die Taschenart nach der Auslastungsinformation anzuzeigen."
L["Check this to display an indicator on quest items."] = "Aktivieren, um Questgegenstände mit einem farbigen Rahmen hervorzuheben."
L["Check this to display an textual tag before usage of each type of bags."] = "Aktivieren, um für jede Taschenart die Kurzbezeichnung vor der Auslastung anzeigen zu lassen."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "Aktivieren, um einen individuellen Bereich für jedes Set anzuzeigen. Wenn diese Option nicht aktiviert ist, wird nur ein großer Sets- Bereich angezeigt."
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "Aktivieren, um nur einen Wert anzuzeigen, der alle Taschenplätze unabhängig von der Taschenart zählt."
L["Check this to have poor quality items dimmed."] = "Aktivieren, um Gegenstände mit geringer Qualität dunkler darzustellen."
L["Check this to show space at your bank in the plugin."] = "Aktivieren, um die Anzahl der freien Plätze in der Bank anzuzeigen."
L["Check this to show this section. Uncheck to hide it."] = "Auswählen, um diesen Bereich anzuzeigen; abwählen, um sie zu verbergen."
L["Check to disable error reporting."] = "Auswählen, um die Fehlerberichterstattung auszuschalten."
L["Check to enable this module."] = "Aktivieren, um dieses Modul zu nutzen."
L["Click on a item to remove it from the list. You can drop an item on the empty slot to add it to the list."] = "Klicke auf einen Gegenstand, um ihn aus der Liste zu entfernen. Platziere einen Gegenstand auf dem freien Platz, um ihn der Liste hinzuzufügen."
L["Click on this button to create the new association."] = "Klicke auf diesen Knopf, um eine neue Zuweisung zu erstellen."
L["Click or drag this item to remove it."] = "Klicke oder ziehe den Gegenstand, um ihn zu entfernen."
L["Click there to reset the bag positions and sizes."] = "Hier klicken, um die Taschenposition und -größe zurückzusetzen."
L["Click to purchase"] = "Klicken, um zu kaufen"
L["Click to reset item status."] = "Klicken, um den Gegenstandsstatus zurückzusetzen."
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "Anklicken, um festzulegen, welche Bereiche angezeigt werden sollen und welche nicht. Die Sichtbarkeit der Untergliederungen gilt für alle Taschen."
L["Click to swap between %s and %s."] = "Klicken, um zwischen %s und %s zu wechseln."
L["Click to toggle the bag anchor."] = "Klicken, um den Taschenanker anzuzeigen"
L["Click to toggle the equipped bag panel, so you can change them."] = "Klicken, um die Taschenleiste anzuzeigen, sodass die Behälter gewechselt oder belegt werden können."
L["Close"] = "Schließen"
L["Color"] = "Farbe"
L["Color scheme"] = "Farbschema"
L["Column width"] = "Spaltenbreite"
L["Configure"] = "Konfigurieren"
L["Consider gems as a subcategory of trade goods"] = "Edelsteine als Unterkategorie von Handelswaren betrachten"
L["Consider glyphs as a subcategory of trade goods"] = "Glyphen als Unterkategorie von Handelswaren betrachten"
L["Container information"] = "Behälterinformation"
L["COOKING_BAR_TAG"] = "Ko"
L["Currencies to show"] = "Zu zeigende Währungen"
L["Currency"] = "Währungen"
L["Dim junk"] = "Plunder-Gegenstände verblassen."
L["disabled"] = "deaktiviert"
L["Display a smaller money frame. This setting will take effect on next reload."] = "Zeigt einen kleineren Geldbereich. Diese Einstellung wird erst nach dem Neuladen des Interfaces wirksam."
L["Display character currency at bottom left of the backpack."] = "Zeigt die Währungen des Charakters rechts unten im Rucksack an."
L["Display character money at bottom right of the backpack."] = "Zeigt das Gold des Charakters rechts unten im Rucksack an"
L["Display the level of equippable item in the top left corner of the button."] = "Zeigt die Stufe von ausrüstbaren Gegenständen in der linken oberen Ecke an."
L["Do not show anchor point"] = "Den Ankerpunkt nicht anzeigen."
L["Do not show level of heirloom items."] = "Zeigt bei Erbstücken keine Gegenstandsstufe an."
L["Do not show level of items that cannot be equipped."] = "Zeigt die Stufe bei nicht anlegbaren Gegenständen nicht an."
L["Do not show level of poor quality items."] = "Zeigt die Gegenstandsstufe bei Gegenständen minderwertiger Qualität nicht an."
L["Do not show levels under this threshold."] = "Zeigt keine Gegenstandsstufen unter diesem Grenzwert an."
L["Drag to move this bag."] = "Ziehen, um diese Tasche zu bewegen."
L["Drop an item there to add it to the list."] = "Platziere einen Gegenstand hier, um in der Liste hinzuzufügen."
L["Drop your item there to add it to this section."] = "Gegenstand hier ablegen, um ihn diesem Bereich zuzuordnen."
L["Enabled"] = "Aktiviert"
L["enabled"] = "aktiviert"
L["Enabled bags"] = "Aktivierte Taschen"
L["ENCHANTING_BAG_TAG"] = "Vz"
L["ENGINEERING_BAG_TAG"] = "Ing"
L["Enter the name of the section to associate with the item."] = "Gib den Namen des Bereiches ein, der dem Gegenstand zugewiesen werden soll."
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "Gib den Namen, den Link oder die Gegenstand-ID des Gegenstandes ein, der dem Bereich zugewiesen werden soll. Du kannst auch einen Gegenstand in dieses Feld ziehen."
L["Equipment"] = "Ausrüstung"
L["Equipped bags"] = "Angelegte Taschen"
L["Error in %s: %s -- details: %s"] = "Fehler in %s: %s -- Details: %s"
L["Exclude list"] = "Ausschlussliste"
L["Filter"] = "Filter"
L["Filtering information"] = "Filterinformationen"
L["Filters"] = "Filter"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "Filter werden benutzt, um Gegenstände in Bereiche innerhalb der Tasche einzuordnen. Ein Gegenstand kann immer nur in einem Bereich auftauchen. Wenn für den Gegenstand mehrere Filter zutreffen, dann wird der Filter mit der höchsten Priorität verwendet."
L["Font"] = "Schriftart"
L["Four general sections."] = "Vier Hauptbereiche."
L["Free space"] = "Freier Platz"
L["Free space / total space"] = "freier Platz / gesamter Platz"
L["Gear manager item sets"] = "Ausrüstungsmanagersets"
L["GEM_BAG_TAG"] = "Ju"
L["Gems are trade goods"] = "Edelsteine sind Handelswaren"
L["Glyphs are trade goods"] = "Glyphen sind Handelswaren"
L["HERB_BAG_TAG"] = "Kr"
L["Hide the colored corner shown when you move the bag."] = "Versteckt die farbige Ecke, die beim Verschieben der Tasche angezeigt wird."
L["Hide zeroes"] = "Nullen verstecken"
L["Highlight changes"] = "Änderungen hervorheben"
L["Highlight color"] = "Farbe der Hervorhebung"
L["Highlight scale"] = "Hervorhebungsskalierung"
L["Highlight style"] = "Hervorhebungsstil"
L["Highlight what changes in bags with a little sparkle."] = "Hebt Änderungen in den Taschen mit einem kleinen Funkeln hervor."
L["If the addon seems not to work properly, please re-enable error reporting and check again before filing a bug ticket."] = "Falls das Addon nicht richtig zu funktionieren scheint, bitte aktiviere die Fehlerberichterstattung und überprüfe das Verhalten erneut, bevor du einen offiziellen Fehlerbericht erstellst."
L["Ignore currencies with null amounts."] = "Nicht vorhandene Währungen ignorieren"
L["Ignore heirloom items"] = "Erbstücke ignorieren"
L["Ignore low quality items"] = "Gegenstände von geringer Qualität ignorieren."
L["Include list"] = "Einschlussliste"
L["Included categories"] = "Enthaltene Kategorien"
L["INSCRIPTION_BAG_TAG"] = "Schr"
L["Insets"] = "Einrückung"
L["Item"] = "Gegenstand"
L["Item category"] = "Kategorie für Gegenstände"
L["Item information"] = "Gegenstandsinformation"
L["Item level"] = "Gegenstandsstufe"
L["Items"] = "Gegenstände"
L["Items in this list are always considered as junk. Click an item to remove it from the list."] = "Gegenstände in dieser Liste werden immer als Plunder behandelt. Klicke auf einen Gegenstand, um ihn aus der Liste zu entfernen."
L["Items in this list are never considered as junk. Click an item to remove it from the list."] = "Gegenstände in dieser Liste werden nie als Plunder behandelt. Klicke auf einen Gegenstand, um ihn aus der Liste zu entfernen."
L["Jewelry"] = "Schmuck"
L["Junk category"] = "Plunder-Kategorie"
L["Keep all stacks together."] = "Alle Stapel beibehalten"
L["KEYRING_TAG"] = "Schl"
L["LDB Plugin"] = "LDB-Plugin"
L["LEATHERWORKING_BAG_TAG"] = "Le"
L["Legacy"] = "Klassisch"
L["Let SyLevel handle the the display."] = "Überlasse SyLevel das Anzeigen."
L["Lock anchor"] = "Anker fixieren"
L["Low quality items"] = "Gegenstände niederer Qualität"
L["Manual"] = "Manuell"
L["Manual filtering"] = "Selbst einstellbare Filter"
L["Maximum bag height"] = "Maximale Taschenhöhe"
L["Maximum stack size"] = "Maximale Stapelgröße"
L["Merge bag types"] = "Taschenarten mischen"
L["Merge free space"] = "Freie Plätze vereinen."
L["Merge incomplete stacks with complete ones."] = "Vereint unvollständige mit vollständigen Stapeln."
L["Merge stackable items"] = "Stapelbare Gegenstände vereinen."
L["Merge unstackable items"] = "Unstapelbare Gegenstände vereinen."
L["Merged sets"] = "Sets zusammenführen"
L["MINING_BAG_TAG"] = "Bb"
L["Mininum level"] = "Mindeststufe"
L["Money"] = "Gold"
L["Move items from and to the bank by right-clicking on section headers."] = "Verschiebe Gegenstände durch Rechtsklick auf den Bereichsnamen von und zu der Bank."
L["Never"] = "Niemals"
L["New"] = "Neu"
L["New Override"] = "Neue Aufhebung"
L["New section"] = "Neuer Bereich"
L["No error reports"] = "Keine Fehlerberichte"
L["None"] = "Nichts"
L["Nothing to sell."] = "Nichts zu verkaufen."
L["One section per item slot."] = "Eine Bereich pro Gegenstandsplatz."
L["One section per set"] = "Ein Bereich pro Set"
L["Only equippable items"] = "Nur anlegbare Gegenstände"
L["Only one section."] = "Nur ein Bereich."
L["Opacity"] = "Deckkraft"
L["Open automatically"] = "Automatisches Öffnen"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "Bitte beachten: Dieser Filter betrifft jeden Gegenstand. Alle Filter mit niedriger Priorität als dieser werden keinen Effekt haben."
L["Plugins"] = "Plugins"
L["Position mode"] = "Positionsmodus"
L["Press Alt while doing so to open a dropdown menu."] = "Drücke gleichzeitig Alt, um ein Auswahlmenü zu öffnen."
L["Priority"] = "Priorität"
L["Provides a LDB data source to be displayed by LDB display addons."] = "Stellt eine LDB-Datenquelle zur Verfügung, welche von DataBroker-Addons angezeigt werden kann."
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "Ordnet jeden ausrüstbaren Gegenstand (inklusive Taschen) im Bereich \"Ausrüstung\" an."
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "Ordnet Gegenstände, die zu einem oder mehreren Sets des Ausrüstungsmanagers gehören, in dementsprechenden Bereichen an."
L["Put items in sections depending on their first-level category at the Auction House."] = "Ordnet Gegenstände basierend auf der Hauptkategorie des Auktionshauses in Bereiche ein."
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "Ordnet Gegenstände geringer Qualität oder als Plunder gekennzeichnete Gegenstände im Bereich \"Plunder\" an."
L["Put quest-related items in their own section."] = "Ordnet questbezogene Gegenstände in einem eigenen Bereich an."
L["Quality highlight"] = "Qualität hervorheben"
L["Quest indicator"] = "Questindikator"
L["Quest Items"] = "Questgegenstände"
L["QUIVER_TAG"] = "Kö"
L["Recent Items"] = "Kürzlich hinzugefügt"
L["Related to player level"] = "Nach der Spielerstufe"
L["Remove"] = "Entfernen"
L["Reset"] = "Zurücksetzen"
L["Reset new items"] = "Neue Gegenstände zurücksetzen"
L["Reset position"] = "Position zurücksetzen"
L["Right-click to (un)lock the bag anchor."] = "Rechtsklick, um den Taschenanker zu fixieren/entsperren."
L["Right-click to configure."] = "Rechtsklick, um zu konfigurieren."
L["Right-click to move these items."] = "Rechtsklick, um diese Gegenstände zu verschieben."
L["Right-click to open options"] = "Rechtsklick, um die Einstellungen zu öffnen"
L["Right-click to sell these items."] = "Rechtsklick, um diese Gegenstände zu verkaufen."
L["Right-click to toggle %s."] = "Rechtsklick, um %s umzuschalten."
L["Right-click to try to empty this bag."] = "Rechtsklick, um zu versuchen, diese Tasche zu leeren."
L["Same as InventoryItemLevels"] = "Selbe wie Inventar-Itemlevel"
L["Scale"] = "Skalierung"
L["Section"] = "Bereich"
L["Section category"] = "Bereichskategorie"
L["Section header"] = "Bereichsüberschrift"
L["Section setup"] = "Bereichskonfiguration"
L["Section visibility"] = "Sichtbarkeit der Bereiche"
L["Section visibility button"] = "Einstellbare Bereichssichtbarkeit"
L["Select how bag usage should be formatted in the plugin."] = "Wähle aus, wie die Taschennutzung im Plugin formatiert werden soll."
L["Select how items should be sorted within each section."] = "Wähle aus, wie die Gegenstände innerhalb eines Bereichs sortiert werden sollen."
L["Select how the bags are positionned."] = "Wähle, wie die Taschen positioniert werden."
L["Select the category of the section to associate. This is used to group sections together."] = "Wähle die Kategorie aus, die dem Bereich zugewiesen werden soll. Damit werden Bereiche miteinander gruppiert."
L["Select the sections in which the items should be dispatched."] = "Wähle die Aufteilung der Bereiche, in welche die Gegenstände abgelegt werden sollen."
L["Select which bags AdiBags should display."] = "Wähle, welche Taschen AdiBags darstellen soll."
L["Select which first-level categories should be split by sub-categories."] = "Wähle aus, welche Hauptkategorien in Unterkategorien aufgeteilt werden sollen."
L["Separate incomplete stacks."] = "Unvollständige Stapel trennen."
L["Separate unstackable items."] = "Unstapelbare Gegenstände trennen."
L["Set: %s"] = "Set: %s"
L["Sets"] = "Sets"
L["Show %s"] = "Zeige %s"
L["Show bag type icons"] = "Die Taschenart als Symbol anzeigen"
L["Show bag type tags"] = "Die Taschenart als Text anzeigen"
L["Show bank usage"] = "Die Bankauslastung anzeigen"
L["Show container information..."] = "Zeige Behälterinformation..."
L["Show every distinct item stacks."] = "Zeige jeden einzelnen Itemstapel"
L["Show filtering information..."] = "Zeige Filterinformationen..."
L["Show item information..."] = "Zeige Gegenstandsinformation..."
L["Show only one free slot for each kind of bags."] = "Zeigt nur einen freien Platz für jeden Taschentyp."
L["Show only one slot of items that can be stacked."] = "Zeigt stapelbare Gegenstände an nur einem Platz."
L["Show only one slot of items that cannot be stacked."] = "Zeigt nicht stapelbare Gegenstände an nur einem Platz."
L["Size"] = "Größe"
L["Skin"] = "Aussehen"
L["Slot number"] = "Platznummer"
L["Small"] = "Klein"
L["Sort items by bind type."] = "Sortiere Gegenstände nach der Art, wie/ob der Gegenstand gebunden wird."
L["Sorting order"] = "Sortierreihenfolge"
L["SOUL_BAG_TAG"] = "Se"
L["Space in use"] = "Belegte Plätze"
L["Space in use / total space"] = "Belegte Plätze / alle Plätze"
L["Split armors by types"] = "Rüstung gemäß ihrer Art aufteilen"
L["Split by subcategories"] = "Nach Unterkategorien aufteilen"
L["TACKLE_BOX_TAG"] = "Fi"
L["Text"] = "Text"
L["Texture"] = "Textur"
L["Toggle and configure item filters."] = "Gegenstandsfilter aktivieren und konfigurieren."
L["Toggle and configure plugins."] = "Plugins aktivieren und konfigurieren."
L["Tooltip information"] = "Tooltipinformation"
L["Track new items"] = "Neue Gegenstände beobachten"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "Markiert neue Gegenstände in jeder Tasche mit einer glühenden Aura und ordnet sie in einem spezielle Bereich an. Der Status \"Neu\" kann durch Klicken auf den kleinen Knopf \"N\" oben links im Taschenfenster zurückgesetzt werden."
L["Uncheck this to disable AdiBags."] = "Abwählen, um Adibags zu deaktivieren."
L["Unlock anchor"] = "Anker entsperren"
L["Use SyLevel"] = "SyLevel verwenden"
L["Use this section to define any item-section association."] = "Hier können beliebige Zuordnungen von Gegenständen und Bereichen definiert werden."
L["Use this to adjust the bag scale."] = "Skalierung der Taschen anpassen."
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "Deckkraft der Qualitätsumrandung der Gegenstände anpassen. 100% bedeutet volle Deckkraft."
L["Virtual stack slots"] = "Virtuelle Stapelplätze"
L["Virtual stacks"] = "Virtuelle Stapel"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "Virtuelle Stapel zeigen Gegenstände an einem Platz, die eigentlich in verschiedenen Taschen verteilt sind."
L["When alt is held down"] = "Wenn Alt gedrückt ist"
L["When any modifier key is held down"] = "Wenn irgendeine Modifikator-Taste gedrückt ist"
L["When checked, right-clicking on an empty space of a bag opens the configuration panel."] = "Auswählen, um die Einstellungen durch einen Rechtsklick auf einen leeren Bereich in den Taschen zu öffnen."
L["When ctrl is held down"] = "Wenn Strg gedrückt ist"
L["When shift is held down"] = "Wenn Umschalt gedrückt ist"
L["Which color scheme should be used to display the item level ?"] = "Welches Farbschema soll benutzt werden, um die Gegenstandsstufen anzuzeigen?"
L["You can block auto-deposit ponctually by pressing a modified key while talking to the banker."] = "Automatisches Einlagern kann durch gleichzeitiges Drücken einer Modifikator-Taste beim Öffnen der Bank unterdrückt werden."

	elseif locale == "esES" then
L["%s is: %s."] = "%s es: %s."
L["... including incomplete stacks"] = "... incluyendo montones incompletos."
L["6.0"] = "6.0"
L["Add a dropdown menu to bags that allow to hide the sections."] = "Añade un menú desplegable a las bolsas que te permite esconder las secciones."
L["Add association"] = "Añadir asociación"
L["Add more information in tooltips related to items in your bags."] = "Añade más información en la información del objeto relacionado con los objetos de tus bolsas."
L["Adjust the maximum height of the bags, relative to screen size."] = "Ajustar al maximo la altura de las bolsas, en relación a el tamaño de la pantalla."
L["Adjust the width of the bag columns."] = "Ajusta la anchura de las columnas de bolsas."
L["AH category"] = "Categoría AH"
L["AH subcategory"] = "Subcategoría AH"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Permite redefinir manualmente la sección en la que un objeto debe situarse. Solo arrastra un objeto dentro del título de la sección"
L["Always"] = "Siempre"
L["Ammunition"] = "Municion (not for 4.0)"
L["Bag #%d"] = "Bolsa #%d"
L["Bag number"] = "Número de bolsa"
L["Bag usage format"] = "Formato mal usado."
L["Bags"] = "Bolsas"
L["Bank bag #%d"] = "Bolsa de banco #%d"
L["By category, subcategory, quality and item level (default)"] = "Por categoria, subcategoria, calidad y nivel del objeto (por defecto)"
L["By name"] = "Por Nombre"
L["By quality and item level"] = "Por calidad y nivel del objeto"
L["Category"] = "Categoria"
L["Check this to display a colored border around items, based on item quality."] = "Señala esto para mostrar un borde coloreado alrededor de los objetos, basado solo en la calidad del objeto."
L["Check this to display an icon after usage of each type of bags."] = "Marque esto para mostrar un icono después de las bolsas según su uso."
L["Check this to display an indicator on quest items."] = "Marca esto para mostrar un indicador en los objetos de misión"
L["Check this to display an textual tag before usage of each type of bags."] = "Marca esto para mostrar una frase de texto antes de las bolsas según su uso."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "Marca esto para mostrar una sección por cada grupo. Si está desactivado, habra una gran sección de \"Grupos\""
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "Marca esto para mostrar un valor contando todas las bolsas equipadas, ignorando su tipo de uso."
L["Check this to show space at your bank in the plugin."] = "Marca esto para mostrar eel espacio en el banco en el Accesorio."
L["Check to enable this module."] = "Señala para habilitar este modulo."
L["Click on this button to create the new association."] = "Aprieta en este boton para crear una nueva asociación"
L["Click there to reset the bag positions and sizes."] = "Apretar aqui para borrar la posicion y tamaño de la bolsa."
L["Click to purchase"] = "Aprieta para comprar"
L["Click to reset item status."] = "Aprieta para borrar el estado de los objetos."
L["Click to toggle the bag anchor."] = "Aprieta para intercambiar el anclaje de la bolsa"
L["Click to toggle the equipped bag panel, so you can change them."] = "Aprieta para intercambiar el panel de la bolsa equipada, para poder cambiarlas."
L["Close"] = "Cerrar."
L["Configure"] = "Configurar"
L["Consider gems as a subcategory of trade goods"] = "Considerar gemas como subcategoria de objetos comerciables."
L["Consider glyphs as a subcategory of trade goods"] = "Considerar Glifos  como subcategoria de objetos comerciables."
L["Container information"] = "Informacion del contenerdor"
L["Display character money at bottom right of the backpack."] = "Muestra el dinero en el personaje abajo a la derecha de la mochila."
L["Drop your item there to add it to this section."] = "Suelta tu objeto aqui para añadirlo a esta sección."
L["Enabled"] = "Habilitado."
L["Enter the name of the section to associate with the item."] = "Escribe un nombre de sección para asociar con este objeto."
L["Equipment"] = "Equipado, Equipo."
L["Equipped bags"] = "Bolsas equipadas"
L["Filter"] = "filtro"
L["Filtering information"] = "Información filtrada"
L["Filters"] = "Filtros"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "Los filtros se usan para disponer artículos en las secciones bolsa."
L["Free space"] = "Espacio vacio"
L["Free space / total space"] = "Espacio vacio / espacio total"
L["Gear manager item sets"] = "Gestor de equipamiento conjuntos de objetos"
L["Gems are trade goods"] = "Las gemas son objetos comerciables."
L["Glyphs are trade goods"] = "Los Glifos  son objetos comerciables"
L["Highlight color"] = "Resaltar color"
L["Highlight scale"] = "resaltar la escala"
L["Item category"] = "Categoria del objeto"
L["Items"] = "Objetos"
L["LDB Plugin"] = "Load Data Base plugin   - Carga base datos accesorio"
L["Lock anchor"] = "Bloquear anclaje"
L["Manual filtering"] = "Filtro manual"
L["Merge bag types"] = "Combinar tipos de bolsas"
L["Merge incomplete stacks with complete ones."] = "Combinar montones incompletos con completos."
L["Merge stackable items"] = "Unir objetos apilables"
L["Money"] = "Dinero"
L["New"] = "Nuevo"
L["One section per set"] = "Una seccion por grupo"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "Por favor fijese que este filtro encuentra cada uno de los objetos, Cualquier filtro con menor prioridad que este no tendra efecto."
L["Plugins"] = "Accesorio, complemento."
L["Priority"] = "Prioridad"
L["Provides a LDB data source to be displayed by LDB display addons."] = "Proporciona una fuente de datos de Carga que se muestran en el panel del ayudante LDB.(loaddatabase)"
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "Ponga cualquier elemento que puede ser equipado (incluyendo las bolsas) en la sección \"equipo\" ."
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "Coloca los artículos pertenecientes a uno o más conjuntos del gestor de equipamiento en secciones específicas."
L["Put items in sections depending on their first-level category at the Auction House."] = "Coloca los artículos en las secciones en función de su primer nivel de categoría de la casa de subastas."
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "Coloca los artículos de mala calidad o etiquetados como basura en la sección \"basura\" ."
L["Put quest-related items in their own section."] = [=[Poner los objetos relacionados con misiones en su correspondiente seccion. 
( not quest section?)]=]
L["Quality highlight"] = "Resaltar calidad"
L["Quest indicator"] = "Señalador de misión"
L["Quest Items"] = "Objetos de misión"
L["Reset new items"] = "Recargar Obejtos nuevos"
L["Reset position"] = "Restablecer posición"
L["Right-click to try to empty this bag."] = "Boton derecho para intentar vaciar esta bolsa"
L["Scale"] = "escala."
L["Section visibility button"] = "Seccion de visibilidad del boton"
L["Select how bag usage should be formatted in the plugin."] = "Selecciona como el uso de la bolsa sera conformado en el accesorio."
L["Select how items should be sorted within each section."] = "Selecciona como se deben ordenar los objetos en cada sección."
L["Select which first-level categories should be split by sub-categories."] = "Selecciona que Categorias de primer nivel (encantameinto de objeto) deben separarse en subcategorias ( Encantamiento de objeto - permanente)"
L["Show only one free slot for each kind of bags."] = "Mostrar solo 1 hueco libre para cada tipo de bolsa"
L["Show only one slot of items that can be stacked."] = "Mostrar solo un ranura de objetos apilables."
L["Show only one slot of items that cannot be stacked."] = "Mostrar solo 1 ranura de objetos que no pueden apilarse"
L["Split by subcategories"] = "Dividir en subcategorias"
L["Toggle and configure item filters."] = "Intercambia y configura los filtros de objetos."
L["Toggle and configure plugins."] = "Intercambia y configura los accesorios."
L["Track new items"] = "Rastrea objetos nuevos"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "Rastrea objetos nuevos en cada bolsa, mostrando un aura brillante sobre ellos, y poniendolos en una sección especial.El estado  \"nuevos\" puede ser borrado en el pequeño boton \"N\" en el borde superior izquierdo de las bolsas."
L["Unlock anchor"] = "desbloquear anclaje - desanclar."
L["Use this to adjust the bag scale."] = "Usa esto para ajustar la escala de la bolsa."
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = [=[Usa esto para ajustar la opacidad del borde basado en la calidad. 100% significa opaco.
]=]

	elseif locale == "zhTW" then
L["%s is: %s."] = "%s 是: %s."
L["... including incomplete stacks"] = "... 包括不完整的堆疊"
L["6.0"] = "6.0"
L["Add a dropdown menu to bags that allow to hide the sections."] = "增加下拉式選單來隱藏類別"
L["Add association"] = "新增關聯"
L["Add more information in tooltips related to items in your bags."] = "顯示物品的額外資訊提示"
L["AdiBags Anchor"] = "AdiBags 錨點"
L["Adjust the maximum height of the bags, relative to screen size."] = "調整背包最大高度，相對於螢幕尺寸"
L["Adjust the width of the bag columns."] = "調整背包的欄寬。"
L["AH category"] = "拍賣場類別"
L["AH subcategory"] = "拍賣場子類別"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "允許以手動方式，將物品拖曳至區塊標題來分類物品"
L["Alt-right-click to configure manual filtering."] = "Alt-右鍵點擊以設定手動篩選。"
L["Alt-right-click to configure the Junk module."] = "Alt-右鍵點擊以設定垃圾模組。"
L["Alt-right-click to switch to anchored placement."] = "Alt-右鍵點擊以切換到錨定位置。"
L["Alt-right-click to switch to manual placement."] = "Alt-右鍵點擊以切換到手動位置。"
L["Always"] = "總是"
L["AMMO_TAG"] = "Am"
L["Ammunition"] = "彈藥"
L["Anchored"] = "錨點"
L["Are you sure you want to remove this section ?"] = "你確定要刪除本分類嗎？"
L["Assign %s to ..."] = "指定 %s 為 ..."
L["At merchants', bank, auction house, ..."] = "在商店、銀行、拍賣場等"
L["auto-deposit"] = "自動存放"
L["Automatically open the bags at merchant's, bank, ..."] = "與商人或銀行員等對話時，自動開啟背包。"
L["auto-sort"] = "自動排序"
L["Auto-sort can cause freeze when the bag is closed."] = "若當背包運行自動排序時突然被關閉，可能會導致所有背包介面凍結。"
L["Backpack"] = "背包"
L["Backpack color"] = "背包顏色"
L["Bag #%d"] = "背包 #%d"
L["Bag background"] = "背包背景"
L["Bag number"] = "背包數量"
L["Bag title"] = "背包標題"
L["Bag type"] = "背包類型"
L["Bag usage format"] = "背包運用格式"
L["Bags"] = "背包"
L["Bank"] = "銀行"
L["Bank bag #%d"] = "銀行背包 #%d"
L["Bank color"] = "銀行顏色"
L["Bank Switcher"] = "銀行切換"
L["Bind type"] = "綁定類型"
L["Border"] = "邊框"
L["Border width"] = "邊框寬度"
L["By category, subcategory, quality and item level (default)"] = "按類別, 子類別, 品質和物品等級(預設)"
L["By name"] = "按物品名稱"
L["By quality and item level"] = "按品質和物品等級"
L["Category"] = "種類"
L["Change stacking at merchants', auction house, bank, mailboxes or when trading."] = "商人，拍賣行，銀行，郵箱或交易時更改堆疊。"
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "勾選裝備設定將其合併成一個「套裝」類別。此項設定顯然為角色獨用。"
L["Check this so armors are dispatched in four sections by type."] = "護甲將按四大類型分組（布甲/皮甲/鎖甲/鎧甲）。"
L["Check this to display a bag type tag in the top left corner of items."] = "在物品左上角顯示背包標籤"
L["Check this to display a colored border around items, based on item quality."] = "依物品品質著色邊框"
L["Check this to display an icon after usage of each type of bags."] = "在每個背包運用類型後顯示圖示。"
L["Check this to display an indicator on quest items."] = "在任務物品上顯示指示。"
L["Check this to display an textual tag before usage of each type of bags."] = "在每個背包運用類型前顯示文字標記。"
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "依各個套裝獨立分組。若停用此選項，將會合併成一個大「套裝」分組。"
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "讓所有裝備背包顯示一個值，忽略其類型。"
L["Check this to have poor quality items dimmed."] = "黯淡品質為粗糙的物品"
L["Check this to show space at your bank in the plugin."] = "在銀行中顯示背包空間。"
L["Check this to show this section. Uncheck to hide it."] = "設定要顯示的類別"
L["Check to disable error reporting."] = "勾選以停用錯誤報告。"
L["Check to enable this module."] = "檢查以啟用模組。"
L["Click on a item to remove it from the list. You can drop an item on the empty slot to add it to the list."] = "點擊一個項目從列表中刪除它。也可拖放物品至空格以添加至列表。"
L["Click on this button to create the new association."] = "建立新的關聯"
L["Click or drag this item to remove it."] = "點擊或拖曳物品以移除。"
L["Click there to reset the bag positions and sizes."] = "點擊重置背包位置和尺寸。"
L["Click to purchase"] = "點擊購買"
L["Click to reset item status."] = "點擊重置物品狀態。"
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "設定要顯示或隱藏的類別"
L["Click to swap between %s and %s."] = "點擊以交換 %s 和 %s。"
L["Click to toggle the bag anchor."] = "點擊開啟或關閉背包錨點。"
L["Click to toggle the equipped bag panel, so you can change them."] = "點擊開啟或關閉已裝備背包面板, 用來修改他們。"
L["Close"] = "關閉"
L["Color"] = "顏色"
L["Color scheme"] = "顏色設定"
L["Column width"] = "欄寬"
L["Configure"] = "配置"
L["Consider gems as a subcategory of trade goods"] = "將寶石設定為商品的子類別"
L["Consider glyphs as a subcategory of trade goods"] = "將雕紋設定為商品的子類別"
L["Container information"] = "容器資訊"
L["COOKING_BAR_TAG"] = "食材"
L["Currencies to show"] = "通貨至顯示"
L["Currency"] = "貨幣"
L["Dim junk"] = "暗淡的垃圾"
L["disabled"] = "停用"
L["Display a smaller money frame. This setting will take effect on next reload."] = "顯示一個較小的金錢框架。此設置將在下次重載後生效。"
L["Display character currency at bottom left of the backpack."] = "與背爆左下角顯示角色通貨"
L["Display character money at bottom right of the backpack."] = "在背包右下方顯示玩家金錢。"
L["Display the level of equippable item in the top left corner of the button."] = "在可裝備物品的左上角顯示物品等級。"
L["Do not show anchor point"] = "不顯示錨點"
L["Do not show level of heirloom items."] = "不要顯示傳家寶的物品等級。"
L["Do not show level of items that cannot be equipped."] = "不要顯示無法裝備物品的等級。"
L["Do not show level of poor quality items."] = "不要顯示劣質物品的等級。"
L["Do not show levels under this threshold."] = "不要顯示此等級以下的物品。"
L["Drag to move this bag."] = "拖曳以移動這個袋子。"
L["Drop an item there to add it to the list."] = "拖放物品至此可添加至列表。"
L["Drop your item there to add it to this section."] = "拖放物品加入到類別。"
L["Enabled"] = "啟用"
L["enabled"] = "啟用"
L["Enabled bags"] = "啟用介面"
L["ENCHANTING_BAG_TAG"] = "附魔"
L["ENGINEERING_BAG_TAG"] = "工程"
L["Enter the name of the section to associate with the item."] = "輸入類別名稱來與物品建立關連"
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "輸入物品名稱、連結或物品ID，來與類別建立關連；也可以直接將物品拖曳至此處。"
L["Equipment"] = "裝備"
L["Equipped bags"] = "裝備背包"
L["Error in %s: %s -- details: %s"] = "%s錯誤：%s -- 細節：%s"
L["Exclude list"] = "排除列表"
L["Filter"] = "過濾"
L["Filtering information"] = "過濾資訊"
L["Filters"] = "篩選條件"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "篩檢條件是用來分類背包中的物品。一件物品只能被分類到一個類別。如果一項物品符合多個篩選條件，會以優先順序最高者為準。"
L["Font"] = "字型"
L["Four general sections."] = "裝備分為四大類(武器/護甲/飾品/其他)"
L["Free space"] = "可用空間"
L["Free space / total space"] = "空間/總空間"
L["Gear manager item sets"] = "裝備管理物品設定"
L["GEM_BAG_TAG"] = "寶石"
L["Gems are trade goods"] = "寶石是貿易商品"
L["Glyphs are trade goods"] = "雕紋是貿易商品"
L["HERB_BAG_TAG"] = "草藥"
L["Hide the colored corner shown when you move the bag."] = "當移動背包框架時隱藏在角落顯示的錨點色框。"
L["Hide zeroes"] = "隱藏零值"
L["Highlight changes"] = "突顯變動"
L["Highlight color"] = "高亮顏色"
L["Highlight scale"] = "高亮縮放"
L["Highlight style"] = "突顯方式"
L["Highlight what changes in bags with a little sparkle."] = "以閃光來突顯背包內的變動。"
L["If the addon seems not to work properly, please re-enable error reporting and check again before filing a bug ticket."] = "如果該插件似乎不能正常運作，在提交問題回報(bug ticket)前，請重新啟用錯誤報告(error reporting)來檢查。"
L["Ignore currencies with null amounts."] = "忽略數量為零的貨幣。"
L["Ignore heirloom items"] = "忽略傳家寶"
L["Ignore low quality items"] = "忽略低品質的物品"
L["Include list"] = "包含列表"
L["Included categories"] = "包含分類"
L["INSCRIPTION_BAG_TAG"] = "銘文"
L["Insets"] = "間距"
L["Item"] = "物品"
L["Item category"] = "物品類別"
L["Item information"] = "物品資訊"
L["Item level"] = "物品等級"
L["Items"] = "物品"
L["Items in this list are always considered as junk. Click an item to remove it from the list."] = "在此列表中的物品總是視為垃圾。可從列表中點擊要剔除的物品。"
L["Items in this list are never considered as junk. Click an item to remove it from the list."] = "在此列表中的物品不會視為垃圾。可從列表中點擊要剔除的物品。"
L["Jewelry"] = "飾品"
L["Junk category"] = "垃圾類別"
L["Keep all stacks together."] = "保持全部堆疊合起來。"
L["KEYRING_TAG"] = "Ke"
L["LDB Plugin"] = "LDB 插件"
L["LEATHERWORKING_BAG_TAG"] = "製皮"
L["Legacy"] = "傳承"
L["Let SyLevel handle the the display."] = "讓 SyLevel 處理顯示。"
L["Lock anchor"] = "鎖定錨點"
L["Low quality items"] = "劣質物品"
L["Manual"] = "手動"
L["Manual filtering"] = "手動過濾"
L["Maximum bag height"] = "最大高度的背包"
L["Maximum stack size"] = "最大的堆疊多少"
L["Merge bag types"] = "合併背包類型"
L["Merge free space"] = "合併空間"
L["Merge incomplete stacks with complete ones."] = "合併顯示完整與不完整推疊"
L["Merge stackable items"] = "合併可堆疊的物品"
L["Merge unstackable items"] = "合併未可堆疊的物品"
L["Merged sets"] = "合併設定"
L["MINING_BAG_TAG"] = "礦石"
L["Mininum level"] = "最低物品等級"
L["Money"] = "金錢"
L["Move items from and to the bank by right-clicking on section headers."] = "右鍵點擊類別標題，可將該類別物品存放到銀行，或由銀行中提取。"
L["Never"] = "從不"
L["New"] = "新物品"
L["New Override"] = "新覆蓋"
L["New section"] = "新分類"
L["No error reports"] = "沒有錯誤報告"
L["None"] = "無"
L["Nothing to sell."] = "不賣。"
L["One section per item slot."] = "依物品部位各自分類"
L["One section per set"] = "以一組裝備設定為一個分類"
L["Only equippable items"] = "只有可裝備的物品"
L["Only one section."] = "只分為一個類別"
L["Opacity"] = "透明度"
L["Open automatically"] = "自動開啟"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "請注意，此項篩選功能將適用全部物品，其他優先性較低的篩選設定將被覆蓋而無法生效。"
L["Plugins"] = "插件"
L["Position mode"] = "位置模式"
L["Press Alt while doing so to open a dropdown menu."] = "按下Alt鍵，而這樣做可以打開一個下拉菜單。"
L["Priority"] = "優先順序"
L["Provides a LDB data source to be displayed by LDB display addons."] = "提供LDB顯示插件的資料來源"
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "放置可裝備物品至「裝備」類別。"
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "按裝備管理設置的套裝類別放置物品。"
L["Put items in sections depending on their first-level category at the Auction House."] = "依拍賣場的「主類型」來分類物品。"
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "將劣質或垃圾物品分類為垃圾類別。"
L["Put quest-related items in their own section."] = "將任務相關物品分類為任務類別。"
L["Quality highlight"] = "品質高亮"
L["Quest indicator"] = "任務指示物"
L["Quest Items"] = "任務物品"
L["QUIVER_TAG"] = "Qu"
L["Recent Items"] = "新物品"
L["Related to player level"] = "相對於玩家等級"
L["Remove"] = "移除"
L["Reset"] = "重設"
L["Reset new items"] = "重設新物品"
L["Reset position"] = "重設位置"
L["Right-click to (un)lock the bag anchor."] = "右鍵點擊以鎖定/解鎖背包錨點。"
L["Right-click to configure."] = "右鍵點擊開啟選單"
L["Right-click to move these items."] = "右鍵點擊以移動這些物品。"
L["Right-click to open options"] = "右鍵點擊開啟選項"
L["Right-click to sell these items."] = "右鍵點擊以出售這些物品。"
L["Right-click to toggle %s."] = "右鍵點擊切換%s。"
L["Right-click to try to empty this bag."] = "右鍵點擊嘗試空白的背包。"
L["Same as InventoryItemLevels"] = "與 InventoryItemLevels 插件一樣"
L["Scale"] = "縮放"
L["Section"] = "類別"
L["Section category"] = "類別"
L["Section header"] = "類別標題"
L["Section setup"] = "類別設定"
L["Section visibility"] = "類別顯示"
L["Section visibility button"] = "類別顯示按鈕"
L["Select how bag usage should be formatted in the plugin."] = "選擇背包使用狀況格式"
L["Select how items should be sorted within each section."] = "設定各類別中物品的排序方式。"
L["Select how the bags are positionned."] = "選擇背包該如何決定位置"
L["Select the category of the section to associate. This is used to group sections together."] = "選擇分類相關聯的分組。這是用來組合類別的分組。"
L["Select the sections in which the items should be dispatched."] = "選擇物品分組的類別"
L["Select which bags AdiBags should display."] = "選擇哪種背包要使用 AdiBags 介面"
L["Select which first-level categories should be split by sub-categories."] = "勾選將此類型再細分為子類型"
L["Separate incomplete stacks."] = "分開不完整的堆疊。"
L["Separate unstackable items."] = "分開未可堆疊的物品。"
L["Set: %s"] = "換裝設定: %s"
L["Sets"] = "裝備設定"
L["Show %s"] = "顯示 %s"
L["Show bag type icons"] = "顯示背包類型圖示"
L["Show bag type tags"] = "顯示背包類型標籤"
L["Show bank usage"] = "顯示銀行使用"
L["Show container information..."] = "顯示容器資訊"
L["Show every distinct item stacks."] = "顯示每個不同的物品堆疊。"
L["Show filtering information..."] = "顯示過濾資訊..."
L["Show item information..."] = "顯示物品資訊"
L["Show only one free slot for each kind of bags."] = "將各個背袋的可用格數合併為一格顯示。"
L["Show only one slot of items that can be stacked."] = "可堆疊物品合併顯示於一格"
L["Show only one slot of items that cannot be stacked."] = "將不可堆疊物品也集中顯示"
L["Size"] = "大小"
L["Skin"] = "皮膚"
L["Slot number"] = "槽數"
L["Small"] = "小型"
L["Sort items by bind type."] = "依綁定類型排序。"
L["Sorting order"] = "排序"
L["SOUL_BAG_TAG"] = "靈魂"
L["Space in use"] = "空間使用"
L["Space in use / total space"] = "空間使用/總空間"
L["Split armors by types"] = "根據武器種類進行分類"
L["Split by subcategories"] = "子類別的分離"
L["TACKLE_BOX_TAG"] = "釣魚"
L["Text"] = "文字"
L["Texture"] = "材質"
L["Toggle and configure item filters."] = "切換和配置物品過濾。"
L["Toggle and configure plugins."] = "切換和配置插件。"
L["Tooltip information"] = "提示資訊"
L["Track new items"] = "追蹤新物品"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "追蹤新進物品，在新物品上顯示光環並分類至一個特殊的「新物品」分類。點擊右上角的「N」按鈕可還原新進物品至一般分類。"
L["Uncheck this to disable AdiBags."] = "不選此停用AdiBags。"
L["Unlock anchor"] = "解鎖錨點"
L["Use SyLevel"] = "使用SyLevel"
L["Use this section to define any item-section association."] = "使用此類別定義任意物品分組過濾"
L["Use this to adjust the bag scale."] = "調整包包大小"
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "調整品質邊框透明度 100%=完全不透明"
L["Virtual stack slots"] = "虛擬堆疊插槽"
L["Virtual stacks"] = "虛擬堆疊"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "將散落於各背包內的同一物品以虛擬堆疊顯示"
L["When alt is held down"] = "當 alt 按住"
L["When any modifier key is held down"] = "當任何修改鍵按住"
L["When checked, right-clicking on an empty space of a bag opens the configuration panel."] = "勾選時，可在背包的空白處點擊右鍵，以打開設定選單。"
L["When ctrl is held down"] = "當 ctrl 按住"
L["When shift is held down"] = "當 shift 按住"
L["Which color scheme should be used to display the item level ?"] = "應該使用哪種顏色設定顯示物品等級?"
L["You can block auto-deposit ponctually by pressing a modified key while talking to the banker."] = "在與銀行職員對話的同時按住『輔助按鍵』，可避免自動存放功能。"

	elseif locale == "zhCN" then
L["%s is: %s."] = "%s 是: %s。"
L["... including incomplete stacks"] = "包含不完整堆叠"
L["6.0"] = "6.0"
L["Add a dropdown menu to bags that allow to hide the sections."] = "给背包添加下拉菜单, 允许隐藏分组."
L["Add association"] = "添加过滤"
L["Add more information in tooltips related to items in your bags."] = "显示物品的额外提示信息"
L["AdiBags Anchor"] = "AdiBags 锚点"
L["Adjust the maximum height of the bags, relative to screen size."] = "调整背包最大高度 (相对于屏幕)"
L["Adjust the width of the bag columns."] = "调整背包的栏宽。"
L["AH category"] = "拍卖类"
L["AH subcategory"] = "拍卖子类"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "允许以将物品拖曳至区块标题的方式来分类物品。"
L["Alt-right-click to configure manual filtering."] = "按住Alt键单击鼠标右键 配置手动筛选。"
L["Alt-right-click to configure the Junk module."] = "按住Alt键单击鼠标右键配置垃圾模块。"
L["Alt-right-click to switch to anchored placement."] = "按住Alt键单击鼠标右键切换到锚定位置。"
L["Alt-right-click to switch to manual placement."] = "按住Alt键单击鼠标右键切换到手动放置。"
L["Always"] = "总是"
L["AMMO_TAG"] = "弹"
L["Ammunition"] = "弹药"
L["Anchored"] = "锚点"
L["Are you sure you want to remove this section ?"] = "确定移除此过滤 ?"
L["Assign %s to ..."] = "指定 %s 到 …"
L["At merchants', bank, auction house, ..."] = "在商人，银行，拍卖场等…"
L["auto-deposit"] = "自动存放 "
L["Automatically open the bags at merchant's, bank, ..."] = "在商人、银行等处自动打开背包 "
L["auto-sort"] = "自动排序 "
L["Auto-sort can cause freeze when the bag is closed."] = "若当背包运行自动排序时突然被关闭，可能会导致所有背包介面冻结。"
L["Backpack"] = "背包"
L["Backpack color"] = "背包颜色"
L["Bag #%d"] = "背包 #%d"
L["Bag background"] = "背包背景"
L["Bag number"] = "背包号"
L["Bag title"] = "背包标题"
L["Bag type"] = "背包类型"
L["Bag usage format"] = "背包使用格式"
L["Bags"] = "背包"
L["Bank"] = "银行"
L["Bank bag #%d"] = "银行包 #%d"
L["Bank color"] = "银行颜色"
L["Bank Switcher"] = "银行切换"
L["Bind type"] = "绑定类型"
L["Border"] = "边框"
L["Border width"] = "边框宽度"
L["By category, subcategory, quality and item level (default)"] = "按类别, 子类别, 品质和物品等级(默认)"
L["By name"] = "按名称"
L["By quality and item level"] = "按品质和物品等级"
L["Category"] = "分类"
L["Change stacking at merchants', auction house, bank, mailboxes or when trading."] = "在交易, 拍卖, 银行, 邮局以及实施商业技能时更改堆叠效果."
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "根据套装分组物品, 此项根据每个角色设置有所不同."
L["Check this so armors are dispatched in four sections by type."] = "护甲将按四大类型分组 (布甲/皮甲/锁甲/板甲)."
L["Check this to display a bag type tag in the top left corner of items."] = "在物品左上角显示标签, 标示其放置的特殊背包类型."
L["Check this to display a colored border around items, based on item quality."] = "按物品品质着色边框."
L["Check this to display an icon after usage of each type of bags."] = "在每个类型背包使用后显示一个图标."
L["Check this to display an indicator on quest items."] = "标示任务物品."
L["Check this to display an textual tag before usage of each type of bags."] = "在每个类型背包前显示文本标记."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "每个套装独立分组, 禁用此选项, 将会合并成一个大[套装]分组"
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "选中来让所有装备包显示一个值，忽略类型。"
L["Check this to have poor quality items dimmed."] = "将低品质物品变暗"
L["Check this to show space at your bank in the plugin."] = "在银行中显示背包空间"
L["Check this to show this section. Uncheck to hide it."] = "勾选则显示此分组, 不勾选则隐藏."
L["Check to disable error reporting."] = "点选以禁用错误报告 "
L["Check to enable this module."] = "启用此模块"
L["Click on a item to remove it from the list. You can drop an item on the empty slot to add it to the list."] = "点击物品可从列表中移除. 也可拖放物品至空栏以添加至列表."
L["Click on this button to create the new association."] = "创建一个新过滤"
L["Click or drag this item to remove it."] = "点击或拖出物品可移除."
L["Click there to reset the bag positions and sizes."] = "重置背包位置和尺寸"
L["Click to purchase"] = "购买"
L["Click to reset item status."] = "重置物品状态."
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "设置显示/隐藏物品分组, 默认全部显示."
L["Click to swap between %s and %s."] = "点击以切换%s 和 %s。 "
L["Click to toggle the bag anchor."] = "切换背包锚点"
L["Click to toggle the equipped bag panel, so you can change them."] = "点击切换背包面板, 用于更换背包."
L["Close"] = "关闭"
L["Color"] = "颜色"
L["Color scheme"] = "颜色设定 "
L["Column width"] = "栏宽 "
L["Configure"] = "配置"
L["Consider gems as a subcategory of trade goods"] = "将珠宝设定为商品子类"
L["Consider glyphs as a subcategory of trade goods"] = "将雕文设定为商品子类"
L["Container information"] = "容器信息"
L["COOKING_BAR_TAG"] = "食材 "
L["Currencies to show"] = "货币显示"
L["Currency"] = "货币"
L["Dim junk"] = "灰色垃圾"
L["disabled"] = "停用 "
L["Display a smaller money frame. This setting will take effect on next reload."] = "显示一个较小的货币框体。此项设定将在重载界面后生效。"
L["Display character currency at bottom left of the backpack."] = "在背包底部左侧显示角色拥有的货币."
L["Display character money at bottom right of the backpack."] = "在背包底部右侧显示金钱"
L["Display the level of equippable item in the top left corner of the button."] = "在按钮的左上角显示可装备物品的物品等级。"
L["Do not show anchor point"] = "不要显示锚点 "
L["Do not show level of heirloom items."] = "不要显示传家宝的物品等级。"
L["Do not show level of items that cannot be equipped."] = "不要显示无法装备的物品的物品等级。"
L["Do not show level of poor quality items."] = "不要显示质量差的物品的物品等级。"
L["Do not show levels under this threshold."] = "不要显示低于此阈值的物品的物品等级。"
L["Drag to move this bag."] = "拖动以移动这个袋子。"
L["Drop an item there to add it to the list."] = "拖放物品至此可添加至列表."
L["Drop your item there to add it to this section."] = "拖曳物品到此分组."
L["Enabled"] = "启用"
L["enabled"] = "启用"
L["Enabled bags"] = "(启用/关闭)袋UI界面"
L["ENCHANTING_BAG_TAG"] = "附魔"
L["ENGINEERING_BAG_TAG"] = "工"
L["Enter the name of the section to associate with the item."] = "输入分组名称以建立过滤"
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "输入物品名称, 链接或物品 ID 到此分组, 也可以拖曳物品至此."
L["Equipment"] = "装备"
L["Equipped bags"] = "已装备背包"
L["Error in %s: %s -- details: %s"] = "错误出现于%s：%s --详情：%s"
L["Exclude list"] = "排除列表"
L["Filter"] = "过滤"
L["Filtering information"] = "过滤信息"
L["Filters"] = "过滤器"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "过滤器将用于背包分类中调度物品, 一件物品仅可在一个分类中显示. 如果在多个过滤器中选中相同的物品, 将使用最高优先级."
L["Font"] = "字型"
L["Four general sections."] = "按护甲类型分组"
L["Free space"] = "空闲空间"
L["Free space / total space"] = "空闲 / 总空间"
L["Gear manager item sets"] = "套装管理"
L["GEM_BAG_TAG"] = "宝"
L["Gems are trade goods"] = "宝石是商品"
L["Glyphs are trade goods"] = "铭文是商品"
L["HERB_BAG_TAG"] = "草"
L["Hide the colored corner shown when you move the bag."] = "当移动背包时隐藏边框着色。 "
L["Hide zeroes"] = "隐藏零"
L["Highlight changes"] = "高亮变动"
L["Highlight color"] = "高亮颜色"
L["Highlight scale"] = "高亮缩放"
L["Highlight style"] = "高亮方式"
L["Highlight what changes in bags with a little sparkle."] = "高亮显示背包内的变动。"
L["If the addon seems not to work properly, please re-enable error reporting and check again before filing a bug ticket."] = "如果插件看上去不能正常工作，请在向作者提交报告之前启用错误报告并检查一次。"
L["Ignore currencies with null amounts."] = "忽略数量无效的货币。"
L["Ignore heirloom items"] = "忽略传家宝 "
L["Ignore low quality items"] = "忽略劣质物品 "
L["Include list"] = "包含列表"
L["Included categories"] = "包含过滤"
L["INSCRIPTION_BAG_TAG"] = "铭"
L["Insets"] = "插图"
L["Item"] = "物品"
L["Item category"] = "物品类别"
L["Item information"] = "物品信息"
L["Item level"] = "物品等级 "
L["Items"] = "物品"
L["Items in this list are always considered as junk. Click an item to remove it from the list."] = "此列表物品将不被归类为垃圾. 点击可移除."
L["Items in this list are never considered as junk. Click an item to remove it from the list."] = "此列表物品将不被归类为垃圾. 点击可移除."
L["Jewelry"] = "饰品"
L["Junk category"] = "垃圾"
L["Keep all stacks together."] = "将所有堆叠合并"
L["KEYRING_TAG"] = "钥"
L["LDB Plugin"] = "LDB 组件"
L["LEATHERWORKING_BAG_TAG"] = "皮"
L["Legacy"] = "传说"
L["Let SyLevel handle the the display."] = "让 SyLevel 来处理显示。"
L["Lock anchor"] = "锁定锚点"
L["Low quality items"] = "劣质物品"
L["Manual"] = "手动"
L["Manual filtering"] = "手动过滤"
L["Maximum bag height"] = "最大背包高度"
L["Maximum stack size"] = "最大堆叠"
L["Merge bag types"] = "合并背包类型"
L["Merge free space"] = "合并空间"
L["Merge incomplete stacks with complete ones."] = "合并不完整堆叠"
L["Merge stackable items"] = "合并可堆叠物品"
L["Merge unstackable items"] = "合并不可堆叠的物品"
L["Merged sets"] = "合并套装"
L["MINING_BAG_TAG"] = "矿"
L["Mininum level"] = "最低等级的限度"
L["Money"] = "金钱"
L["Move items from and to the bank by right-clicking on section headers."] = "通过右键单击类别标题，移动该类别物品到银行。"
L["Never"] = "从不"
L["New"] = "新物品"
L["New Override"] = "新建覆盖"
L["New section"] = "新分类 "
L["No error reports"] = "没有错误报告 "
L["None"] = "无 "
L["Nothing to sell."] = "没有东西可卖。"
L["One section per item slot."] = "按物品位置分组"
L["One section per set"] = "按套装分组"
L["Only equippable items"] = "只有可装备的物品"
L["Only one section."] = "仅一个分组"
L["Opacity"] = "透明度"
L["Open automatically"] = "自动打开"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "注意, 此筛选功能应用于全部物品, 其他优先级较低的筛选设置将被覆盖而无法生效."
L["Plugins"] = "组件"
L["Position mode"] = "定位模式"
L["Press Alt while doing so to open a dropdown menu."] = "按下Alt键将打开一个下拉菜单。 "
L["Priority"] = "优先级"
L["Provides a LDB data source to be displayed by LDB display addons."] = "给 LDB 提供数据资料, 以便符合 LDB 规范的插件使用."
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "放置可装备物品至[装备]分组"
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "按装备管理设置的套装分组放置物品"
L["Put items in sections depending on their first-level category at the Auction House."] = "按拍卖行主类型规则分组放置物品."
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "将低品质或者垃圾物品放入[垃圾]分组"
L["Put quest-related items in their own section."] = "将任务物品放入相关分组"
L["Quality highlight"] = "品质高亮"
L["Quest indicator"] = "任务指示器"
L["Quest Items"] = "任务物品"
L["QUIVER_TAG"] = "箭"
L["Recent Items"] = "新物品 "
L["Related to player level"] = "与玩家等级相关 "
L["Remove"] = "移除"
L["Reset"] = "重设"
L["Reset new items"] = "整理新物品"
L["Reset position"] = "重置位置"
L["Right-click to (un)lock the bag anchor."] = "右键单击(不锁定/锁定)袋锚点。"
L["Right-click to configure."] = "右键单击配置"
L["Right-click to move these items."] = "右键单击以移动这些物品。"
L["Right-click to open options"] = "右键点击开启选项"
L["Right-click to sell these items."] = "右键单击出售这些物品。"
L["Right-click to toggle %s."] = "右键点击以切换％S。"
L["Right-click to try to empty this bag."] = "右键点击尝试清空此背包."
L["Same as InventoryItemLevels"] = "一样等级的物品 "
L["Scale"] = "缩放"
L["Section"] = "分组"
L["Section category"] = "分组类型"
L["Section header"] = "分类标题 "
L["Section setup"] = "分组设定"
L["Section visibility"] = "分组可见"
L["Section visibility button"] = "分组可见按钮"
L["Select how bag usage should be formatted in the plugin."] = "选择背包使用状况格式"
L["Select how items should be sorted within each section."] = "物品在每个分组内排序方式"
L["Select how the bags are positionned."] = "选择背包应如何放置 "
L["Select the category of the section to associate. This is used to group sections together."] = "选择分组过滤类型. 用于聚合分组."
L["Select the sections in which the items should be dispatched."] = "选择物品分配的分组"
L["Select which bags AdiBags should display."] = "选择Adibags应该显示哪些背包 "
L["Select which first-level categories should be split by sub-categories."] = "选择使用子类型拆分的物品主类型"
L["Separate incomplete stacks."] = "分开不完整的堆叠"
L["Separate unstackable items."] = "分开不可堆叠的物品"
L["Set: %s"] = "套装: %s"
L["Sets"] = "套装"
L["Show %s"] = "显示 %s"
L["Show bag type icons"] = "显示背包类型图标"
L["Show bag type tags"] = "显示背包类型标签"
L["Show bank usage"] = "显示银行占用"
L["Show container information..."] = "显示容器信息"
L["Show every distinct item stacks."] = "显示每个不同的物品堆叠"
L["Show filtering information..."] = "显示过滤信息"
L["Show item information..."] = "显示物品信息"
L["Show only one free slot for each kind of bags."] = "每种类型背包空余空间分别合并显示为一格"
L["Show only one slot of items that can be stacked."] = "将可堆叠物品合并显示为一格"
L["Show only one slot of items that cannot be stacked."] = "将不可堆叠物品合并显示为一格"
L["Size"] = "大小"
L["Skin"] = "皮肤"
L["Slot number"] = "槽号"
L["Small"] = "小型 "
L["Sort items by bind type."] = "依绑定类型排序物品。"
L["Sorting order"] = "分类顺序"
L["SOUL_BAG_TAG"] = "魂"
L["Space in use"] = "已使用空间"
L["Space in use / total space"] = "已使用空间 / 总空间"
L["Split armors by types"] = "按类型拆分护甲"
L["Split by subcategories"] = "按子类拆分"
L["TACKLE_BOX_TAG"] = "渔具箱"
L["Text"] = "文本"
L["Texture"] = "材质"
L["Toggle and configure item filters."] = "配置物品过滤"
L["Toggle and configure plugins."] = "配置组件"
L["Tooltip information"] = "提示信息"
L["Track new items"] = "追踪新物品"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "追踪背包中的新物品, 新物品在[新物品]区将高亮显示, 可以点击右上[N]按钮将其重置."
L["Uncheck this to disable AdiBags."] = "反选禁用 AdiBags"
L["Unlock anchor"] = "解锁锚点"
L["Use SyLevel"] = "使用 SyLevel"
L["Use this section to define any item-section association."] = "使用此分组定义任意物品分组过滤"
L["Use this to adjust the bag scale."] = "背包缩放"
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "调整品质背景透明度, 100% 为不透明"
L["Virtual stack slots"] = "虚拟堆叠"
L["Virtual stacks"] = "虚拟堆叠"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "虚拟堆叠将同一物品用一个单位显示, 实际在背包中仍占用多个位置."
L["When alt is held down"] = "当ALT键被按下 "
L["When any modifier key is held down"] = "当任意键被按下 "
L["When checked, right-clicking on an empty space of a bag opens the configuration panel."] = "选择后可以在背包空白处点击右键打开配置面板。 "
L["When ctrl is held down"] = "当CTRL键被按下 "
L["When shift is held down"] = "当SHIFT键被按下 "
L["Which color scheme should be used to display the item level ?"] = "应该使用哪种颜色来显示物品的等级?"
L["You can block auto-deposit ponctually by pressing a modified key while talking to the banker."] = "在与银行职员对话的同时按住「辅助按键」，可避免自动存放。"

	elseif locale == "ruRU" then
L["%s is: %s."] = "%s это: %s."
L["... including incomplete stacks"] = "... включая не полные стопки"
L["6.0"] = "6.0"
L["Add a dropdown menu to bags that allow to hide the sections."] = "Показывать выпадающее меню для групп, которые можно скрывать."
L["Add association"] = "Добавить объединение"
L["Add more information in tooltips related to items in your bags."] = "Показывать расширенную информацию в подсказках к предметам в сумках."
L["AdiBags Anchor"] = "Крепление AdiBags"
L["Adjust the maximum height of the bags, relative to screen size."] = "Настройка высоты окна рюкзака относительно размера экрана.."
L["Adjust the width of the bag columns."] = "Настройка ширины столбца в рюкзаке."
L["AH category"] = "Категория аукциона"
L["AH subcategory"] = "Подкатегория аукциона"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Позволяет вручную изменять группу в которую следует помещать предмет. Просто перетащите элемент на название группы."
L["Alt-right-click to configure manual filtering."] = "Alt+Правый клик - настройки Ручного фильтрования"
L["Alt-right-click to configure the Junk module."] = "Alt+Правый клик - настройка фильтра \"Хлама\""
L["Alt-right-click to switch to anchored placement."] = "Alt+Правый клик - закрепить положение окна"
L["Alt-right-click to switch to manual placement."] = "Alt+Правый клик - Свободное перемещение окна"
L["Always"] = "Всегда"
L["AMMO_TAG"] = "Бп"
L["Ammunition"] = "Боеприпасы"
L["Anchored"] = "Закрепленный"
L["Are you sure you want to remove this section ?"] = "Удалить эту группу?"
L["Assign %s to ..."] = "Отнести %s к ..."
L["At merchants', bank, auction house, ..."] = "У торговца, в банке, в аукционном доме, ...:"
L["auto-deposit"] = "Авто-вклад"
L["Automatically open the bags at merchant's, bank, ..."] = "Открывать окно Рюкзака у торговца, в банке, ..."
L["auto-sort"] = "Авто-сортировка"
L["Auto-sort can cause freeze when the bag is closed."] = "Автоматическая сортировка может вызывать задержки когда сумка закрыта."
L["Backpack"] = "Рюкзак"
L["Backpack color"] = "Цвет фона рюкзака"
L["Bag #%d"] = "Сумка #%d"
L["Bag background"] = "Цвет фона в банке"
L["Bag number"] = "Номер сумки"
L["Bag title"] = "Заголовок сумки"
L["Bag type"] = "Тип сумки"
L["Bag usage format"] = "Формат использования сумки"
L["Bags"] = "Сумки"
L["Bank"] = "Банк"
L["Bank bag #%d"] = "Сумка банка #%d"
L["Bank color"] = "Цвет фона банковских сумок"
L["Bank Switcher"] = "Работа с банком"
L["Bind type"] = "Тип привязки"
L["Border"] = "Стиль рамки"
L["Border width"] = "Толщина рамки"
L["By category, subcategory, quality and item level (default)"] = "По категориям, качеству и уровню предмета (по умолчанию)"
L["By name"] = "По имени"
L["By quality and item level"] = "По качеству и уровню"
L["Category"] = "Раздел"
L["Change stacking at merchants', auction house, bank, mailboxes or when trading."] = "Переключать стопки у торговцев, на аукционе, в банке, при отправке по почте или обмене."
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "Отмеченные наборы будут отображаться в единой группе \"Наборы\". Это персональная настройка."
L["Check this so armors are dispatched in four sections by type."] = "Разделять броню по типам: Ткань, Кожа, Кольчуга и Латы."
L["Check this to display a bag type tag in the top left corner of items."] = "Показывать тип особой сумки в левом верхнем углу иконки предмета."
L["Check this to display a colored border around items, based on item quality."] = "Включите флажок, чтобы предметы подсвечивались в соответствии с их качеством."
L["Check this to display an icon after usage of each type of bags."] = "Включите флажок, чтобы отображалась иконка типа сумки."
L["Check this to display an indicator on quest items."] = "Включите флажок, чтобы подсвечивались предметы, необходимые для задания."
L["Check this to display an textual tag before usage of each type of bags."] = "Показывать подсказку перед использованием каждого типа сумок."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "Включите флажок, чтобы каждый набор выводился в отдельной группе. Когда флажок снят, то все наборы отображаются в группе \"Наборы\"."
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "Показывать общее количество свободных ячеек, не разделяя по типам сумок."
L["Check this to have poor quality items dimmed."] = "Затенять вещи плохого качества."
L["Check this to show space at your bank in the plugin."] = "Включите флажок, чтобы в окне банка показывались свободные ячейки."
L["Check this to show this section. Uncheck to hide it."] = "Показывать эту секцию."
L["Check to disable error reporting."] = "Не сообщать об ошибках."
L["Check to enable this module."] = "Включить для активации модуля."
L["Click on a item to remove it from the list. You can drop an item on the empty slot to add it to the list."] = "Кликните по предмету для его удаления. Для добавления перетащите предмет в свободную ячейку."
L["Click on this button to create the new association."] = "Кликните на кнопку, что бы создать новую ассоциацию."
L["Click or drag this item to remove it."] = "Кликните или перетащите предмет для его удаления."
L["Click there to reset the bag positions and sizes."] = "Нажмите для сброса положения и размера окна рюкзака."
L["Click to purchase"] = "Кликните чтобы купить"
L["Click to reset item status."] = "Кликните чтобы сбросить статус предметов."
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "Кликните что бы выбрать какие секции должны показываться, а какие скрываться. Настройки видимости секций общие для свех сумок."
L["Click to swap between %s and %s."] = "Нажмите для переключения между %s и %s."
L["Click to toggle the bag anchor."] = "Кликните чтобы переключить якорь сумки."
L["Click to toggle the equipped bag panel, so you can change them."] = "Кликните для переключения панели надетых сумок, так что вы можете их изменить."
L["Close"] = "Закрыть"
L["Color"] = "Цвет"
L["Color scheme"] = "Цветовая палитра"
L["Column width"] = "Размер столбца"
L["Configure"] = "Настройка"
L["Consider gems as a subcategory of trade goods"] = "Рассматривать самоцветы как подкатегорию хозяйственных товаров"
L["Consider glyphs as a subcategory of trade goods"] = "Рассматривать символы как подкатегорию хозяйственных товаров"
L["Container information"] = "Информация о контейнере"
L["COOKING_BAR_TAG"] = "Кул"
L["Currencies to show"] = "Отображаемые валюты"
L["Currency"] = "Валюта"
L["Dim junk"] = "Затемнять хлам"
L["disabled"] = "выключено"
L["Display a smaller money frame. This setting will take effect on next reload."] = "Уменьшить надпись с золотом. Изменения применятся после перезагрузки интерфейса."
L["Display character currency at bottom left of the backpack."] = "Показывать валюты в левом нижнем углу рюкзака."
L["Display character money at bottom right of the backpack."] = "Отображать золото в правом нижнем углу рюкзака."
L["Display the level of equippable item in the top left corner of the button."] = "Показывать уровень предметов, которые можно одеть."
L["Do not show anchor point"] = "Не отоброжать зону привязки "
L["Do not show level of heirloom items."] = "Не показывать уровень наследуемых предметов."
L["Do not show level of items that cannot be equipped."] = "Показывать уровень только тех предметов, которые можно одеть."
L["Do not show level of poor quality items."] = "Не показывать уровень предметов низкого качества."
L["Do not show levels under this threshold."] = "Не показывать уровень для предметов ниже отметки."
L["Drag to move this bag."] = "Сумку можно перетаскивать."
L["Drop an item there to add it to the list."] = "Чтобы добавить предмет перетащите его в эту ячейку."
L["Drop your item there to add it to this section."] = "Вы можете добавить предмет, перетащив его в эту группу."
L["Enabled"] = "Включить"
L["enabled"] = "включить"
L["Enabled bags"] = "Используемые сумки"
L["ENCHANTING_BAG_TAG"] = "Чры"
L["ENGINEERING_BAG_TAG"] = "Эн"
L["Enter the name of the section to associate with the item."] = "Введите название секции, с которой вы хотите связать вещь."
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "Введите название, ссылку или ID предмета, что бы связать ее с секцией. Так же вы можете просто перетащить предмет в окошко."
L["Equipment"] = "Экипировка"
L["Equipped bags"] = "Сумки персонажа"
L["Error in %s: %s -- details: %s"] = "%s: возникла ошибка %s. Подробности: %s"
L["Exclude list"] = "Список исключений"
L["Filter"] = "Фильтр"
L["Filtering information"] = "Фильтрование информации"
L["Filters"] = "Фильтры"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "Фильтры используются для группировки предметов. Один предмет выводится только в одной группе. Если предмет указан в нескольких группах, то он будет выводиться в группе с наивысшим приоритетом."
L["Font"] = "Шрифт"
L["Four general sections."] = "Четыре общих секции."
L["Free space"] = "Свободно"
L["Free space / total space"] = "Свободно / всего места"
L["Gear manager item sets"] = "Менеджер комплектов брони"
L["GEM_BAG_TAG"] = "См"
L["Gems are trade goods"] = "Самоцветы это Хозяйственные товары"
L["Glyphs are trade goods"] = "Символы это Хозяйственные товары"
L["HERB_BAG_TAG"] = "Тр"
L["Hide the colored corner shown when you move the bag."] = "Скрыть цветной угол при перетаскивании окна."
L["Hide zeroes"] = "Только имеющиеся"
L["Highlight changes"] = "Подсвечивать изменения"
L["Highlight color"] = "Цвет подсвечивания"
L["Highlight scale"] = "Масштаб подсвечивания"
L["Highlight style"] = "Стиль подсветки"
L["Highlight what changes in bags with a little sparkle."] = "Подсвечивать новые предметы искрящимся фоном."
L["If the addon seems not to work properly, please re-enable error reporting and check again before filing a bug ticket."] = "Перед тем как сообщить об ошибке, пожалуйста, заново включите вывод ошибок и перепроверьте поведение."
L["Ignore currencies with null amounts."] = "Показывать только имеющиеся валюты"
L["Ignore heirloom items"] = "Игнорировать наследуемые предметы"
L["Ignore low quality items"] = "Игнорировать вещи низкого качества."
L["Include list"] = "Дополнительно включенные:"
L["Included categories"] = "Добавленные группы"
L["INSCRIPTION_BAG_TAG"] = "Нч"
L["Insets"] = "Отступы"
L["Item"] = "Предмет"
L["Item category"] = "Категория предмета"
L["Item information"] = "Информация о предмете"
L["Item level"] = "Уровень предмета"
L["Items"] = "Предметы"
L["Items in this list are always considered as junk. Click an item to remove it from the list."] = "Эти предметы считаются хламом. Кликните по предмету для удаления из списка хлама."
L["Items in this list are never considered as junk. Click an item to remove it from the list."] = "Эти предметы не считаются хламом. Кликните по предмету для удаления из списка исключений."
L["Jewelry"] = "Драгоценности"
L["Junk category"] = "Хлам"
L["Keep all stacks together."] = "Объединять все."
L["KEYRING_TAG"] = "Клч"
L["LDB Plugin"] = "Плагин LDB"
L["LEATHERWORKING_BAG_TAG"] = "Кж"
L["Legacy"] = "Наследие"
L["Let SyLevel handle the the display."] = "Использовать SyLevel для отображения уровня предмета."
L["Lock anchor"] = "Закрепить положение"
L["Low quality items"] = "Предметы низкого качества"
L["Manual"] = "В ручную"
L["Manual filtering"] = "Ручная фильтрация"
L["Maximum bag height"] = "Максимальная высота сумки"
L["Maximum stack size"] = "Максимальный размер стопки"
L["Merge bag types"] = "Объединить типы сумок"
L["Merge free space"] = "Объединить пустые ячейки"
L["Merge incomplete stacks with complete ones."] = "Объединять не полные стэки, с полными."
L["Merge stackable items"] = "Объединить стэки предметов"
L["Merge unstackable items"] = "Объединять одиночные предметы в стопки"
L["Merged sets"] = "Объединенные наборы"
L["MINING_BAG_TAG"] = "Гд"
L["Mininum level"] = "Минимальный уровень"
L["Money"] = "Золото"
L["Move items from and to the bank by right-clicking on section headers."] = "Перемещать всю группу предметов по клику правой кнопкой мыши на заголовке группы."
L["Never"] = "Никогда"
L["New"] = "Новое"
L["New Override"] = "Новое перераспределение"
L["New section"] = "Новая группа"
L["No error reports"] = "Не сообщать об ошибках"
L["None"] = "Нет"
L["Nothing to sell."] = "Нечего продать."
L["One section per item slot."] = "Для каждого слота доспехов, своя секция."
L["One section per set"] = "Одна секция на набор"
L["Only equippable items"] = "Только те предметы, которые можно одеть"
L["Only one section."] = "Только одна секция"
L["Opacity"] = "Непрозрачность"
L["Open automatically"] = "Открывать автоматически"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "Имейте ввиду, что этот фильтр будет использоваться для всех вещей. Любой фильтр с меньшим приоритетом чем этот, не будет применяться."
L["Plugins"] = "Плагины"
L["Position mode"] = "Режим позиционирования"
L["Press Alt while doing so to open a dropdown menu."] = "Нажмите Alt для открытия контекстного меню."
L["Priority"] = "Приоритет"
L["Provides a LDB data source to be displayed by LDB display addons."] = "Отображает источники данных LDB при помощи LDB аддонов. LDB это LibDataBroker."
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "Поместить все предметы которые могут быть одеты на персонажа (включая сумки) в группу \"Экипировка\""
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "Помещает вещи, являющиеся частью одного из наборов, созданных с помощью управления экипировкой, в отдельные группы."
L["Put items in sections depending on their first-level category at the Auction House."] = "Раскладывать вещи в сумках, используя общие категории аукциона."
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "Показывать хлам и предметы низкого качества в группе \"Хлам\"."
L["Put quest-related items in their own section."] = "Показывать предметы, связанные с выполнением заданий, в группе \"Задания\"."
L["Quality highlight"] = "Подсвечивать в зависимости от качества"
L["Quest indicator"] = "Необходимые для заданий"
L["Quest Items"] = "Предметы, необходимые для задания"
L["QUIVER_TAG"] = "Клчн"
L["Recent Items"] = "Последние"
L["Related to player level"] = "Зависит от уровня игрока"
L["Remove"] = "Удалить"
L["Reset"] = "По умолчанию"
L["Reset new items"] = "Сброс новых предметов"
L["Reset position"] = "Сброс расположения"
L["Right-click to (un)lock the bag anchor."] = "Щелкните правой кнопкой мыши чтобы включить или отключить привязку к якорю."
L["Right-click to configure."] = "Для настройки кликните правой кнопкой мыши."
L["Right-click to move these items."] = "Для перемещения этих предметов кликните правой кнопкой мыши."
L["Right-click to open options"] = "Правый клик открывает Настройки"
L["Right-click to sell these items."] = "Для продажи кликните правой кнопкой мыши."
L["Right-click to toggle %s."] = "Правая кнопка мыши для переключения %s."
L["Right-click to try to empty this bag."] = "Кликните правой кнопкой, что бы попытаться опустошить эту сумку."
L["Same as InventoryItemLevels"] = "Также как InventoryItemLevels"
L["Scale"] = "Масштаб"
L["Section"] = "Секция"
L["Section category"] = "Раздел"
L["Section header"] = "Заголовок секции"
L["Section setup"] = "Настройки секции"
L["Section visibility"] = "Видимость секции"
L["Section visibility button"] = "Кнопка отображения секций"
L["Select how bag usage should be formatted in the plugin."] = "Выберите как использование сумок должно быть отображено в плагине."
L["Select how items should be sorted within each section."] = "Выберите как предметы должны сортироваться в пределах каждой секции."
L["Select how the bags are positionned."] = "Выберите как размещать сумки."
L["Select the category of the section to associate. This is used to group sections together."] = "Выберите категорию секции для того, что бы ее связать. Это необходимо для того, чтобы сгруппировать секции вместе."
L["Select the sections in which the items should be dispatched."] = "Укажите секцию, в которую предметы будут отправлены."
L["Select which bags AdiBags should display."] = "Отметьте для каких сумок использовать AdiBags."
L["Select which first-level categories should be split by sub-categories."] = "Укажите, какие общие категории должны быть разделены на субкатегории."
L["Separate incomplete stacks."] = "Объединять только полные стопки."
L["Separate unstackable items."] = "Объединять стопки."
L["Set: %s"] = "Набор: %s"
L["Sets"] = "Наборы"
L["Show %s"] = "Показать %s"
L["Show bag type icons"] = "Показать иконку типа сумки"
L["Show bag type tags"] = "Показать тег типа сумки"
L["Show bank usage"] = "Показать использование банка"
L["Show container information..."] = "Показать данные контейнера..."
L["Show every distinct item stacks."] = "Не объединять."
L["Show filtering information..."] = "Показать данные фильтрации..."
L["Show item information..."] = "Показать данные о вещи..."
L["Show only one free slot for each kind of bags."] = "Показывать одну свободную ячейку для каждой сумки."
L["Show only one slot of items that can be stacked."] = "Показывать только один слот для вещей, которые можно сложить в стопки"
L["Show only one slot of items that cannot be stacked."] = "Показывать только один слот вещей, которые не могут быть сложены в стопки"
L["Size"] = "Размер"
L["Skin"] = "Cкин"
L["Slot number"] = "Номер слота"
L["Small"] = "Маленький"
L["Sort items by bind type."] = "Сортировать по принадлежности"
L["Sorting order"] = "Сортировка"
L["SOUL_BAG_TAG"] = "Кд"
L["Space in use"] = "Исп. места"
L["Space in use / total space"] = "Использовано / всего места"
L["Split armors by types"] = "Разделять доспехи по типам"
L["Split by subcategories"] = "Разделить по субкатегориям"
L["TACKLE_BOX_TAG"] = "Снасти"
L["Text"] = "Текст"
L["Texture"] = "Фон"
L["Toggle and configure item filters."] = "Переключение и настройка фильтров предмета."
L["Toggle and configure plugins."] = "Переключение и настройка плагина."
L["Tooltip information"] = "Информация подсказки"
L["Track new items"] = "Следить за новыми предметами"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "Отслеживать новые предметы в каждой сумке, подсвечивать их и помещать в отдельную секцию. Статус \"Новое\" может быть сброшен кликом по небольшой кнопке \"N\" находящейся, в верхней левой стороне окна сумок."
L["Uncheck this to disable AdiBags."] = "Использование AdiBags. Снимите этот флажок когда нужно на время отключить AdiBags."
L["Unlock anchor"] = "Разблок. якорь"
L["Use SyLevel"] = "Использовать SyLevel"
L["Use this section to define any item-section association."] = "Использовать эту секцию что бы задать любую связь предмет-секция."
L["Use this to adjust the bag scale."] = "Регулировка масштаба сумок."
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "Настройте прозрачность рамки. При 100% рамка полностью видна."
L["Virtual stack slots"] = "Виртуальное сложение слотов"
L["Virtual stacks"] = "Виртуальные стопки"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "Виртуальные стопки объединяют предметы, разбросанные по сумкам."
L["When alt is held down"] = "Когда кнопка Alt нажата"
L["When any modifier key is held down"] = "Когда какая-либо клавиша модификатора нажата"
L["When checked, right-clicking on an empty space of a bag opens the configuration panel."] = "Когда включено, Правый клик в незанятой области Рюкзака откроет Окно параметров."
L["When ctrl is held down"] = "Когда кнопка Ctrl нажата"
L["When shift is held down"] = "Когда кнопка Shift нажата"
L["Which color scheme should be used to display the item level ?"] = "Каким цветом следует отображать уровень предметов?"
L["You can block auto-deposit ponctually by pressing a modified key while talking to the banker."] = "Для блокирования Авто-вклада реагентов нажмите клавишу-модификатор перед разговором с банкиром."

	elseif locale == "frFR" then
L["%s is: %s."] = "%s est : %s."
L["... including incomplete stacks"] = "... y compris les piles incomplètes"
L["6.0"] = "6.0"
L["Add a dropdown menu to bags that allow to hide the sections."] = "Ajoute un menu déroulant aux sacs pour cacher les sections."
L["Add association"] = "Ajouter l'association"
L["Add more information in tooltips related to items in your bags."] = "Ajoute des informations additionnelles dans les bulles d'aides des objets de vos sacs."
L["AdiBags Anchor"] = "Ancre d'AdiBags"
L["Adjust the maximum height of the bags, relative to screen size."] = "Ajustez la taille maximale des sacs, par rapport à la taille de l'écran."
L["Adjust the width of the bag columns."] = "Ajuster la largeur des colonnes du sac."
L["AH category"] = "Catégorie HV"
L["AH subcategory"] = "Sous-catégorie HV"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Vous permet de redéfinir manuellement la section dans laquelle un objet doit être mis. Tirez simplement un objet sur le titre de section."
L["Alt-right-click to configure manual filtering."] = "Alt-clic-droit pour configurer les filtres manuels."
L["Alt-right-click to configure the Junk module."] = "Alt-clic-droit pour configurer le module \"Camelote\"."
L["Alt-right-click to switch to anchored placement."] = "Alt+clic-droit pour activer le placement ancré."
L["Alt-right-click to switch to manual placement."] = "Alt+clic-droit pour activer le placement manuel."
L["Always"] = "Toujours"
L["AMMO_TAG"] = "Ba"
L["Ammunition"] = "Munitions"
L["Anchored"] = "Ancrée"
L["Are you sure you want to remove this section ?"] = "Etes-vous sûr de vouloir effacer cette section ?"
L["Assign %s to ..."] = "Assigner %s à ..."
L["At merchants', bank, auction house, ..."] = "Chez les marchands, à la banque, à l'hôtel des ventes, ..."
L["auto-deposit"] = "dépôt automatique"
L["Automatically open the bags at merchant's, bank, ..."] = "Ouvre automatiquement les sacs chez un marchand, à la banque, ..."
L["auto-sort"] = "tri automatique"
L["Auto-sort can cause freeze when the bag is closed."] = "Le tri automatique peut geler l'affichage à la fermeture du sac."
L["Backpack"] = "Sac à dos"
L["Backpack color"] = "Couleur du sac à dos"
L["Bag #%d"] = "Sac n°%d"
L["Bag background"] = "Arrière-plan des sacs"
L["Bag number"] = "Numéro du sac"
L["Bag title"] = "Titres des sacs"
L["Bag type"] = "Type de sac"
L["Bag usage format"] = "Format de l'usage des sacs"
L["Bags"] = "Sacs"
L["Bank"] = "Banque"
L["Bank bag #%d"] = "Sac de banque n°%d"
L["Bank color"] = "Couleur de la banque"
L["Bank Switcher"] = "Banque rapide"
L["Bind type"] = "Type de lien"
L["Border"] = "Bord"
L["Border width"] = "Largeur du bord"
L["By category, subcategory, quality and item level (default)"] = "Par catégorie, sous-catégorie, qualité et niveau d'objet (par défaut)"
L["By name"] = "Par nom"
L["By quality and item level"] = "Par qualité et niveau d'objet"
L["Category"] = "Catégorie"
L["Change stacking at merchants', auction house, bank, mailboxes or when trading."] = "Modifie l'empilement chez les marchands, à l'autel des ventes, à la banque, aux boîtes aux lettres et lors des échanges."
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "Cochez les ensembles qui doivent être fusionnés en une section \"Ensembles\" unique. C'est évidemment un réglage spécifique à ce personnage."
L["Check this so armors are dispatched in four sections by type."] = "Cochez ceci pour que les armures sont distribuées dans quatre sections selon leur type."
L["Check this to display a bag type tag in the top left corner of items."] = "Cochez ceci pour afficher le type des sacs dans le coin supérieur gauche des objets."
L["Check this to display a colored border around items, based on item quality."] = "Cochez ceci pour afficher un bord coloré autour des objets basé sur leur qualité."
L["Check this to display an icon after usage of each type of bags."] = "Cochez ceci pour afficher une icône de type de sac après l'usage."
L["Check this to display an indicator on quest items."] = "Cochez ceci pour afficher un indicateur sur les objets de quête."
L["Check this to display an textual tag before usage of each type of bags."] = "Cochez ceci pour afficher le type de sac avant l'usage."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "Cochez ceci pour afficher une section individuelle par ensemble d'équipement. Sinon, il n'y aura qu'une seule section \"Ensembles\"."
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "Cochez ceci pour n'afficher qu'une seule valeur pour tous les sacs, quelque soit leur type."
L["Check this to have poor quality items dimmed."] = "Cochez ceci pour assombrir les objets de mauvaise qualité."
L["Check this to show space at your bank in the plugin."] = "Cochez ceci pour afficher l'espace libre de votre banque."
L["Check this to show this section. Uncheck to hide it."] = "Cochez ceci pour afficher cette section. Décochez-le pour la cacher."
L["Check to disable error reporting."] = "Cochez pour désactiver les rapports d'erreurs"
L["Check to enable this module."] = "Cochez cette case pour activer ce module."
L["Click on a item to remove it from the list. You can drop an item on the empty slot to add it to the list."] = "Cliquer sur un objet pour le retirer de la liste. Vous pouvez mettre un objet dans l'emplacement vide pour l'ajouter à la liste."
L["Click on this button to create the new association."] = "Cliquez sur ce bouton pour créer la nouvelle association."
L["Click or drag this item to remove it."] = "Cliquez sur l'objet ou glissez-le pour le retirer."
L["Click there to reset the bag positions and sizes."] = "Cliquez ici pour remettre à zéro la position et la taille de sacs."
L["Click to purchase"] = "Cliquez pour acheter."
L["Click to reset item status."] = "Cliquez pour remettre à zéro les nouveaux objets."
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "Cliquez pour sélectionner les sections à afficher ou à cacher. Ceci est commun à tous les sacs."
L["Click to swap between %s and %s."] = "Cliquer pour échanger %s contre %s"
L["Click to toggle the bag anchor."] = "Cliquez pour afficher/cacher l'ancre des sacs."
L["Click to toggle the equipped bag panel, so you can change them."] = "Cliquez pour afficher/cacher le panneau des sacs équipés. Vous pourrez ainsi les manipuler."
L["Close"] = "Fermer"
L["Color"] = "Couleur"
L["Color scheme"] = "Thème de couleurs"
L["Column width"] = "Largeur de colonne"
L["Configure"] = "Configurer"
L["Consider gems as a subcategory of trade goods"] = "Considère les gemmes comme une sous-catégorie d'artisanat."
L["Consider glyphs as a subcategory of trade goods"] = "Considère les glyphes comme une sous-catégorie d'artisanat."
L["Container information"] = [=[Information sur le contenant
]=]
L["COOKING_BAR_TAG"] = "Cu"
L["Currencies to show"] = "Monnaies à afficher"
L["Currency"] = "Insignes"
L["Dim junk"] = "Assombrir la camelote"
L["disabled"] = "désactivé"
L["Display a smaller money frame. This setting will take effect on next reload."] = "Affiche les monnaies en plus petit. Effectif après rechargement."
L["Display character currency at bottom left of the backpack."] = "Affiche les insignes du personnage en bas à gauche du sac à dos."
L["Display character money at bottom right of the backpack."] = "Affiche l'or du personnage en bas à droite du sac à dos."
L["Display the level of equippable item in the top left corner of the button."] = "Afficher le niveau objets des équipements dans le coin supérieur gauche du bouton."
L["Do not show anchor point"] = "Masquer le point d'ancrage"
L["Do not show level of heirloom items."] = "N'affiche pas le niveau des objets d'héritage."
L["Do not show level of items that cannot be equipped."] = "N'affiche pas le niveau des objets qu'on ne peut pas équiper"
L["Do not show level of poor quality items."] = "N'affiche pas le niveau des objets de mauvaise qualité."
L["Do not show levels under this threshold."] = "N'affiche pas les niveaux inférieurs à ce seuil."
L["Drag to move this bag."] = "Tirer pour déplacer ce sac."
L["Drop an item there to add it to the list."] = "Glissez un objet ici pour l'ajouter à la liste."
L["Drop your item there to add it to this section."] = "Déposez votre objet ici pour l'ajouter à cette section."
L["Enabled"] = "Activé"
L["enabled"] = "activé"
L["Enabled bags"] = "Sacs activés"
L["ENCHANTING_BAG_TAG"] = "En"
L["ENGINEERING_BAG_TAG"] = "In"
L["Enter the name of the section to associate with the item."] = "Entrez le nom de la section à associer à l'objet."
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "Entrez le nom, le lien ou l'identifiant de l'objet à associer à la section. Vous pouvez aussi déposer un objet dans cette boîte."
L["Equipment"] = "Equipement"
L["Equipped bags"] = "Sacs équipés"
L["Error in %s: %s -- details: %s"] = "Erreur dans %s : %s -- détails : %s"
L["Exclude list"] = "Liste \"exclus\""
L["Filter"] = "Filtre"
L["Filtering information"] = "Information de filtrage"
L["Filters"] = "Filtres"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "Les filtres sont utilisés pour répartir les objets en section de sac. Un objet ne peut apparaître que dans une seule section. Si un objet correspond à plusieurs filtres, celui avec la meilleur priorité l'emporte."
L["Font"] = "Police"
L["Four general sections."] = "Quatre sections générales."
L["Free space"] = "Espace libre"
L["Free space / total space"] = "Espace libre / espace total"
L["Gear manager item sets"] = "Ensembles d'objets du gestionnaire d'équipement"
L["GEM_BAG_TAG"] = "Jo"
L["Gems are trade goods"] = "Gemmes dans artisanat"
L["Glyphs are trade goods"] = "Glyphes dans artisanat"
L["HERB_BAG_TAG"] = "He"
L["Hide the colored corner shown when you move the bag."] = "Masquer le coin coloré affiché quand vous déplacez le sac."
L["Hide zeroes"] = "Cacher les zéros"
L["Highlight changes"] = "Surligner les changements"
L["Highlight color"] = "Couleur du surlignage"
L["Highlight scale"] = "Echelle du surlignage"
L["Highlight style"] = "Style du surlignage"
L["Highlight what changes in bags with a little sparkle."] = "Mettre en évidence les changements dans les sacs avec un halo."
L["If the addon seems not to work properly, please re-enable error reporting and check again before filing a bug ticket."] = "Si l'addon semble ne pas fonctionner correctement, veuillez réactiver les rapports d'erreurs et vérifier à nouveau avant de créer un ticket d'incident."
L["Ignore currencies with null amounts."] = "Ignore les insignes en quantité nulle."
L["Ignore heirloom items"] = "Ignorer les objets d'héritage"
L["Ignore low quality items"] = "Ignorer les objets de mauvaise qualité"
L["Include list"] = "Liste \"inclus\""
L["Included categories"] = "Catégories incluses"
L["INSCRIPTION_BAG_TAG"] = "Ca"
L["Insets"] = "Taille de l'insert"
L["Item"] = "Objet"
L["Item category"] = "Catégories d'objets"
L["Item information"] = "Informations sur l'objet"
L["Item level"] = "Niveau d'objet"
L["Items"] = "Objets"
L["Items in this list are always considered as junk. Click an item to remove it from the list."] = "Les objets de cette liste sont considérés comme de la camelote. Cliquez sur un objet pour le retirer de la liste."
L["Items in this list are never considered as junk. Click an item to remove it from the list."] = "Les objets de cette liste ne sont jamais considérés comme de la camelote. Cliquez sur un objet pour le retirer de la liste."
L["Jewelry"] = "Joaillerie"
L["Junk category"] = "Catégorie camelote"
L["Keep all stacks together."] = "Conserver les piles ensembles."
L["KEYRING_TAG"] = "Cl"
L["LDB Plugin"] = "Plugin LDB"
L["LEATHERWORKING_BAG_TAG"] = "Cu"
L["Legacy"] = "Héritage"
L["Let SyLevel handle the the display."] = "Laisser SyLevel gérer l'affichage."
L["Lock anchor"] = "Verrouiller l'ancre"
L["Low quality items"] = "Objets de qualité médiocre."
L["Manual"] = "Manuelle"
L["Manual filtering"] = "Filtrage manuel"
L["Maximum bag height"] = "Hauteur maximale des sacs"
L["Maximum stack size"] = "Taille maximale des piles"
L["Merge bag types"] = "Fusionner les types de sacs"
L["Merge free space"] = "Fusionner l'espace libre"
L["Merge incomplete stacks with complete ones."] = "Fusionne les piles incomplètes avec celles qui sont complètes."
L["Merge stackable items"] = "Fusionne les objets empilables"
L["Merge unstackable items"] = "Fusionner les objets non-empilables"
L["Merged sets"] = "Ensembles fusionnés"
L["MINING_BAG_TAG"] = "Mi"
L["Mininum level"] = "Niveau minimum"
L["Money"] = "Monnaie"
L["Move items from and to the bank by right-clicking on section headers."] = "Déplacer des objets de ou vers la banque en cliquant-droit sur les en-tête de section."
L["Never"] = "Jamais"
L["New"] = "Nouveau"
L["New Override"] = "Nouvelle association"
L["New section"] = "Nouvelle section"
L["No error reports"] = "Aucun rapport d'erreur"
L["None"] = "Aucun"
L["Nothing to sell."] = "Rien à vendre."
L["One section per item slot."] = "Une section par emplacement d'équipement"
L["One section per set"] = "Une section par ensemble"
L["Only equippable items"] = "Objets équipables uniquement"
L["Only one section."] = "Seulement une section"
L["Opacity"] = "Opacité"
L["Open automatically"] = "Ouvrir automatiquement"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "Veuillez notez que ce filtre correspond à tous les objets. Tout filtre avec une priorité plus faible que celle de ce filtre n'aura aucun effet."
L["Plugins"] = "Plugins"
L["Position mode"] = "Disposition"
L["Press Alt while doing so to open a dropdown menu."] = "Presser Alt en le faisant pour ouvrir un menu déroulant."
L["Priority"] = "Priorité"
L["Provides a LDB data source to be displayed by LDB display addons."] = "Fournit une source LDB qui peut être affichée dans un addon d'affichage de LDB."
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "Place les objets qui peuvent être équipés (y compris les sacs) dans la section \"Equipement\"."
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "Place les objets appartenant à un ou plusieurs ensembles d'objet du gestionnaire d'objets dans des sections spécifiques."
L["Put items in sections depending on their first-level category at the Auction House."] = "Répartit les objets en fonction de leur catégorie principale (premier niveau de l'Hôtel des Ventes). "
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "Place les objets de mauvaise qualité ou considéré comme camelote dans la section \"Camelote\"."
L["Put quest-related items in their own section."] = "Place les objets en rapport avec les quêtes dans une section spécifique."
L["Quality highlight"] = "Surlignage de la qualité"
L["Quest indicator"] = "Indicateur de quête"
L["Quest Items"] = "Objets de quête"
L["QUIVER_TAG"] = "Fl"
L["Recent Items"] = "Objets Récents"
L["Related to player level"] = "Relatif au niveau du joueur"
L["Remove"] = "Effacer"
L["Reset"] = "Réinit."
L["Reset new items"] = "Remet à zéro les nouveaux objets."
L["Reset position"] = "R.à.z. position"
L["Right-click to (un)lock the bag anchor."] = "Clic-droit pour (dé)verrouiller l'ancre des sacs."
L["Right-click to configure."] = "Clic-droit pour configurer."
L["Right-click to move these items."] = "Clic-droit pour déplacer ces objets."
L["Right-click to open options"] = "Clic droit pour ouvrir les options"
L["Right-click to sell these items."] = "Clic-droit pour vendre ces objets."
L["Right-click to toggle %s."] = "Clique-droit pour basculer %s."
L["Right-click to try to empty this bag."] = "Clic droit pour essayer de vider ce sac."
L["Same as InventoryItemLevels"] = "Comme InventoryItemLevels"
L["Scale"] = "Echelle"
L["Section"] = "Section"
L["Section category"] = "Catégorie de section"
L["Section header"] = "En-têtes des sections"
L["Section setup"] = "Configuration de section"
L["Section visibility"] = "Visibilité des sections"
L["Section visibility button"] = "Bouton de visibilité des sections."
L["Select how bag usage should be formatted in the plugin."] = "Choisissez comment l'occupation d'un sac doit être formaté."
L["Select how items should be sorted within each section."] = "Choisissez comment les objets doivent être triés à l'intérieur de chaque section."
L["Select how the bags are positionned."] = "Choisissez comment les sacs sont positionnés."
L["Select the category of the section to associate. This is used to group sections together."] = "Sélectionnez la catégorie de la section à associer. Ceci est utilisé pour regrouper les sections."
L["Select the sections in which the items should be dispatched."] = "Sélectionnez les sections parmi lesquelles l'objet devra être affiché"
L["Select which bags AdiBags should display."] = "Choisissez quels sacs AdiBags doit afficher."
L["Select which first-level categories should be split by sub-categories."] = "Sélectionnez quelles catégories doivent être séparées en sous-catégories."
L["Separate incomplete stacks."] = "Séparer les piles incomplètes."
L["Separate unstackable items."] = "Séparer les objets non-empilables."
L["Set: %s"] = "Ens.: %s"
L["Sets"] = "Ensembles"
L["Show %s"] = "Afficher %s"
L["Show bag type icons"] = "Affiche les icônes de type de sacs"
L["Show bag type tags"] = "Affiche les tags de type de sac"
L["Show bank usage"] = "Afficher la banque"
L["Show container information..."] = "Afficher les informations du contenant..."
L["Show every distinct item stacks."] = "Afficher chaque pile distincte."
L["Show filtering information..."] = "Afficher les informations de filtrage..."
L["Show item information..."] = "Afficher les informations sur l'objet..."
L["Show only one free slot for each kind of bags."] = "N'affiche qu'un seul emplacement vide pour chaque type de sac."
L["Show only one slot of items that can be stacked."] = "N'affiche qu'un seul emplacement pour les objets pouvant être empilés."
L["Show only one slot of items that cannot be stacked."] = "N'affiche qu'un seul emplacement pour les objets ne pouvant normalement pas être empilés."
L["Size"] = "Taille"
L["Skin"] = "Apparence"
L["Slot number"] = "Numéro d'emplacement"
L["Small"] = "Petite"
L["Sort items by bind type."] = "Trier par type de lien."
L["Sorting order"] = "Ordre de tri"
L["SOUL_BAG_TAG"] = "Âm"
L["Space in use"] = "Espace utilisé"
L["Space in use / total space"] = "Espace utilisé / espace total"
L["Split armors by types"] = "Séparer les types d'armures"
L["Split by subcategories"] = "Répartir par sous-catégorie"
L["TACKLE_BOX_TAG"] = "Pê"
L["Text"] = "Texte"
L["Texture"] = "Texture"
L["Toggle and configure item filters."] = "Activer et configurer les filtres."
L["Toggle and configure plugins."] = "Activer et configurer les plugins."
L["Tooltip information"] = "Informations dans les bulles d'aides"
L["Track new items"] = "Détection des nouveaux objets"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "Détecte les nouveaux objets dans chaque sac, affiche une lueur colorée auteur d'eux et les place dans une section spéciale. Les nouveaux objets peuvent être remis à zéro en cliquant sur le bouton \"N\" en haut à droite des sacs."
L["Uncheck this to disable AdiBags."] = "Décochez ceci pour désactiver AdiBags."
L["Unlock anchor"] = "Déverrouiller l'ancre"
L["Use SyLevel"] = "Utiliser SyLevel"
L["Use this section to define any item-section association."] = "Utilisez cette section pour définir de nouvelles associations objet-section."
L["Use this to adjust the bag scale."] = "Ajustez la taille des sacs."
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "Ajustez l'opacité de la bordure de qualité. 100% signifie complétement opaque."
L["Virtual stack slots"] = "Emplacements de pile virtuelle"
L["Virtual stacks"] = "Piles virtuelles"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "Les piles virtuelles affichent en un seul endroit plusieurs piles d'objets."
L["When alt is held down"] = "Quand ALT est enfoncé"
L["When any modifier key is held down"] = "Quand n'importe quelle touche de modification est enfoncée"
L["When checked, right-clicking on an empty space of a bag opens the configuration panel."] = "Quand coché, un clic droit sur un espace vide d'un sac ouvre le panneau de configuration."
L["When ctrl is held down"] = "Quand CONTROL est enfoncé"
L["When shift is held down"] = "Quand MAJ est enfoncé"
L["Which color scheme should be used to display the item level ?"] = "Quel thème de couleur doit être utilisé pour afficher le niveau d'objet ?"
L["You can block auto-deposit ponctually by pressing a modified key while talking to the banker."] = "Vous pouvez bloquer temporairement le dépôt automatique en pressant une touche de modification quand vous parlez au banquier."

	elseif locale == "esMX" then

	elseif locale == "ptBR" then
L["%s is: %s."] = "%S é: %S."
L["... including incomplete stacks"] = "... incluindo pilhas incompletas"
L["6.0"] = "6.0"
L["Add a dropdown menu to bags that allow to hide the sections."] = "Adicione um menu retrátil nas bolsas que permitem esconder as seções"
L["Add association"] = "Adicionar associação"
L["Add more information in tooltips related to items in your bags."] = "Adicionar mais informação nas janelas de saque relacionadas aos itens em suas bolsas"
L["AdiBags Anchor"] = "Âncora do AdiBags"
L["Adjust the maximum height of the bags, relative to screen size."] = "Ajusta a altura máxima das bolsas, relativo a altura da tela"
L["Adjust the width of the bag columns."] = "Ajustar a largura das colunas da bolsa"
L["AH category"] = "Categoria da casa de leilões"
L["AH subcategory"] = "Subcategoria da casa de leilões"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Permite redefinir manualmente a seção na qual um item deve ser colocado. Basta arrastar o item no título de seleção."
L["Alt-right-click to configure manual filtering."] = "Alt-clique-direito para configurar a filtragem de manuais."
L["Alt-right-click to configure the Junk module."] = "Alt direito do mouse para configurar o módulo de Lixo"
L["Alt-right-click to switch to anchored placement."] = "Alt-click com botão direito para mudar para o ajuste fixo"
L["Alt-right-click to switch to manual placement."] = "Alt-click com botão direito para mudar para o ajuste manual"
L["Always"] = "Sempre"
L["AMMO_TAG"] = "Am"
L["Ammunition"] = "Munição"
L["Anchored"] = "Ancorado"
L["Are you sure you want to remove this section ?"] = "Tem certeza de que deseja remover esta seção?"
L["Assign %s to ..."] = "Associado %s para..."
L["At merchants', bank, auction house, ..."] = "Nos mercadores, bancos, casas de leilões, ..."
L["auto-deposit"] = "Auto-depositar"
L["Automatically open the bags at merchant's, bank, ..."] = "Abre as bolsas automaticamente nos mercadores, banco..."
L["auto-sort"] = "Auto-ordenar"
L["Auto-sort can cause freeze when the bag is closed."] = "Auto-ordenar pode causar congelamento quando a bolsa é fechada."
L["Backpack"] = "Mochila"
L["Backpack color"] = "Cor da bolsa"
L["Bag #%d"] = "Bolsa #%d"
L["Bag background"] = "Fundo da bolsa"
L["Bag number"] = "Número da bolsa"
L["Bag title"] = "Título da Bolsa"
L["Bag type"] = "Tipo de bolsa"
L["Bag usage format"] = "Formato de uso de bolsas"
L["Bags"] = "Bolsas"
L["Bank"] = "Banco"
L["Bank bag #%d"] = "Bolsa do banco #%d"
L["Bank color"] = "Cor do banco"
L["Bank Switcher"] = "Modificador do banco"
L["Bind type"] = "Tipo de vinculo"
L["Border"] = "Borda"
L["Border width"] = "Largura da borda"
L["By category, subcategory, quality and item level (default)"] = "Por categoria, subcategoria, qualidade e nível do item (padrão)"
L["By name"] = "Por nome"
L["By quality and item level"] = "Por qualidade e nível do item"
L["Category"] = "Categoria"
L["Change stacking at merchants', auction house, bank, mailboxes or when trading."] = "Mude empilhando nos vendedores, casa de leilões, banco, caixa de correio ou quando negociando"
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "Verifica equipamentos que deveriam ser fundidos numa única seção \"sets\". Isso é obviamente uma configuração por personagem"
L["Check this so armors are dispatched in four sections by type."] = "Marque para que armaduras sejam colocadas em quatro seções por tipo"
L["Check this to display a bag type tag in the top left corner of items."] = "Marque para mostrar o tipo de bolsa no topo esquerdo dos itens"
L["Check this to display a colored border around items, based on item quality."] = "Marque para mostrar uma borda colorida em volta dos itens, baseados em sua qualidade."
L["Check this to display an icon after usage of each type of bags."] = "Marque para mostrar um ícone após o uso de cada tipo de bolsas."
L["Check this to display an indicator on quest items."] = "Marque para mostrar um indicador de itens de missões."
L["Check this to display an textual tag before usage of each type of bags."] = "Marque para mostrar uma aba de texto antes do uso de cada tipo de bolsas"
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "Marque para mostrar uma seção individual por conjunto de equipamentos. Se desabilitado mostrará uma enorme seção de \"sets\"."
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "Marque para mostrar somente um valor contando todas as bolsas equipadas, ignorando seu tipo"
L["Check this to have poor quality items dimmed."] = "Marque para ter itens de qualidade inferior apagados"
L["Check this to show space at your bank in the plugin."] = "Marque para mostrar o espaço no seu banco no plugin"
L["Check this to show this section. Uncheck to hide it."] = "Marque para mostrar essa seção. Desmarque para escondê-la"
L["Check to disable error reporting."] = "Marque para desativar reporte de erros."
L["Check to enable this module."] = "Marque para habilitar esse módulo"
L["Click on a item to remove it from the list. You can drop an item on the empty slot to add it to the list."] = "Clique em um item para removê-lo da lista. Você pode soltar um item num espaço vazio para adicioná-lo a lista"
L["Click on this button to create the new association."] = "Clique botão para criar uma nova associação"
L["Click or drag this item to remove it."] = "Clique e arraste este item para removê-lo"
L["Click there to reset the bag positions and sizes."] = "Clique para resetar os tamanhos e posições das bolsas"
L["Click to purchase"] = "Clique para comprar"
L["Click to reset item status."] = "Clique para resetar os status dos itens"
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "Clique para selecionar quais seções deverão ser mostradas ou escondidas. Seleção de visibilidade é comum para todas as bolsas."
L["Click to swap between %s and %s."] = "Clique para trocar entre %S e %S."
L["Click to toggle the bag anchor."] = "Clique para alternar a âncora da bolsa"
L["Click to toggle the equipped bag panel, so you can change them."] = "Clique para alternar o painel da bolsa equipada, assim você pode alterá-las"
L["Close"] = "Fechar"
L["Color"] = "Cor"
L["Color scheme"] = "Esquema de cores"
L["Column width"] = "Largura da coluna"
L["Configure"] = "Configurar"
L["Consider gems as a subcategory of trade goods"] = "Considera gemas como uma subcategoria de bens de troca"
L["Consider glyphs as a subcategory of trade goods"] = "Considera glifos como uma subcategoria de bens de troca"
L["Container information"] = "Informação do conteiner"
L["COOKING_BAR_TAG"] = "Co"
L["Currencies to show"] = "Moedas a mostrar"
L["Currency"] = "Moeda"
L["Dim junk"] = "Apagar sucata"
L["disabled"] = "Desabilitado"
L["Display a smaller money frame. This setting will take effect on next reload."] = "Mostra um quadro de dinheiro menor. Essa configuração será aplicada na próxima reinicialização."
L["Display character currency at bottom left of the backpack."] = "Mostrar moedas do personagem na parte inferior esquerda da mochila"
L["Display character money at bottom right of the backpack."] = "Mostra o dinheiro do personagem na parte de baixo direita da mochila"
L["Display the level of equippable item in the top left corner of the button."] = "Mostra o nível equipável de item no topo esquerdo do botão."
L["Do not show anchor point"] = "Não mostrar ponto da âncora"
L["Do not show level of heirloom items."] = "Não mostrar o nível de itens de herança"
L["Do not show level of items that cannot be equipped."] = "Não mostrar o nível de itens que não podem ser equipados."
L["Do not show level of poor quality items."] = "Não mostrar o nível de itens de baixa qualidade."
L["Do not show levels under this threshold."] = "Não mostrar níveis abaixo deste limite."
L["Drag to move this bag."] = "Arraste para mover esta bolsa"
L["Drop an item there to add it to the list."] = "Solte um item aqui para adicioná-lo a lista"
L["Drop your item there to add it to this section."] = "Solte seu item aqui para adicionar a esta seção"
L["Enabled"] = "Ligado"
L["enabled"] = "Abilitado"
L["Enabled bags"] = "Ativar Bolsas"
L["ENCHANTING_BAG_TAG"] = "Enc"
L["ENGINEERING_BAG_TAG"] = "Eng"
L["Enter the name of the section to associate with the item."] = "Entre o nome da seção para associar com o item"
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "Entre com o nome, link ou ID do item para associá-lo com a seção. Você também pode arrastar e soltar o item nesta caixa"
L["Equipment"] = "Equipamento"
L["Equipped bags"] = "Bolsas equipadas"
L["Error in %s: %s -- details: %s"] = "Erro em %s: %s -- detalhes: %s"
L["Exclude list"] = "Excluir a lista"
L["Filter"] = "Filtro"
L["Filtering information"] = "Informação de filtragem"
L["Filters"] = "Filtros"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "Filtros são usados para enviar itens para as seções das bolsas. Um item pode aparecer somente em uma seção. Se o mesmo item está selecionado para vários filtros, o com maior prioridade definida vence."
L["Font"] = "Fonte"
L["Four general sections."] = "Quatro seções gerais"
L["Free space"] = "Espaço livre"
L["Free space / total space"] = "Espaço livre / espaço total"
L["Gear manager item sets"] = "Gerenciador de equipamento"
L["GEM_BAG_TAG"] = "Ge"
L["Gems are trade goods"] = "Gemas são bens de troca"
L["Glyphs are trade goods"] = "Glifos são bens de troca"
L["HERB_BAG_TAG"] = "Er"
L["Hide the colored corner shown when you move the bag."] = "Oculta o canto colorido mostrado quando você move sua bolsa"
L["Hide zeroes"] = "Esconder zeros"
L["Highlight changes"] = "Destaque as mudanças"
L["Highlight color"] = "Cor de destaque"
L["Highlight scale"] = "Escala de destaque"
L["Highlight style"] = "Estilo de destaque"
L["Highlight what changes in bags with a little sparkle."] = "Destaque o que muda nas bolsas, com um pouco de brilho."
L["If the addon seems not to work properly, please re-enable error reporting and check again before filing a bug ticket."] = "Se o addon parecer não funcionar devidamente, por favor ative novamente o reporte de erros e verifique novamente antes de preencher um ticket de Bug(falha)"
L["Ignore currencies with null amounts."] = "Ignorar quantias com valores nulos"
L["Ignore heirloom items"] = "Ignorar itens de herança"
L["Ignore low quality items"] = "Ignora itens de qualidade inferior"
L["Include list"] = "Incluir lista"
L["Included categories"] = "Categorias inclusas"
L["INSCRIPTION_BAG_TAG"] = "Esc"
L["Insets"] = "Insetos"
L["Item"] = "Item"
L["Item category"] = "Categoria do item"
L["Item information"] = "Informação do item"
L["Item level"] = "Nível do item"
L["Items"] = "Itens"
L["Items in this list are always considered as junk. Click an item to remove it from the list."] = "Itens nessa lista são sempre considerados sucata. Click em um item para removê-lo da lista"
L["Items in this list are never considered as junk. Click an item to remove it from the list."] = "Itens nessa lista nunca serão considerados sucata. Clique em um item para removê-lo da lista."
L["Jewelry"] = "Jóias"
L["Junk category"] = "Categoria de sucata"
L["Keep all stacks together."] = "Manter todas as pilhas juntas"
L["KEYRING_TAG"] = "Ch"
L["LDB Plugin"] = "Plugin LDB"
L["LEATHERWORKING_BAG_TAG"] = "Co"
L["Legacy"] = "Legado"
L["Let SyLevel handle the the display."] = "Permite que SyLevel suporte a tela"
L["Lock anchor"] = "Travar âncora"
L["Low quality items"] = "Item inferior"
L["Manual"] = "Manual"
L["Manual filtering"] = "Filtragem manual"
L["Maximum bag height"] = "Altura máxima da bolsa"
L["Maximum stack size"] = "Tamanho máximo do empilhamento"
L["Merge bag types"] = "Fundir tipos de bolsas"
L["Merge free space"] = "Fundir espaço livre"
L["Merge incomplete stacks with complete ones."] = "Funde pilhas incompletas com completas"
L["Merge stackable items"] = "Funde itens empilháveis"
L["Merge unstackable items"] = "Fundir itens não empilháveis"
L["Merged sets"] = "Sets fundidos"
L["MINING_BAG_TAG"] = "Mi"
L["Mininum level"] = "Nível minimo"
L["Money"] = "Dinheiro"
L["Move items from and to the bank by right-clicking on section headers."] = "Move itens \"de\" e \"para\" o banco quando clicar nos cabeçalhos de seção "
L["Never"] = "Nunca"
L["New"] = "Novo"
L["New Override"] = "Nova Importancia"
L["New section"] = "Nova seção"
L["No error reports"] = "Sem reporte de erros"
L["None"] = "Nenhum"
L["Nothing to sell."] = "Nada para vender."
L["One section per item slot."] = "Uma seção por espaço"
L["One section per set"] = "Uma seção por set"
L["Only equippable items"] = "Somente itens equipáveis"
L["Only one section."] = "Somente uma seção"
L["Opacity"] = "Opacidade"
L["Open automatically"] = "Abrir automaticamente"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "Por favor note que este filtro engloba todos os itens. qualquer filtro com menor prioridade não terá efeito algum."
L["Plugins"] = "Plugins"
L["Position mode"] = "Modo de posicionamento"
L["Press Alt while doing so to open a dropdown menu."] = "Pressione Alt enquanto faz isso para abrir o menu dropdown"
L["Priority"] = "Prioridade"
L["Provides a LDB data source to be displayed by LDB display addons."] = "Fornece uma fonte LDB para ser exibida por LDB addons"
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "Põe qualquer item que pode ser equipado (incluindo bolsas) na categoria \"equipamento\""
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "Põe itens pertencentes a um ou mais sets do gerenciador de equipamentos padrão em seções específicas"
L["Put items in sections depending on their first-level category at the Auction House."] = "Põe itens em seções dependendo da categoria inicial na Casa de Leilões"
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "Põe itens de qualidade inferior ou rotulados como sucata na seção \"Sucata\" "
L["Put quest-related items in their own section."] = "Põe itens relativos a missões em suas respectivas seções"
L["Quality highlight"] = "Destaca qualidade"
L["Quest indicator"] = "Indicador de missões"
L["Quest Items"] = "Itens de missões"
L["QUIVER_TAG"] = "Qu"
L["Recent Items"] = "Itens Recentes"
L["Related to player level"] = "Relativos ao nível do jogador"
L["Remove"] = "Remover"
L["Reset"] = "Reiniciar"
L["Reset new items"] = "Reseta itens novos"
L["Reset position"] = "Reseta posição"
L["Right-click to (un)lock the bag anchor."] = "Botão Direito para (des)travar a âncora da bolsa"
L["Right-click to configure."] = "Botão direito do mouse para configurar."
L["Right-click to move these items."] = "Botão direito do mouse para mover esses itens."
L["Right-click to open options"] = "Botão direito para abrir opções"
L["Right-click to sell these items."] = "Clique-direito de vender esses itens."
L["Right-click to toggle %s."] = "Clique-direito para mudar %s."
L["Right-click to try to empty this bag."] = "Clique com o botão direito para esvaziar esta bolsa"
L["Same as InventoryItemLevels"] = "Mesmo que InventoryItemLevels (Nível de ítens do inventário)"
L["Scale"] = "Escala"
L["Section"] = "Seção"
L["Section category"] = "Categoria da seção"
L["Section header"] = "Cabeçalho de seção"
L["Section setup"] = "Configurações de seção"
L["Section visibility"] = "Visibilidade da seção"
L["Section visibility button"] = "Seção do botão de visibilidade"
L["Select how bag usage should be formatted in the plugin."] = "Seleciona como o uso de bolsas deve ser formatado no plugin"
L["Select how items should be sorted within each section."] = "Seleciona quantos itens devem ser arrumados em cada seção"
L["Select how the bags are positionned."] = "Seleciona como as bolsas são posicionadas"
L["Select the category of the section to associate. This is used to group sections together."] = "Selecione a categoria da seção para unir. Isto é usado para agrupar seções"
L["Select the sections in which the items should be dispatched."] = "Selecione as seções para as quais os itens serão encaminhados"
L["Select which bags AdiBags should display."] = "Seleciona quais bolsas o Adibags deve mostrar"
L["Select which first-level categories should be split by sub-categories."] = "Seleciona qual categoria primária deve ser dividida em subcategorias"
L["Separate incomplete stacks."] = "Separar pilhas incompletas"
L["Separate unstackable items."] = "Separar itens não empilháveis"
L["Set: %s"] = "Set: %s"
L["Sets"] = "Sets"
L["Show %s"] = "Mostra %s"
L["Show bag type icons"] = "Mostrar o ícone dos tipos de bolsas"
L["Show bag type tags"] = "Mostrar a aba dos tipos de bolsas"
L["Show bank usage"] = "Mostrar ocupação do banco"
L["Show container information..."] = "Mostrar informação da janela de saque"
L["Show every distinct item stacks."] = "Mostrar cada pilha diferente de itens"
L["Show filtering information..."] = "Mostrar informação de filtragem"
L["Show item information..."] = "Mostrar informação do item"
L["Show only one free slot for each kind of bags."] = "Mostre somente um espaço livre para cada tipo de bolsa"
L["Show only one slot of items that can be stacked."] = "Mostre somente um espaço com itens que podem ser empilhados"
L["Show only one slot of items that cannot be stacked."] = "Mostre somente um espaço de itens que não podem ser empilhados"
L["Size"] = "Tamanho"
L["Skin"] = "Pele"
L["Slot number"] = "Número do slot"
L["Small"] = "Pequeno"
L["Sort items by bind type."] = "Ordenar itens por tipo de vinculo."
L["Sorting order"] = "Ordem de arrumação"
L["SOUL_BAG_TAG"] = "So"
L["Space in use"] = "Espaço em uso"
L["Space in use / total space"] = "Espaço em uso / espaço total"
L["Split armors by types"] = "Separar armaduras por tipo"
L["Split by subcategories"] = "Divide em subcategorias"
L["TACKLE_BOX_TAG"] = "Fi"
L["Text"] = "Texto"
L["Texture"] = "Textura"
L["Toggle and configure item filters."] = "Alterna e configura filtros de itens"
L["Toggle and configure plugins."] = "Alterna e configura plugins"
L["Tooltip information"] = "Dicas Informações"
L["Track new items"] = "Rastreia itens novos"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "Rastreia itens novos em cada bolsa, mostrando uma aura brilhante sobre eles e colocando-os em uma seção especial. Status \"Novo\" pode ser apagado clicando no pequeno botão \"N\" no topo esquerdo de suas bolsas"
L["Uncheck this to disable AdiBags."] = "Desmarque para desabilitar AdiBags"
L["Unlock anchor"] = "Destrava âncora"
L["Use SyLevel"] = "Use SyLevel"
L["Use this section to define any item-section association."] = "Use esta seção para definir qualquer associação seção-item"
L["Use this to adjust the bag scale."] = "Use para ajustar a escala da bolsa"
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "Use para ajustar a opacidade da borda baseada na qualidade. 100% significa totalmente opaco"
L["Virtual stack slots"] = "Espaços de pilhas virtuais"
L["Virtual stacks"] = "Emplilhamento virtual"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "Emplilhamentos virtuais mostram em um espaço itens que na verdade se espalhariam por vários espaços das bolsas"
L["When alt is held down"] = "Quando ALT é pressionado"
L["When any modifier key is held down"] = "Quando qualquer tecla modificadora é Pressionada"
L["When checked, right-clicking on an empty space of a bag opens the configuration panel."] = "Quando marcado, botão direito em um espaço vazio de uma bolsa abrirá o painel de configurações"
L["When ctrl is held down"] = "Quando CTRL é pressionado"
L["When shift is held down"] = "Quando SHIFT é pressionado"
L["Which color scheme should be used to display the item level ?"] = "Qual esquema de cores deve ser usado para mostrar o nível do item?"
L["You can block auto-deposit ponctually by pressing a modified key while talking to the banker."] = "Você pode bloquear o auto-deposito pressionando a tecla modificada enquanto fala com o banqueiro."

	elseif locale == "itIT" then
L["AH category"] = "AH categoria"
L["AH subcategory"] = "AH sottocategoria"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Permette di ridefinire manualmente la sezione in cui dovrebbe essere collocato un oggetto. Semplicemente trascinando un oggetto sul titolo della sezione."
L["Always"] = "Sempre"
L["Ammunition"] = "Munizioni"
L["Anchored"] = "Ancorato"
L["auto-deposit"] = "auto-deposita"
L["Automatically open the bags at merchant's, bank, ..."] = "Apre automaticamente le borse se parli a un mercante, banchiere, ..."
L["Bag number"] = "Numero borsa"
L["Bag title"] = "Titolo borsa"
L["Bag type"] = "Tipo borsa"
L["Bag usage format"] = "Modalità di utilizzo delle borse"
L["Bags"] = "Borse"
L["Bank"] = "Banca"
L["Border"] = "Bordo"
L["Border width"] = "Lunghezza bordo"
L["By category, subcategory, quality and item level (default)"] = "Per categoria, sottocategoria, qualità e livello dell'oggetto (predefinito)"
L["By name"] = "Per nome"
L["By quality and item level"] = "Per qualità e livello dell'oggetto."
L["Category"] = "Categoria"
L["Check this to display a colored border around items, based on item quality."] = "Selezionare questa opzione per visualizzare un bordo colorato attorno agli oggetti in base alla qualità dell'oggetto."
L["Check this to display an icon after usage of each type of bags."] = "Selezionare questa opzione per visualizzare un icona dopo l'utilizzo di ogni tipo di borsa."
L["Check this to display an indicator on quest items."] = [=[Selezionare questa opzione per visualizzare un indicatore sugli oggetti di missione.
]=]
L["Check this to display an textual tag before usage of each type of bags."] = "Selezionare questa opzione per visualizzare un'etichetta testuale prima dell'uso di ogni tipo di borsa."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "Selezionare questa opzione per visualizzare una sezione separata per ogni collezione. Se disabilitata, ci sarà una sola sezione denominata \"Collezioni\"."
L["Check this to show space at your bank in the plugin."] = "Spunta questo per mostrare lo spazio nella tua banca nel plugin"
L["Check to enable this module."] = [=[Selezionare per abilitare questo modulo.
]=]
L["Click there to reset the bag positions and sizes."] = [=[Clicca per ripristinare la posizione e le dimensioni delle borse.
]=]
L["Click to purchase"] = "Clicca per acquistare"
L["Click to reset item status."] = "Clicca per resettare lo stato degli oggetti"
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "Clicca per selezionare quali sezioni mostrare o nascondere. La visibilità è comune a tutte le borse."
L["Click to swap between %s and %s."] = "Clicca per scambiare tra %s a %s."
L["Click to toggle the bag anchor."] = "Clicca per mostare / nascondere l'icona di ancoraggio delle borse."
L["Click to toggle the equipped bag panel, so you can change them."] = "Clicca per mostare / nascondere il pannello delle borse equipaggiate, in modo da poterle sostituire."
L["Close"] = [=[Chiudi
]=]
L["Color"] = "Colore"
L["Color scheme"] = "Schema colore"
L["Column width"] = "Lunghezza colonna"
L["Configure"] = "Configura"
L["Consider gems as a subcategory of trade goods"] = "Considera le gemme come una sottocategoria di beni commerciali"
L["Consider glyphs as a subcategory of trade goods"] = "Considera i glifi come una sottocategoria di beni commerciali"
L["Currencies to show"] = "Valute da mostrare"
L["Currency"] = "Valuta"
L["Dim junk"] = "Dim cianfrusaglie"
L["disabled"] = "disabilitato"
L["Display character money at bottom right of the backpack."] = "Mostra i soldi del personaggio in basso a destra nello zaino."
L["Do not show anchor point"] = "Non mostrare il punto di ancoraggio"
L["Drag to move this bag."] = "Trascina per spostare questa borsa"
L["Drop your item there to add it to this section."] = "Rilascia il tuo oggetto per aggiungerlo a questa sezione."
L["Enabled"] = "Abilitato"
L["enabled"] = "abilitato"
L["Enabled bags"] = "Borse abilitate"
L["Equipment"] = "Equipaggiamento"
L["Equipped bags"] = "Borse equipaggiate"
L["Filter"] = "Filtro"
L["Filters"] = "Filtri"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "I filtri vengono utilizzati per allocare gli oggetti nelle sezioni delle borse. Un oggetto può comparire solo in una sezione. Se lo stesso oggetto è selezionato da diversi filtri verrà utilizzato il filtro con priorità più alta."
L["Font"] = "Carattere"
L["Four general sections."] = "Quattro sezioni generali."
L["Free space"] = "Spazio libero"
L["Free space / total space"] = "Spazio libero / spazio totale"
L["Gems are trade goods"] = "Le gemme sono beni di scambio"
L["Glyphs are trade goods"] = "I glifi sono beni di scambio"
L["Item"] = "Oggetto"
L["Item category"] = "Categoria dell'oggetto"
L["Item information"] = "Dettagli oggetto"
L["Item level"] = "Livello oggetto"
L["Items"] = "Oggetti"
L["Jewelry"] = "Gioielli"
L["Junk category"] = "Categoria Cianfrusaglia"
L["Keep all stacks together."] = "Raggruppa tutte le cataste."
L["Lock anchor"] = "Blocca indicatore di ancoraggio"
L["Low quality items"] = "Oggetti di bassa qualità"
L["Manual"] = "Manuale"
L["Manual filtering"] = "Filtro manuale"
L["Merge bag types"] = "Unisci le tipologie di borse"
L["Merged sets"] = "Raggruppa le collezioni"
L["Mininum level"] = "Livello minimo"
L["Money"] = "Monete"
L["Never"] = "Mai"
L["New section"] = "Nuova sezione"
L["Nothing to sell."] = "Nulla da vendere."
L["Opacity"] = "Opacità"
L["Open automatically"] = "Apri automaticamente"
L["Priority"] = "Priorità"
L["Quest indicator"] = "Indicatore missione"
L["Quest Items"] = "Oggetti Missione"
L["Recent Items"] = "Oggetti Recenti"
L["Remove"] = "Rimuovi"
L["Section"] = "Sezione"
L["Set: %s"] = "Collezione: %s"
L["Sets"] = "Collezioni"
L["Text"] = "Testo"

	end
end

